{B+}

unit DR;

interface
uses Crt, Def, FastWr, DrawSqar, CPaU, BeeU, ColorDef, GetKeU;
procedure GetDrive;
procedure PutDrive;
procedure DriveSet;

implementation

procedure GetDrive;
var Err:           integer;
begin
TempFileLine := 'Drive';
assign(DriveFile,TempFileLine);  (* make empty slot in mode *)
DataDrive := 'A:';
{$I-}     reset(DriveFile);
{$I+}     Err := ioresult;
{$I-}     read(DriveFile,DataDrive);
{$I+}     Err := ioresult;
{$I-}     close(DriveFile);
{$I+}     Err := ioresult;
end;

procedure PutDrive;
begin
TempFileLine := 'Drive';
assign(DriveFile,TempFileLine); rewrite(DriveFile);
write(DriveFile,DataDrive);  close(DriveFile);
end;

procedure DriveSet;
var I,
    X:             integer;
    FunctionKey:   boolean;
    Ch:            char;
begin
clrscr;
DrawSquare( 1, 1, 80, 5, Msgs.Attr, true);
GetDrive;
FastWrite( CPad('Current Data Drive '+ DataDrive,78), 2, 2, Msgs.Attr);
FastWrite( CPad('Type drive letter (A - E)',78), 3, 2, Msgs.Attr);
FastWrite( CPad('Strike [ESC] to exit',78), 4, 2, Msgs.Attr);
GetKey(Ch,FunctionKey);
Ch := upcase(Ch);
while ((Ch < 'A') or (Ch > 'G')) and (Ch <> #27) do
    begin
    Beep(1);
    GetKey(Ch,FunctionKey);
    Ch := upcase(Ch);
    end;
clrscr;
I := ord(Ch);
if I <> 27 then
   if (I > 64) and (I < 91) then
      begin
      DataDrive := Ch+':';
      PutDrive;
      end;
end;

end.

