unit Def;

interface
const
   MaxList            =     4500;
   SubDivisionTop     =       26;
   DivisionTop        =       26;
   MostPrinters       =        9;
   FinalLine          =       12;
   MaxSortDiff        =        1;
   max_copies         =       25;
   MostPhone     =     4500;
   LinesOnPage  =       58;
   high_record    =    32000;
   MailLine      =        5;
   ZipLine       =        8;
   Phone1Line    =        9;
   Phone2Line    =       10;
   BeginBlock    =        1;
   DisplayLines      =       14;
   PrintBlock    =      254;
   DriveDefault  =     'A:';
   Restrict1     =     9730;
   Restrict2     =      278;
   LastDescription    =       11;
   MaxFieldLine       =        5;
   MaxForms           =       40;
   MaxFormLength      =       66;
   MaxFormWidth       =      272;
   row:                               integer = 0;
   FileTop:                           integer = 0;
   BackupFileTop:                     integer = 0;
   SortTop:                           integer = 0;
   BackupSortTop:                     integer = 0;
   commentTop:                        integer = 0;
   RecordNum:                         integer = 0;
   I:                                 integer = 0;
   J:                                 integer = 0;
   K:                                 integer = 0;
   FirstDisplay:                      longint = 0;
   LastDisplay:                       longint = 0;
   ProgramUse:                        integer = 0;
   ActivePrinter:                     integer = 0;
   ActiveForm:                        integer = 0;
   ShowMode:                          integer = 0;
   PrinterMode:                       integer = 0;

const
   FieldLen:      array [0..FinalLine] of integer = (1,40,20,30,30,30,20,2,10,12,12,40,1);
   Description:   array [1..LastDescription] of string[20] = ( 'Addressee', 'Title',
                                                        'Company',
                                                        'Aux. address line',
                                                        'Mailing address',
                                                        'City', 'State',
                                                        'Zip code',
                                                        'Phone number 1',
                                                        'Phone number 2',
                                                        'Comments');

type
    s1  = char;
    S2  = string[2];
    s5  = string[5];
    S10 = string[10];
    s12 = string[12];
    s20 = string[20];
    s25 = string[25];
    S30 = string[30];
    s40 = string[40];
    S80 = string[80];
    Line = string[80];
    IntArray        = array [1..SubDivisionTop] of integer;
    code_arr    = array [0..DivisionTop,0..SubDivisionTop] of S30;
    BlockArray  = array [1..MaxList] of integer;
    SetType =                       set of char;

MainRecordType = record
                         Addressee:            s40;
                         AuxAddress:           S30;
                         MailAddress:          S30;
                         City:                 s20;
                         State:                S2;
                         ZipCode:              S10;
                         Phone1:               s12;
                         Phone2:               s12;
                         Comments:             s40;
                         waste:                byte;
                         Division:             char;
                         waste2:               byte;
                         SubDivision:          char;
                         Title:                s20;
                         Company:              S30;
                         end;

FormRecord   =  record
                Description:         S30;
                FormLen:         integer;
                FormWidth:        integer;
                ReturnColOffset:          integer;
                ReturnRowOffset:          integer;
                ColOffset:           integer;
                RowOffset:           integer;
                PlaceArray:    array [1..LastDescription, 1..MaxFieldLine] of integer;
                end;

var
   TempMainFile,
   AddressFile:      file of MainRecordType;
   FormFile:         file of FormRecord;
   Entry,
   ReturnAddress,
   HoldEntry:        MainRecordType;
   Compress1,
   Compress2,
   DeCompress1,
   DeCompress2:      array [1..MostPrinters] of integer;
   Printers:         array [1..MostPrinters] of S80;
   Ch:               char;
   DataDrive:        S2;
   TempFileLine,
   TestName,
   Device,
   BlankLine:        Line;
   WriteState,
   Komma,
   Continue,
   FunctionKey:      boolean;
   blank:            S30;
   FindName:         s25;
   IntFile:          file of integer;
   rfile:            file of real;
   AlphaCodeFile:    file of S30;
   DriveFile:        file of S2;  (* make empty slot in mode *)
   TextFile,
   OutPutDevice:     text;
   AlphaCode:              code_arr;
   Form:             array [0..MaxForms] of FormRecord;
   Frame:            array [0..43,0..FinalLine] of char;

implementation

end.

