unit BL;

interface
uses Crt,     Def,      ColorDef, FastWr,   DivEdit,  PrtDiv,   PrtSDiv,
     GetForU, StrnU,    Str2InU,  RE,       CursorOU, CPaU,     DrawSqar,
     GetKeU,  SetBU,    ShadoU,   LPaU,     StriU,    BeeU,     DL,
     UCasU,   PG,       SortLisU, SumPrint, FT,       Swap,     DQ,
     ER,      SM,       Printer;
procedure BuildList;

implementation

procedure BuildList;
var Pause,
    StackSort:              boolean;
    StackNumber,
    Choice,
    BeginRec,
    ZipBegin,
    ListDisplay,
    FirstSort,
    StackTop:               integer;
    X,
    X1,
    X2:                      S40;
    Stack:                   BlockArray;

    (* ------------------------------------ *)

    function CopyQuery: integer;
    var AllowControl,
        Err,
        Copies:              integer;
        AllowInput,
        Continue:            boolean;
    begin
    Copies := 1;
    AllowControl := -1;
    AllowInput := true;
    Continue := true;
    (* DrawSquare *)
    FastWrite( 'Enter number of copies for each form :   ',
               23, 1, Inputs.Attr);
    Copies := Str2Int( GetForm( 40, 23, 5, Strng(5,#32), '1', AllowControl,
                                AllowInput, Inputs.Attr, ['0'..'9']),
                       Err);
    FastWrite( BlankLine, 24, 1, Displays.Attr);
    CopyQuery := Copies;
    end;

    (* ------------------------------------ *)

    procedure SetCodes;
    var I,
        TempDivision,
        TempSubDivision:                integer;
        TempStr:           Line;
    begin
    TempDivision := 0;     TempSubDivision := 0;
    DivisionEdit(TempDivision,TempSubDivision);
    clrscr;
    if (TempDivision <> 0) and (TempSubDivision <> 0) then
       begin
       str(StackTop:5, TempStr);
       FastWrite( 'Encoding', 1, 1, Msgs.Attr);
       FastWrite( 'of '+TempStr, 1, 25, Msgs.Attr);
       for I := 1 to StackTop do
           begin
           if (I mod 10) = 0 then
              begin
              str(I,TempStr);
              FastWrite( TempStr, 1, 15, Msgs.Attr);
              end;
           GetRec(Entry,Stack[I]);
           Entry.Division := chr(TempDivision);
           Entry.SubDivision := chr(TempSubDivision);
           PutRec(Entry,Stack[I]);
           end;
       end;
    end;

    (* ------------------------------------ *)

    procedure StackChoice(var Choice, ZipBegin: integer);
    var AllowControl,
        Err,
        I:              integer;
        Ch:             char;
        Search,
        AllowInput,
        FunctionKey:    boolean;
        Temp:           array [1..11] of S40;

        function SearchQuery( X: integer): boolean;
        var TempStr:              Line;
            Ch:                   char;
            FunctionKey:          boolean;
        begin
        TempStr := CPad('Do you wish to search on: ' +
                   Temp[X] + ' ?  (Y/N)  ',78);
        DrawSquare(1, 23, 80, 25, Inputs.Attr, true);
        FastWrite( TempStr, 24, 2, Inputs.Attr);
        Ch := ' ';
        while (Ch <> 'Y') and (Ch <> 'N') and (Ch <> #27) do
            begin
            GetKey(Ch,FunctionKey);
            Ch := upcase(Ch);
            end;
        if Ch = 'Y' then
           SearchQuery := true
          else
           SearchQuery := false;
        end;

    begin
    SetBG;
    clrscr;
    AllowControl := -1;
    AllowInput := true;
    Temp[1] :=    Description[1];
    Temp[2] :=    Description[2];
    Temp[3] :=    Description[3];
    Temp[4] :=    Description[4];
    Temp[5] :=    Description[5];
    Temp[6] :=    Description[6];
    Temp[7] :=    Description[7];
    Temp[8] :=    Description[8];
    Temp[9] :=    'Phone number     ';
    Temp[10] :=   Description[11];
    Temp[11] :=   'Division         ';
    Shadow( 25, 4, 55, 18, Menus.Attr, true);
    for I := 1 to 11 do
        begin
        FastWrite(LPad(chr(I+64)+'  '+Temp[I],26), 5+I, 29, Menus.Attr);
        end;
    CursorOn(false);
    DrawSquare( 1, 23, 80, 25, Inputs.Attr, true);
    FastWrite( CPad('Choice ?   (A-K)',78), 24, 2, Inputs.Attr);
    Ch := ' ';
    while ((Ch < 'A') or (Ch > 'K')) and (Ch <> #27) do
        begin
        Ch := upcase(ReturnKey(FunctionKey));
        end;
    Choice := ord(Ch)-64;
    if ProgramUse = 2 then
       if Choice = 3 then
          Choice := 1
         else
          if Choice = 1 then
             Choice := 3;
    if Choice > 0 then
       Search := SearchQuery(Choice)
      else
       Search := false;
    if Search then
       begin
       if Choice = 8 then
          begin
          FastWrite( LPad('Enter search position for zip-code. (0 = anywhere)',
                    78), 24, 2, Inputs.Attr);
          ZipBegin := Str2Int( GetForm( 65, 24, 2, '  ', '0', AllowControl,
                                        AllowInput, Inputs.Attr, ['0'..'9']),
                               Err);
          end;
       X := Strip(Temp[Choice]);
       end
      else
       begin
       Choice := 0;
       X := '';
       end;
    SetBG;
    clrscr;
    CursorOn(false);
    if keypressed then Beep(1);
    end;

    (* ------------------------------------ *)

    procedure ClearStack;
    begin
    StackSort := false;
    ListDisplay := 0;
    StackTop := 0;
    BeginRec := 0;
    end;

    (* ------------------------------------ *)

    procedure ViewList(var FunctionKey: boolean; Ch: char);
    var EndRec,
        I,
        RecordNum,
        J:                               integer;
        TempStr:                         Line;
    begin
    if BeginRec < 1 then BeginRec := 1;
    if FunctionKey then
       begin
       if Ch = #73 then BeginRec := BeginRec + succ(DisplayLines);
       if Ch = #81 then BeginRec := BeginRec - succ(DisplayLines);
       if BeginRec < 1 then BeginRec := 1;
       if BeginRec > StackTop then BeginRec := StackTop;
       end;
    EndRec := BeginRec + DisplayLines;
    if EndRec > StackTop then EndRec := StackTop;
    SetBG;
    clrscr;
    str(StackTop,TempStr);
    FastWrite( 'Elements '+TempStr, 1, 1, Headings.Attr);
    J  := 1;
    if StackTop > 0 then
       begin
       for I := BeginRec to EndRec do
           begin
           inc(J);
           gotoxy(2,J);
           RecordNum := Stack[I];
           GetRec(Entry,RecordNum);
           DisplayLine(Entry,J,Displays.Attr);
           str(I:4,TempStr);
           FastWrite( TempStr, J, 1, Menus.Attr);
           end;                (* for..next loop *)
       end;                    (* if..then *)
    if StackTop > succ(DisplayLines) then
       begin
       DrawSquare( 5, 18, 75, 20, Msgs.Attr, true);
       FastWrite( CPad('List contains more than 15 elements !',50),
                 19, 15, Msgs.Attr);
       end;
    end;

    (* ------------------------------------ *)

    function RecTestInteger( RecordNum, Division, ArrayTop: integer;
                             A:                             IntArray;
                             AcceptAll:                     boolean): boolean;
    var Temp:                                               S40;
        Continue:                                           boolean;
        I,
        J,
        K,
        X:                                                  integer;
    begin
    RecTestInteger := false;
    Continue := true;
    GetRec(Entry,RecordNum);
    I := ord(Entry.Division);
    J := ord(Entry.SubDivision);
    if Division = I then                               (* if..1 *)
       begin
       if AcceptAll then                                (* if..2 *)
          RecTestInteger := true
       else
          begin
          K := 1;
          while (K <= ArrayTop) and Continue do
             begin
             if J = A[K] then                     (* if..3 *)
                begin
                RecTestInteger := true;
                Continue := false;
                end
             else
                inc(K);       (* if..then..else..3 *)
             end;             (* while..loop *)
          end;                (* if..then..else..2 *)
       end;                   (* if..then..else..1 *)
    end;

    (* ------------------------------------ *)

    function RecTestChar( RecordNum, Choice: integer;
                          SearchFor:         S40;
                          ZipBegin:          integer): boolean;
    var LookIn:                              S40;
        FoundAt:                             integer;
    begin
    RecTestChar := false;
    GetRec(Entry,RecordNum);
    case Choice of
       1:  begin
           if ProgramUse = 2 then
              LookIn := UCase(Entry.Company)
             else
              LookIn := UCase(Entry.Addressee);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       2:  begin
           LookIn := UCase(Entry.Title);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       3:  begin
           if ProgramUse = 2 then
              LookIn := UCase(Entry.Addressee)
             else
              LookIn := UCase(Entry.Company);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       4:  begin
           LookIn := UCase(Entry.AuxAddress);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       5:  begin
           LookIn := UCase(Entry.MailAddress);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       6:  begin
           LookIn := UCase(Entry.City);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       7:  begin
           LookIn := UCase(Entry.State);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       8:  begin
           LookIn := UCase(Entry.ZipCode);
           FoundAt := pos(SearchFor,LookIn);
           if ZipBegin = 0 then
              begin
              if FoundAt <> 0 then
                 RecTestChar := true
                else
                 RecTestChar := false;
              end
             else
              begin
              if FoundAt = ZipBegin then
                 begin
                 RecTestChar := true;
                 end
                else
                 RecTestChar := false;
              end;
           end;
       9:  begin
           LookIn := UCase(Entry.Phone1);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           LookIn := UCase(Entry.Phone2);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       10: begin
           LookIn := UCase(Entry.Comments);
           FoundAt := pos(SearchFor,LookIn);
           if FoundAt <> 0 then RecTestChar := true;
           end;
       end;
    if Choice <> 8 then
       begin
       FoundAt := pos(SearchFor,LookIn);
       if FoundAt <> 0 then RecTestChar := true;
       end;
    end;

    (* ------------------------------------ *)

    procedure StackHeading( SearchFor: S40);
    var TempStr:                       Line;
    begin
    SetBG;
    clrscr;
    X := Strip(X);
    Shadow( 23, 7, 57, 12, Headings.Attr, true);
    FastWrite( CPad('Searching under:',30), 8, 25, Headings.Attr);
    FastWrite( CPad(X,30), 9, 25, Headings.Attr);
    FastWrite( CPad(' for ',30), 10, 25, Headings.Attr);
    FastWrite( CPad(SearchFor,30), 11, 25, Msgs.Attr);

    Shadow( 23, 16, 57, 21, Headings.Attr, true);
    str(FileTop,TempStr);
    FastWrite( CPad('Searching',30), 17, 25, Headings.Attr);
    FastWrite( CPad('from',30), 19, 25, Headings.Attr);
    FastWrite( CPad(TempStr,30), 20, 25, Headings.Attr);
    end;

    (* ------------------------------------ *)

    function GetSearchFor( Choice: integer): S40;
    var AllowControl,
        Y:                         integer;
        SearchFor:                 S40;
        AllowInput:                boolean;
    begin
    AllowInput := true;
    AllowControl := -1;
    Y := 1;
    FastWrite( CPad('Search parameter = '+X, 80), Y, 1, Headings.Attr);
    inc( Y, 3);
    FastWrite( 'Search for ', Y, 1, Inputs.Attr);
    gotoxy(15,Y);
    SearchFor := Strip( GetForm( 15, Y, FieldLen[Choice],
                                 Strng(FieldLen[Choice],#32), '', AllowControl,
                                 AllowInput, Inputs.Attr, [#31..#126]));
    GetSearchFor := UCase(SearchFor);
    SetBG;
    end;

    (* ------------------------------------ *)

    procedure PrintCount(RecordNum:integer);
    var TempStr:                       Line;
    begin
    str(RecordNum,TempStr);
    FastWrite( CPad(TempStr,30), 18, 25, Msgs.Attr);
    end;

    (* ------------------------------------ *)

    procedure AlphaTest( Choice, ZipBegin: integer);
    var SearchFor,
        Temp:                              S40;
        RecordNum:                         integer;
        Found:                             boolean;
    begin
    SearchFor := GetSearchFor(Choice);
    StackHeading(SearchFor);
    for RecordNum := 1 to FileTop do
       begin
       if (RecordNum mod 10) = 0 then PrintCount(RecordNum);
       Found := RecTestChar(RecordNum,Choice,SearchFor,ZipBegin);
       if Found then
          begin
          inc(StackTop);
          Stack[StackTop] := RecordNum;
          end;
       end;       (* next RecordNum *)
    end;          (* procedure *)

    (* ------------------------------------ *)

    procedure DivisionTest;
    var HoldTop,
        Division,
        HoldLen,
        SubCode,
        I,
        J:                    integer;
        Found,
        AcceptAll:                  boolean;
        HoldSubDivisions:           Line;
        SubCodeStack:            IntArray;
    begin
    Division := 0;
    AcceptAll := false;
    PrintDivision;
    FastWrite( CPad('Search which division ? (A-Z)',78), 24, 2, Menus.Attr);
    Ch := upcase(ReturnKey(FunctionKey));
    Division := ord(Ch)-64;
    if (Division > 0) and (Division <= DivisionTop) then
       begin
       HoldSubDivisions := '';
       HoldTop := 0;
       PrintSubDivision(Division);
       FastWrite( CPad('Letter or F1 for ALL division',78), 24, 2, Menus.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       if Ch = #59 then SubCode := -1 else SubCode := ord(Ch)-64;
       if SubCode = -1 then
          AcceptAll := true
         else
          begin
          repeat
            if (SubCode >= 1) and (SubCode <= SubDivisionTop) then
               begin
               HoldSubDivisions := HoldSubDivisions + ' ' + Ch;
               inc(HoldTop);
               SubCodeStack[HoldTop] := SubCode;
               end;
            HoldLen := (80 - ord(HoldSubDivisions[0])) div 2 ;
            FastWrite( '  '+HoldSubDivisions+'  ', 21, HoldLen, Msgs.Attr);
            FastWrite( CPad('Letter, [BACKSPACE], or F1 to search',78),
                       24, 2, Menus.Attr);
            Ch := upcase(ReturnKey(FunctionKey));
            if Ch = #59 then
               SubCode := 41
              else
               if Ch = #8 then
                  begin
                  dec(HoldTop);
                  dec( HoldSubDivisions[0], 2);
                  HoldLen := (80 - ord(HoldSubDivisions[0])) div 2 ;
                  FastWrite( '  '+HoldSubDivisions+'  ', 21, HoldLen, Msgs.Attr);
                  SubCode := 0;
                  end
                 else
                  SubCode := ord(Ch)-64;
            until SubCode = 41;
          end;
       end;
    StackHeading(AlphaCode[Division,0]);
    for RecordNum := 1 to FileTop do
       begin
       if (RecordNum mod 10) = 0 then PrintCount(RecordNum);
       Found := RecTestInteger( RecordNum, Division, HoldTop,
                                SubCodeStack, AcceptAll);
       if Found then
          begin
          inc(StackTop);
          Stack[StackTop] := RecordNum;
          end;
       end;   (* next RecordNum *)
    end;

    (* ------------------------------------ *)

    procedure PrintStack;
    var RecordNum,
        LineCount,
        I:                           integer;
        FunctionKey:                 boolean;
        Ch:                          char;

        procedure PrintOutStack( Stack: BlockArray; StackTop: integer);
        var I,
            LineCount:         integer;
            FunctionKey:       boolean;
            Ch:                char;
        begin
        SetBG;
        DrawSquare( 1, 23, 80, 25, Msgs.Attr, true);
        FastWrite( CPad('Hit any key to print, or [ESC] to quit.',78),
                   24, 2, Msgs.Attr);
        GetKey(Ch,FunctionKey);
        if Ch <> #27 then
           begin
           clrscr;
           LineCount := 0;
           DrawSquare( 1, 11, 80, 13, Msgs.Attr, true);
           if Pause then
              FastWrite( CPad('Any key for next item, or [A] for ALL',70),
                         12, 5, Inputs.Attr)
             else
              FastWrite( CPad('Standby: Printing',70),
                         12, 5, (Msgs.Attr or $0080));
           for I := 1 to StackTop do
               begin
               if LineCount > LinesOnPage then
                  begin
                  writeln(OutPutDevice,#12);
                  LineCount := 0;
                  end;

               PrintRecord(1,Stack[I]);
               inc(LineCount);

               if PrinterMode = 4 then inc(LineCount, 3);
               if Pause then
                  begin
                  Ch := upcase(ReturnKey(FunctionKey));
                  if Ch = 'A' then
                     begin
                     Pause := false;
                     FastWrite( CPad('Standby: Printing',70), 12, 5,
                               (Msgs.Attr or $0080));
                     end
                    else
                     begin
                     if Ch = #27 then I := succ(StackTop);
                     end;
                  end
                 else
                  begin
                  if keypressed then
                     begin
                     GetKey(Ch,FunctionKey);
                     if Ch = #27 then I := succ(StackTop);
                     end;
                  end;
               end;
           writeln(OutPutDevice,#12);
           end;
        end;

        (* ------------------------------------ *)

        procedure SortPrintStack( PrintStack:    BlockArray;
                                  PrintStackTop: integer);
        var I,
            LineCount:            integer;
            FunctionKey:          boolean;
            Ch:                   char;
        begin
        SortList( PrintStack, PrintStackTop, FirstSort);
        SetBG;
        DrawSquare( 1, 23, 80, 25, Msgs.Attr, true);
        FastWrite( CPad('Hit any key to print, or [ESC] to quit.',78), 24, 2, Msgs.Attr);
        GetKey(Ch,FunctionKey);
        if Ch <> #27 then
           begin
           clrscr;
           LineCount := 0;
           DrawSquare( 1, 11, 80, 13, Msgs.Attr, true);
           if Pause then
              FastWrite( CPad('Any key for next item, or [A] for ALL',70),
                         12, 5, Inputs.Attr)
             else
              FastWrite( CPad('Standby: Printing',70), 12, 5,
                        (Msgs.Attr or $0080));
           for I := 1 to PrintStackTop do
               begin
               if LineCount > LinesOnPage then
                  begin
                  writeln(OutPutDevice,#12);
                  LineCount := 0;
                  end;
               PrintRecord(1,PrintStack[I]);
               inc(LineCount);
               if PrinterMode = 4 then inc(LineCount,3);
               if Pause then
                  begin
                  Ch := upcase(ReturnKey(FunctionKey));
                  if Ch = 'A' then
                     begin
                     Pause := false;
                     FastWrite( CPad('Standby: Printing',70), 12, 5,
                                (Msgs.Attr or $0080));
                     end
                    else
                     begin
                     if Ch = #27 then I := succ(PrintStackTop);
                     end;
                  end
                 else
                  begin
                  if keypressed then
                     begin
                     GetKey(Ch,FunctionKey);
                     if Ch = #27 then I := succ(PrintStackTop);
                     end;
                  end;
               end;
           writeln(OutPutDevice,#12);
           end;
        end;

        (* ------------------------------------ *)

    begin
    LineCount := 0;
    SetBG;
    clrscr;
    PrintDevice;    (* uses lines 1 and 2 *)
    Ch := ' ';
    while not (Ch in ['Y','N']) do
       begin
       FastWrite( 'Pause after each Form ?  (Y/N) ', 4, 1, Inputs.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       end;
    if Ch = 'Y' then Pause := true else Pause := false;
    Ch := ' ';
    while not (Ch in ['Y','N']) do
       begin
       FastWrite( 'Would you like to sort by other than '+Description[1]+' ?  (Y/N) ',
                  6, 1, Inputs.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       end;
    CursorOn(false);
    assign(OutPutDevice,Device);
    rewrite(OutPutDevice);
(*    if UCase(Device) <> LstDevice then
       begin
       writeln(Device,' ',LstDevice);
       end; *)
    if Ch = 'Y' then
       SortPrintStack(Stack,StackTop)
      else
       PrintOutStack(Stack,StackTop);
    close(OutPutDevice);
    end;

     (* ------------------------------------ *)

    procedure MailMergeStack;
    var RecordNum,
        LineCount,
        I:                           integer;
        FunctionKey:                 boolean;
        Ch:                          char;

        procedure MailMergeDump( Stack: BlockArray; StackTop: integer);
        var I,
            LineCount:         integer;
            FunctionKey:       boolean;
            Ch:                char;
        begin
        SetBG;
        DrawSquare( 1, 23, 80, 25, Msgs.Attr, true);
        FastWrite( CPad('Hit any key to print, or [ESC] to quit.',78),
                   24, 2, Msgs.Attr);
        GetKey(Ch,FunctionKey);
        if Ch <> #27 then
           begin
           clrscr;
           LineCount := 0;
           DrawSquare( 1, 11, 80, 13, Msgs.Attr, true);
           FastWrite( CPad('Standby: Writing',70), 12, 5, (Msgs.Attr or $0080));
           for I := 1 to StackTop do
               begin
               MailMergeRecord(Stack[I]);
               if keypressed then
                  begin
                  GetKey(Ch,FunctionKey);
                  if Ch = #27 then I := succ(StackTop);
                  end;
               end;
           end;
        end;

        (* ------------------------------------ *)

        procedure SortMailMergeStack( PrintStack: BlockArray;
                                      PrintStackTop: integer);
        var I,
            LineCount:          integer;
            FunctionKey:        boolean;
            Ch:                 char;
        begin
        SortList( PrintStack, PrintStackTop, FirstSort);
        SetBG;
        DrawSquare( 1, 23, 80, 25, Msgs.Attr, true);
        FastWrite( CPad('Hit any key to print, or [ESC] to quit.',78),
                   24, 2, Msgs.Attr);
        GetKey(Ch,FunctionKey);
        if Ch <> #27 then
           begin
           clrscr;
           DrawSquare( 1, 11, 80, 13, Msgs.Attr, true);
           FastWrite( CPad('Standby: Writing',70), 12, 5,
                     (Msgs.Attr or $0080));
           for I := 1 to PrintStackTop do
               begin
               MailMergeRecord(PrintStack[I]);
               if keypressed then
                  begin
                  GetKey(Ch,FunctionKey);
                  if Ch = #27 then I := succ(PrintStackTop);
                  end;
               end;
           end;
        end;

        (* ------------------------------------ *)

    begin
    SetBG;
    clrscr;
    Device := 'PRN';
    while Device = 'PRN' do
        begin
        PrintDevice;    (* uses lines 1 and 2 *)
        if Device = 'PRN' then
           begin
           FastWrite( CPad('MailMerge requires a file name !', 40),
                      1, 20, Msgs.Attr);
           Beep(1);
           delay(4000);
           FastWrite( Strng(40,#32), 1, 20, Displays.Attr);  (* was CPad *)
           end;
        end;
    Pause := false;
    Ch := ' ';
    while not (Ch in ['Y','N']) do
       begin
       FastWrite( 'Would you like to sort by other than '+Description[1]+' ?  (Y/N) ',
                  6, 1, Inputs.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       end;
    CursorOn(false);
    assign(OutPutDevice,Device);
    rewrite(OutPutDevice);
    if Ch = 'Y' then
       SortMailMergeStack(Stack,StackTop)
      else
       MailMergeDump(Stack,StackTop);
    close(OutPutDevice);
    end;

     (* ------------------------------------ *)

    procedure LabelStack;
    var RecordNum,
        Copies,
        LineCount,
        I:                           integer;
        FunctionKey:                     boolean;
        Ch:                          char;

        procedure LabelOutStack( Stack:     BlockArray;
                                 StackTop,
                                 Copies:    integer);
        var J,
            I:                              integer;
            FunctionKey:                    boolean;
            Ch:                             char;
        begin
        SetBG;
        DrawSquare( 1, 23, 80, 25, Msgs.Attr, true);
        FastWrite( CPad('Hit any key to print, or [ESC] to quit.',78),
                   24, 2, Msgs.Attr);
        GetKey(Ch,FunctionKey);
        if Ch <> #27 then
           begin
           clrscr;
           DrawSquare( 1, 11, 80, 13, Msgs.Attr, true);
           if Pause then
              FastWrite( CPad('Any key for next item, or [A] for ALL',70),
                         12, 5, Inputs.Attr)
             else
              FastWrite( CPad('Standby: Printing',70),
                         12, 5, (Msgs.Attr or $0080));
           for I := 1 to StackTop do
               begin
               for J := 1 to Copies do
                   begin
                   PrintLabel(1,Stack[I]);
                   if Pause then
                      begin
                      GetKey(Ch,FunctionKey);
                      Ch := upcase(Ch);
                      if Ch = 'A' then
                         begin
                         Pause := false;
                         FastWrite( CPad('Standby: Printing',70),
                                    12, 5, (Msgs.Attr or $0080));
                         end
                        else
                         begin
                         if Ch = #27 then
                            begin
                            I := succ(StackTop);
                            J := succ(Copies);
                            end;
                         end;
                      end
                     else
                      begin
                      if keypressed then
                         begin
                         GetKey(Ch,FunctionKey);
                         if Ch = #27 then
                            begin
                            I := succ(StackTop);
                            J := succ(Copies);
                            end;
                         end;
                      end;
                   end;
               end;
           end;
        end;

        (* ------------------------------------ *)

        procedure SortLabelStack( PrintStack:    BlockArray;
                                  PrintStackTop,
                                  Copies:        integer);
        var Ch:                                  char;
            FunctionKey:                         boolean;
            J,
            I:                                   integer;
        begin
        SortList(PrintStack,PrintStackTop,FirstSort);
        SetBG;
        DrawSquare( 1, 23, 80, 25, Msgs.Attr, true);
        FastWrite( CPad('Hit any key to print, or [ESC] to quit.',78),
                   24, 2, Msgs.Attr);
        GetKey(Ch,FunctionKey);
        if Ch <> #27 then
           begin
           clrscr;
           DrawSquare( 1, 11, 80, 13, Msgs.Attr, true);
           if Pause then
              FastWrite( CPad('Any key for next item, or [A] for ALL',70),
                         12, 5, Inputs.Attr)
             else
              FastWrite( CPad('Standby: Printing',70), 12, 5,
                        (Msgs.Attr or $0080));
           for I := 1 to PrintStackTop do
               begin
               for J := 1 to Copies do
                   begin
                   PrintLabel(1,PrintStack[I]);
                   if Pause then
                      begin
                      Ch := upcase(ReturnKey(FunctionKey));
                      if Ch = 'A' then
                         begin
                         Pause := false;
                         FastWrite( CPad('Standby: Printing',70), 12, 5,
                                   (Msgs.Attr or $0080));
                         end
                        else
                         begin
                         if Ch = #27 then
                            begin
                            I := succ(PrintStackTop);
                            J := succ(Copies);
                            end;
                         end;
                      end
                     else
                      begin
                      if keypressed then
                         begin
                         GetKey(Ch,FunctionKey);
                         if Ch = #27 then
                            begin
                            I := succ(PrintStackTop);
                            J := succ(Copies);
                            end;
                         end;
                      end;
                   end;
               end;
           if FirstSort = 8 then
              begin
              SetBG;
              clrscr;
              FastWrite( 'You have sorted by zip-AlphaCode.          ', 1, 1, Msgs.Attr);
              FastWrite( 'Do you wish a summary sheet ?  (Y/N)  ', 2, 1, Inputs.Attr);
              Ch := ' ';
              while not (Ch in ['Y','N']) do
                 begin
                 Ch := upcase(ReturnKey(FunctionKey));
                 end;
              if Ch = 'Y' then PrintSummary( PrintStack, PrintStackTop);
              end;
           end;
        end;

        (* ------------------------------------ *)

    begin
    SetBG;
    clrscr;
    PrintDevice;
    Copies := CopyQuery;
    LineCount := 0;
    Ch := ' ';
    while not (Ch in ['Y','N']) do
       begin
       FastWrite( 'Pause after each Form ?  (Y/N) ', 4, 1, Inputs.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       end;
    if Ch = 'Y' then Pause := true else Pause := false;
    Ch := ' ';
    while not (Ch in ['Y','N']) do
       begin
       FastWrite( 'Insert a comma after City & period after State ? (Y/N) ',
                  5, 1, Inputs.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       end;
    if Ch = 'Y' then Komma := true else Komma := false;
    Ch := ' ';
    while not (Ch in ['Y','N']) do
       begin
       FastWrite( 'Would you like to sort by other than '+Description[1]+' ?  (Y/N) ',
                  6, 1, Inputs.Attr);
       Ch := upcase(ReturnKey(FunctionKey));
       end;
    CursorOn(false);
    assign(OutPutDevice,Device);
    rewrite(OutPutDevice);
    if Ch = 'Y' then
       SortLabelStack(Stack,StackTop,Copies)
      else
       LabelOutStack(Stack,StackTop,Copies);
    close(OutPutDevice);
    end;

    (* ------------------------------------ *)

    procedure CancelStack(var ActionTaken: boolean);
    var Marker,
        TempStr,
        A:                               s25;
        GetPoint,
        PutPoint,
        AllowControl,
        I:                               integer;
        AllowInput:                      boolean;
    begin
    SetBG;
    clrscr;
    ActionTaken := false;
    DrawSquare( 1, 1, 80, 5, Msgs.Attr, true);
    FastWrite( CPad('You are about to delete ALL marked items from the FILE.',78),
               2, 2, Msgs.Attr);
    FastWrite( CPad('If that is what you want to do, type "DELETE" and hit [ENTER].', 78), 3, 2, Msgs.Attr);
    FastWrite( CPad('Strike [ENTER], alone, to exit.',78), 4, 2, Msgs.Attr);
    AllowControl := -1;
    AllowInput := true;
    A := Strip( GetForm( 35, 6, 10, Strng(10,#32), '', AllowControl,
                         AllowInput, (Inputs.Attr or $0008), [#31..#126]));
    CursorOn(false);
    if UCase(A) = 'DELETE' then
       begin
       SetBG;
       clrscr;
       DrawSquare( 1, 1, 80, 6, Headings.Attr, true);
       ActionTaken := true;
       Marker := '* DELETE *';
       FastWrite( CPad('Re-writing record',70), 2, 5, Headings.Attr);
       for I := 1 to StackTop do
           begin
           str(Stack[I],TempStr);
           FastWrite( CPad(TempStr,10), 3, 35, Msgs.Attr);
           GetRec(Entry,Stack[I]);
           Entry.Addressee := Marker;
           PutRec(Entry,Stack[I]);
           end;
       str(FileTop,TempStr);
       FastWrite( CPad(TempStr,10), 3, 35, Msgs.Attr);
       FastWrite( CPad('Updating record',70), 4, 5, Headings.Attr);
       PutPoint := 1;
       for GetPoint := 1 to FileTop do
           begin
           if (GetPoint mod 10) = 0 then
              begin
              str(GetPoint,TempStr);
              FastWrite( CPad(TempStr,10), 5, 35, Msgs.Attr);
              end;
           GetRec(Entry,GetPoint);
           if Entry.Addressee <> Marker then
              begin
              PutRec(Entry,PutPoint);
              inc(PutPoint);
              end;
           end;            (* for..next *)
        SortTop := SortTop - ((FileTop - PutPoint) + 1);
        FileTop := pred(PutPoint);
        PutFileTop;
        end;         (* if..then *)
    end;

    (* ------------------------------------ *)

    procedure SortStack;
    var I,
        J,
        PutPoint:                integer;
        TempStr:                  Line;
    begin
    if StackTop > 0 then
       begin
       clrscr;
       DrawSquare( 25, 10, 55, 15, Headings.Attr, true);
       FastWrite( CPad('Eliminating Duplicates',24), 12, 28, Headings.Attr);
       for I := StackTop downto 2 do
           begin
           if (I mod 10) = 0 then
              begin
              str(I,TempStr);
              FastWrite( CPad(TempStr,24), 13, 28, Msgs.Attr);
              end;
           for J := 1 to pred(I) do
               begin
               if Stack[I] < Stack[J] then SwapI( Stack[I], Stack[J]);
               end;        (* for..next loop (J) *)
           end;            (* for..next loop (I) *)
       clrscr;
       FastWrite( CPad('Standby:',70), 12, 5, (Msgs.Attr or $0080));
       PutPoint := 1;
       for I := 1 to pred(StackTop) do
           begin
           if Stack[I] <> Stack[succ(I)] then
              begin
              Stack[PutPoint] := Stack[I];
              inc(PutPoint);
              end;      (* if..then *)
           end;         (* for..next *)
       Stack[PutPoint] := Stack[StackTop];
       StackTop := PutPoint;
       end;
    end;

    (* ------------------------------------ *)

    procedure WhichNumber(var X: integer);
    var AllowControl,
        Err:                     integer;
        AllowInput:              boolean;
    begin
    FastWrite( CPad('Which Entry from the list above ?   (or [ENTER])  ',70),
               23, 5, Inputs.Attr);
    Err := 0;
    AllowControl := -1;
    AllowInput := true;
    X := Str2Int( GetForm( 68, 23, 5, Strng(5,#32), '1', AllowControl,
                           AllowInput, Inputs.Attr, ['0'..'9']),
                  Err);
    if ((X < 1) or (X > StackTop)) or (Err <> 0) then X := 0;
    end;

    (* ------------------------------------ *)

    procedure StackAnd;
    var RecordNum,
        StackTop2,
        HoldTop,
        Division,
        SubCode,
        I,
        HoldLen,
        J:                               integer;
        Stack2:                          BlockArray;
        SearchFor:                          S40;
        AcceptAll,
        Found:                           boolean;
        HoldSubDivisions:                      Line;
        SubCodeStack:                       IntArray;
    begin
    StackTop2 := StackTop;
                 (* for I := 1 to StackTop do Stack2[I] := Stack[I]; *)
    move( Stack, Stack2, sizeof(Stack));
    ClearStack;
    StackChoice( Choice, ZipBegin);
    if (Choice > 0) and (Choice <= 11) then
       begin
       if Choice = 11 then
          begin
          CursorOn(false);
          Division := 0;
          AcceptAll := false;
          PrintDivision;
          FastWrite( CPad('Which division ? (A-Z)',78), 24, 2, Menus.Attr);
          Ch := upcase(ReturnKey(FunctionKey));
          Division := ord(Ch)-64;
          if (Division > 0) and (Division <= DivisionTop) then
             begin
             HoldSubDivisions := '';
             HoldTop := 0;
             PrintSubDivision(Division);
             FastWrite( CPad('Letter or F1 for ALL division',78),
                        24, 2, Menus.Attr);
             Ch := upcase(ReturnKey(FunctionKey));
             if Ch = #59 then SubCode := -1 else SubCode := ord(Ch)-64;
             if SubCode = -1 then
                AcceptAll := true
               else
                begin
                repeat
                   if (SubCode >= 1) and (SubCode <= SubDivisionTop) then
                      begin
                      HoldSubDivisions := HoldSubDivisions + ' ' + Ch;
                      inc(HoldTop);
                      SubCodeStack[HoldTop] := SubCode;
                      end;
                   HoldLen := (80 - ord(HoldSubDivisions[0])) div 2 ;
                   FastWrite( HoldSubDivisions, 21, HoldLen, Msgs.Attr);
                   FastWrite( CPad('Letter or F1 to search',78),
                              24, 2, Menus.Attr);
                   Ch := upcase(ReturnKey(FunctionKey));
                   if Ch = #59 then SubCode := 41 else SubCode := ord(Ch)-64;
                until SubCode = 41;
                SearchFor := HoldSubDivisions;
                end;   (* get choices *)
             end;      (* Division section *)
          end
         else
          begin        (* Division not in range *)
          clrscr;
          SearchFor := GetSearchFor(Choice);
          X := Description[Choice];
          end;
       clrscr;
       StackHeading(SearchFor);
       for I := 1 to StackTop2 do
          begin
          RecordNum := Stack2[I];
          PrintCount(RecordNum);
          if Choice = 11 then
             Found := RecTestInteger( RecordNum, Division, HoldTop,
                                      SubCodeStack, AcceptAll)
            else
             Found := RecTestChar( RecordNum, Choice, SearchFor, ZipBegin);
          if Found then
             begin
             inc(StackTop);
             Stack[StackTop] := RecordNum;
             end;
          end;   (* next I *)
       end
      else
       begin
       move( Stack2, Stack, sizeof(Stack2));
       (* for I := 1 to StackTop2 do Stack[I] := Stack2[I]; *)
       StackTop := StackTop2;
       end;       (* if..then..else *)
    end;

    (* ------------------------------------ *)

    procedure StackNot;
    var RecordNum,
        StackTop2,
        HoldTop,
        HoldLen,
        Division,
        SubCode,
        I,
        J:                               integer;
        Stack2:                          BlockArray;
        SearchFor:                       S40;
        AcceptAll,Found :                boolean;
        HoldSubDivisions:                Line;
        SubCodeStack:                    IntArray;
    begin
    StackTop2 := StackTop;
    move( Stack, Stack2, sizeof(Stack));
    ClearStack;
    StackChoice( Choice, ZipBegin);
    if (Choice > 0) and (Choice <= succ(LastDescription)) then
       begin
       if Choice = 11 then
          begin
          Division := 0;
          AcceptAll := false;
          PrintDivision;
          FastWrite( CPad('Which division ? (A-Z)',78), 24, 2, Menus.Attr);
          Ch := upcase(ReturnKey(FunctionKey));
          Division := ord(Ch)-64;
          if (Division > 0) and (Division <= DivisionTop) then
             begin
             HoldSubDivisions := '';
             HoldTop := 0;
             PrintSubDivision(Division);
             FastWrite( CPad('Letter or F1 for ALL division',78),
                        24, 2, Menus.Attr);
             Ch := upcase(ReturnKey(FunctionKey));
             if Ch = #59 then SubCode := -1 else SubCode := ord(Ch)-64;
             if SubCode = -1 then
                AcceptAll := true
               else
                begin
                repeat
                   if (SubCode >= 1) and (SubCode <= SubDivisionTop) then
                      begin
                      HoldSubDivisions := HoldSubDivisions + ' ' + Ch;
                      inc(HoldTop);
                      SubCodeStack[HoldTop] := SubCode;
                      end;
                   HoldLen := (80 - ord(HoldSubDivisions[0])) div 2 ;
                   FastWrite( HoldSubDivisions, 21, HoldLen, Msgs.Attr);
                   FastWrite( CPad('Letter or F1 to search',78),
                              24, 2, Menus.Attr);
                   Ch := upcase(ReturnKey(FunctionKey));
                   if Ch = #59 then SubCode := 41 else SubCode := ord(Ch)-64;
                until SubCode = 41;
                SearchFor := HoldSubDivisions;
                end;   (* get choices *)
             end;      (* Division section *)
          end
         else
          begin
          clrscr;
          SearchFor := GetSearchFor(Choice);
          X := Description[Choice];
          end;
       clrscr;
       StackHeading(SearchFor);
       for I := 1 to StackTop2 do
           begin
           RecordNum := Stack2[I];
           PrintCount(RecordNum);
           if Choice = 11 then
              Found := RecTestInteger( RecordNum, Division, HoldTop,
                                       SubCodeStack, AcceptAll)
             else
              Found := RecTestChar( RecordNum, Choice, SearchFor, ZipBegin);
           if not Found then
              begin
              inc(StackTop);
              Stack[StackTop] := RecordNum;
              end;
           end;   (* next I *)
        end
       else
        begin
        move( Stack2, Stack, sizeof(Stack2));
        StackTop := StackTop2;
        end;       (* if..then..else *)
    end;

    (* ------------------------------------ *)

  procedure RepeatStack;

    procedure StackList;
    var ActionTaken,
        FunctionKey,
        Continue:          boolean;
        Ch:                char;
        OCh,
        StackNumber,
        TempNumber:          integer;
    begin
    Ch := ' ';
    Continue := true;
    if StackSort then SortStack;
    while Continue do
       begin
       ViewList(FunctionKey,Ch);
       DrawSquare( 1, 22, 80, 25, Menus.Attr, true);
       FastWrite( '                            CTL-F'+
                  '5 MailMerge                               ',
                  23, 3, Menus.Attr);
       FastWrite( ' Function keys: F1 - F10 ', 23, 3, Msgs.Attr);
       FastWrite( '1 Del  2 Cancel  3 Code  4 Edit  '+
                  '5 Sys  6 Form  7 Line  8 And  9 Or  10 Not',
                  24, 3, Menus.Attr);
       CursorOn(false);
       GetKey(Ch,FunctionKey);
       OCh := ord(Ch);
       if (OCh = 27) then
          Continue := false
         else
          begin
          Continue := true;
          case OCh of
             59: begin
                 WhichNumber(StackNumber);
                 if (StackNumber) <> 0 then
                    begin
                    TempNumber := Stack[StackNumber];
                    DeleteQuery( ActionTaken, TempNumber);
                    if ActionTaken then Continue := false;
                    end;
                 end;
             60: begin
                 CancelStack(ActionTaken);
                 if ActionTaken then Continue := false;
                 end;
             61: begin
                 clrscr;
                 SetCodes;
                 Continue := true;
                 end;
             62: begin
                 WhichNumber(StackNumber);
                 if (StackNumber) <> 0 then
                    begin
                    TempNumber := Stack[StackNumber];
                    GetRec(HoldEntry,TempNumber);
                    EditRecord(TempNumber);
                    GetRec(Entry,TempNumber);
                    if (UCase(Entry.Addressee) <> UCase(HoldEntry.Addressee)) then
                       Continue := false;
                    end;
                 end;
             63: begin
                 ModeMenu;
                 Continue := true;
                 end;
             64: begin
                 clrscr;
                 LabelStack;
                 end;
             65: begin
                 clrscr;
                 PrintStack;
                 end;
             66: begin
                 StackAnd;
                 end;
             67: begin
                 StackSort := true;
                 RepeatStack;
                 Continue := false;
                 end;
             68: begin
                 StackNot;
                 end;
             98: begin    (* ctl - f5 *)
                 clrscr;
                 MailMergeStack;
                 end;
             end;            (* case *)
          end;               (* if..then..else *)
       end;                  (* while loop *)
    end;

  begin
  StackChoice(Choice,ZipBegin);
  (* if Choice = 0 then RepeatStack; allow quiting *)
  if (Choice > 0) and (Choice <= 10) then
     begin
     clrscr;
     AlphaTest(Choice,ZipBegin);
     StackList;
     end
    else
     begin
     if Choice = 11 then
        begin
        clrscr;
        DivisionTest;
        StackList;
        end;
     end;
  end;

begin
ZipBegin := 0;
X1 := '';  X2 := '';
ClearStack;
RepeatStack;
SetBG;
end;

end.

