UNIT PopCalc;

INTERFACE
 USES IoStuff,CRT;
 PROCEDURE SetPocketCalc(X,Y:Integer);
 FUNCTION  PocketCalc:Real;

{  This function pops up a typical pocket calculator on the screen  }
{  which performs simple addition, division, multiplication and     }
{  subtraction.  The calculator has a memory register which may be  }
{  added, multiplied into.  The decimal points displayed may be     }
{  changed.  Since the calculator uses real numbers for the results }
{  the accuracy is limited to about 11 digits.  This could be       }
{  increased by using double variables if the computer has a numeric}
{  coprocessor.                                                     }

IMPLEMENTATION
CONST
  ColorF1  = Yellow;    { Border and keys of calculator }
  ColorB1  = Blue;      { Background of calculator }
VAR
  Operand  : Char;      { Operand + - / * = return key }
  ChIn     : Char;      { Input Character }
  DisplayNum  : Real;   { The number displayed in the calculator }
  StorageNum  : Real;   { The result of the last operation }
  Memory   : Real;      { Memory register }
  TempSt   : String[15];  { Temporary string used for input }
  ShiftSt  : String[15];  { Another temporary string }
  ClearMem : Boolean;     { Switch used in clearing memory }
  JustOp   : Boolean;     { True if we just performed an operation }
  JustNum  : Boolean;     { True if we just input a number }
  DecCh    : Char;        { Character indicating number of decimal pl }
  NDec     : Integer;     { Number of decimal places for display }
  Err      : Integer;     { Indicates errors in string operations }
  ExitCalc : Boolean;     { True when we are ready to get out }
  XPos,YPos: Integer;     { Row, Col of upper left hand corner of calculator }
  SaveAttr : Byte;        { To save color attribute of calling routine }
{===========================================================================}

PROCEDURE SetPocketCalc(X,Y:Integer);    { Sets position of Calculator }
Begin
  XPos := X;
  YPos := Y;
  If XPos > 60 then XPos := 60;        { Make sure Calculator is on screen }
  If YPos > 19 then YPos := 19;
  If XPos < 1 then XPos := 1;
  If YPos < 1 then YPos := 1;
End;

{===========================================================================}

PROCEDURE Operate;   { Here's where we do the arithmetic }
BEGIN

 { If a number string was just entered get it and turn it into a real value }
 If JustNum then begin
    Val(ReadFromScr(XPos+3,YPos+2,15),DisplayNum,Err);
    JustNum := false;
 end;

 Case Operand of
 '+' : DisplayNum := StorageNum + DisplayNum;  { Addition }
 '-' : DisplayNum := StorageNum - DisplayNum;  { Subtraction }
 '*' : DisplayNum := StorageNum * DisplayNum;  { Multiplication }
 '/' : DisplayNum := StorageNum / DisplayNum;  { Division }
                                    { Add more stuff here if you wish }
 End; {case}

 Str(DisplayNum:15:NDec,TempSt);   { Turn DisplayNum into a string }
 WriteSt(TempSt,XPos+3,YPos+2);    { and write it on the screen }
 JustOp := True;                   { Set JustOp switch for logic below }
 WriteCh(' ',XPos+19,YPos+2);      { Blank out the operator character }
END;

{===========================================================================}

FUNCTION PocketCalc:Real;      { PocketCalc returns the value in the display }
BEGIN
  SaveAttr := TextAttr;        { Save the current Text attribute }
  ExitCalc := False;           { Initialize switches, etc. }
  JustOp := True;
  JustNum := False;
  ClearMem := False;
  Operand := ' ';              { Start with a nul operand }

  SetColor(ColorF1,ColorB1);         { Blank out the area of the calculator }
  Window(XPos,YPos,XPos+21,YPos+18);
  ClrScr;
  Window(1,1,80,25);

  HideCursor;                                  { Hide the cursor }
  Border(XPos,YPos,XPos+21,YPos+18,'');        { Write the calculator }
  Border(XPos+2,YPos+1,XPos+18,YPos+3,'');
  WriteSt('Ŀ Ŀ',XPos+2,YPos+4);
  WriteSt(' 7  8  9   / ',XPos+2,YPos+5);
  WriteSt(' 4  5  6   * ',XPos+2,YPos+6);
  WriteSt(' 1  2  3   - ',XPos+2,YPos+7);
  WriteSt('    0  .   + ',XPos+2,YPos+8);
  WriteSt('           = ',XPos+2,YPos+9);
  WriteSt(' ',XPos+2,YPos+10);
  WriteSt('Ŀ',XPos+2,YPos+11);
  WriteSt(' C Clear       ',XPos+2,YPos+12);
  WriteSt(' D Decimal Pl. ',XPos+2,YPos+13);
  WriteSt(' M Mem. +-*/=R ',XPos+2,YPos+14);
  WriteSt('',XPos+2,YPos+15);

  Str(DisplayNum:15:NDec,TempSt);       { Display default number }
  WriteSt(TempSt,XPos+3,YPos+2);        { If first time this is zero }
  GoToXY(XPos+17,YPos+2);

  Repeat                           { Start of big keystroke reading loop }
   ChIn := Upcase(ReadKey);
   Case ChIn of

   '0'..'9','.' : Begin            { Process a number keystroke }
             JustNum := true;
                                   { If 1st digit clear display }
             If JustOp then WriteSt('               ',XPos+3,YPos+2);
             JustOp := False;
                                   { Clear memory line at bottom }
             If ClearMem then Begin
               WriteSt('                   ',XPos+2,YPos+17);
               ClearMem := False;
             End;
                                   { Read existing numbers from screen }
             ShiftSt := ReadFromScr(XPos+3,YPos+2,15);
                                   { Add a zero to front of string if    }
                                   { user entered decimal because        }
                                   { Turbo Val function won't recognize  }
                                   { a number that begins with a decimal }
             If (ChIn = '.') and (ShiftSt  = '')
                             then ShiftSt := '              0';

                                   { Delete leftmost digit (ususally blank )}
             Delete(ShiftSt,1,1);
                                   { Write out the shifted number string }
             WriteSt(ShiftSt,XPos+3,YPos+2);
                                   { Finally write out the digit read in }
             WriteCh(ChIn,XPos+17,YPos+2);
            End;

   '+','-','*','/' : Begin     { Process an operator Keystroke }

                               { First handle the messy case of negative }
                               { numbers rather than the minus operator. }
                               { Test for negative number conditions     }
                      If JustOp and (ChIn in ['-','+']) and (Operand <> ' ')
                      then begin
                               { Blank display }
                        WriteSt('               ',XPos+3,YPos+2);
                               { and write a - or + sign on display }
                        WriteCh(ChIn,XPos+17,YPos+2);
                        JustOp := false;
                      End
                               { OK now we got a real operator }
                      else begin
                               { First clean up the last operation }
                        Operate;
                        JustNum := false;
                               { Store the results }
                        StorageNum := DisplayNum;
                               { Put the operator in the hopper for next time }
                        Operand := ChIn;
                        WriteCh(Operand,XPos+20,YPos+2);
                      End;
                     End;

   '=',#13 : Begin      { Process enter key or = key }

                        { First clean up last operation }
          Operate;
          Operand := ' ';
          WriteCh('=',XPos+20,YPos+2);
         End;

    'C' : Begin         { Process a "clear" instruction }
           DisplayNum := 0;
           StorageNum := 0;
           Operand := '!';
           JustOp := true;
           WriteSt('               ',XPos+3,YPos+2);
          End;

     'D' : Begin       { Change number of decimal places displayed }
           WriteSt('Decimal Places ?  ',XPos+2,YPos+17);
                       { Get the number of decimal places }
           Repeat
             DecCh := ReadKey;
             If not (DecCh in ['0'..'9',#27]) then beep;
           Until DecCh in ['0'..'9',#27];

           If DecCh <> #27 then Begin
             Val(DecCh,NDec,Err);            { Convert the string  to a number }
             Str(DisplayNum:15:NDec,TempSt); { and rewrite the display }
             WriteSt(TempSt,XPos+3,YPos+2);
           End;
                          { Blank the decimal places prompt }
           WriteSt('                ',XPos+2,YPos+17);
          End;

   'M' : Begin      { Process memory stuff here }

           If JustNum then begin
            Val(ReadFromScr(XPos+3,YPos+2,15),DisplayNum,Err);
            JustNum := false;
           end;

           WriteSt('Mem',XPos+2,YPos+17);
           GoToXY(XPos+6,YPos+17);
           Write(Memory:14:2);
                    { Get the second Memory keystroke }
                    { +, -, C(lear), R(ecall), =, enter, escape }
           Repeat
                DecCh := Upcase(ReadKey);
                If not (DecCh in ['+','-','C','R','=',#13,#27]) then beep;
              Until DecCh in ['+','-','C','R','=',#13,#27];

              If DecCh <> #27 then begin
               If DecCh = #13 then DecCh := '=';
               WriteCh(DecCh,XPos+6,YPos+17);

               Case DecCh of
               '+' : Memory := Memory + DisplayNum; { Add to memory }
               '-' : Memory := Memory - DisplayNum; { Subtract from memory }
               'C' : Memory := 0;                   { Clear memory }
               'R' : Begin                          { Recall memory to Display }
                       Str(Memory:15:NDec,TempSt);
                       WriteSt(TempSt,XPos+3,YPos+2);
                       DisplayNum := Memory;
                     End;
               '=' : Memory := DisplayNum;            { Move display into memory }
               End; {case}
               JustOp := True;
               GoToXY(XPos+6,YPos+17);

               Write(Memory:14:2);     { Write out contents of memory }
               ClearMem := true;       { Set switch to clear mem display }
              End
                                       { user hit escape }
              else WriteSt('                   ',XPos+2,YPos+17);
            End;

   #27 : ExitCalc := True;     { User hit escape -- set switch to exit }
   Else Beep;                  { Illegal key }
   End; {Case}

  Until ExitCalc;         { End of big keystroke loop }

 ShowCursor;
 TextAttr := SaveAttr;
 PocketCalc := DisplayNum;      { Set Function to number in display }
END;

BEGIN {Initialization}
  XPos := 10;
  YPos := 5;
  DisplayNum := 0;
  StorageNum := 0;
  Memory := 0;
  NDec := 2;
END.