UNIT GETCOLOR;
INTERFACE
  USES CRT,IOSTUFF;
  PROCEDURE SetChooseColor(X,Y : Integer);
  PROCEDURE ChooseColor(VAR Fore,Back : Integer);
IMPLEMENTATION
VAR
      XPos        : Integer;  {These two varibles control the location}
      YPos        : Integer;   {of the color box on the screen}
{======================================================================}
PROCEDURE SetChooseColor(X,Y : Integer);
BEGIN
  If X < 1 then X := 1;
  If Y < 1 then Y := 1;
  If X + 52 < 81 then XPos := X else XPos := 28;
  If Y + 8 < 26 then YPos := Y else YPos := 17;
END;

{======================================================================}
PROCEDURE ChooseColor(VAR Fore,Back : Integer);

{ ChooseColor Pops up a color selection smorgasbord on the screen   }
{ and allows the user to select the background and foreground colors}
{ desired by playing with the smorgasbord.  When the user exits     }
{ the procedure, the selected colors are returned in Fore and  }
{ Back.  The only outside procedure needed is SetColor.        }
{ The logic to turn the cursor off and on should be placed external }
{ in procedures CursorOff and CursorOn, for example, if they are    }
{ needed elsewhere in the main program.                             }
{ Constants XPos and YPos control the position of the upper left    }
{ hand corner of the color selection smorgasbord box.               }

CONST
      Phrase               : Array[1..3] of String[20] =
                             ('ForeGround:',
                              'BackGround:',
                              'Quit & Lock Colors');

      FirstLet   :  Array[1..3] of Char = ('F','B','Q');


      EscKey     = #27;       { Keys acted on in color selection }
      DownArrow  = #80;
      UpArrow    = #72;
      RightArrow = #77;
      LeftArrow  = #75;
      EnterKey   = #13;

      ColorF1    = Green;     { Foreground color - menu phrases }
      ColorB1    = Black;     { Background color - menu phrases }
      ColorF2    = Magenta;   { Foreground color - border       }
      ColorB2    = Black;     { Background color - border       }
      ColorF3    = LightCyan; { Foreground color - first letter of menu }
      ColorB3    = Black;     { Background color - first letter of menu }
      ColorF4    = Black;     { Foreground color - reverse menu }
      ColorB4    = LightGray; { Background color - reverse menu }
      ColorF5    = LightRed;  { Foreground color - arrow }
      ColorB5    = Black;     { Background color - arrow }


VAR
      II          : Integer;
      FBQ         : Integer;       { 1,2 or 3 depending on whether   }
      LastFBQ     : Integer;       { Fore, Back or Quit is selected. }
      CCh         : Char;
      ColorExit   : Boolean;
      FunctKey    : Boolean;
      SaveAttr    : Byte;
 {======================================================================}
  PROCEDURE DrawSample;
  BEGIN
            { show a sample of the color selected }
        SetColor(Fore,Back);
        WriteSt('͸',XPos+32,YPos+2);
        WriteSt('  SAMPLE OF COLOR  ',XPos+32,YPos+3);
        WriteSt(';',XPos+32,YPos+4);
  END;
{======================================================================}
PROCEDURE ShowTopArrow;
BEGIN
   SetColor(ColorF5,ColorB5);
   WriteSt('                ',XPos+13,YPos+1);
   WriteCh(chr(25),XPos+13+Fore,YPos+1);
END;
{======================================================================}
PROCEDURE ShowBottomArrow;
BEGIN
   SetColor(ColorF5,ColorB5);
   WriteSt('                ',XPos+13,YPos+3);
   WriteCh(chr(25),XPos+13+Back,YPos+3);
END;

{======================================================================}
BEGIN
   If (Fore < 0) or (Fore > 15) then Fore := LightGray;
   If (Back < 0) or (Back > 15) then Back := Black;
   SaveAttr  := TextAttr;
   ColorExit := False;
   HideCursor;
   SetColor(ColorF2,ColorB2);
   Window(XPos,YPos,XPos+30,YPos+8);
   ClrScr;
   Window(1,1,80,25);
   Border(XPos,YPos,XPos+30,YPos+8,'CHOOSE COLOR');

         {Write the menu phrases}
   For II := 1 to 3 do
    Begin
     SetColor(ColorF1,ColorB1);
     WriteSt(Phrase[II],Xpos+2,YPos+II*2);
     SetColor(ColorF3,ColorB3);
     WriteCh(FirstLet[II],XPos+2,YPos+II*2);
    End;

         {Write the color dots}
   For II := 0 to 15 do
   Begin
     Setcolor(II,ColorB1);
     WriteSt(chr(254),II+XPos+13,YPos+2);
     If II = 8 then SetColor(LightGray,II)
               else SetColor(ColorB1,II);
     WriteCh(chr(254),II+XPos+13,YPos+4);
   End;

         {Get ready for the key reading loop}
    FBQ := 1;
    LastFBQ := 0;
    DrawSample;
    ShowTopArrow;
    ShowBottomArrow;
        {Start Big key reading loop}
  Repeat

              {write the reverse video menu phrase}
       If LastFBQ <> FBQ then Begin
         SetColor(ColorF4,ColorB4);
         WriteSt(Phrase[FBQ],XPos+2,YPos+FBQ*2);

              {restore the last reverse video menu phrase}
         If LastFBQ <> 0 then Begin
           SetColor(ColorF1,ColorB1);
           WriteSt(Phrase[LastFBQ],XPos+2,YPos+LastFBQ*2);
           SetColor(ColorF3,ColorB3);
           WriteCh(FirstLet[LastFBQ],XPos+2,YPos+LastFBQ*2);
         End;
       End;
              { remember the last FBQ Index }
       LastFBQ := FBQ;

       CCh := Readkey;        {read a keystroke}
       If CCh <> #0 then FunctKey := False else
        Begin
          CCh := Readkey;
          FunctKey := True;
        End;

    If not FunctKey then Case CCh of

      'F','f': FBQ := 1;                    {got an F key, Foreground}
      'B','b': FBQ := 2;                    {got a B key, Background }
      'Q','q',EscKey : ColorExit := True;    {got a Q or Escape key, quit}

      EnterKey : Begin                       {got an enter key}
                  If FBQ < 3 then FBQ := Succ(FBQ)
                  Else ColorExit := True;
                 End;

      Else Beep;                             {beep on any other key}

    End; {case non function keys}

            {process function keys (cursor pad)}
   If FunctKey then Case CCh of
   DownArrow : Begin
                If FBQ < 3 then FBQ := FBQ+1
                Else FBQ := 1;
               End;

   UpArrow   : Begin
                If FBQ > 1 then FBQ := FBQ - 1
                Else FBQ := 3;
               End;

   RightArrow : Case FBQ of
          1: Begin
              If Fore < 15 then Fore := Succ(Fore)
                                else Fore := 0;
              DrawSample;
              ShowTopArrow;
             End;
          2: Begin
              If Back < 15 then Back := Succ(Back)
                                else Back := 0;
              DrawSample;
              ShowBottomArrow;
             End;
          3: Beep;
          End; {case FBQ}

   LeftArrow : Case FBQ of
          1: Begin
              If Fore > 0 then Fore := Pred(Fore)
                               else Fore := 15;
              DrawSample;
              ShowTopArrow;
             End;
          2: Begin
              If Back > 0 then Back := Pred(Back)
                               else Back := 15;
              DrawSample;
              ShowBottomArrow;
             End;
          3: Beep;
         End; {case}

   Else Beep;
   End; {case function keys}

Until ColorExit;     {bottom of keystroke loop}

ShowCursor;
TextAttr := SaveAttr;

END;

BEGIN  {Initialization}
  XPos := 20;
  YPos := 5;

END. {UNIT}