UNIT DRAWBOX;
INTERFACE
 USES CRT,IOSTUFF;
 PROCEDURE Box(VAR X,Y:Integer);
IMPLEMENTATION
{=================================================================}
PROCEDURE Box(VAR X,Y:Integer);
CONST
      LeftArrow   = #75;
      RightArrow  = #77;
      UpArrow     = #72;
      DownArrow   = #80;
      EnterKey    = #13;
      EscKey      = #27;
VAR
      ExitDrawBox : Boolean;
      XL,YL       : Integer;
      DrawCh      : Char;
      FunctKey    : Boolean;
{===========================================}
FUNCTION Patch1(X,Y:Integer):Char;
VAR
     Temp : Integer;
BEGIN
     Temp := 0;
     If X > 1 then If GetCh(X-1,Y) in ['','','','','','','']
                      then Temp := Temp + 1;
     If Y > 1 then If GetCh(X,Y-1) in ['','','','','','','']
                      then Temp := Temp + 2;
     If X < 80 then If GetCh(X+1,Y) in ['','','','','','','']
                       then Temp := Temp + 4;
     If Y < 25 then If GetCh(X,Y+1) in ['','','','','','','']
                       then Temp := Temp + 8;

  Case Temp of
     0: Patch1 := ' ';
     1: Patch1 := '';
     2: Patch1 := '';
     3: Patch1 := '';
     4: Patch1 := '';
     5: Patch1 := '';
     6: Patch1 := '';
     7: Patch1 := '';
     8: Patch1 := '';
     9: Patch1 := '';
     10: Patch1 := '';
     11: Patch1 := '';
     12: Patch1 := '';
     13: Patch1 := '';
     14: Patch1 := '';
     15: Patch1 := '';
     End; {case}
End;
{==========================================================}
BEGIN
    ExitDrawBox := False;
    If (X < 1) or (X > 80) then X := 1;
    If (Y < 1) or (Y > 25) then Y := 1;
    XL := X; YL := Y;
Repeat
      GoToXY(X,Y);
      DrawCh := ReadKey;
      If DrawCh <> #0 then FunctKey := False
      else Begin
        DrawCh := ReadKey;
        FunctKey := true;
      End;

      If not FunctKey then Case DrawCh of

         EnterKey : ExitDrawBox := True;
         EscKey   : ExitDrawBox := True;
         else Beep;

       End; {case}

      If FunctKey then Case DrawCh of

         LeftArrow  : If X > 1 then X := X - 1 else Beep;
         RightArrow : If X < 80 then X := X + 1 else Beep;
         UpArrow    : If Y > 1 then Y := Y - 1 else Beep;
         DownArrow  : If Y < 25 then Y := Y + 1 else Beep;
         else Beep;

      End;{ of case DrawCh}

         HideCursor;
         If Y <> YL then WriteCh('',X,Y);
         If X <> XL then WriteCh('',X,Y);
         WriteCh(Patch1(XL,YL),XL,YL);
         WriteCh(Patch1(X,Y),X,Y);

         XL:=X; YL:=Y;
         ShowCursor;

 Until ExitDrawBox;

END;

END.