UNIT KEY2;
INTERFACE
 USES IOSTUFF,CRT;

VAR
 FunctKey : Boolean;
 HelpEnv  : Integer;

 FUNCTION NextKey:Char;
 PROCEDURE SetHelpMax(Max : Integer);
 PROCEDURE HelpLoad(N : Integer; HelpFile : ShortStr);

IMPLEMENTATION

CONST
   NumScr = 7;

VAR
   HelpS      : Array[1..NumScr] of ^screen;
   HelpNam    : Array[1..NumScr] of ShortStr;
   FoundIt    : Array[1..NumScr] of Boolean;
   FileMem    : File;
   NN         : Integer;
   MaxScr     : Integer;

{=====================================================================}
PROCEDURE SetHelpMax(Max : Integer);
BEGIN
   MaxScr := Max;
END;

{=====================================================================}
PROCEDURE HelpLoad(N : Integer; HelpFile : ShortStr);
BEGIN
   If (N > 0) and (N <= MaxScr) then
   Begin
       FoundIt[N] := True;
       Assign(FileMem,HelpFile);
       {$I-} Reset(FileMem,4000); {$I+}
       If IOresult = 0 then
        Begin
         New(HelpS[N]);
         BlockRead(FileMem,HelpS[N]^,1);
         Close(FileMem);
        End

       Else FoundIt[N] := false;
   End;
END; {MemoryLoad}

{=====================================================================}
PROCEDURE HelpMsg;
VAR
   SaveRow,SaveCol   : Integer;
   SaveFore,SaveBack : Integer;
   HelpScr           : Integer;
   HelpCh            : Char;
   Funct,ExitHelp    : Boolean;
   SaveAttr          : Byte;
BEGIN
    SaveScreen(3);
    SaveAttr := TextAttr;
    SaveRow := WhereX;
    SaveCol := WhereY;
    HelpScr := HelpEnv;
    ExitHelp := False;
    Repeat
          If FoundIt[HelpScr] then
            Begin
              MovetoScreen(HelpS[HelpScr]^,Video^,4000);
              Display('Hit any key to return.  Or use PgDn/PgUp keys for more help screens.',1,25);
            End
          Else Beep;
          HelpCh := ReadKey;
          If HelpCh <> #0 then Funct := false
            else begin
              HelpCh := ReadKey;
              Funct := True;
            End;

          If (Funct) and (HelpCh in [#72,#73,#80,#81])
          then Case HelpCh of
                #72,#73 : If HelpScr > 1 then Dec(HelpScr)
                                         else HelpScr := MaxScr;
                #80,#81 : If HelpScr < MaxScr then Inc(HelpScr)
                                         else HelpScr := 1;
              End {case}
          else ExitHelp := true;
    Until ExitHelp;

    TextAttr := SaveAttr;
    RestoreScreen(3);
    GoToXY(SaveRow,SaveCol);
END;


{=====================================================================}
FUNCTION NextKey:Char;
VAR
    NKey : Char;
LABEL
    Start;
BEGIN
Start:Nkey := Readkey;
      If Nkey <> #0 then FunctKey := False
      else
        Begin
          Nkey := Readkey;
          FunctKey := True;
        End;
      If FunctKey and (Nkey = #59) then
      Begin
        HelpMsg;
        GoTo Start;
      End;
      NextKey := NKey;
END;
Begin
  MaxScr := 0;
  For NN := 1 to NumScr do FoundIt[NN] := False;
  HelpEnv := 1;
END.