UNIT GETLNE;

INTERFACE
 USES IOSTUFF,KEY2,CRT;

 FUNCTION GetStr(X,Y,Len:Integer;Default:AnyStr) : AnyStr;

IMPLEMENTATION

CONST
  LeftArrow  = #75;         { Keys used in editing string }
  RightArrow = #77;
  InsertKey  = #82;
  DeleteKey  = #83;
  EnterKey   = #13;
  EscKey     = #27;
  BackSpKey  = #8;
  CtrlBackSp = #127;
  HomeKey    = #71;
  EndKey     = #79;

VAR
  InsToggle : Boolean;     { Insert key toggle switch }
  Virgin    : Boolean;     { Used for edit versus enter-new decision }

{======================================================================}
FUNCTION GetStr(X,Y,Len:Integer;Default:AnyStr) : AnyStr;
VAR
   ExitGetStr          : Boolean;  { Exit switch }
   TCh                 : Char;     { Current keystroke }
   XG,II               : Integer;  { Remember starting X position }
   TempStr             : AnyStr;   { Temporary string for editing }
 { FunctKey            : Boolean;    True if keystroke was function key }
                                   { FunctKey is defined in Key }
BEGIN
   ExitGetStr := False;   { Set exit switch false }
   XG := X;
   X := X+Length(Default);            { Set X location of cursor }
   FillChar(TempStr,Sizeof(TempStr),' ');  { Fill TempStr with Blanks }
   Tempstr[0] := Chr(Len);
   WriteSt(TempStr,XG,Y);              { Write blanks on screen }
   InsToggle := False;                 { Start with insert off }
   ShowCursor;                         { Make sure cursor is visible }
   LineCursor;                         { Make cursor small }
   WriteSt(Default,XG,Y);              { Write default on screen }
   Virgin := true;                     { Assume default will not be edited }
Repeat
     If X > XG+Len-1 then Begin        { Increment cursor location }
       X := XG+Len-1;
       Beep;
     End;
     If X < XG then Begin              { Don't let cursor get out of field }
       X := XG;
       Beep;
     End;

      GoToXY(X,Y);                    { Position cursor }

      If InsToggle then Bigcursor else Linecursor;   { Make cursor big }

      TCh := NextKey;                    { Read a keystroke }

  If FunctKey then case TCh of       { Handle function keys here }
      LeftArrow : X := X - 1;      { Decrement cursor location }
      RightArrow: X := X + 1;      { Increment cursor location }
      InsertKey : Begin              { Toggle insert switch on/off}
                   InsToggle := not InsToggle;
                   If InsToggle then Bigcursor  {block cursor - ins off}
                   Else Linecursor;             {line cursor - ins on}
                  End;
      DeleteKey : Begin             {delete - destruct Char at cursor}
                   TempStr:= ReadFromScr(X+1,Y,XG+Len-X-1);
                   WriteSt(TempStr,X,Y);
                   Write(' ');
                  End;
      HomeKey   : X := XG;          { Cursor to begining of string }
      EndKey    : X := XG+Len-1;    { Cursor to end of string }

   End;  {Function key true}

  If not FunctKey then case TCh of    {  Handle non function keys }
      #28..#126,
      #128..#255 : Begin              { Regular everyday Characters}
                    If Virgin then Begin   { If virgin then delete default }
                       FillChar(TempStr,Sizeof(TempStr),' ');
                       Tempstr[0] := Chr(Len);
                       WriteSt(TempStr,XG,Y);
                       X := XG;
                       GoToXY(X,Y);
                     End;
                    If InsToggle then Begin  { If insert then push characters }
                      TempStr := ReadFromScr(X,Y,XG+Len-X-1);
                      WriteSt(TempStr,X+1,Y);
                      GoToXY(X,Y);
                     End;
                    Write(TCh);        { Finally write the character on screen }
                    X := X+1;
                  End;
       EnterKey : Begin                   { Get set to exit }
                   ExitGetStr := true;
                  End;
       EscKey   : Begin                   { Exit now with a nul string }
                   GetStr := '';
                   Exit;
                  End;
       BackSpKey :Begin                  { Destruct Char to left }
                   If X > XG then Begin
                     TempStr := ReadFromScr(X,Y,XG+Len-X);
                     WriteSt(TempStr,X-1,Y);
                     Write(' ');
                   End;
                     X := X-1;
                  End;
       CtrlBackSp :Begin                { Delete entire string }
                     FillChar(TempStr,Sizeof(TempStr),' ');
                     Tempstr[0] := Chr(Len);
                     WriteSt(TempStr,XG,Y);
                     X := XG;
                   End;

   End; { FunctKey false}
 Virgin := false;        { Set virgin false if any editing key hit }
Until ExitGetStr;

   Linecursor;                         { Reset the cursor }
   GetStr := ReadFromScr(XG,Y,Len);   { Read the edited string from screen }


END;

END.  {UNIT}