{---- 10/23/1988  16:20:41 ----}
{$A-,R-,B-,S-,I-,F-,O-,V-,N-,E-,D-,L-}
{$M 1024,0,42000}                                { stack, min heap, max heap }
{----------------------------------------------------------------------------}
{                                                                            }
{                             'TESTC.PAS'                                    }
{                                                                            }
{  This program tests the LZW Compression logic in MDCD1213.OBJ.  It also    }
{  illustrates the calling sequence and interfacing methodology.             }
{                                                                            }
{  To run it, enter:                                                         }
{                                                                            }
{    testc inputfile outputfile                                              }
{                                                                            }
{  It will compress the input file into the output file.  No header records  }
{  are added to identify the file name, date or anything else.  It is        }
{  strictly a compressed file that can be decompressed with TESTD.           }
{                                                                            }
{  No validity checking is done to verify the input file or output file      }
{  names.  This is strictly meant to illustrate a very simple use of the     }
{  MDCD1213.OBJ module.                                                      }
{                                                                            }
{----------------------------------------------------------------------------}

Uses Dos;                                      { Borland DOS unit            }

  {$L MDCD1213.OBJ}              { assembler module for compress/decompress }

{$F+}
Function CompressFile(InFile  : Word;     {handle of input file              }
                      OutFile : Word;     {handle of output file             }
                      AbsOfst : LongInt;  {absolute offset to start write at }
                      ReturnR : Pointer;  {return info from CompressFile     }
                      HashSg  : Word;     {segment:0 of allocated hash table }
                      LZWtype : Word      {12 = 12 bit, 13 = 13 bit lzw      }
                     )        : Word;     {-1 = good return                  }
    external {MDCD1213.OBJ} ;
{$F-}

{$F+}
Function DeCompressFile(InFile  : Word;   {handle of input file              }
                        OutFile : Word;   {handle of output file             }
                        AbsOfst : LongInt;{absolute offset to start write at }
                        ReturnR : Pointer;{return info from CompressFile     }
                        HashSg  : Word;   {segment:0 of allocated hash table }
                        LZWtype : Word    {12 = 12 bit, 13 = 13 bit lzw      }
                       )        : Word;   {-1 = good return                  }
    external {MDCD1213.OBJ} ;
{$F-}

Type
  ReturnRec = Record                      {return info from mdcd1213.obj     }
    FileCrc  : Word;                      {  calculated file crc decompressed}
    FileSize : LongInt;                   {  compressed/decompressed filesize}
  end;                                    {..                                }

Const
  HexXlate : Array[0..$F] of Char =       { table to translate word to hex   }
             '0123456789ABCDEF';

Var
  InF     : File;         { Input file                                       }
  OutF    : File;         { Output file                                      }
  IHandle : Word;         { Input file handle                                }
  OHandle : Word;         { Output file handle                               }
  HashPtr : Pointer;      { Pointer to LZW hash table allocated on heap      }
  HashSeg : Word;         { Paragraph aligned (segment) of hash table        }
  RC      : Word;         { Return code from compress/decompress function    }
  ReturnR : ReturnRec;    { storage for return info from mdcd1213.obj        }

Begin

{ compress test }

  If ( (Length(ParamStr(1)) = 0) or
       (Length(ParamStr(2)) = 0) ) then begin
    WriteLn;
    WriteLn('Usage: testc inputfile outputfile');
    WriteLn;
    Halt(1);
  end;

  Assign(InF, ParamStr(1));       {setup input file variable FileRec         }
  Assign(OutF, ParamStr(2));      {setup output file variable FileRec        }
  System.FileMode := 0;           {read only to get hidden/system files etc. }
  Reset(InF,1);                   {open input file to assign handle          }
  System.FileMode := 2;           {read write                                }
  If (IOResult <> 0) then begin   {if file didn't open ok..                  }
    WriteLn('Input File not found');{  user error message                    }
    WriteLn('Program Canceled'); {  cancel message                          }
    Halt(1);                      {  end program                             }
  end;                            {..                                        }
  Reset(OutF,1);                  {open output file to check for existance   }
  If (IOResult = 0) then begin    {if file opened ok..                       }
    Close(OutF);                  {close output file                         }
    WriteLn('Output File exists');{  user error message                      }
    WriteLn('Program Canceled'); {  cancel message                          }
    Halt(1);                      {  end program                             }
  end;                            {..                                        }
  ReWrite(OutF,1);                {create/open output file to assign handle  }
  IHandle := FileRec(InF).Handle; {extract input file handle from FileRec    }
  OHandle := FileRec(OutF).Handle;{extract output file handle from FileRec   }
  GetMem(HashPtr, 40960+15);      {get memory for hash table + 15 bytes      }
  if Ofs(HashPtr^) = 0 then       {if offset already -0- then seg is okay    }
    HashSeg := Seg(HashPtr^)      {  store segment                           }
  else                            {else                                      }
    HashSeg := 1+Seg(HashPtr^);   {  add 1 paragraph (16 bytes) to segment   }

{ Compress the file }

  RC :=   CompressFile(Ihandle,   { input file handle                        }
                       Ohandle,   { output file handle                       }
                       0,         { file absolute offset in bytes to start   }
                       @ReturnR,  { address of return data from compress     }
                       HashSeg,   { segment of allocated hash table          }
                       13);       { 13 bit compression                       }

{ free memory and close files }

  FreeMem(HashPtr, 40960+15);     {get rid of heap memory for hash table     }
  Close(InF);                     {close input file                          }
  Close(OutF);                    {close output file                         }

  WriteLn;
  Write('Compressed file size: ', ReturnR.FileSize);
  Write('  CRC: ');
  Write(HexXlate[Hi(ReturnR.FileCrc) shr 4]);
  Write(HexXlate[Hi(ReturnR.FileCrc) and $F]);
  Write(HexXlate[Lo(ReturnR.FileCrc) shr 4]);
  Write(HexXlate[Lo(ReturnR.FileCrc) and $F]);
  WriteLn;
  WriteLn;

End.

