{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}

UNIT MENU;

INTERFACE
  USES DOS,
       CRT,
       SCRNHEAP;

  type
    menus            =     record
                            xb,
                            yb,
                            xe          : Integer;
                            title       : String[20];
                            qk          : Char;
                            descrpt     : String[60];
                          end;

  var
    HelpAtt,
    QKAtt              : Byte;
    MenuOption         : Array[1..55] of menus;
    value              : Integer;
    EscDepressed       : Boolean;

  Procedure HelpScreen(choice: Integer);
  Procedure ChooseMenu(first, last, MenuStyle, att, hatt: Integer;
                       qkr, DspDescrp: Boolean;
                       dspx, dspy, DspAtt: Integer);


IMPLEMENTATION

Procedure HelpScreen(* choice: Integer *);
  var
    ch          : Char;

  begin
    CursorOff;
    Case choice of
      1,2 : begin
              ClearBox(5,5,76,19,HelpAtt,2,False);
              PutStr('-- Help Screen --',32,6,HelpAtt);
              PutStr('Home - Highlight first menu',8,8,HelpAtt);
              PutStr('       option',8,9,HelpAtt);
              PutStr('End - Highlight last menu',9,11,HelpAtt);
              PutStr('      option',9,12,HelpAtt);
              PutStr(chr(25),45,8,HelpAtt);
              PutStr(chr(26),48,8,HelpAtt);
              PutStr('- Move Highlight',51,8,HelpAtt);
              if choice=1 then
                PutStr('bar right',53,9,HelpAtt)
              else
                PutStr('bar down',53,9,HelpAtt);
              PutStr(chr(24),45,11,HelpAtt);
              PutStr(chr(27),48,11,HelpAtt);
              PutStr('- Move Highlight',51,11,HelpAtt);
              if choice=1 then
                PutStr('Bar Left',53,12,HelpAtt)
              else
                PutStr('Bar Up',53,12,HelpAtt);
              PutStr('<RETURN> - Select Highlighted ',42,14,HelpAtt);
              PutStr('           menu option',42,15,HelpAtt);
              PutStr(' (Depress Any Key to Continue) ',25,17,15);
            end;
        3 : begin
              ClearBox(9,3,72,20,HelpAtt,2,False);
              PutStr('-- Help Screen --',32,4,HelpAtt);
              PutStr('Home - Highlight first menu',16,6,HelpAtt);
              PutStr('option',23,7,HelpAtt);
              PutStr('End - Highlight last menu',17,9,HelpAtt);
              PutStr('option',23,9,HelpAtt);
              PutStr('<RETURN> - Select Highlighted',12,15,HelpAtt);
              PutStr('menu option',23,16,HelpAtt);

              PutStr(chr(25),49,6,HelpAtt);
              PutStr('- Move Highlight',52,6,HelpAtt);
              PutStr('bar down',54,7,HelpAtt);
              PutStr(chr(24),49,9,HelpAtt);
              PutStr('- Move Highlight',52,9,HelpAtt);
              PutStr('bar up',54,10,HelpAtt);
              PutStr(chr(26),49,12,HelpAtt);
              PutStr('- Move Hightlight',52,12,HelpAtt);
              PutStr('bar right',54,13,HelpAtt);
              PutStr(chr(27),49,15,HelpAtt);
              PutStr('- Move Highlight',52,15,HelpAtt);
              PutStr('bar left',54,16,HelpAtt);
              PutStr(' (Depress Any Key to Continue) ',26,18,15);
            end;
    end; {Case choice of}
    ch:=ReadKey;
  end; {Procedure HelpScreen}

{---------------------------------------------------------------------------}
Procedure ChooseMenu(* first, last, MenuStyle, att, hatt: Integer;
                     qkr, DspDescrp: Boolean;
                     dspx, dspy, DspAtt: integer *);

  { Choose Menu - This function chooses the menu options given the
     following parameters:

           first     -  First value of array MenuOption
           last      -  Last value of array MenuOption to be used.
                        Note: All values in between will be used.
           MenuStyle -  The type of menu, vertical only =1, horizontal
                        only =2  and both =3.
                 att -  Color attribute for Menu Choice
                hatt -  Highlight attribute for Menu Choice
                 qkr -  Quick Keys Required (TRUE or FALSE)
           DspDescrp -  Display Description (TRUE or FALSE)
                dspx -  Description x coordinate
                dspy -  Description y coordinate
              DspAtt -  Description Attribute
                                                                         }

   const
     BELL     =#7;
     CR       =13;   {Carraige Return}
     ESC      =27;   {Escape character}
     SPC      =32;   {Space Bar}
     UPARROW  =72;
     DNARROW  =80;
     LTARROW  =75;
     RTARROW  =77;
     END_KEY  =79;
     HOME     =71;
     PGUP     =73;
     PGDN     =81;
     F1       =59;
     F2       =60;

   var
     i,
     j,
     k,
     m,
     w,
     height,
     qkwidth,
     y1,
     y2,
     xoff,
     c,
     scan,
     error:                            Integer;

     match,
     done:                             Boolean;

     regs:                             Registers;

  begin
    CursorOff;
    EscDepressed:=False;
    done:=False;
    value:=0;
    { ------------------ Print Out Menu Options ------------------- }
     i:=first;
     while (i <= last) do begin
      PutStr(MenuOption[i].title,MenuOption [i].xb, MenuOption[i].yb,
             att);
      i:=i+1;
     end; { While i <= last }
    { ------------------ Highlight First Option ------------------- }

     SetAtt(MenuOption[first].xb,MenuOption[first].yb,
            MenuOption[first].xe,MenuOption[first].yb,hatt);
     if (DspDescrp) then begin
       PutStr(MenuOption[first].descrpt,dspx,dspy,DspAtt);
     end;

    { --------------------  Get Valid Key  ------------------------ }
     i:=first;
     while (not done) do begin
       with regs do begin
         AH:=0;
         Intr($16,regs);
         c:=AL;
         scan:=AH;
       end;


        if (c = 0) then begin
          Case scan of
            UPARROW: begin                     { Up arrow key    }

             { Note if vertical will move up and horiz. left }
                       SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                              MenuOption[i].xe,MenuOption[i].yb,att);
                       if (i = first) then begin
                          i:=last;
                       end
                       else begin
                          i:=i-1;
                       end;
                       SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                              MenuOption[i].xe,MenuOption[i].yb,hatt);
                       if (DspDescrp) then begin
                          RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                          PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                       end;
                     end; {End if UPARROW}
          {--------------------------------------------------------}
            DNARROW: begin                       { Down arrow key  }
             { Note if vertical will move up and horiz. left }
              SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                     MenuOption[i].xe,MenuOption[i].yb,att);
                       if (i = last) then begin
                         i:=first;
                       end
                       else begin
                         i:=i+1;
                       end;
                       SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                              MenuOption[i].xe,MenuOption[i].yb,hatt);
                       if (DspDescrp) then begin
                         RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                        PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                       end;
                     end; {End of DNARROW}
          {--------------------------------------------------------}
            RTARROW: begin                      { Right arrow key  }
                  SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                         MenuOption[i].xe,MenuOption[i].yb,att);
                  if (MenuStyle = 3) then begin
                    j:=i;
                    match:=False;
                    while (j <= last) do begin
                      j:=j+1;
                      if (MenuOption[j].yb = MenuOption[i].yb) then begin
                        match:=True;
                        k:=j;
                        j:=last+1;
                      end;
                    end; {End while j<=last}
                    if (not match) then begin
                      j:=first;
                      while (j < i) do begin
                        if (MenuOption[j].yb = MenuOption[i].yb) then begin
                          match:=True;
                          k:=j;
                          j:=i;
                         end;
                         j:=j+1;
                       end; {End while j<i}
                     end; {End if not match}
                     if (match) then
                       i:=k
                     else
                       write(BELL);
                     SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                            MenuOption[i].xe,MenuOption[i].yb,hatt);
                     if (DspDescrp) then begin
                       RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                       PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                     end;
                  end
                  else begin { End if MenuStyle =3 }
                    if (i = last) then
                      i:=first
                    else
                      i:=i+1;
                    SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                           MenuOption[i].xe,MenuOption[i].yb,hatt);
                    if (DspDescrp) then begin
                      RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                      PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                    end;
                  end; { If MenuStyle <>3 }
            end; {Case of right}
          {--------------------------------------------------------}
            LTARROW: begin                        { Left arrow key }
                       SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                              MenuOption[i].xe,MenuOption[i].yb,att);
                       if (MenuStyle = 3) then begin
                         j:=i;
                         match:=False;
                         while (j >= first) do begin
                            j:=j-1;
                            if (MenuOption[j].yb = MenuOption[i].yb) then begin
                              match:=True;
                              k:=j;
                              j:=first-1;
                            end; {If y coordinates match}
                          end; {while j>=first}
                          if (not match) then begin
                            j:=last;
                            while (j > i) do begin
                               if (MenuOption[j].yb = MenuOption[i].yb) then begin
                                 match:=True;
                                 k:=j;
                                 j:=i;
                               end;
                               j:=j-1;
                            end; {while j>i}
                          end;
                          if (match) then
                            i:=k
                          else
                            write(BELL);
                          SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                                 MenuOption[i].xe,MenuOption[i].yb,hatt);
                          if (DspDescrp) then begin
                            RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                            PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                          end;
                       end
                       else begin
                          if (i = first) then
                            i:=last
                          else
                            i:=i-1;
                          SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                                 MenuOption[i].xe,MenuOption[i].yb,hatt);
                          if (DspDescrp) then begin
                            RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                            PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                          end;
                       end; { If MenuStyle <> 3 }
            end; {Case of Left Arrow}
          {--------------------------------------------------------}
            HOME: begin                          { Home key        }
                    SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                           MenuOption[i].xe,MenuOption[i].yb,att);
                    i:=first;
                    SetAtt(MenuOption[first].xb,MenuOption[first].yb,
                           MenuOption[first].xe,MenuOption[first].yb,hatt);
                    if (DspDescrp) then begin
                      RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                      PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                    end;
                  end; {Case Home}
          {--------------------------------------------------------}
        END_KEY: begin
                   SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                          MenuOption[i].xe,MenuOption[i].yb,att);
                   i:=last;
                   SetAtt(MenuOption[last].xb,MenuOption[last].yb,
                          MenuOption[last].xe,MenuOption[last].yb,hatt);
                   if (DspDescrp) then begin
                     RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                     PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                   end;
                 end; {Case of END}
          {--------------------------------------------------------}

            F1: begin                         { F1:Help            }
                  SaveScreen(1);
                  HelpScreen(MenuStyle);
                  RestoreScreen(1);
                end; {Case F1}
          {--------------------------------------------------------}
            F2: begin                         { Quick Keys         }
                  if (qkr) then begin
               { ---------- Find Width of Quick Key Box ---------- }
                    w:=0;
                    qkwidth:=0;
                    xoff:=3;
                    for m:=first to last do begin;
                      w:=MenuOption[m].xe-MenuOption[m].xb;
                      if (w > qkwidth) then
                        qkwidth:=w;
                    end; {For m=first to last}
                    qkwidth:=qkwidth+8;
                    if qkwidth<22 then begin
                      xoff:=22-qkwidth;
                      xoff:=xoff div 2;
                      xoff:=xoff+3;
                      qkwidth:=22;
                    end;
               { ---------- Find Heigth of Quick Key Box --------- }
                    height:=last-first;
                    height:=height+6;
                    y1:=25-height;
                    y1:=y1 div 2;
                    y2:=y1+height;
               { ------------------ Draw Box --------------------- }
                    SaveScreen(1);
                    ClearBox(70-qkwidth,y1,70,y2,QKAtt,3,False);
                    w:=qkwidth-16;
                    w:=w div 2;
                    w:=(70-qkwidth)+w;
               { ----------------- Write Title ------------------ }
                    PutStr('-- Quick Keys --',w,y1+1,QKAtt);
               { --------------- Write Quick Kyes --------------- }
                    w:=(70-qkwidth)+xoff;
                    y1:=y1+3;
                    m:=first;
                    while (m <= last) do begin
                      PutStr(MenuOption[m].qk,w,y1,QKAtt);
                      PutStr('-',w+2,y1,QKAtt);
                      PutStr(MenuOption[m].title,w+4,y1,QKAtt);
                      y1:=y1+1;
                      m:=m+1;
                    end; {while m <=last}
               { ------------------ Write "Any Key " ------------ }
                    y1:=y1+1;
                    w:=(qkwidth-17) div 2;
                    w:=(70-qkwidth)+w;
                    PutStr(' (Depress Any Key) ',w,y1,15);
               { ---------------- Wait for Key Depressed -------- }
                    with regs do begin
                      AH:=0;
                      Intr($16,regs);
                    end;
                    RestoreScreen(1);
                  end
                  else begin
                    Write(BELL);
                  end;
                end; {Case F2}
          {--------------------------------------------------------}
          end; {Case scan of}
        end
        else begin { If c=0, scan code }
          Case c of

            ESC: begin                     { Esc Depressed         }
                   EscDepressed:=True;
                   done:=True;
                 end;
            CR: begin                       { Enter Depressed       }
                  value:=i;
                  done:=True;
                end;
           SPC: begin                      { Space Bar Depressed   }
             { Note if vertical will move up and horiz. left }
                    SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                           MenuOption[i].xe,MenuOption[i].yb,att);
                    if (i = last) then
                      i:=first
                    else
                      i:=i+1;
                    SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                           MenuOption[i].xe,MenuOption[i].yb,hatt);
                    if (DspDescrp) then begin
                      RemBlkR(dspx,dspy,dspx+60,dspy,DspAtt,False);
                      PutStr(MenuOption[i].descrpt,dspx,dspy,DspAtt);
                    end;
                 end; {Case Space Bar}
            else
              if (c>=97) and (c<=122) then
                c:=c-32;
              m:=first;
              done:=False;
              while (m <= last) do begin
                if (MenuOption[m].qk = chr(c)) then begin
                  SetAtt(MenuOption[i].xb,MenuOption[i].yb,
                         MenuOption[i].xe,MenuOption[i].yb,att);
                  value:=m;
                  done:=True;
                  SetAtt(MenuOption[m].xb,MenuOption[m].yb,
                         MenuOption[m].xe,MenuOption[m].yb,hatt);
                  m:=last;
                end;
                m:=m+1;
              end; {while m<=last}
              if (not done) then
                write(BELL);
          end;  { Case of character in keyboard buffer }
        end; {If c<>0 }
     end; {While done = False }

   end; {Choose Menu }

{---------------------------------------------------------------------------}

BEGIN
END.
