{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS

==========================================================================
}
Unit GetFiles;

INTERFACE

USES    DOS,
        PRINTER,
        GLOBALS;


Procedure GetFile(SearchString: AString; Short: Boolean);
Procedure ReshuffleFiles;
Procedure DisposeFiles;

IMPLEMENTATION

Procedure GetFile(* SearchString: AnyString *);
  var
    DirInfo      : SearchRec;
    ValidFile    : Boolean;
    f            : File;
    attr         : Byte;
    x,
    y            : ShortInt;

 {===============================================================}
  Procedure PutFileInHeap;

    var
      s             : String[12];
      s1,
      s2,
      s3            : String[8];
      i,
      xx,
      l             : ShortInt;
      DteTme        : DateTime;
      fsze,
      dte,
      tme           : LongInt;

    begin

      if (y=firsty) and (x=firstx) then PageNumber:=PageNumber+1;
     {--------------------- Format File Name -----------------}
      s:=DirInfo.Name;
      xx:=pos('.',s);
      if xx>0 then begin
        l:=9-xx;
        for i:=1 to l do insert(' ',s,xx);
      end
      else begin
        xx:=length(s);
        l:=12-xx;
        for i:=1 to l do s:=s+' ';
      end; {if not extensions}
     {--------------------------------------------------------}

      UnPackTime(DirInfo.Time,DteTme);
      dte:=(DteTme.year-1900)*512;
      dte:=dte+(DteTme.month*32)+DteTme.day;

      tme:=(DteTme.hour*2048)+(DteTme.min*32)+(DteTme.sec div 2);
     {------------------- Make Date String (s1) -----------------}
      str(DteTme.month,s1);
      if DteTme.month<10 then s1:='0'+s1+'/' else s1:=s1+'/';
      str(DteTme.day,s2);
      if DteTme.day<10 then s1:=s1+'0'+s2+'/' else s1:=s1+s2+'/';
      str(DteTme.year-1900,s2);
      s1:=s1+s2;

     {----------------- Make Time String (s2) ---------------------}
      str(DteTme.hour,s2);
      if DteTme.hour<10 then s2:='0'+s2+':' else s2:=s2+':';
      str(DteTme.min,s3);
      if DteTme.min<10 then s2:=s2+'0'+s3+'.' else s2:=s2+s3+'.';
      str(DteTme.sec,s3);
      if DteTme.sec<10 then s2:=s2+'0'+s3 else s2:=s2+s3;

    {--------------------- FileSize String (ie. 345K)----------------}
      str(DirInfo.Size,s3);
      l:=length(s3);
      l:=6-l;
      if l>0 then begin
         for i:=1 to l do s3:=' '+s3;
      end;

   {-------------------------------------------------------------------}
      new(new_dir);                     {Create new record}
      new_dir^.FileName :=s;
      new_dir^.FileSize :=DirInfo.Size;
      new_dir^.FileSSize:=s3;
      new_dir^.FileDate :=dte;
      new_dir^.FileSDate:=s1;
      new_dir^.FileTime :=tme;
      new_dir^.FileSTime:=s2;
      new_dir^.x        :=x;
      new_dir^.y        :=y;
      new_dir^.DirPage  :=PageNumber;
      new_dir^.DirTag   :=False;

      if first_dir=nil then begin
          first_dir:=new_dir;
        new_dir^.prev_dir:=nil;
      end
      else begin
        last_dir^.next_dir:=new_dir;
          new_dir^.prev_dir :=last_dir;
      end;

      last_dir:=new_dir;
      last_dir^.next_dir:=nil;

      y:=y+1;
      if y=16 then begin
        Case Short of
          True: begin
                  y:=6;
                  Case x of
                     6: x:=20;
                    20: x:=35;
                    35: x:=49;
                    49: x:=63;
                    63: x:=6;
                  end; {Case x of}
                end; {Short Style}
         False: y:=7;
        end; {Case Short of}

      end; {if y=18}
      TotalPages:=PageNumber;
    end; {End Put Dir in Heap}
  {===============================================================}


  begin
    Case Short of
       True: begin
               firstx:=6;
               firsty:=6;
             end; {Short}
     False: begin
              firstx:=17;
              firsty:=7;
            end; {Long}
    end; {Case short of}

    y:=firsty;
    x:=firstx;
    PageNumber:=0;
    ValidFile:=True;
    first_dir:=nil;
    FindFirst(SearchString,AnyFile,DirInfo);
    if DirInfo.Attr and Hidden<>0 then ValidFile:=False;
    if DirInfo.Attr and SysFile<>0 then ValidFile:=False;
    if DirInfo.Attr and VolumeID<>0 then ValidFile:=False;
    if DirInfo.Attr and Directory<>0 then ValidFile:=False;
    if (DosError<>18) and (ValidFile) then PutFileInHeap;
    while DosError<>18 do begin
      ValidFile:=True;
      FindNext(DirInfo);
      if DirInfo.Attr and Hidden<>0 then ValidFile:=False;
      if DirInfo.Attr and SysFile<>0 then ValidFile:=False;
      if DirInfo.Attr and VolumeID<>0 then ValidFile:=False;
      if DirInfo.Attr and Directory<>0 then ValidFile:=False;
      if (DosError<>18) and (ValidFile) then PutFileInHeap;
    end; {while not Error Condition}
  end; {Procedure Get Files}
{--------------------------------------------------------------------}
 Procedure ReshuffleFiles;
   begin
     PageNumber:=0;
     y:=firsty;
     x:=firstx;
     new_dir:=first_dir;

     while new_dir<>nil do begin
       if (y=firsty) and (x=firstx) then PageNumber:=PageNumber+1;

       new_dir^.x        :=x;
       new_dir^.y        :=y;
       new_dir^.DirPage  :=PageNumber;

       y:=y+1;
       if y=16 then begin
         Case ShortFile of
           True: begin
                   y:=6;
                   Case x of
                      6: x:=20;
                     20: x:=35;
                     35: x:=49;
                     49: x:=63;
                     63: x:=6;
                   end; {Case x of}
                 end; {Short Style}
          False: y:=7;
         end; {Case Short of}
       end; {if y=16}
       with new_dir^ do  new_dir:=next_dir;
     end; {while new_dir<>nil}
     TotalPages:=PageNumber;
   end; {Reshuffle Files}
{--------------------------------------------------------------------}
 Procedure DisposeFiles;
   begin
     new_dir:=first_dir;
     while new_dir<>nil do begin
       with new_dir^ do last_dir:=next_dir;
       dispose(new_dir);
       new_dir:=last_dir;
     end; {while new_dir<>nil}
   end; {DisposeFiles}

BEGIN
END.
