{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with EZ.PAS.

* ASSOCIATED FILES
EZ.PAS
BINED.TPU
EZ.DOC
EZ.EXE
EZ.OBJ
EZS.EXE
EZS.OVR
EZ0.PAS
EZ1.PAS
EZ2.PAS
EZ3.PAS
EZINVOKE.TPU
GETFILES.PAS
GETSUB.PAS
GLOBALS.PAS
INVOKE.TPU
MENU.PAS
POPSCRN.TPU
PRINTDOC.BAT
PTROP.TPU
SCRNHEAP.PAS


==========================================================================
}
UNIT Ez1;

INTERFACE

USES  CRT,
      DOS,
      PRINTER,
      POPSCRN,
      SCRNHEAP,
      MENU,
      GLOBALS,
      GETFILES,
      EZ0;

{$V-}

Procedure GoodBye;
Procedure Initialize;
Procedure IntroScreen;
Procedure SetMenuOptions;
Procedure DisplayFirstPage;
Procedure MPLFileName(Code: ShortInt; var FileNme: AnyString);
Procedure TagByPattern(s1: AnyString);
Procedure RenameFile ( OldName, NewName  : AnyString;
                       var Ecode : integer );
Procedure GetFileNumber(var num: Integer);
Procedure ASort(NameOrExt: Char);
Procedure ASortD(NameOrExt: Char);
Procedure NSort(DateOrSize: Char);
Procedure NSortD(DateOrSize: Char);
Procedure GoNameSortA;
Procedure GoNameSortD;
Procedure GoExtSortA;
Procedure GoExtSortD;
Procedure GoSizeSortA;
Procedure GoSizeSortD;
Procedure GoDateSortA;
Procedure GoDateSortD;



IMPLEMENTATION

Procedure GoodBye;
  var
    TreeFile       : Text;
    i              : Integer;
    s              : String[6];

  begin
    for i:=64 to 90 do begin
      s:=chr(i)+'.ezd';
      Assign(TreeFile,s);
      {$I-}
        Reset(TreeFile);
      {$I+}
      if IOResult=0 then begin
        Close(TreeFile);
        Erase(TreeFile);
      end;
    end;

    bf(0,15);
    CursorOn;
    ClrScr;
    PutStr('Thanks for using EzDoss!',1,1,15);
    halt;
  end; {GoodBye}

{------------------------------------------------------------------------}
Procedure Initialize;
  begin
    LocateSelected:=False;
    FindDupSelected:=False;
    ShortFile     :=True;
    ExpertMode    :=False;
    FromMenu      :=False;
    FromAltF10    :=False;
    Sd            :=NUL;
    fofs          :=11;
    firstx        :=6;
    lastx         :=63;
    firsty        :=17;
  end; {Initialize}

{------------------------------------------------------------------------}
Procedure IntroScreen;
  var
    SkipIntro    : Boolean;
    att,
    att1         : Byte;
    x,
    i            : ShortInt;
    s1           : String[20];
    s            : String[1];
    ch           : Char;

  begin
    SkipIntro:=False;
    VideoMode;
    if DisplayMode=7 then monitor:=2 else monitor:=1;
    if ParamCount>=1 then begin
      for i:=1 to ParamCount do begin
        s:=copy(ParamStr(i),1,1);
        if (s='M') or (s='m') then monitor:=2;
        if (s='X') or (s='x') then ExpertMode:=True;
        if (s='L') or (s='l') then LocateSelected:=True;
        if (s='F') or (s='f') then FindDupSelected:=True;
        if (s='I') or (s='i') then SkipIntro:=True;
        if (s='S') or (s='s') then begin
          s1:=ParamStr(i);
          if length(s1)>1 then Sd:=s1[2];
        end; {if source drive on command line}
      end; {for i=1 to}
    end;
    if monitor=1 then begin
      att        :=31;
      att1       :=27;
      FreeAtt    :=47;
      HelpBar    :=30;
      HelpAtt    :=95;
      QKAtt      :=47;
      ErrAtt     :=79;
      SrceMain   :=31;
      SrceHigh   :=15;
      FilesMain  :=31;
      FilesHigh  :=79;
      TagAtt     :=30;
      StatusAtt  :=48;
      MainMenuAtt:=47;
      MainMenuHigh:=14;
      MainMenuDscpt:=46;
      FileNameAtt  :=47;
      ExpandAtt    :=111;
      ExpandTitle  :=110;
      VerifyAtt    :=113;
      VerifyHigh   :=31;
      VerifyTitle  :=127;
      Verify2Att   :=11;
      Verify2High  :=63;
      Verify2Title :=15;
      ExeCmdAtt    :=95;
    end
    else begin
      att        :=15;
      att1       :=7;
      FreeAtt    :=112;
      HelpBar    :=112;
      HelpAtt    :=112;
      QKAtt      :=112;
      ErrAtt     :=112;
      SrceMain   :=112;
      SrceHigh   :=15;
      FilesMain  :=7;
      FilesHigh  :=112;
      TagAtt     :=15;
      StatusAtt  :=15;
      MainMenuAtt:=15;
      MainMenuHigh:=112;
      MainMenuDscpt:=15;
      FileNameAtt  :=112;
      ExpandAtt    :=112;
      ExpandTitle  :=112;
      VerifyAtt    :=112;
      VerifyHigh   :=15;
      VerifyTitle  :=112;
      Verify2Att   :=15;
      Verify2High  :=112;
      Verify2Title :=15;
      ExeCmdAtt    :=112;
    end;

    if not SkipIntro then begin
      FillHeap(1,1,1,80,25,SHADE,att1);
      FillHeap(1,1,25,80,25,#32,HelpBar);

      FillHeap(1,19,7,58,16,SHADE1,att1 div 16);
      ClearBoxHeap(1,21,6,60,15,att,2);
      PutHeap(1,'EzDoss',38,8,att);
      PutHeap(1,'Menu Driven Dos Commands',29,9,att1);
      PutHeap(1,'by',39,10,att1);
      PutHeap(1,'John E. Bean',35,11,att1);
      PutHeap(1,'Version 2.0',35,13,att1);
      PutHeap(1,'(c) Copywright 1987, 1988, Data Acquisition Inc.',16,25,att);
      RestoreScreen(1);
      delay(4000);
    end; {Display Intro Screen}
  end; {Introduction Screen}

{--------------------------------------------------------------------}
Procedure SetMenuOptions;
  begin
    MenuOption[1].xb:=17;
    MenuOption[1].yb:=8;
    MenuOption[1].xe:=21;
    MenuOption[1].title:='  A  ';
    MenuOption[1].qk:='A';
    MenuOption[1].descrpt:=' ';

    MenuOption[2].xb:=17;
    MenuOption[2].yb:=9;
    MenuOption[2].xe:=21;
    MenuOption[2].title:='  B  ';
    MenuOption[2].qk:='B';
    MenuOption[2].descrpt:=' ';

    MenuOption[3].xb:=17;
    MenuOption[3].yb:=10;
    MenuOption[3].xe:=21;
    MenuOption[3].title:='  C  ';
    MenuOption[3].qk:='C';
    MenuOption[3].descrpt:=' ';

    MenuOption[4].xb:=17;
    MenuOption[4].yb:=11;
    MenuOption[4].xe:=21;
    MenuOption[4].title:='  D  ';
    MenuOption[4].qk:='D';
    MenuOption[4].descrpt:=' ';

    MenuOption[5].xb:=17;
    MenuOption[5].yb:=12;
    MenuOption[5].xe:=21;
    MenuOption[5].title:='  E  ';
    MenuOption[5].qk:='E';
    MenuOption[5].descrpt:=' ';

    MenuOption[6].xb:=17;
    MenuOption[6].yb:=13;
    MenuOption[6].xe:=21;
    MenuOption[6].title:='  F  ';
    MenuOption[6].qk:='F';
    MenuOption[6].descrpt:=' ';

    MenuOption[7].xb:=17;
    MenuOption[7].yb:=14;
    MenuOption[7].xe:=21;
    MenuOption[7].title:='  G  ';
    MenuOption[7].qk:='G';
    MenuOption[7].descrpt:=' ';

    MenuOption[8].xb:=17;
    MenuOption[8].yb:=15;
    MenuOption[8].xe:=21;
    MenuOption[8].title:='  H  ';
    MenuOption[8].qk:='H';
    MenuOption[8].descrpt:=' ';

    MenuOption[9].xb:=17;
    MenuOption[9].yb:=16;
    MenuOption[9].xe:=21;
    MenuOption[9].title:='  I  ';
    MenuOption[9].qk:='I';
    MenuOption[9].descrpt:=' ';

    MenuOption[10].xb:=17;
    MenuOption[10].yb:=17;
    MenuOption[10].xe:=21;
    MenuOption[10].title:='  J  ';
    MenuOption[10].qk:='J';
    MenuOption[10].descrpt:=' ';


    MenuOption[11].xb:=17;
    MenuOption[11].yb:=18;
    MenuOption[11].xe:=21;
    MenuOption[11].title:='  K  ';
    MenuOption[11].qk:='K';
    MenuOption[11].descrpt:='';

    MenuOption[12].xb:=17;
    MenuOption[12].yb:=19;
    MenuOption[12].xe:=21;
    MenuOption[12].title:='  L  ';
    MenuOption[12].qk:='L';
    MenuOption[12].descrpt:='';

    MenuOption[13].xb:=17;
    MenuOption[13].yb:=20;
    MenuOption[13].xe:=21;
    MenuOption[13].title:='  M  ';
    MenuOption[13].qk:='M';
    MenuOption[13].descrpt:=' ';

    MenuOption[14].xb:=25;
    MenuOption[14].yb:=8;
    MenuOption[14].xe:=29;
    MenuOption[14].title:='  N  ';
    MenuOption[14].qk:='N';
    MenuOption[14].descrpt:=' ';

    MenuOption[15].xb:=25;
    MenuOption[15].yb:=9;
    MenuOption[15].xe:=29;
    MenuOption[15].title:='  O  ';
    MenuOption[15].qk:='P';
    MenuOption[15].descrpt:=' ';

    MenuOption[16].xb:=25;
    MenuOption[16].yb:=10;
    MenuOption[16].xe:=29;
    MenuOption[16].title:='  P  ';
    MenuOption[16].qk:='P';
    MenuOption[16].descrpt:=' ';

    MenuOption[17].xb:=25;
    MenuOption[17].yb:=11;
    MenuOption[17].xe:=29;
    MenuOption[17].title:='  Q  ';
    MenuOption[17].qk:='Q';
    MenuOption[17].descrpt:=' ';

    MenuOption[18].xb:=25;
    MenuOption[18].yb:=12;
    MenuOption[18].xe:=29;
    MenuOption[18].title:='  R  ';
    MenuOption[18].qk:='R';
    MenuOption[18].descrpt:=' ';

    MenuOption[19].xb:=25;
    MenuOption[19].yb:=13;
    MenuOption[19].xe:=29;
    MenuOption[19].title:='  S  ';
    MenuOption[19].qk:='S';
    MenuOption[19].descrpt:=' ';

    MenuOption[20].xb:=25;
    MenuOption[20].yb:=14;
    MenuOption[20].xe:=29;
    MenuOption[20].title:='  T  ';
    MenuOption[20].qk:='T';
    MenuOption[20].descrpt:=' ';

    MenuOption[21].xb:=25;
    MenuOption[21].yb:=15;
    MenuOption[21].xe:=29;
    MenuOption[21].title:='  U  ';
    MenuOption[21].qk:='U';
    MenuOption[21].descrpt:=' ';

    MenuOption[22].xb:=25;
    MenuOption[22].yb:=16;
    MenuOption[22].xe:=29;
    MenuOption[22].title:='  V  ';
    MenuOption[22].qk:='V';
    MenuOption[22].descrpt:=' ';

    MenuOption[23].xb:=25;
    MenuOption[23].yb:=17;
    MenuOption[23].xe:=29;
    MenuOption[23].title:='  W  ';
    MenuOption[23].qk:='W';
    MenuOption[23].descrpt:=' ';

    MenuOption[24].xb:=25;
    MenuOption[24].yb:=18;
    MenuOption[24].xe:=29;
    MenuOption[24].title:='  X  ';
    MenuOption[24].qk:='X';
    MenuOption[24].descrpt:=' ';

    MenuOption[25].xb:=25;
    MenuOption[25].yb:=19;
    MenuOption[25].xe:=29;
    MenuOption[25].title:='  Y  ';
    MenuOption[25].qk:='Y';
    MenuOption[25].descrpt:=' ';

    MenuOption[26].xb:=25;
    MenuOption[26].yb:=20;
    MenuOption[26].xe:=29;
    MenuOption[26].title:='  Z  ';
    MenuOption[26].qk:='Z';
    MenuOption[26].descrpt:=' ';

    MenuOption[27].xb:=9;
    MenuOption[27].yb:=19;
    MenuOption[27].xe:=14;
    MenuOption[27].title:=' File ';
    MenuOption[27].qk:='F';
    MenuOption[27].descrpt:='Copy, Delete, Move, Rename tagged files.';

    MenuOption[28].xb:=17;
    MenuOption[28].yb:=19;
    MenuOption[28].xe:=21;
    MenuOption[28].title:=' taG ';
    MenuOption[28].qk:='G';
    MenuOption[28].descrpt:='Tag All Files, Untag All Files or Tag Files by Pattern';


    MenuOption[29].xb:=24;
    MenuOption[29].yb:=19;
    MenuOption[29].xe:=29;
    MenuOption[29].title:=' masK ';
    MenuOption[29].qk:='K';
    MenuOption[29].descrpt:='Display Files by User define Mask.';

    MenuOption[30].xb:=32;
    MenuOption[30].yb:=19;
    MenuOption[30].xe:=39;
    MenuOption[30].title:=' Locate ';
    MenuOption[30].qk:='L';
    MenuOption[30].descrpt:='Locate all matching files for a given drive.';


    MenuOption[31].xb:=42;
    MenuOption[31].yb:=19;
    MenuOption[31].xe:=52;
    MenuOption[31].title:=' View/Edit ';
    MenuOption[31].qk:='V';
    MenuOption[31].descrpt:='View/Edit tagged ASCII files on the screen. ';

    MenuOption[32].xb:=55;
    MenuOption[32].yb:=19;
    MenuOption[32].xe:=61;
    MenuOption[32].title:=' priNt ';
    MenuOption[32].qk:='N';
    MenuOption[32].descrpt:='Print tagged ASCII files to the printer.';

    MenuOption[33].xb:=64;
    MenuOption[33].yb:=19;
    MenuOption[33].xe:=72;
    MenuOption[33].title:=' finDdup ';
    MenuOption[33].qk:='D';
    MenuOption[33].descrpt:='Find all duplicate file for a given drive.';

    MenuOption[34].xb:=10;
    MenuOption[34].yb:=20;
    MenuOption[34].xe:=15;
    MenuOption[34].title:=' Copy ';
    MenuOption[34].qk:='C';
    MenuOption[34].descrpt:='Copy tagged files to specified drive/subdirectory.';

    MenuOption[35].xb:=18;
    MenuOption[35].yb:=20;
    MenuOption[35].xe:=25;
    MenuOption[35].title:=' Delete ';
    MenuOption[35].qk:='D';
    MenuOption[35].descrpt:='Delete tagged files.';

    MenuOption[36].xb:=28;
    MenuOption[36].yb:=20;
    MenuOption[36].xe:=33;
    MenuOption[36].title:=' Move ';
    MenuOption[36].qk:='M';
    MenuOption[36].descrpt:='Move tagged files to specified drive/subdirectory.';

    MenuOption[37].xb:=36;
    MenuOption[37].yb:=20;
    MenuOption[37].xe:=43;
    MenuOption[37].title:=' Rename ';
    MenuOption[37].qk:='R';
    MenuOption[37].descrpt:='Rename tagged files.';

    MenuOption[38].xb:=10;
    MenuOption[38].yb:=20;
    MenuOption[38].xe:=19;
    MenuOption[38].title:=' Tagg All ';
    MenuOption[38].qk:='T';
    MenuOption[38].descrpt:='Tag all the files.';

    MenuOption[39].xb:=22;
    MenuOption[39].yb:=20;
    MenuOption[39].xe:=32;
    MenuOption[39].title:=' Untag All ';
    MenuOption[39].qk:='U';
    MenuOption[39].descrpt:='Untag all the files.';

    MenuOption[40].xb:=35;
    MenuOption[40].yb:=20;
    MenuOption[40].xe:=43;
    MenuOption[40].title:=' Pattern ';
    MenuOption[40].qk:='P';
    MenuOption[40].descrpt:='Tag files by specified pattern.';

    MenuOption[41].xb:=35;
    MenuOption[41].yb:=11;
    MenuOption[41].xe:=39;
    MenuOption[41].title:=' YES ';
    MenuOption[41].qk:='Y';
    MenuOption[41].descrpt:='';

    MenuOption[42].xb:=43;
    MenuOption[42].yb:=11;
    MenuOption[42].xe:=46;
    MenuOption[42].title:=' NO ';
    MenuOption[42].qk:='N';
    MenuOption[42].descrpt:='';

    MenuOption[43].xb:=23;
    MenuOption[43].yb:=12;
    MenuOption[43].xe:=38;
    MenuOption[43].title:=' File/Date/Size ';
    MenuOption[43].qk:='F';
    MenuOption[43].descrpt:='Select only those files whose file names, date & size match ';

    MenuOption[44].xb:=43;
    MenuOption[44].yb:=12;
    MenuOption[44].xe:=58;
    MenuOption[44].title:=' file Name Only ';
    MenuOption[44].qk:='N';
    MenuOption[44].descrpt:='Select all files whose names are identical.';

    MenuOption[45].xb:=29;
    MenuOption[45].yb:=12;
    MenuOption[45].xe:=36;
    MenuOption[45].title:=' Screen ';
    MenuOption[45].qk:='S';
    MenuOption[45].descrpt:='';

    MenuOption[46].xb:=40;
    MenuOption[46].yb:=12;
    MenuOption[46].xe:=55;
    MenuOption[46].title:=' Printer (LPT1) ';
    MenuOption[46].qk:='P';
    MenuOption[46].descrpt:='';

    MenuOption[47].xb:=33;
    MenuOption[47].yb:=22;
    MenuOption[47].xe:=37;
    MenuOption[47].title:=' YES ';
    MenuOption[47].qk:='Y';
    MenuOption[47].descrpt:='';

    MenuOption[48].xb:=40;
    MenuOption[48].yb:=22;
    MenuOption[48].xe:=43;
    MenuOption[48].title:=' NO ';
    MenuOption[48].qk:='N';
    MenuOption[48].descrpt:='';

    MenuOption[49].xb:=23;
    MenuOption[49].yb:=13;
    MenuOption[49].xe:=33;
    MenuOption[49].title:=' Overwrite ';
    MenuOption[49].qk:='O';
    MenuOption[49].descrpt:='';

    MenuOption[50].xb:=36;
    MenuOption[50].yb:=13;
    MenuOption[50].xe:=49;
    MenuOption[50].title:=' overWriteAll ';
    MenuOption[50].qk:='W';
    MenuOption[50].descrpt:='';

    MenuOption[51].xb:=52;
    MenuOption[51].yb:=13;
    MenuOption[51].xe:=57;
    MenuOption[51].title:=' Skip ';
    MenuOption[51].qk:='S';
    MenuOption[51].descrpt:='';

    MenuOption[52].xb:=35;
    MenuOption[52].yb:=13;
    MenuOption[52].xe:=39;
    MenuOption[52].title:=' YES ';
    MenuOption[52].qk:='Y';
    MenuOption[52].descrpt:='';

    MenuOption[53].xb:=43;
    MenuOption[53].yb:=13;
    MenuOption[53].xe:=46;
    MenuOption[53].title:=' NO ';
    MenuOption[53].qk:='N';
    MenuOption[53].descrpt:='';


end; {Set Menu Options}


{---------------------------------------------------------------------------}
Procedure DisplayFirstPage;
  begin
    ptr:=first_dir;                {Set pointer to first_directory listing}
    new_dir:=first_dir;
    PageNumber:=1;
    FillHeap(2,1,1,80,25,#32,FilesMain);
    if not ShortFile then begin
      PutHeap(2,'File Name',19,6,TagAtt);
      PutHeap(2,'Date',35,6,TagAtt);
      PutHeap(2,'Time',47,6,TagAtt);
      PutHeap(2,'Size',59,6,TagAtt);
    end;

    while (new_dir<>nil) and (PageNumber=1) do begin
      with new_dir^do begin
        if ShortFile then
          PutHeap(2,filename,x,y,FilesMain)
        else begin
          str(FileSize,string2);
          PutHeap(2,filename,x,y,FilesMain);
          PutHeap(2,FileSDate,33,y,FilesMain);
          PutHeap(2,FileSTime,45,y,FilesMain);
          PutHeap(2,FileSSize,57,y,FilesMain);
        end;

        if DirTag then PutHeap(2,TAG,x-1,y,TagAtt);
        ptr1:=new_dir;
        new_dir:=next_dir;

        if new_dir<>nil then begin
          with new_dir^do begin
            PageNumber:=DirPage;
            ptr1:=prev_dir;
          end;
        end; {if new dir <> nil}

      end; {with new dir do}
    end; {While new dir <> nill ...}
    PageNumber:=1;
    string1:=' 1';

    Case monitor of
      1: PoPObjLib(@ezd,'ezdfilec',true,true);
      2: PoPObjLib(@ezd,'ezdfilem',true,true);
    end; {Case monitor of}

    PutStr(string1,13,16,FilesMain);
    str(TotalPages,string1);
    if TotalPages<10 then string1:=' '+string1;
    PutStr(string1,19,16,FilesMain);
    PutStr(DriveNSub,17,20,StatusAtt);
    Heap2Scr(2,5,6,74,15,5,6);
    if not ExpertMode then
      string1:='Off'
    else
      string1:='On ';
    PutStr(string1,61,20,StatusAtt);
    if ShortFile then
      SetAtt(6,6,6+fofs,6,FilesHigh)
    else
      SetAtt(17,7,17+fofs,7,FilesHigh);
    str(TotalFilesTagged,string1);
    RemBlkR(34,21,37,21,StatusAtt,False);
    PutStr(string1,34,21,StatusAtt);
    str(TaggedFilesSize,string1);
    RemBlkR(61,21,70,21,StatusAtt,False);
    PutStr(string1,61,21,StatusAtt);
    new_dir:=first_dir;

  end; {DisplayFirstPage - Display first page of files}

{---------------------------------------------------------------------------}
  Procedure RenameFile (* OldName,
                         NewName  : AnyString;
                         var Ecode : integer *);
                       { Error codes: 0 - successful
                                      2 - file not found
                                      3 - path/file not found
                                      5 - access denied
                                      11h - not same device }
    var
      regs                 : Registers;

    begin
      with regs do begin
        OldName := OldName + #0;
        NewName := NewName + #0;
        ds := seg(OldName);
        dx := ofs(OldName) + 1;
        es := seg(NewName);
        di := ofs(NewName) + 1;
        ax := $5600;
        MsDos ( regs );
        if (flags and 1) = 0 then
           Ecode := 0
        else
           Ecode := ax and $00FF;
      end;
    end;   { BoRename }

{---------------------------------------------------------------------------}
Procedure MPLFileName(* Code: ShortInt; var FileNme: AnyString *);
  var
     i                     : Integer;
     ch                    : Char;
     s,
     filename              : String[12];
     filext                : String[3];
     EndofString           : Boolean;

  label File_Name, File_Extension;

  begin
    SaveScreen(2);
    ClearBox(28,6,52,15,FileNameAtt,2,False);
    Case Code of
      1: begin
           PutStr('Locate',37,7,FileNameAtt);
           PutStr('Enter name of the ',31,9,FileNameAtt);
           PutStr(' file to LOCATE',31,10,FileNameAtt);
         end; {1 - Rename}
      2: begin
           PutStr('Pattern',37,7,FileNameAtt);
           PutStr('Enter the pattern to',30,9,FileNameAtt);
           PutStr('    tag files by.',30,10,FileNameAtt);
         end; {2 - Tag by Pattern}
      3: begin
           PutStr('Mask',38,7,FileNameAtt);
           PutStr('Enter the file mask ',31,9,FileNameAtt);
           PutStr('     desired.',30,10,FileNameAtt);
         end; {3 - Mask}
    end; {Case Code of}
    PutStr('Name',32,12,FileNameAtt);
    PutStr(' Ext',32,13,FileNameAtt);
    PutStr('[        ]',38,12,15);
    PutStr('[   ]',38,13,15);

   {---------------------  Get Data into fields --------------------}
     bf(0,15);
     EndOfString:=False;
     File_Name:
       s:='';
       i:=1;
       PutStr('[        ]',38,12,15);
       gotoxy(39,12);
       CursorOn;
       repeat
         ch:=ReadKey;
         ch:=UpCase(ch);
         if ch=NUL then begin
           ch:=ReadKey;
           Case ch of
             F1: begin
                   SaveScreen(4);
                   CursorOff;
                   Case monitor of
                     1: PoPObjLib(@ezd,'mplhelpc',true,true);
                     2: PoPObjLib(@ezd,'mplhelpm',true,true);
                   end; {Case monitor of}
                   ch1:=ReadKey;
                   if ch1=NUL then ch1:=ReadKey;
                   CursorOn;
                   RestoreScreen(4);
                 end;
             else
               write(BELL);
           end; {Case Ch of}
         end                                     {End if ESC hit}
         else begin
           Case ch of
             ESC: begin
                    CursorOff;
                    EscDepressed:=True;
                    exit;
                  end; {Esc}
              BS: begin
                    Case i of
                       1: write(BELL);
                    2..9: begin
                            EndofString:=False;
                            i:=i-1;
                            gotoxy(38+i,12);
                            write(' ');
                            gotoxy(38+i,12);
                          end;
                    end; {Case i of}
                  end; {if BackSpace}
         'A'..'Z',
         '0'..'9',
         '?','@',
         '!'..'-': begin
                     Case i of
                       1..7: begin
                               if EndofString then
                                 write(BELL)
                               else begin
                                 write(ch);
                                 i:=i+1;
                                 gotoxy(38+i,12);
                               end;
                             end; {1..7}
                          8: begin
                               write(ch);
                               i:=9;
                               EndofString:=True;
                               gotoxy(46,12);
                               end;
                             else
                               write(BELL);
                     end; {Case i of}
                   end; {Valid Input}
                   else
                     if ch<>CR then write(BELL);
            end; {Case ch of}
          end; {Key pressed not ESC}
        until ch=CR;
        GetStr(s,39,12,8);
        if Code=2 then begin
          l:=pos('*',s);
          if l>0 then begin
            for i:=l to 8 do s[i]:='?';
          end;
          l:=pos(SPC,s);
          if l>0 then begin
            for i:=l to 8 do s[i]:='?';
          end;
        end; {replace all after pattern with ?}
        l:=length(s);
        while copy(s,l,1)=SPC do begin
          delete(s,l,1);
          l:=length(s);
        end;
        filename:=s;

      File_Extension:
       s:='';
       i:=1;
       PutStr('[   ]',38,13,15);
       gotoxy(38+i,13);
       CursorOn;
       repeat
          ch:=ReadKey;
          ch:=UpCase(ch);
          if ch=NUL then begin
            ch:=ReadKey;
            Case ch of
                   F1: begin
                         SaveScreen(4);
                         CursorOff;
                         Case monitor of
                           1: PoPObjLib(@ezd,'mplhelpc',true,true);
                           2: PoPObjLib(@ezd,'mplhelpm',true,true);
                         end; {Case monitor of}
                         ch1:=ReadKey;
                         if ch1=NUL then ch1:=ReadKey;
                         CursorOn;
                         RestoreScreen(4);
                       end; {F1}
              UPARROW: begin
                         PutStr('[   ]',38,13,15);
                         goto File_Name;
                       end; {UpArrow}
            end; {Case ch of}
          end
          else begin
            Case ch of
                ESC: begin
                       CursorOff;
                       EscDepressed:=True;
                       exit;
                     end; {Esc}
                 BS: begin
                       Case i of
                         1: write(BELL);
                      2..4: begin
                              i:=i-1;
                              gotoxy(38+i,13);
                              write(' ');
                              gotoxy(38+i,13);
                            end;
                       end; {Case i of}
                     end; {if BackSpace}
               'A'..'Z',
               '0'..'9',
               '?','@',
               '!'..'-': begin
                            Case i of
                              1..2:
                                  begin
                                   write(ch);
                                   i:=i+1;
                                   gotoxy(38+i,13);
                                 end;
                              3: begin
                                   write(ch);
                                   i:=4;
                                   gotoxy(42,13);
                                 end;
                              else
                                write(BELL);
                            end; {Case i of}
                          end; {Valid Input}
                       else
                 if ch<>CR then write(BELL);
            end; {Case ch of}
          end; {Key pressed not ESC}
        until ch=CR;
        CursorOff;
        GetStr(s,39,13,3);
        if Code=2 then begin
          l:=pos('*',s);
          if l>0 then begin
            for i:=l to 3 do s[i]:='?';
          end;
          l:=pos(SPC,s);
          if l>0 then begin
            for i:=l to 3 do s[i]:='?';
          end;
        end; {replace all after pattern with ?}
        l:=length(s);
        while copy(s,l,1)=SPC do begin
          delete(s,l,1);
          l:=length(s);
        end;
        filext:=s;
        FileNme:=filename+'.'+filext;
        if Code<>1 then begin
          if FileNme='.' then FileNme:='????????.???'
        end;
  end; {MPLFileName - for Locate, Pattern, Mask}

{----------------------------------------------------------------------}
  Procedure TagByPattern(* s1: AnyString *);
    var
      att        : Byte;
      i,l        : Integer;
      s          : String[12];
      Match      : Boolean;

    begin
      new_dir:=first_dir;
      repeat
        with new_dir^ do begin
          s:=FileName;
          for i:=1 to 12 do begin
            if s[i]=SPC then s[i]:='?';
          end;
          i:=1;
          Match:=True;
          repeat
            if s1[i]<>'?' then begin
              if (s[i]<>'?') and (s[i]<>s1[i]) then Match:=False;
            end; {if character in string<>?}
            inc(i);
          until (i=9) or (Match=False);
          if Match then begin
            i:=10;
            repeat
              if s1[i]<>'?' then begin
                if (s[i]<>'?') and (s[i]<>s1[i]) then Match:=False;
              end; {if character in string<>?}
              inc(i);
            until (i=13) or (Match=False);
          end; {if filename matches}
          if Match then begin
            DirTag:=True;
            inc(TotalFilesTagged);
            TaggedFilesSize:=TaggedFilesSize+FileSize;
          end;
          new_dir:=next_dir;
        end;
      until new_dir=nil;
      str(TotalFilesTagged,string2);
      RemBlkR(34,21,37,21,StatusAtt,False);
      PutStr(string2,34,21,StatusAtt);
      str(TaggedFilesSize,string2);
      RemBlkR(61,21,70,21,StatusAtt,False);
      PutStr(string2,61,21,StatusAtt);
    end; {Pattern}

{-----------------------------------------------------------------------}
Procedure GetFileNumber(* var num: Integer *);
  var
    k           : Integer;
  begin
    k:=1;
    new_dir:=first_dir;
    while new_dir<>nil do begin
      new_dir:=new_dir^.next_dir;
      inc(k);
    end;
    num:=k-1;
  end; {GetFileNumber - Returns number of files in linked list}

{-------------------------------------------------------------------------}
Procedure ASort(* NameOrExt: Char *);
  var
    root,
    pnext,
    pprior,
    pl,
    pr,
    p,
    p1       : Dir_Ptr;
    position,
    width,
    i        : Integer;
    s,
    s1       : String[12];

  Label Left1, Right1, NextFile;

  begin
    i:=2;
    Case NameOrExt of
      'N': begin
             position:=1;
             width:=12;
           end; {N}
      'E': begin
             position:=10;
             width:=3;
           end; {E}
    end; {Case NameOrExt of}
  {----------------- Establish Root of Tree ---------------------}
    root:=first_dir;               {Set Root to first file}
    p:=first_dir^.next_dir;        {Set pointer to next file}
    pl:=nil;                       {Set pointer left to nil}
    pr:=nil;                       {Set pointer right to nil}
    root^.prev_dir:=nil;           {Set pointer left in Root to nil}
    root^.next_dir:=nil;           {Set pointer right in Root to nil}
    s:=copy(first_dir^.filename,position,width); {Get Root File Name}
    pprior:=root;
    first_dir:=root;
    last_dir:=root;

    while i<=NumOfFiles do begin
      pnext:=p^.next_dir;
      s1:=copy(p^.filename,position,width); {Get FileName of Next File}
      if s1<=s then begin
        if root^.prev_dir=nil then begin
          p^.next_dir:=root;
          p^.prev_dir:=nil;
          first_dir:=p;
          root^.prev_dir:=p;
          goto NextFile;
        end
        else begin
         Left1:
          pprior:=pl^.next_dir;
          pl:=pprior^.prev_dir;
          s:=copy(pl^.filename,position,width);
          if s1<=s then begin
            if pl^.prev_dir=nil then begin
             p^.next_dir:=pl;
             p^.prev_dir:=nil;
             first_dir:=p;
             pl^.prev_dir:=p;
             goto NextFile;
            end
            else begin
              pl:=pl^.prev_dir;
              goto Left1;
            end; {if not end of left side}
          end {if s1<=1}
          else begin
            p^.prev_dir:=pl;
            p^.next_dir:=pprior;
            pl^.next_dir:=p;
            pprior^.prev_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pl<>nil}
      end {if string less than or equal to}
      else begin
        if root^.next_dir=nil then begin
          p^.next_dir:=nil;
          p^.prev_dir:=root;
          last_dir:=p;
          root^.next_dir:=p;
          goto NextFile;
        end
        else begin
         Right1:
          pprior:=pr^.prev_dir;
          pr:=pprior^.next_dir;
          s:=copy(pr^.filename,position,width);
          if s1>s then begin
            if pr^.next_dir=nil then begin
             p^.next_dir:=nil;
             p^.prev_dir:=pr;
             last_dir:=p;
             pr^.next_dir:=p;
             goto NextFile;
            end
            else begin
              pr:=pr^.next_dir;
              goto Right1;
            end; {if not end of left side}
          end {if s1>=1}
          else begin
            p^.prev_dir:=pprior;
            p^.next_dir:=pr;
            pr^.prev_dir:=p;
            pprior^.next_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pr<>nil}
      end; {if string greater than compare}
     NextFile:
      inc(i);
      if i<=NumOfFiles then begin
        pl:=root^.prev_dir;
        pr:=root^.next_dir;
        s:=copy(root^.filename,position,width);
        p:=pnext;
      end; {if i<=Number of Files}
    end; {while i<NumOfFiles - Main Body of Program}
  end; {ASort - Alpha Sort, really BTree sort of}

{------------------------------------------------------------------------}
Procedure ASortD(* NameOrExt: Char *);
  var
    root,
    pnext,
    pprior,
    pl,
    pr,
    p,
    p1       : Dir_Ptr;
    position,
    width,
    i        : Integer;
    s,
    s1       : String[12];

  Label Left1, Right1, NextFile;

  begin
    i:=2;
    Case NameOrExt of
      'N': begin
             position:=1;
             width:=12;
           end; {N}
      'E': begin
             position:=10;
             width:=3;
           end; {E}
    end; {Case NameOrExt of}
  {----------------- Establish Root of Tree ---------------------}
    root:=first_dir;               {Set Root to first file}
    p:=first_dir^.next_dir;        {Set pointer to next file}
    pl:=nil;                       {Set pointer left to nil}
    pr:=nil;                       {Set pointer right to nil}
    root^.prev_dir:=nil;           {Set pointer left in Root to nil}
    root^.next_dir:=nil;           {Set pointer right in Root to nil}
    s:=copy(first_dir^.filename,position,width); {Get Root File Name}
    pprior:=root;
    first_dir:=root;
    last_dir:=root;

    while i<=NumOfFiles do begin
      pnext:=p^.next_dir;
      s1:=copy(p^.filename,position,width); {Get FileName of Next File}
      if s<=s1 then begin
        if root^.prev_dir=nil then begin
          p^.next_dir:=root;
          p^.prev_dir:=nil;
          first_dir:=p;
          root^.prev_dir:=p;
          goto NextFile;
        end
        else begin
         Left1:
          pprior:=pl^.next_dir;
          pl:=pprior^.prev_dir;
          s:=copy(pl^.filename,position,width);
          if s<=s1 then begin
            if pl^.prev_dir=nil then begin
             p^.next_dir:=pl;
             p^.prev_dir:=nil;
             first_dir:=p;
             pl^.prev_dir:=p;
             goto NextFile;
            end
            else begin
              pl:=pl^.prev_dir;
              goto Left1;
            end; {if not end of left side}
          end {if s1<=1}
          else begin
            p^.prev_dir:=pl;
            p^.next_dir:=pprior;
            pl^.next_dir:=p;
            pprior^.prev_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pl<>nil}
      end {if string less than or equal to}
      else begin
        if root^.next_dir=nil then begin
          p^.next_dir:=nil;
          p^.prev_dir:=root;
          last_dir:=p;
          root^.next_dir:=p;
          goto NextFile;
        end
        else begin
         Right1:
          pprior:=pr^.prev_dir;
          pr:=pprior^.next_dir;
          s:=copy(pr^.filename,position,width);
          if s>s1 then begin
            if pr^.next_dir=nil then begin
             p^.next_dir:=nil;
             p^.prev_dir:=pr;
             last_dir:=p;
             pr^.next_dir:=p;
             goto NextFile;
            end
            else begin
              pr:=pr^.next_dir;
              goto Right1;
            end; {if not end of left side}
          end {if s1>=1}
          else begin
            p^.prev_dir:=pprior;
            p^.next_dir:=pr;
            pr^.prev_dir:=p;
            pprior^.next_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pr<>nil}
      end; {if string greater than compare}
     NextFile:
      inc(i);
      if i<=NumOfFiles then begin
        pl:=root^.prev_dir;
        pr:=root^.next_dir;
        s:=copy(root^.filename,position,width);
        p:=pnext;
      end; {if i<=Number of Files}
    end; {while i<NumOfFiles - Main Body of Program}
  end; {ASortD - Alpha Sort Descending, really BTree sort of}

{------------------------------------------------------------------------}
Procedure NSort(* DateOrSize: Char *);
  var
    root,
    pnext,
    pprior,
    pl,
    pr,
    p,
    p1       : Dir_Ptr;
    position,
    width,
    i        : Integer;
    s,
    s1       : LongInt;

  Label Left1, Right1, NextFile;

  begin
    i:=2;
  {----------------- Establish Root of Tree ---------------------}
    root:=first_dir;               {Set Root to first file}
    p:=first_dir^.next_dir;        {Set pointer to next file}
    pl:=nil;                       {Set pointer left to nil}
    pr:=nil;                       {Set pointer right to nil}
    root^.prev_dir:=nil;           {Set pointer left in Root to nil}
    root^.next_dir:=nil;           {Set pointer right in Root to nil}
    Case DateOrSize of
      'D': s:=first_dir^.filedate;
      'S': s:=first_dir^.filesize;
    end; {Case FileOr}
    pprior:=root;
    first_dir:=root;
    last_dir:=root;

    while i<=NumOfFiles do begin
      pnext:=p^.next_dir;
      Case DateOrSize of
        'D': s1:=p^.filedate;
        'S': s1:=p^.filesize;
      end; {Case FileOr}
      if s1<=s then begin
        if root^.prev_dir=nil then begin
          p^.next_dir:=root;
          p^.prev_dir:=nil;
          first_dir:=p;
          root^.prev_dir:=p;
          goto NextFile;
        end
        else begin
         Left1:
          pprior:=pl^.next_dir;
          pl:=pprior^.prev_dir;
          Case DateOrSize of
            'D': s:=pl^.filedate;
            'S': s:=pl^.filesize;
          end; {Case FileOr}
          if s1<=s then begin
            if pl^.prev_dir=nil then begin
             p^.next_dir:=pl;
             p^.prev_dir:=nil;
             first_dir:=p;
             pl^.prev_dir:=p;
             goto NextFile;
            end
            else begin
              pl:=pl^.prev_dir;
              goto Left1;
            end; {if not end of left side}
          end {if s1<=1}
          else begin
            p^.prev_dir:=pl;
            p^.next_dir:=pprior;
            pl^.next_dir:=p;
            pprior^.prev_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pl<>nil}
      end {if string less than or equal to}
      else begin
        if root^.next_dir=nil then begin
          p^.next_dir:=nil;
          p^.prev_dir:=root;
          last_dir:=p;
          root^.next_dir:=p;
          goto NextFile;
        end
        else begin
         Right1:
          pprior:=pr^.prev_dir;
          pr:=pprior^.next_dir;
          Case DateOrSize of
            'D': s:=pr^.filedate;
            'S': s:=pr^.filesize;
          end; {Case FileOr}
          if s1>s then begin
            if pr^.next_dir=nil then begin
             p^.next_dir:=nil;
             p^.prev_dir:=pr;
             last_dir:=p;
             pr^.next_dir:=p;
             goto NextFile;
            end
            else begin
              pr:=pr^.next_dir;
              goto Right1;
            end; {if not end of left side}
          end {if s1>=1}
          else begin
            p^.prev_dir:=pprior;
            p^.next_dir:=pr;
            pr^.prev_dir:=p;
            pprior^.next_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pr<>nil}
      end; {if string greater than compare}
     NextFile:
      inc(i);
      if i<=NumOfFiles then begin
        pl:=root^.prev_dir;
        pr:=root^.next_dir;
        Case DateOrSize of
          'D': s:=root^.filedate;
          'S': s:=root^.filesize;
        end; {Case FileOr}
        p:=pnext;
      end; {if i<=Number of Files}
    end; {while i<NumOfFiles - Main Body of Program}
  end; {NSort - Number Sort, really BTree sort of}

{------------------------------------------------------------------------}
Procedure NSortD(* DateOrSize: Char *);
  var
    root,
    pnext,
    pprior,
    pl,
    pr,
    p,
    p1       : Dir_Ptr;
    position,
    width,
    i        : Integer;
    s,
    s1       : LongInt;

  Label Left1, Right1, NextFile;

  begin
    i:=2;
  {----------------- Establish Root of Tree ---------------------}
    root:=first_dir;               {Set Root to first file}
    p:=first_dir^.next_dir;        {Set pointer to next file}
    pl:=nil;                       {Set pointer left to nil}
    pr:=nil;                       {Set pointer right to nil}
    root^.prev_dir:=nil;           {Set pointer left in Root to nil}
    root^.next_dir:=nil;           {Set pointer right in Root to nil}
    Case DateOrSize of
      'D': s:=first_dir^.filedate;
      'S': s:=first_dir^.filesize;
    end; {Case FileOr}
    pprior:=root;
    first_dir:=root;
    last_dir:=root;

    while i<=NumOfFiles do begin
      pnext:=p^.next_dir;
      Case DateOrSize of
        'D': s1:=p^.filedate;
        'S': s1:=p^.filesize;
      end; {Case FileOr}
      if s<=s1 then begin
        if root^.prev_dir=nil then begin
          p^.next_dir:=root;
          p^.prev_dir:=nil;
          first_dir:=p;
          root^.prev_dir:=p;
          goto NextFile;
        end
        else begin
         Left1:
          pprior:=pl^.next_dir;
          pl:=pprior^.prev_dir;
          Case DateOrSize of
            'D': s:=pl^.filedate;
            'S': s:=pl^.filesize;
          end; {Case FileOr}
          if s<=s1 then begin
            if pl^.prev_dir=nil then begin
             p^.next_dir:=pl;
             p^.prev_dir:=nil;
             first_dir:=p;
             pl^.prev_dir:=p;
             goto NextFile;
            end
            else begin
              pl:=pl^.prev_dir;
              goto Left1;
            end; {if not end of left side}
          end {if s1<=1}
          else begin
            p^.prev_dir:=pl;
            p^.next_dir:=pprior;
            pl^.next_dir:=p;
            pprior^.prev_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pl<>nil}
      end {if string less than or equal to}
      else begin
        if root^.next_dir=nil then begin
          p^.next_dir:=nil;
          p^.prev_dir:=root;
          last_dir:=p;
          root^.next_dir:=p;
          goto NextFile;
        end
        else begin
         Right1:
          pprior:=pr^.prev_dir;
          pr:=pprior^.next_dir;
          Case DateOrSize of
            'D': s:=pr^.filedate;
            'S': s:=pr^.filesize;
          end; {Case FileOr}
          if s>s1 then begin
            if pr^.next_dir=nil then begin
             p^.next_dir:=nil;
             p^.prev_dir:=pr;
             last_dir:=p;
             pr^.next_dir:=p;
             goto NextFile;
            end
            else begin
              pr:=pr^.next_dir;
              goto Right1;
            end; {if not end of left side}
          end {if s1>=1}
          else begin
            p^.prev_dir:=pprior;
            p^.next_dir:=pr;
            pr^.prev_dir:=p;
            pprior^.next_dir:=p;
            goto NextFile;
          end; {place to insert file}
        end; {if pr<>nil}
      end; {if string greater than compare}
     NextFile:
      inc(i);
      if i<=NumOfFiles then begin
        pl:=root^.prev_dir;
        pr:=root^.next_dir;
        Case DateOrSize of
          'D': s:=root^.filedate;
          'S': s:=root^.filesize;
        end; {Case FileOr}
        p:=pnext;
      end; {if i<=Number of Files}
    end; {while i<NumOfFiles - Main Body of Program}
  end; {NSortD - Number Sort Descending, really BTree sort of}

{------------------------------------------------------------------------}
 Procedure GoNameSortA;
   begin
     GetFileNumber(NumOfFiles);
     ASort('N');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=1;
   end; {Sort Files by Name Ascending}

{-------------------------------------------------------------------------}
 Procedure GoNameSortD;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Name - Descending',26,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=2;
   end; {Sort Files by Name Descending}

{-------------------------------------------------------------------------}
 Procedure GoExtSortA;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Extension - Ascending',24,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     ASort('E');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=3;
   end; {Sort Files by Extension - Ascending}

{-------------------------------------------------------------------------}
 Procedure GoExtSortD;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Extension - Descending',23,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     ASortD('E');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=4;
   end; {Sort Files by Extension - Descending}

{-------------------------------------------------------------------------}
 Procedure GoSizeSortA;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Size - Ascending',27,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     NSort('S');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=5;
   end; {Sort Files by Size - Ascending}

{-------------------------------------------------------------------------}
 Procedure GoSizeSortD;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Size - Descending',26,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     NSortD('S');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=6;
   end; {Sort Files by Size - Descending}

{-------------------------------------------------------------------------}
 Procedure GoDateSortA;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Date - Ascending',27,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     NSort('D');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=7;
   end; {Sort Files by Date - Ascending}

{-------------------------------------------------------------------------}
 Procedure GoDateSortD;
   begin
     RemBlkR(1,25,80,25,HelpBar,False);
     PutStr('Sorting by Date - Descending',27,25,HelpBar+128);
     GetFileNumber(NumOfFiles);
     ASortD('N');
     NSortD('D');
     ReshuffleFiles;
     PageNumber:=1;
     DisplayFirstPage;
     LastSort:=8;
   end; {Sort Files by Date - Descending}

{-------------------------------------------------------------------------}


BEGIN
END.
