{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Demonstration program for TPPICK and TPDIR units.

* ASSOCIATED FILES
TPDIR.PAS
DEMO1.PAS
DEMO1.EXE
TPDIR.TPU
TPPICK.PAS
TPPICK.TPU

}
{
Demonstration program for TPPick and TPDir units.

This program requires the use of units from the commercial product Turbo
Professional 4.0, by TurboPower Software. It demonstrates two new units,
supplied here. The TPPick unit offers general-purpose scrolling "pick"
windows, which allow the user to scroll though a list of strings and select
one to return to the calling program. The TPDir unit offers a popup directory
unit, useful wherever user entry of filenames is required.

Copyright (c) 1987 by TurboPower Software. May be freely used by and
distributed to owners of Turbo Professional 4.0.

Turbo Professional 4.0 is a library of 400 general purpose procedures and
functions especially optimized for Turbo Pascal 4.0. It costs $99 and includes
complete source code and a 450 page manual. Contact TurboPower Software at
408-438-8608 or on Compuserve [72457,2131] for more information.
}

{$R-,S-,I-,V-}

program Demo;
  {-Demonstrate TPPick and TPDir units}
uses
  Dos,
  TPString,
  TPCrt,
  TPWindow,
  TPPick,
  TPDir;
var
  Mask, Fname : string;
begin
  {Override default position of the pick window}
  if CurrentWidth < 80 then
    TPDir.XLow := 1
  else
    TPDir.XLow := 15;
  TPDir.YHigh := CurrentHeight;

  WriteLn('Press Ctrl-Break to quit');

  repeat
    Write('Enter a filename mask: ');
    ReadLn(Mask);
    case GetFileName(Mask, Fname) of
      0 : WriteLn('Got filename=', Fname);
      1 : WriteLn('Path not found');
      2 : WriteLn('No matching files');
      3 : WriteLn('Unsupported video mode');
      4 : WriteLn('Insufficient memory');
    else
      WriteLn('Dos critical error');
    end;
  until False;
end.

