{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program demonstrates the use of the heap allocation tools provided in
the HeapChek unit.

* ASSOCIATED FILES
HEAPCHEK.PAS
DEMO.EXE
DEMO.PAS
HEAPCHEK.TPU

}
Program Demo;

{ This program demonstrates the use of the heap allocation tools provided
  in the HeapChek unit.

  Public Domain -- Lynn W. Taylor (CIS 74176,52) }

Uses TpCRT, TpString, HeapChek;

const MaxArray=24;
      BlockSize=1;

var PointerArray: array  [1..MaxArray] of Pointer;
    Ctr, Index: integer;
    AllocationStrategy: char;

Begin
  ClrScr;
  WriteLn('Heap allocation strategy demo');
  WriteLn;
  WriteLn('Program demonstrates tools to show heap states, and to alter the allocation');
  WriteLn('strategies used by the Heap Manager by modifying the free list.');
  WriteLn;
  WriteLn('To demonstrate, program will allocate 24 one-byte blocks, deallocate them');
  WriteLn('in a random order, then re-allocate them.');
  WriteLn;
  WriteLn('After the blocks are allocated, an "*" will indicate a block which');
  WriteLn('has been deallocated.  The new pointer will be displayed to the right');
  WriteLn('as it is allocated, along with the size of the largest free block.');
  WriteLn;
  WriteLn('Choose [E] for Exact Fit');
  WriteLn('       [F] for First Fit');
  WriteLn('       [B] for Best Fit');
  WriteLn('       [W] for Worst Fit');
  WriteLn('       [S] to place disposed pointer at end of free list');
  WriteLn;
  WriteLn('Any other key uses Turbo default heap management');
  AllocationStrategy:=ReadKey;
  ClrScr;
  Randomize;
  AlwaysShowHeapStatus:=true;
  ClrScr;
  For Ctr:=1 to MaxArray do
    Begin
      GetMem(PointerArray[Ctr], BlockSize);
      GotoXY(32, Ctr);
      Write(Ctr:2,' $', HexPtr(PointerArray[Ctr]));
      GotoXY(1, 1);
      HeapCheck;
      Delay(500)
    End;
  For Ctr:=1 to Random(MaxArray)+MaxArray div 2 do
    Begin
      Index:=Random(MaxArray)+1;
      If PointerArray[Index]<>NIL then
        Begin
          GotoXY(46, Index);
          Write('+');
          FreeMem(PointerArray[Index], BlockSize);
          If UpCase(AllocationStrategy)='S' then SwapFreeHeap;
          GotoXY(1,1);
          HeapCheck;
          ShowFreeList;
          While WhereY<24 do WriteLn('                       ');
          Delay(500);
          GotoXY(46, Index);
          Write('*');
          PointerArray[Index]:=NIL;
        End
    End;
  GotoXY(46, Index);
  Write('+');
  For Ctr:=1 to MaxArray do
    If PointerArray[Ctr]=NIL then
      Begin
        GotoXY(60, Ctr);
        Write('(',MaxFreeListBlock,')');
        Case AllocationStrategy of
          'b','B': BestFitHeap(BlockSize);
          'e','E': ExactFitHeap(BlockSize);
          'f','F': FirstFitHeap(BlockSize);
          'w','W': WorstFitHeap
        end;  {cases}
        GetMem(PointerArray[Ctr], BlockSize);
        GotoXY(48, Ctr);
        Write('$', HexPtr(PointerArray[Ctr]));
        GotoXY(1,1);
        HeapCheck;
        ShowFreeList;
        While WhereY<24 do WriteLn('                       ');
        Delay(500)
      End;
  GotoXY(1,1)
End.

