{
--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
File used with FM.PAS.

* ASSOCIATED FILES
FM.PAS
FM.DOC
FM.EXE
FM.TPU
FMFILE.PAS
FMINPUT.PAS
FMSCREEN.PAS
FMUTEST.EXE
FMUTEST.PAS
FMVIEW.PAS

==========================================================================
}
{$R-}    { Range checking off }                         { Unit:    FMFile.PAS }
{$S-}    { Stack checking off }                         { Program: FM.PAS     }
{$V+}    { Strict String type checking on }             { Author:  Jim Zwick  }
{$B-}    { Boolean short-circuit evaluation on }        { Version: 1.0        }
{$I-}    { I/O checking off }                           { Date:    03-04-88   }

UNIT FMFile;

INTERFACE

USES
  Crt,
  Dos,
  FMScreen,
  FMInput;

TYPE
  FileBufferType = ARRAY[1..65530] OF CHAR;
  Str12   = STRING[12];
  Str128  = STRING[128];
  FilePtr = ^FileRec;
  FileRec = RECORD
              Key  : Str12;
              FNum : INTEGER;
              Mark : BOOLEAN;
              Next : FilePtr;
              Last : FilePtr;
            END;

VAR
  Attribute           : WORD;                 { Used to store file attributes }
  SpoolOK             : BOOLEAN;
  FirstFile, LastFile : FilePtr;
  CurrFile            : FilePtr;
  FileBuffer          : ^FileBufferType;
  FileBufSize         : WORD;
  Mask                : Str12;
  CurrDir             : Str80;


  PROCEDURE GetFilesList(Mask : Str12; VAR FirstFN, LastFN : FilePtr;
                VAR ListCount : WORD);
  PROCEDURE DeleteFile(VAR FirstPtr, LastPtr : FilePtr; OldKey : Str12);
  FUNCTION EnvSearch(SearchStr : Str80) : Str128;
  PROCEDURE SpoolFile(FN : Str80; VAR Ok : BOOLEAN);
  PROCEDURE ControlSpool;
  PROCEDURE EraseFile;
  PROCEDURE RenameFile;
  PROCEDURE CopyFile;
  PROCEDURE MoveFile;
  PROCEDURE GetCurrDir;
  PROCEDURE GetNewDirectory;


IMPLEMENTATION

  FUNCTION DOSversion : REAL;
  VAR
    DReg     : Registers;
    Maj, Min : INTEGER;
  BEGIN
    DReg.AH := $30;
    INTR($21, DReg);
    Maj := DReg.AL;
    Min := DReg.AH;
    DOSversion := Maj + (Min DIV 100);
  END;
  { ------------------------------------------------------------------------- }

  FUNCTION Exist(FN : Str80) : BOOLEAN;
  VAR
    DirInfo : SearchRec;
  BEGIN
    FindFirst(FN, ReadOnly + Hidden + SysFile, DirInfo);
    Exist := (DosError = 0) AND (POS('*', FN) = 0) AND (POS('?', FN) = 0);
  END;
  { ------------------------------------------------------------------------- }

  FUNCTION DiskFull(SourceName : Str80; Drive : WORD) : BOOLEAN;
  VAR
    FV   : FILE OF BYTE;                       { Check to see if copy of file }
    Attr : WORD;                               { will fit on destination disk }
  BEGIN                                        { before copying               }
    DiskFull := TRUE;
    ASSIGN(FV, SourceName);
    GetFAttr(FV, Attr);
    SetFAttr(FV, Archive);
    RESET(FV);
    IF (IOResult = 0) THEN DiskFull := (DiskFree(Drive) < FileSize(FV));
    CLOSE(FV);
    IF (IOResult = 0) THEN SetFAttr(FV, Attr);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE InsertFile(VAR FirstPtr, LastPtr, NewPtr : FilePtr);
  VAR
    SearchPtr : FilePtr;                       { FirstPtr and LastPtr must be }
    Found     : BOOLEAN;                       { initialized to NIL before    }
  BEGIN                                        { calling this routine the     }
    SearchPtr := FirstPtr;                     { first time.  NewPtr must be  }
    Found := FALSE;                            { allocated and initialized    }
    NewPtr^.Next := NIL;
    NewPtr^.Last := NIL;
    IF (SearchPtr = NIL) THEN
      BEGIN
        FirstPtr := NewPtr;
        LastPtr := FirstPtr;
      END
    ELSE
      BEGIN
        WHILE (SearchPtr <> NIL) AND (NOT Found) DO
          IF (SearchPtr^.Key < NewPtr^.Key) THEN SearchPtr := SearchPtr^.Next
          ELSE Found := TRUE;
        NewPtr^.Next := SearchPtr;
        IF (SearchPtr = FirstPtr) THEN
          BEGIN
            FirstPtr := NewPtr;
            SearchPtr^.Last := FirstPtr;
          END
        ELSE IF (SearchPtr = NIL) THEN
          BEGIN
            NewPtr^.Last := LastPtr;
            LastPtr^.Next := NewPtr;
            LastPtr := NewPtr;
          END
        ELSE
          BEGIN
            NewPtr^.Last := SearchPtr^.Last;
            SearchPtr^.Last^.Next := NewPtr;
            SearchPtr^.Last := NewPtr;
          END;
      END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE DeleteFile(VAR FirstPtr, LastPtr : FilePtr; OldKey : Str12);
  VAR
    DelPtr : FilePtr;                             { FirstPtr and LastPtr must }
  BEGIN                                           { be initialized to NIL     }
    IF (FirstPtr = NIL) THEN DelPtr := NIL        { before calling  this      }
    ELSE IF (OldKey = FirstPtr^.Key) THEN         { routine the first time    }
      BEGIN
        DelPtr := FirstPtr;
        FirstPtr := FirstPtr^.Next;
        IF (FirstPtr <> NIL) THEN FirstPtr^.Last := NIL;
        IF (FirstPtr = NIL) THEN LastPtr := NIL;
      END
    ELSE IF (OldKey = LastPtr^.Key) THEN
      BEGIN
        DelPtr := LastPtr;
        LastPtr := LastPtr^.Last;
        IF (LastPtr <> NIL) THEN LastPtr^.Next := NIL;
      END
    ELSE
      BEGIN
        DelPtr := FirstPtr;
        WHILE (DelPtr <> NIL) AND (DelPtr^.Key <> OldKey) DO
          DelPtr := DelPtr^.Next;
        IF (DelPtr <> NIL) THEN
          BEGIN
            DelPtr^.Next^.Last := DelPtr^.Last;
            DelPtr^.Last^.Next := DelPtr^.Next;
          END;
      END;
    IF (DelPtr <> NIL) THEN DISPOSE(DelPtr);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE GetFilesList(Mask : Str12; VAR FirstFN, LastFN : FilePtr;
                                             VAR ListCount : WORD);
  VAR
    TempPtr : FilePtr;               { FirstFN and LastFN must be initialized }
    NewFRec : FileRec;               { to NIL before calling this routine the }
    DirInfo : SearchRec;             { first time.  See Initialization below. }
  BEGIN
    WHILE (FirstFN <> NIL) DO DeleteFile(FirstFN, LastFN, FirstFN^.Key);
    ListCount := 0;
    FindFirst(Mask, ReadOnly, DirInfo);
    WHILE (DosError = 0) DO
      BEGIN
        NewFRec.Key := DirInfo.Name;
        NewFRec.Mark := FALSE;
        NEW(TempPtr);
        TempPtr^ := NewFRec;
        InsertFile(FirstFN, LastFN, TempPtr);
        FindNext(DirInfo);
      END;
    TempPtr := FirstFN;
    WHILE (TempPtr <> NIL) DO
      BEGIN
        Inc(ListCount);
        TempPtr^.FNum := ListCount;
        TempPtr := TempPtr^.Next;
      END;
  END;
  { ------------------------------------------------------------------------- }

  FUNCTION EnvSearch(SearchStr : Str80) : Str128;
  VAR
    EnvPtr        : ^INTEGER;   { Searches environment for left side of an    }
    MemOffSet     : INTEGER;    { assignment statement and returns the right. }
    EnvCh         : CHAR;       { This can be very useful with Turbo 4.0 EXEC }
    ELeft, ERight : Str128;     { in finding COMSPEC so it can be loaded from }
    EndOfEnviron  : BOOLEAN;    { any drive rather than using an              }
  BEGIN                         { EXEC('\COMMAND.COM', '') statement.         }
    EnvPtr := Ptr(PrefixSeg, $002C);    { Pointer to beginning of Environment }
    MemOffSet := 0;
    ERight[0] := #0;
    REPEAT
      ELeft[0] := #0;
      EnvCh := CHR(MEM[EnvPtr^:MemOffSet]);
      Inc(MemOffSet);
      EndOfEnviron := (EnvCh = #0);
      WHILE (EnvCh <> '=') AND (EnvCh <> #0) DO     { Read Env until equal    }
        BEGIN                                       { found.  If equal found  }
          ELeft := ELeft + EnvCh;                   { but ERight <> SearchStr }
          EnvCh := CHR(MEM[EnvPtr^:MemOffSet]);     { then read until end of  }
          Inc(MemOffSet);                           { assignment statement.   }
        END;
      IF (ELeft = SearchStr) THEN
        BEGIN
          EnvCh := CHR(MEM[EnvPtr^:MemOffSet]);             { Skip equal sign }
          Inc(MemOffSet);
          WHILE (EnvCh <> #0) DO
            BEGIN                                     { Read Env until end of }
              ERight := ERight + EnvCh;               { assignment statement  }
              EnvCh := CHR(MEM[EnvPtr^:MemOffSet]);
              Inc(MemOffSet);
            END;
        END;
    UNTIL (ELeft = SearchStr) OR (EndOfEnviron);
    EnvSearch := ERight;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE SpoolStat(VAR Ok : BOOLEAN);           { Checks availablity of    }
  VAR                                              { PRINT spooler.  DOS 3.xx }
    StatReg : Registers;                           { is required and PRINT    }
    RCode   : BYTE;                                { must be installed before }
  BEGIN                                            { starting programs which  }
    Ok := FALSE;                                   { use these routines.  Ok  }
    IF (DOSversion >= 3.0) THEN                    { will return FALSE if DOS }
      BEGIN                                        { version is less than 3.0 }
        StatReg.AH := FCarry;                      { or if PRINT has not been }
        StatReg.AL := $00;                         { installed.               }
        INTR($2F, StatReg);
        IF ((StatReg.FLAGS AND FCarry) <> FCarry) THEN
          Ok := (StatReg.AL = 255);
      END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE SpoolFile(FN : Str80; VAR Ok : BOOLEAN);
  TYPE                                              { Sends FN to PRINT spool }
    SubmitPacket = RECORD
                      LevCode : BYTE;     { LevCode is apparently meaningless }
                      FileOFS : INTEGER;  { but must be set to 0 and included }
                      FileSEG : INTEGER;  { in the Submit Packet anyway.      }
                    END;
  VAR
    SubPack : SubmitPacket;
    SpReg   : Registers;
  BEGIN
    FN := FN + #0;                      { File names must be in ASCIIZ format }
    WITH SubPack DO
      BEGIN
        LevCode := $00;
        FileSEG := SEG(FN[1]);
        FileOFS := OFS(FN[1]);
      END;
    WITH SpReg DO
      BEGIN
        AH := FCarry;
        AL := FCarry;
        DS := SEG(SubPack);
        DX := OFS(SubPack);
      END;
    INTR($2F, SpReg);
    Ok := ((SpReg.FLAGS AND FCarry) <> FCarry);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE Cancel(VAR Ok : BOOLEAN);    { Cancels all files from print spool }
  VAR
    SpReg : Registers;
  BEGIN
    SpReg.AH := FCarry;
    SpReg.AL := $03;
    INTR($2F, SpReg);
    Ok := ((SpReg.FLAGS AND FCarry) <> FCarry);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE DeleteFromSpool(FSpec : Str80; VAR Ok : BOOLEAN);
  VAR
    SpReg : Registers;             { Deletes all files that match FSpec from  }
  BEGIN                            { spool.  FSpec must be a full filespec    }
    FSpec := FSpec + #0;           { but DOS wildcard characters * and ? can  }
    WITH SpReg DO                  { be used.                                 }
      BEGIN
        AH := FCarry;
        AL := $02;
        DS := SEG(FSpec[1]);
        DX := OFS(FSpec[1]);
      END;
    INTR($2F, SpReg);
    Ok := (SpReg.FLAGS AND FCarry) <> FCarry;
  END;
  { ------------------------------------------------------------------------- }

TYPE                                               { Max Queue is 32 files    }
  SpList = ARRAY[1..32] OF ARRAY[1..64] OF CHAR;   { Name length is always 64 }

  PROCEDURE GetSpoolQue(VAR QBuf : SpList; VAR Ok : BOOLEAN);
  VAR
    SpReg : Registers;                             { MOVEs current queue from }
  BEGIN                                            { DS:SI to QBuf for return }
     SpReg.AH := FCarry;                           { to ListQue.              }
     SpReg.AL := $04;                                          { Access Queue }
     INTR($2F, SpReg);
     IF ((SpReg.FLAGS AND FCarry) <> FCarry) THEN
       BEGIN
         MOVE(MEM[SpReg.DS:SpReg.SI], MEM[SEG(QBuf[1]):OFS(QBuf[1])], 2048);
         Ok := TRUE;
       END
     ELSE Ok := FALSE;
     SpReg.AH := FCarry;
     SpReg.AL := $05;                                        { Unfreeze Queue }
     INTR($2F, SpReg);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE ListQue(VAR NumberOfFiles: BYTE);
  VAR
    Y, Entry, Loc : BYTE;
    QList         : SpList;
    SpoolOK       : BOOLEAN;
  BEGIN
    GetSpoolQue(QList, SpoolOK);
    Entry := 1;
    Y := 4;
    IF SpoolOK THEN            { Write memory contents only if queue is there }
      BEGIN
        HIGHVIDEO;
        GotoXY(2, 3);    WRITE('QUEUE');
        LOWVIDEO;
        WHILE (QList[Entry, 1] <> #0) AND (Entry < 33) DO
          BEGIN
            IF ((Entry MOD 17) = 0) THEN
              BEGIN
                WritePrompt(2, Y, 'More');
                FOR Y := 4 TO 19 DO ClrLn(1, Y);
                Y := 4;
              END;
            Loc := 1;
            GotoXY(2, Y);
            WHILE (QList[Entry, Loc] <> CHR(0)) AND (Loc < 65) DO
              BEGIN
                WRITE(QList[Entry, Loc]);
                Inc(Loc);
              END;
            Inc(Y);
            Inc(Entry);
          END;
        HIGHVIDEO;
        GotoXY(2, Y);    WRITE('END OF QUEUE');
        LOWVIDEO;
      END
    ELSE WritePrompt(2, 3, 'ERROR Reading Queue');
    NumberOfFiles := PRED(Entry);
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE Help;
  VAR
    Reply : CHAR;
  BEGIN
    WOpen(4);
    ClrScr;
    WRITELN;
    WRITELN(' Print - Enter file to spool.');
    WRITELN;
    WRITELN(' Cancel File - Delete specific files from');
    WRITELN('    spool.  DOS wildcard characters can be');
    WRITELN('    used.');
    WRITELN;
    WRITELN(' Cancel All - Cancel all files from spool.');
    WRITELN('    If printer is not on program may hang');
    WRITELN('    temporarily before displaying status.');
    WRITELN;
    WRITELN(' <Esc> - Exit to File Manager.');
    Reply := GetKey(#27, FALSE);
    WClose;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE ControlSpool;
  VAR
    Reply    : CHAR;
    FilSpec  : Str80;
    NumFiles : BYTE;
    SpOK     : BOOLEAN;
    NewScr   : BOOLEAN;
  BEGIN
    WOpen(1);
    NewScr := TRUE;
    CursorOn(FALSE);
    REPEAT
      IF NewScr THEN
        BEGIN
          ClrScr;
          ListQue(NumFiles);
          GotoXY(25, 22);
          WRITE('rint   Cancel File   Cancel All');
          HIGHVIDEO;
          GotoXY(24, 22);     WRITE('P');
          GotoXY(39, 22);     WRITE('F');
          GotoXY(53, 22);     WRITE('A');
          LOWVIDEO;
          GotoXY(70, 1);      WRITE(NumFiles:2, ' Files');
        END;
      Reply := GetKey(#0+#27+'PFA', TRUE);
      NewScr := FALSE;
      CASE Reply OF
        'P',
        'F' : BEGIN
                GotoXY(2, 2);   WRITE('File Spec:');
                FilSpec := '';
                ReadStr(13, 2, 64, FilSpec);
                CursorOn(FALSE);
                IF (FilSpec <> '') THEN
                  BEGIN
                    IF (POS('\', FilSpec) = 0) THEN             { Add PATH if }
                      FilSpec := CurrDir + FilSpec;             { not entered }
                    IF (Reply = 'P') THEN SpoolFile(FilSpec, SpOK)
                    ELSE DeleteFromSpool(FilSpec, SpOK);
                    IF (NOT SpOK) THEN
                      IF (Reply = 'P') THEN
                        WritePrompt(2, 2, 'ERROR Submitting File to Queue')
                      ELSE
                        WritePrompt(2, 2, 'Error Deleting File(s) From Queue');
                  END;
                NewScr := TRUE;
              END;
        'A' : BEGIN
                Cancel(SpOK);
                IF (NOT SpOK) THEN
                  WritePrompt(2, 2, 'ERROR Clearing Queue');
                NewScr := TRUE;
              END;
        F1 : Help;
      END;
    UNTIL (Reply = #27);
    WClose;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE EraseFile;
  VAR
    TempFPtr : FilePtr;
    Reply    : CHAR;
    FilVar   : FILE;
  BEGIN
    TempFPtr := FirstFile;
    HIGHVIDEO;
    ClrLn(2, 4);
    WRITE('Erase Marked File(s) From Disk (Y/N)? Y', ^H);
    LOWVIDEO;
    Reply := GetKey(#13+#27+'YN', TRUE);
    CursorOn(FALSE);
    IF (Reply = #13) THEN Reply := 'Y';
    ClrLn(2, 4);
    IF (Reply = 'Y') THEN
      WHILE (TempFPtr <> NIL) DO
        BEGIN
          IF (TempFPtr^.Mark) THEN
            BEGIN
              ASSIGN(FilVar, TempFPtr^.Key);
              GetFAttr(FilVar, Attribute);
              IF ((Attribute AND ReadOnly) <> 0) THEN
                WritePrompt(2, 4, TempFPtr^.Key + ' is Read-Only')
              ELSE
                BEGIN
                  ERASE(FilVar);
                  IF (IOResult <> 0) THEN
                    WritePrompt(2, 4, 'ERROR: Unable to Erase '
                      + TempFPtr^.Key);
                END;
            END;
          TempFPtr := TempFPtr^.Next;
        END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE RenameFile;
  VAR
    OldName, NewName : Str80;
    FilVar           : FILE;
  BEGIN
    OldName := CurrDir + CurrFile^.Key;
    NewName[0] := #0;
    ClrLn(2, 3);      WRITE('Old Spec:  ', OldName);
    GotoXY(2, 4);     WRITE('New Spec:');
    NewName := '';
    ReadStr(13, 4, 64, NewName);
    IF (NewName[0] <> #0) THEN
      BEGIN
        IF Exist(NewName) THEN WritePrompt(2, 4, 'File Already Exists')
        ELSE
          BEGIN
            ASSIGN(FilVar, OldName);
            GetFAttr(FilVar, Attribute);
            SetFAttr(FilVar, Archive);
            RENAME(FilVar, NewName);
            IF (IOResult = 0) THEN SetFAttr(FilVar, Attribute)
            ELSE WritePrompt(2, 4, 'ERROR: Unable to Rename File');
          END;
      END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE GetDestPath(VAR DPath : Str80);
  BEGIN
    GotoXY(2, 2);    WRITE('Curr Path:');
    ClrLn(2, 3);     WRITE('Dest Path:');
    DPath[0] := #0;
    ReadStr(13, 3, 52, DPath);
    CursorOn(FALSE);
    IF (DPath[0] <> #0) AND (DPath[LENGTH(DPath)] <> '\') THEN
        DPath := DPath + '\';
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE CopyFile;
  VAR
    TempFRec      : FilePtr;
    Source, Dest  : FILE;
    DestPath      : Str80;
    SourceName    : Str80;
    DestName      : Str80;
    RecsRead      : WORD;
    DestDrive     : WORD;
  BEGIN
    GetDestPath(DestPath);
    IF (DestPath[0] <> #0) THEN
      BEGIN
        IF (LENGTH(DestPath) > 1) AND (DestPath[2] = ':') THEN
          DestDrive := (ORD(UPCASE(DestPath[1])) - 64)
        ELSE DestDrive := 0;
        FileBufSize := SIZEOF(FileBufferType);          { Set Max FileBufSize }
        IF (MaxAvail < FileBufSize) THEN FileBufSize := MaxAvail;
        GETMEM(FileBuffer, FileBufSize);
        TempFRec := FirstFile;
        WHILE (TempFRec <> NIL) DO
          BEGIN
            IF (TempFRec^.Mark) THEN
              BEGIN
                SourceName := CurrDir + TempFRec^.Key;
                DestName := DestPath + TempFRec^.Key;
                IF Exist(DestName) THEN
                  WritePrompt(2, 4, DestName + ' Already Exists')
                ELSE
                  BEGIN
                    ASSIGN(Source, SourceName);
                    GetFAttr(Source, Attribute);
                    SetFAttr(Source, Archive);
                    IF DiskFull(SourceName, DestDrive) THEN
                      BEGIN
                        WritePrompt(2, 4, 'Disk Full');
                        TempFRec := LastFile;
                      END
                    ELSE
                      BEGIN
                        RESET(Source, 1);
                        ASSIGN(Dest, DestName);
                        REWRITE(Dest, 1);
                        IF (IOResult = 0) THEN
                          BEGIN
                            WHILE NOT EOF(Source) DO
                              BEGIN
                                BlockRead(Source, FileBuffer^, FileBufSize, RecsRead);
                                BlockWrite(Dest, FileBuffer^, RecsRead);
                              END;
                          END;
                        CLOSE(Source);
                        IF (IOResult = 0) THEN SetFAttr(Source, Attribute);
                        CLOSE(Dest);
                        IF (IOResult <> 0) THEN ;
                      END;
                  END;
              END;
            TempFRec := TempFRec^.Next;
          END;
        FREEMEM(FileBuffer, FileBufSize);
      END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE MoveFile;
  VAR
    TempFRec   : FilePtr;
    Source     : FILE;
    DestPath   : Str80;
    SourceName : Str80;
    DestName   : Str80;
  BEGIN
    GetDestPath(DestPath);
    IF (DestPath[0] <> #0) THEN
      BEGIN
        TempFRec := FirstFile;
        WHILE (TempFRec <> NIL) DO
          BEGIN
            IF (TempFRec^.Mark) THEN
              BEGIN
                SourceName := CurrDir + TempFRec^.Key;
                DestName := DestPath + TempFRec^.Key;
                IF Exist(DestName) THEN
                  WritePrompt(2, 4, DestName + ' Already Exists')
                ELSE
                  BEGIN
                    ASSIGN(Source, SourceName);
                    GetFAttr(Source, Attribute);
                    SetFAttr(Source, Archive);
                    RENAME(Source, DestName);
                    IF (IOResult <> 0) THEN
                      WritePrompt(2, 4, 'Unable to Move ' + SourceName)
                    ELSE SetFAttr(Source, Attribute);
                  END;
              END;
            TempFRec := TempFRec^.Next;
          END;
      END;
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE GetCurrDir;
  BEGIN
    GetDir(0, CurrDir);
    IF (CurrDir[LENGTH(CurrDir)] <> '\') THEN CurrDir := CurrDir + '\';
  END;
  { ------------------------------------------------------------------------- }

  PROCEDURE GetNewDirectory;
  VAR
    NewDir : Str80;
    Err    : BOOLEAN;
  BEGIN
    REPEAT
      Err := FALSE;
      NewDir[0] := #0;
      ReadStr(13, 2, 64, NewDir);
      IF (NewDir[0] <> #0) THEN
        BEGIN
          ChDir(NewDir);
          IF (IOResult = 0) THEN GetCurrDir
          ELSE
            BEGIN
              Err := TRUE;
              WritePrompt(13, 2, 'ERROR: Directory Not Found');
            END;
        END;
    UNTIL (NOT Err);
    GotoXY(13, 2);    WRITE(CurrDir);
  END;
  { ------------------------------------------------------------------------- }

BEGIN
  SpoolStat(SpoolOK);
  FirstFile := NIL;
  LastFile := NIL;
  CurrFile := NIL;
END.

