{CTYPETST.PAS}
{
Description:  Program for demonstrating the CType unit.

Author:       Eric Kammerer
Date:         11/23/87
Application:  IBM PC with Turbo Pascal 4.0
Copyright 1987, Eric Kammerer. All rights reserved.
}

PROGRAM Test_CType_Unit;

{------------------------------------- DIRECTIVES ---------------------}

{Global directives}

{$D+}                 {Generate debug information}
{$L+}                 {Enable link buffering}
{$N-}                 {No math coprocessor installed}
{$T+}                 {Generate a map file}
{$M 16384,0,655360}   {16K stack, 0..640K heap}

{Local Directives}

{$B-}   {Default to short-circuit boolean evaluation}
{$F-}   {Automatic choice of call model}
{$I+}   {Automatic I/O result checking}
{$R+}   {Generate range-check code}
{$S+}   {Generate stack-overflow-check code}
{$V+}   {Strict type checking of VAR-strings}

{------------------------------------- UNITS --------------------------}

USES

    CRT,
    CType;


{------------------------------------- COPYRIGHT ----------------------}

CONST

    Copyright = '(C)Copyright 1987 by Eric Kammerer';


{------------------------------------- VAR ----------------------------}

VAR

    PressedKey                         {Key pressed by user}
                : CHAR;
{------------------------------------- CONST --------------------------}

CONST

    EscapeKey = #27;
    ExtendedKeyIndicator = #0;

{----------------------------------------------------------------------}

BEGIN

    REPEAT
        PressedKey := ReadKey;
        ClrScr;
        GoToXY (1,5);
        Write ('Character Number:',Ord(PressedKey):4);
        GoToXy (1,10);
        Write ('Classifications:');
        GoToXY (1,12);
        IF IsAlnum (PressedKey) THEN
            Write(' Alphanumeric');
        IF IsAlpha (PressedKey) THEN
            Write(' Alphabetic');
        IF IsAscii (PressedKey) THEN
            Write(' ASCII');
        IF IsCntrl (PressedKey) THEN
            Write(' Control Character');
        IF IsDigit (PressedKey) THEN
            Write(' Digit');
        IF IsGraph (PressedKey) THEN
            Write(' Graphic');
        IF IsLower (PressedKey) THEN
            Write(' Lowercase');
        IF IsPrint (PressedKey) THEN
            Write(' Printing character');
        IF IsPunct (PressedKey) THEN
            Write(' Punctuation');
        IF IsSpace (PressedKey) THEN
            Write(' Space');
        IF IsUpper (PressedKey) THEN
            Write(' UpperCase');
        IF IsXDigit (PressedKey) THEN
            Write(' Hexadecimal Digit');
        Write ('.');
        IF PressedKey = ExtendedKeyIndicator THEN
            Delay(1000);
    UNTIL PressedKey = EscapeKey;

END.
