{ Facilis 0.20                                   file: BLOCK.PAS      }

overlay procedure blockov(fsys: symset; isfun: boolean; level: integer);

type   item = record
                typ: types; ref: index; temp: boolean
              end;
     conrec = record case tp: types of
                       ints,chars,bools: (i:integer);
                       reals: (r: real)
                     end ;

var    dx : integer;    { data allocation index }
       prt: integer;    { t-index of this procedure }
       prb: integer;    { b-index of this procedure }
       x  : integer;

  procedure skip(fsys: symset; n: integer);

  begin
    error(n); skipflag := true;
    while not (sy in fsys) do insymbol;
    if skipflag then endskip
  end  { skip } ;

  procedure test(s1,s2: symset; n: integer);

  begin
    if not (sy in s1) then skip(s1+s2,n)
  end  {test } ;

  procedure testsemicolon;

  begin
    if sy = semicolon
    then insymbol
    else begin
      error(14);
      if sy in [comma,colon] then insymbol
    end ;
    test([ident]+blockbegsys, fsys, 6)
  end  { testsemicolon } ;

  procedure enter(id: alfa; k:object);

  var    j,l: integer;
  begin
    if t = tmax
    then fatal(1)
    else begin
      tab[0].name := id;
      j := btab[display[level]].last;  l := j;
      while tab[j].name <> id do  j := tab[j].link;
      if j <> 0
      then error(1)
      else begin
        t := t+1;
        with tab[t] do
        begin
          name:= id;   link := l;
          obj := k;     typ := notyp;   ref := 0;
          lev := level; adr := 0
        end ;
        btab[display[level]].last := t
      end
    end
  end  { enter } ;

  function loc(id: alfa): integer;

  var    i,j: integer;      { locate id in tabel }
  begin
    i := level; tab[0].name := id;    { sentinel }
    repeat
      j := btab[display[i]].last;
      while tab[j].name <> id do  j := tab[j].link;
      i := i-1;
    until (i<0) or (j<>0);
    if j = 0 then error(0);
    loc := j
  end  { loc } ;

  procedure entervariable;

  begin
    if sy = ident
    then begin
      enter(id,vvariable); insymbol
    end else error(2)
  end  { entervariable } ;

  procedure constant(fsys: symset; var c: conrec);

  var    x, sign: integer;
  begin
    c.tp := notyp; c.i := 0;
    test(constbegsys, fsys, 50);
    if sy in constbegsys
    then begin
      if sy = charcon
      then begin
        c.tp := chars; c.i := inum;
        insymbol
      end else
      if sy = stringcon
      then begin
        c.tp := strngs;
        c.i := seg(spnt^);
        insymbol
      end else begin
        sign := 0;
        if sy in [plus,minus]
        then begin
          if sy = minus then sign := -1 else sign := 1;
          insymbol
        end ;
        if sy = ident
        then begin
          x := loc(id);
          if x <> 0
          then if tab[x].obj <> konstant
               then error(25)
               else begin
                 c.tp := tab[x].typ;
                 if c.tp in [ints,reals] then
                   if sign=0 then sign := 1;
                 if c.tp = reals
                 then c.r := sign*rconst[tab[x].adr]
                 else if c.tp = ints
                 then c.i := sign*tab[x].adr
                 else begin
                   if sign<>0 then error(33);
                   c.i := tab[x].adr
                 end
               end ;
          insymbol
        end else begin
          if sign=0 then sign := 1;
          if sy = intcon
            then begin
              c.tp := ints; c.i := sign*inum;
              insymbol
            end else if sy = realcon
                     then begin
                       c.tp := reals; c.r := sign*rnum;
                       insymbol
                     end else skip(fsys,50)
        end
      end;
      test(fsys,[], 6)
    end
  end  { constant } ;

  procedure typ(fsys: symset; var tp: types; var rf, sz: integer);

  var    eltp: types;
         elrf,elsz,offset,x,t0,t1: integer;
        dummy: conrec;

    procedure arraytyp(var aref,arsz: integer);

    var    eltp: types;
           low, high: conrec;
           elrf, elsz: integer;
    begin
      constant([twodots,rbrack,rparent,ofsy]+fsys, low);
      if low.tp in [reals,strngs]
      then  begin
        error(27);
        low.tp := ints; low.i := 0
      end ;
      if sy = twodots then insymbol else error(13);
      constant([rbrack,comma,rparent,ofsy]+fsys, high);
      if high.tp <> low.tp
      then begin
        error(27); high.i := low.i
      end ;
      enterarray(low.tp, low.i,high.i);
      aref := a;
      if sy = comma
      then begin
        insymbol;
        eltp := arrays;
        arraytyp(elrf,elsz)
      end else begin
        if sy = rbrack
        then insymbol
        else begin
          error(12);
          if sy = rparent then insymbol
        end ;
        if sy = ofsy then insymbol else error(8);
        typ(fsys,eltp,elrf,elsz)
      end ;

      with atab[aref] do
      begin
        arsz := (high-low+1)*elsz; size := arsz;
        if arsz > stacksize then error(61);
        eltyp := eltp; elref := elrf; elsize := elsz
      end ;
    end  {arraytyp } ;

  begin  { typ }
    tp := notyp; rf := 0; sz := 0;
    test(typebegsys,fsys, 10);
    if sy in typebegsys
    then begin
      if sy = ident
      then begin
        x := loc(id);
        if x <> 0
        then with tab[x] do
               if obj <> type1
               then error(29)
               else begin
                 tp := typ; rf := ref; sz := adr;
                 if tp = notyp then error(30)
               end ;
        insymbol;
        if (tp=strngs) and (sy=lbrack)
        then begin
          insymbol;
          constant([rbrack]+fsys,dummy);
          if sy=rbrack then insymbol else error(12);
        end;
      end else if sy = arraysy
               then begin
                 insymbol;
                 if sy = lbrack
                 then insymbol
                 else begin
                   error(11);
                   if sy = lparent
                   then insymbol
                 end ;
                 tp := arrays; arraytyp(rf,sz)
               end else begin  { records }
                 insymbol;
                 enterblock;
                 tp := records; rf := b;
                 if level = lmax then fatal(5);
                 level := level+1; display[level] := b; offset := 0;
                 while not (sy in fsys-[semicolon,comma,ident]+[endsy]) do
                 begin  { field section }
                   if sy = ident
                   then begin
                     t0 := t; entervariable;
                     while sy = comma do
                     begin
                       insymbol; entervariable;
                     end ;
                     if sy = colon then insymbol else error(5);
                     t1 := t;
                     typ(fsys+[semicolon,endsy,comma,ident],eltp,elrf,elsz);
                     while t0 < t1 do
                     begin
                       t0 := t0+1;
                       with tab[t0] do
                       begin
                         typ := eltp;
                         ref := elrf;   normal := true;
                         adr := offset; offset := offset + elsz
                       end
                     end
                   end ; {sy = ident}
                   if sy <> endsy
                   then begin
                     if sy = semicolon
                     then insymbol
                     else begin
                       error(14);
                       if sy = comma then insymbol
                     end ;
                     test([ident,endsy,semicolon], fsys, 6)
                   end
                 end ; {field section}

                 btab[rf].vsize := offset; sz := offset;
                 if sz > stacksize then error(61);
                 btab[rf].psize := 0;
                 insymbol; level := level-1
               end ; {records}
      test(fsys, [], 6)
    end
  end  { typ } ;

  procedure parameterlist;      { formal parameter list }

  var    tp    : types;
         valpar: boolean;
         rf,sz, x, t0: integer;
  begin
    insymbol;
    tp := notyp; rf := 0; sz := 0;
    test([ident, varsy], fsys+[rparent], 7);
    while sy in [ident, varsy] do
    begin
      if sy <> varsy
      then valpar := true
      else begin
        insymbol;
        valpar := false
      end ;
      t0 := t; entervariable;
      while sy = comma do
      begin
        insymbol; entervariable;
      end;
      if sy = colon
      then begin
        insymbol;
        if sy <> ident
        then error(2)
        else begin
          x := loc(id); insymbol;
          if x <> 0
          then with tab[x] do
               if obj <> type1
               then error(29)
               else begin
                 tp := typ;   rf := ref;
                 if valpar then sz := adr else sz := 1
               end ;
          end ;
        test([semicolon,rparent], [comma,ident]+fsys, 14)
      end else error(5);
      while t0 < t do
      begin
        t0 := t0+1;
        with tab[t0] do
        begin
          typ := tp; ref := rf;
          adr := dx; lev := level;
          normal := valpar;
          dx := dx + sz
        end
      end ;
      if sy <> rparent
      then begin
        if sy = semicolon
        then insymbol
        else begin
          error(14);
          if sy = comma then insymbol
        end ;
        test([ident,varsy], [rparent]+fsys, 6)
      end
    end  { while } ;

    if sy = rparent
    then begin
      insymbol;
      test([semicolon,colon], fsys, 6)
    end else error(4)
  end  { parameterlist } ;

  procedure     constdec;

  var    c: conrec;
  begin
    insymbol;
    test([ident], blockbegsys, 2);
    while sy = ident do
    begin
      enter(id,konstant); insymbol;
      if sy = eql
      then insymbol
      else begin
        error(16);
        if sy = becomes then insymbol
      end ;
      constant([semicolon,comma,ident]+fsys,c);
      tab[t].typ := c.tp;
      tab[t].ref := 0;
      if c.tp = reals
      then begin
        enterreal(c.r); tab[t].adr := c1
      end else tab[t].adr := c.i;
      testsemicolon
    end
  end  { constdec } ;

  procedure typedeclaration;

  var    tp: types;
         rf, sz, t1: integer;
  begin
    insymbol;
    test([ident], blockbegsys, 2);
    while sy = ident do
    begin
      enter(id,type1);
      t1 := t; insymbol;
      if sy = eql
      then insymbol
      else begin
        error(16);
        if sy = becomes then insymbol
      end ;
      typ([semicolon,comma,ident]+fsys, tp, rf, sz);
      with tab[t1] do
      begin
        typ := tp; ref := rf; adr := sz
      end;
      testsemicolon
    end
  end  { typedeclaration } ;

  procedure variabledeclaration;

  var    tp: types;
         t0, t1, rf, sz: integer;
  begin
    insymbol;
    while sy = ident do
    begin
      t0 := t; entervariable;
      while sy = comma do
      begin
        insymbol; entervariable;
      end ;
      if sy = colon then insymbol else error(5);
      t1 := t;
      typ([semicolon,comma,ident]+fsys, tp, rf, sz);
      while t0 < t1 do
      begin
        t0 := t0+1;
        with tab[t0] do
        begin
          typ := tp;    ref := rf;
          lev := level; adr := dx;
          normal := true;
          dx := dx + sz
        end
      end ;
      testsemicolon
    end
  end  { variabledeclaration } ;

  procedure procdeclaration;

  var    isfun: boolean;
  begin
    isfun := sy = funcsy;
    insymbol;
    if sy <> ident
    then begin
      error(2); id := '          '
    end;
    if isfun then enter(id,funktion) else enter(id,prozedure);
    tab[t].normal := true;
    insymbol;
    block([semicolon]+fsys, isfun, level+1);
    if sy = semicolon then insymbol else error(14);
    emit(132+ord(isfun))     { exit }
  end  { procdeclaration } ;

  procedure statement(fsys: symset);

  var    i: integer;
         x: item;

    procedure expression(fsys: symset; var x: item); forward;

    procedure selector(fsys: symset; var v: item);

    var    x: item;
           a,j: integer;
    begin  { sy in [lparent, lbrack, period] }
      repeat
        if sy = period
        then begin
          insymbol;   { field selector }
          if sy <> ident
          then error(2)
          else begin
            if v.typ <> records
            then error(31)
            else begin  {search field identifier }
              j := btab[v.ref].last;
              tab[0].name := id;
              while tab[j].name <> id do j := tab[j].link;
              if j = 0 then error(0);
              v.typ := tab[j].typ;
              v.ref := tab[j].ref;
              a := tab[j].adr;
              if a <> 0 then emit1(9,a)
            end ;
            insymbol
          end
        end else begin  { array selector }
          if sy <> lbrack then error(11);
          if v.typ=strngs then begin
            insymbol;
            expression(fsys+[rbrack],x);
            if x.typ<>ints then error(34) else emit(165);
            v.typ := chars
          end else
          repeat
            insymbol;
            expression(fsys+[comma,rbrack], x);
            if v.typ <> arrays
            then error(28)
            else begin
              a := v.ref;
              if atab[a].inxtyp <> x.typ
              then error(26)
              else if atab[a].elsize = 1
                   then emit1(20,a)
                   else emit1(21,a);
              v.typ := atab[a].eltyp;
              v.ref := atab[a].elref
            end
          until sy <> comma;

          if sy = rbrack
          then insymbol
          else begin
            error(12);
            if sy = rparent then insymbol
          end
        end
      until not (sy in [lbrack,lparent,period]);

      test (fsys, [], 6)
    end  { selector } ;

    procedure call(fsys: symset; i: integer);

    var    x: item;
           lastp, cp, k: integer;

    begin
      emit1(18,i);   { mark stack }
      lastp := btab[tab[i].ref].lastpar;
      cp := i;
      if sy = lparent
      then begin  { actual parameter list }
        repeat
          insymbol;
          if cp >= lastp
          then error(39)
          else begin
            cp := cp+1;
            if tab[cp].normal
            then begin  {value parameter }
              expression(fsys+[comma,colon,rparent], x);
              if x.typ=tab[cp].typ
              then begin
                if x.ref <> tab[cp].ref
                then error(36)
                else if x.typ = arrays
                     then emit1(22,atab[x.ref].size)
                else if x.typ = records
                     then emit1(22,btab[x.ref].vsize)
                else if x.typ = strngs
                     then if x.temp then emit(173)
                                    else emit(172)
              end else if (x.typ=ints) and (tab[cp].typ=reals)
                       then emit1(26,0)
                       else if x.typ<>notyp then error(36);
            end else begin  { var parameter }
              if sy <> ident
              then error(2)
              else begin
                k := loc(id);
                insymbol;
                if k <> 0
                then begin
                  if tab[k].obj <> vvariable then error(37);
                  x.typ := tab[k].typ;
                  x.ref := tab[k].ref;
                  if tab[k].normal
                  then emit2(0,tab[k].lev,tab[k].adr)
                  else emit2(1,tab[k].lev,tab[k].adr);
                  if sy in [lbrack,lparent,period]
                  then begin
                    if x.typ=strngs then error(60);
                    selector(fsys+[comma,colon,rparent], x);
                  end;
                  if (x.typ<>tab[cp].typ) or (x.ref<>tab[cp].ref)
                  then error(36)
                end
              end
            end {var parameter}
          end ;
          test([comma,rparent], fsys, 6)
        until sy <> comma;

        if sy = rparent then insymbol else error(4)
      end ;

      if cp < lastp then error(39);  { too few actual parameters }
      emit1(19, btab[tab[i].ref].psize-1);
      if tab[i].lev < level then emit2(3, tab[i].lev, level)
    end  { call } ;

    function resulttype(a,b: types): types;

    begin
      if (a>reals) or (b>reals)
      then begin
        error(33);
        resulttype := notyp
      end else if (a=notyp) or (b=notyp)
               then resulttype := notyp
               else if a=ints
                    then if b=ints
                         then resulttype := ints
                         else begin
                           resulttype := reals; emit1(26,1)
                         end
                    else begin
                      resulttype := reals;
                      if b=ints then emit1(26,0)
                    end
    end   { resulttype } ;

    procedure expression {fsys:symset; var x:item};

    var    y :item;
           op:symbol;
           t :integer;

      procedure simpleexpression(fsys:symset; var x:item);

      var    y :item;
             op:symbol;
             t :integer;

        procedure term(fsys:symset; var x:item);

        var    y :item;
               op:symbol;
               ts:typset;

          procedure factor(fsys:symset; var x:item);

          var    i,f: integer;

            procedure standfct(n: integer);

            var    ts: typset;

            begin { standard function no. n }
            if n=19
            then emit1(8,n)
            else begin
              if sy = lparent
              then insymbol
              else error(9);
              if (n < 17) or (n > 19)
              then begin
                expression(fsys+[comma,rparent],x);

                case n of

 { abs,sqr }    0,2: begin
                       ts := [ints,reals];
                       tab[i].typ := x.typ;
                       if x.typ = reals then n := n+1
                     end;

 { odd,chr }    4,5: ts := [ints];

 { ord }          6: ts := [ints,bools,chars];

 { succ,pred }  7,8: begin
                       ts := [ints,bools,chars];
                       tab[i].typ := x.typ
                     end;

 { round,trunc } 9,10,11,12,13,14,15,16:
 { sin,cos,... }     begin
                       ts := [ints,reals];
                       if x.typ = ints then emit1(26,0)
                     end;

 { length }      20: begin
                       ts := [strngs,chars];
                       if x.temp then n := n+1;
                       if x.typ = chars then n := n+2
                     end;

 { copy }        23: begin
                       ts := [strngs,chars];
                       if x.typ = chars then n := n+2
                         else if x.temp then n := n+1;
                       test([comma], [comma,rparent]+fsys, 59);
                       if sy = comma then begin
                         insymbol;
                         expression(fsys+[comma,rparent],y);
                         if y.typ <> ints
                           then if y.typ <> notyp then error(34);
                         test([comma,rparent], fsys, 6);
                         if sy = comma then begin
                           insymbol;
                           expression(fsys+[rparent],y);
                           if y.typ <> ints
                             then if y.typ <> notyp then error(34);
                         end else emit1(24,nmax);
                       end;
                     end;

{ pos }          26: begin
                       ts := [strngs,chars];
                       if x.typ = chars then n := n+2
                         else if x.temp then n := n+1;
                       test([comma], [comma]+fsys, 59);
                       if sy = comma then begin
                         insymbol;
                         expression(fsys+[rparent],y);
                         if y.typ <> strngs
                         then if y.typ <> notyp then error(38) else
                         else if y.temp then n := n+4;
                       end
                     end;

{ str }          33: begin
                       ts := [ints,reals];
                       if x.typ = reals then n := n+1
                     end;

{ val,rval }  35,37: begin
                       ts := [strngs];
                       if x.temp then n := n+1
                     end;

                end ; { case }

                if x.typ in ts
                then emit1(8,n)
                else if x.typ <> notyp
                     then error(48);
              end else begin    { n in [17,18] }
                if sy <> ident
                then error(2)
                else if id <> 'input     '
                     then error(0)
                     else insymbol;
                emit1(8,n);
              end ;
              x.typ := tab[i].typ; x.temp := true;
              if sy = rparent then insymbol else error(4)
            end end { standfct } ;

          begin  { factor }
            x.typ := notyp;
            x.ref := 0;
            test(facbegsys, fsys, 58);
            while sy in facbegsys do begin
            case sy of
       ident: begin
                i := loc(id);
                insymbol;
                with tab[i] do

                  case obj Of

          jNNstant: begij
                      x.typ := typ;
                      x.ref := 0; x.temp := false;
                      if x.typ = reals
                      then emit1(25,adr)
                      else emit1(24,adr)
                    end ;

         vvariable: begin
                      x.typ := typ;
                      x.ref := ref; x.temp := false;
                      if sy in [lbrack,lp%XX[PS %XX[PS %."MMX][YZ&. QS % % % % % % %Uvn3&V E&8uC ] Uvn3&V E&8rw	C ] Uvnǎ&F E&C] &CGZ^++;&,r&CCGGVRRVPAUv
;vwvN
, r3] U^Ӌ^~
vn&F E<
t<t
&C32ڋ+щ]
     ]   ]  ]^.FFU+r;.,wVA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         BW J16.PAS                                                                                                                                                                                    @ @            `  t 5  `@               5  `   AND       ARRAY     A~        BEGIN     BOOLEAN   CASE      CHAR      CHR       CONST     DO        DOWNTO    ELSE      END       FOR       FUNCTION  GOTO      IF        IN        INTEGER   MOD       NOT       OF        OR        ORD       PRED      PROCEDURE READ      READLN    REPEAT    STRING    SUCC      TEXT      THEN      TO        TYPE      UNTIL     VAR       WHILE     WRITE     WRITELN   ~~~        #>	
< =!!/;
""     
    )  ) ) )     )     $ % & ) ) )                                            	               
   
                                  	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~	 fBW nulf.pas                                                           BW miso.pas                     >`  @pcode out of range error 
                       ~             0                       0      0          
WRITELN    
OUTPUT     
READLN     
INPUT                   'error writing code file; is disk full? 
TRUE       
FALSE       &             Visible-Pascal [Compiler] (         Copyright 1984, William Hapgood )         10 Sycamore Rd. Wayland MA 01778 TRUE FALSE$scratch space for run-time routines! 
INPUT      
OUTPUT     
CON        
PRN        
ASSIGN     
RESET      
REWRITE    
EOF        
EOLN       
CLOSE      
DRAW       
ODD        
KEYPRESSED 
INKEY      
LENGTH     
POS        
SETMODE    
PALETTE    
BACKGROUND 
TEXTTYPE   
TEXTCOLOR  
TEXTBACKGR 
CLS        
CURSOR     
BORDER     
CONCAT     
COPY       
DELETE     
INSERT     
TONE       
PROGRAM         No errors found.   error(s) in program. compiler cannot continue.              reen (to see the lines
of the program as they execute) or with the program output on the screen. You
can switch screens (with the 'S' command) to the screen you want, then single
step with <space>. Switch screens any time you like.

If you single step at a line with a READ or READLN statement, then if the
debugger is showing, you will be clearly told that the program is asking for
input, and you will be prompted to type it in. Single step the program WORDS
to see this in action. If the program output is on the screen, then your
program should prompt you for some input, and as you press <space>, you will
see the cursor move to the right for each space. This is the time to type in
the information your program is expecting.  Try this with the WORDS program,
too.


        N = Next line down.

The Next line command is a short-cut. If you are stepping through some
statements and you don't want to follow a procedure call statement into a new
procedure, but want to go to the next line in the procedure you are in, then
press 'N' instead of <space>.  'N' will also complete statements like:

        FOR COUNT := 1 TO 5 DO WRITELN('something');

in one operation, whereas <space> would stop once for each time the WRITELN is
executed.  Therefore, use 'N' to go to the Next program line after the current
one, no matter what the current line is.


        W = watch the program execute slowly.

Watching a program means to execute each statement at a rate of about 1
statement per second, showing you the result on either the debugger or the
program screen.  It is good for either automatically showing you the progress
of the program, or just to run a program in super-slo-mo. You can stop the
program anytime with Ctrl-Break, as always.


        S = Switch to/from program screen.

'S' switches between the debugger screen and the program output screen. It is
a good habit to form to switch screens as a program runs, so you can see what
it is producing. When you are watching the debugger, all the output from the
program is captured and saved until you switch to the program screen; then all
the saved output is sent to the screen rapidly. It is possible to save more
information than will fit in memory, in which case some program output will be
lost. This won't happen if you occasionally switch screens as you debug the
program (and in any event, you usually have room for several screens full of
output in the buffer).


        Ins = set, Del = clear the checkpoint.

You can set a checkpoint on a program line, which will cause the program to
stop and return to the debugger screen when that line is executed. It is used
when you want the program to execute at full speed up to a point which you
want to examine in greater detail (by single stepping, etc). To do this, just
use the cursor keys (up and down arrow, PgUp/PgDn, etc) to move the brackets






< >  in the left margin of the listing to the line where you want the program
to stop. Then press Ins to insert the checkpoint there. A '!' will appear
inside the brackets:  <!>.  There is only one checkpoint at a time, so any
previous one set will be cleared.  If you want to clear the checkpoint without
setting one, press Del at any time.  After setting a checkpoint, you can
return to the current line by pressing Home. Now if you RUN  or WATCH the
program, it will stop at the checkpoint line.  Of course, if the program never
executes the line with the checkpoint, then it won't stop there!

Hint: If you put a checkpoint on the last line in the listing, the program
will stop after it is done, allowing you to check the final program screen and
any interesting program variables.


        Cursor control keys.

To look around in the program and read the listing, or to inspect variables,
or to insert a checkpoint, you can use the cursor control keys that cause up
and down motion: up and down arrow, PgUp, PgDn, Ctrl-PgUp, Ctrl-PgDn, and
Home. They have the same meaning as in the editor, except that Home returns
you to the current line that is ready to execute. The left and right motion
keys don't do anything; if a long program line is partly off screen right,
there is no way to read the rest of it while in the debugger (although you can
return to the editor to do so).  If the program is very large, the longer
lines in the listing may be abbreviated to save memory for the program.


        Q = Quit, E = Edit : leaving the debugger.

If your program executes correctly and completely, it will end and the
debugger will exit, like any program would. But you can stop the debugger in
two other ways: 'Q' just stops, so you can do something else, or perhaps
re-run the program from the beginning;  and 'E' goes directly to the editor,
and in fact directly to the line you are on, so you can fix the program and
re-run it. During the development of a program, you will find it convenient to
run, trace, or step the program until an error becomes apparent, then use 'E'
to exit directly to the editor, fix the error, and then select 'R' = RUN from
the filing system menu in the editor to re-run the program.  You can repeat
the edit & run process quickly and easily until your program is perfect!




                SUMMARY OF DEBUGGER COMMANDS


        R               Run program until <Break> or checkpoint;
        <space>         Run 1 statement and stop;
        N               run to the Next lower line and stop;
        W               Watch the program run slowly;
        S               Switch between debugger and program
                         screen;
        Ins,Del         Insert and Delete the checkpoint;
        E               go directly to the Editor;
        Q               Quit the debugger, return to DOS;
        up/down arrow
        PgUp/PgDn
        Ctrl-PgUp/PgDn  look around in listing; move < > for
                         setting the checkpoint <!>.











                CHAPTER 8: VISIBLE-PASCAL SYNTAX



This chapter is to help you understand the limitations and special features of
Visible-Pascal; it isn't a complete Pascal manual or study course.
Visible-Pascal is a special version of Pascal, with the purpose of giving the
first-time Pascal programmer an easy time writing and programming his or her
first programs. Therefore, an easy editor, fast and automatic program
execution and running, and a full symbolic debugger with the program operation
and variable values easily visible have been supplied at the expense of other
possible programming features.  For example, Visible-Pascal is not a complete
implementation of Pascal; it does not generate programs that run as fast as
possible; and it does not include such advanced features as low level machine
access and modular program construction and linking. It is an adequate
language to allow the writing of interesting and significant programs,
however.  Disk files can be read and written; strings are included; and the
various screen modes possible on the IBM-PC can be used, including the drawing
of graphics in color. All these features are fully supported by the debugger.
This chapter will describe some of the significant features of Visible-Pascal;
the supplied demonstration programs also have useful examples of various
features.




                Pascal Language Features Included & Excluded


Visible-Pascal includes the following data types:

        INTEGER         1, 32000, -55
        BOOLEAN         TRUE, FALSE
        CHAR            'a', CHR(65)
        STRING          'this is a string'
        Enumerated     (MONDAY,TUESDAY,WEDNESDAY,THURSDAY,FRIDAY)
        TEXT files with integer, boolean, character, or string
components

Missing is the real data type. Variables can be both global and local; types
can be declared in a TYPE section, and used in variable declarations or in
parameter lists.

Single-dimensioned arrays with positive indexes are included:

        ARRAY[1..10] OF INTEGER
        ARRAY[1..100] OF CHAR
        ARRAY[1..1000] OF BOOLEAN

Four text files are pre-declared:

        INPUT   = standard keyboard input, redirectable
        OUTPUT  = standard screen output, also redirectable
        CON     = screen output, not redirectable
        PRN     = printer output







Re-entrant use of procedure and functions is OK, but they cannot be declared
FORWARD nor are local procedures allowed. Full parameter passing is allowed,
by value or by address (VAR - parameters).

These Pascal control statement types are included:

        IF...THEN...
        IF...THEN...ELSE...
        REPEAT...UNTIL...
        WHILE...DO...
        FOR...TO/DOWNTO...DO...
        CASE...OF......END

But the GOTO statement is specifically excluded, as encouraging bad habits!

Set constants are included, so you can write:

        IF X IN ['A'..'Z'] THEN...

but set variables are not included.

Records, pointers, and dynamic memory allocation are not included.

The following string procedures and functions are built-in:

        CHR(int)                returns character value of int
        ORD(ch)                 returns integer value of char. ch
        LENGTH(str):INTEGER     returns the length of str
        POS(str1,str2):INTEGER  returns the position of str2 in
                                 str1
        CONCAT(str1,str2)       concatenates str2 to str1
        COPY(str1,str2,pos,cnt) copies str2[pos]..str2[pos+cnt]
                                 to str1
        DELETE(str,pos,num)     deletes num chars at str[pos]
        INSERT(str1,pos,str2)   inserts str2 at str1[pos]

All strings have a maximum length of 80 characters, and a dynamic length of 0
to 80 which is stored as element 0. Thus, to set the length of S, do:

        S[0] := CHR(LEN);       if LEN is the length to set S to.


The following additional routines can be used for direct keyboard input:

        KEYPRESSED:BOOLEAN      is true if a key was pressed and
                                 its value is waiting in the
                                 keyboard buffer
        INKEY:CHAR              function returning the next key
                                 from keyboard.
                                Returns keys immediately, without
                                 waiting for
                                CR; also returns extended
                                 (double) codes for function keys
                                 and other special cases.

The following routines are supplied to control the screen:

        CLS                     clears the screen, homes the
                                 cursor
        CURSOR(X,Y)             sets cursor position. upper left






                                 = 0,0
        SETMODE(M)              sets screen mode to one of the
                                 following:
                                0 = black&white, 40 columns;
                                1 = color,       40 columns;
                                2 = black&white, 80 columns;
                                3 = color,       80 columns;
                                4 = 320x200 color graphics
                                5 = 320x200 black&white graphics
                                6 = 640x200 black&white graphics
                                7 = monochrome display adapter
        TEXTTYPE(T)             sets all characters following to
                                 attribute:
                                0 = normal white on black;
                                1 = bold intensity
                                4 = underlined (monochrome
                                    adapter only)
                                5 = blinking
                                7 = reverse video
                                8 = invisible
        TEXTCOLOR(C)            sets following characters to
                                 color:
                                0 = black
                                1 = blue
                                2 = green
                                3 = cyan
                                4 = red
                                5 = magenta
                                6 = yellow
                                7 = white
        TEXTBACKGR(C)           sets the background color as
                                 above
        BORDER(C)               sets the border color to colors
                                 0..7, or
                                to colors 8..15 which are light
                                 versions
        PALETTE(X)              Graphics only, selects palette 0
                                 or 1
        BACKGROUND(X)           graphics only, selects color
                                 0..15 as background

This routine is supplied for sound production:

        TONE(NOTE,DURATION)     makes a NOTE of DURATION msec.
                                NOTE is 1..15.

This routine is supplied to draw graphics on the screen:

        DRAW(X1,Y1,X2,Y2,COLOR) draws a line from x1,y1 to x2,y2
                                in COLOR



















                An Outline of a Visible-Pascal Program


The following model program will show some of the basic structural parts of a
Visible-Pascal program.


PROGRAM DEMO;           {no program parameters are needed}

CONST                   (* this is an alternative comment form *)
  INTCONST = 1;
  BOOLCONST = TRUE;
  CHARCONST = 'x';
  CHARCONST2 = "y";     {either ' or " can be used for quotes}
  STRINGCONST = 'this is a string constant';

TYPE
  ATYPE = ARRAY[1..100] OF INTEGER;     {only positive indexes}

VAR
  A,B,C : INTEGER;      {you can do multiple definitions, but}
  D     : ATYPE;                {it's not neat}
  S1    : STRING;
  F1    : TEXT;         {the file type declaration}


PROCEDURE COUNTEMUP(INVAL:INTEGER;
                    VAR OUT:INTEGER);
{note value parameter for input and VAR parameter for output}
VAR             {note local variable with same name as global}
  D : BOOLEAN;
BEGIN
  D := INVAL > 6;
  IF D THEN OUT := 12 ELSE OUT := INVAL;
END;

FUNCTION ANOTHER:INTEGER;       {a function returning an integer}
BEGIN
  ANOTHER := ORD(INKEY);        {built-in proc., gives next key}
END;                            { from keyboard (a char) }


BEGIN                   {this is the start of the program itself}
  A := 1;
  B := 2;
  COUNTEMUP(A+B, C);    {note expression for the value parameter}
  WRITELN(C);
  A := ANOTHER;
  COUNTEMUP(A+C, C);
  WRITELN(C);
  WRITELN('all done now');
  WRITELN("that's all, folks!");        {note use of  '  or "  }
END.










                Syntax of Visible-Pascal


Identifiers in Visible-Pascal consist of the normal alphanumeric characters,
plus the underline character _ which is legal inside identifiers for improved
readability. Identifiers can be any length, but must differ from other
identifiers in the program in the first 10 characters. Numbers are normal
decimal numbers or hexadecimal numbers which are formed by using the dollar
sign as a prefix:  $F000 for example.  Comments are formed by pairs of braces
{...}  or these alternates:  (* ... *).  You can put one kind of comment
around text that includes the other kind.  String quotes can be put in either
single or double quotes (' or "), and the alternate type of quote can be
included in the string (see the last statement of the example above). The
editor automatically capitalizes characters typed except when they are within
single or double quotes or comment braces. Note that the alternate comment
form (* ... *) does not affect capitalization; for neat programs, use the {
... } form for normal comments, and the alternate form to 'comment out' a
procedure or region of the program temporarily.

A Visible-Pascal program consists of a PROGRAM statement, a declarations
section which consists of any number of CONST, TYPE, and VAR sections,
followed by any number of PROCEDUREs or FUNCTIONs, followed by the main
program part: a BEGIN ... END block, finally ended with a period. There are no
compiler directives, pseudo-comments, or other complications.

A PROCEDURE or FUNCTION consists of the heading, including an optional
parameter list, and, in the case of a function, a return type, followed by a
declarations section and a BEGIN ... END block finally ended with a semicolon.
Procedures cannot be nested inside other procedures. Function return values
must be simple types: INTEGER, CHAR, BOOLEAN, or enumerated, but not arrays,
strings, or files.  See the demonstration programs for examples of various
procedures and functions.


Statements follow the syntax of standard Pascal closely.  The CASE statement
also allows ranges of case labels to be expressed just like a set:

        CASE X OF
        1..5: STATEMENT1;
        6..10: STATEMENT2;
        END;

and their is no OTHERWISE clause in the case statement, as in some Pascals.
You should test for legal values of the case selector before the case
statement, unless you wish the run-time