{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program TransferDlg;

{$R MyDlg.RES}

uses WinTypes, WinProcs, WObjects, Strings;

{equate constants defined in the MYDLG.RES resource file}
const
  TextLen      = 18;
  id_ListBox   = 101;
  id_ScrollBar = 102;
  id_CheckBox1 = 103;
  id_CheckBox2 = 104;
  id_CheckBox3 = 105;
  id_Radio0    = 106;
  id_Radio1    = 107;
  id_Radio2    = 108;
  id_InputLine = 109;
  cm_Dialog    = 202;

type
  ListBoxRec = record
    List1String: PStrCollection;
    List1Selection: Integer;
  end;

  ScrollBarTransferRec = record
    LowValue: Integer;
    HighValue: Integer;
    Position: Integer;
  end;

  TransferRecord = record
    ListBoxData: ListBoxRec;
    ScrollBarData: ScrollBarTransferRec;
    Check1, Check2, Check3: Word;
    Radio0, Radio1, Radio2: Word;
    InputEdit: array[0..TextLen - 1] of Char;
  end;

  PMyDialog = ^TMyDialog;
  TMyDialog = object(TDialog)
    MyListBox: PListBox;
    MyScrollBar: PScrollBar;
    MyCheckBox1, MyCheckBox2, MyCheckBox3: PCheckBox;
    MyRadio0, MyRadio1, MyRadio2: PRadioButton;
    MyInputLine: PEdit;
    MyOkButton, MyCancelButton: PButton;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure HandleListBoxMsg(var Message: TMessage);
      virtual id_First + id_ListBox;
    procedure HandleScrollBarMsg(var Message: TMessage);
      virtual id_First + id_Scrollbar;
    procedure SetUpWindow; virtual;
   end;

  PMyMainWindow = ^TMyMainWindow;
  TMyMainWindow = object(TWindow)
    MyDialog : PMyDialog;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure CreateModalDialog(var Message: TMessage);
      virtual cm_First + cm_Dialog;
  end;

  TMyDlgApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

var
  MyTransferRec: TransferRecord;

constructor TMyDialog.Init(AParent: PWindowsObject; ATitle: PChar);

  procedure FillTransferRecord;
  const
    filled: Boolean = False;

  var
     I : byte;
     S : array [0..10] of Char;

  begin
   if not filled then { fill the buffer only once with default values}
   begin
     with MyTransferRec.ListBoxData do
     begin
       List1String := New(PStrCollection, Init(10, 5));
       with List1String^ do
         for I := 0 to 9 do
         begin
	   LoadString(HInstance, I, S, Sizeof(S));
	   Insert(StrNew(S));
     	 end;
       List1Selection := 5;
     end;
     with MyTransferRec.ScrollBarData do
     begin
       LowValue := 0;
       Highvalue := 9;
       Position := 5;
     end;
     MyTransferRec.Check1 := bf_Checked;
     MyTransferRec.Check2 := bf_Unchecked;
     MyTransferRec.Check3 := bf_Checked;

     MyTransferRec.Radio0 := bf_Unchecked;
     MyTransferRec.Radio1 := bf_Checked;
     MyTransferRec.Radio2 := bf_UnChecked;

     StrCopy(MyTransferRec.InputEdit, 'Show Up InputLine');
     Filled := True;
   end;
 end;

begin
  TDialog.Init(AParent,ATitle);
  New(MyListBox, InitResource(@Self, id_ListBox));
  New(MyScrollBar, InitResource(@Self, id_Scrollbar));
  New(MyCheckBox1, InitResource(@Self, id_CheckBox1));
  New(MyCheckBox2, InitResource(@Self, id_CheckBox2));
  New(MyCheckBox3, InitResource(@Self, id_CheckBox3));
  New(MyRadio0, InitResource(@Self, id_Radio0));
  New(MyRadio1, InitResource(@Self, id_Radio1));
  New(MyRadio2, InitResource(@Self, id_Radio2));
  New(MyInputLine, InitResource(@Self, id_InputLine, TextLen));
  New(MyOkButton, InitResource(@Self, id_Ok));
  New(MyCancelButton, InitResource(@Self, id_Cancel));
 { The Ok and Cancel button ID's are set to 0 and 1.}
 { These ID's are Windows ID_OK and ID_Cancel.}
 { No need to setup methods for OK and Cancel Buttons}
 FillTransferRecord;
 TransferBuffer := @MyTransferRec;
end;

procedure TMyDialog.SetUpWindow;
begin
  TDialog.SetUpWindow;
  MyScrollBar^.SetRange(0, 9);
end;

procedure TMyDialog.HandleListBoxMsg(var Message: TMessage);
begin
  if Message.LParamHi = lbn_SelChange then
    MyScrollBar^.SetPosition(MyListBox^.GetSelIndex);
  DefWndProc(Message);
end;

procedure TMyDialog.HandleScrollBarMsg(var Message:TMessage);
var
  NewPos: Integer;
begin
  if Message.wParam <> sb_ThumbTrack then
    MyListBox^.SetSelIndex(MyScrollBar^.GetPosition)
  else
   DefWndProc(Message);
end;

constructor TMyMainWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  TWindow.Init(AParent, ATitle);
  Attr.Menu := LoadMenu(HInstance, 'MyMenu');
end;

procedure TMyMainWindow.CreateModalDialog(var Message: TMessage);
var
  ReturnValue: Integer;

begin
  MyDialog := New(PMyDialog, Init(@Self, 'MYDIALOG'));
  ReturnValue := Application^.ExecDialog(MyDialog);
  if ReturnValue = id_Cancel then
     MessageBox(HWindow, 'No Data Transfered', 'Cancel', mb_Ok)
end;

procedure TMyDlgApp.InitMainWindow;
begin
  MainWindow := New(PMyMainWindow, Init(Nil, 'Dialog App'));
end;

var
  MyApp: TMyDlgApp;

begin
  MyApp.Init('MyApp');
  MyApp.Run;
  MyApp.Done;
end.
