{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Formatted Input ('Picture') Demo Program     }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{   by Jason Sprenger and John Wong              }
{************************************************}


program PictureMan;

{$R Picture.RES}

uses WinProcs, WinTypes, Strings, WObjects, FormLine;

const
  idFirst        = 105;
  idLast         = 106;
  idPhone        = 107;
  idPhonePicture = 110;
  cmPhoneNumber  = 203;
  cmAbout        = 999;

  Size1    = 15;
  Size2    = 20;


type

  MainTransRec = record
    First: array[0..14] of CHAR;
    Last: array[0..14] of CHAR;
    Phone: array[0..14] of CHAR;
  end;

  PhonePic = array[0..19] of CHAR;

var
  F: Text;
  Check1: Boolean;

type
  TMyApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyDialog = ^TMyDialog;
  TMyDialog = object(TDlgWindow)
    Special: PFormEdit;
    PictureStr: PChar;
    TheRec: MainTransRec;
    ThePhonePic: PhonePic;
    constructor Init(AParent: PWindowsObject; AName: PCHAR);
    destructor Done; virtual;
    function GetClassName: PChar; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;
    procedure PhoneNumberPicture(var Msg: TMessage);
      virtual cm_First + cmPhoneNumber;
    procedure About(var Msg: TMessage); virtual cm_First + cmAbout;
  end;

procedure TMyApp.InitMainWindow;
begin
  MainWindow:= new(PMyDialog, init(nil,'MainDialog'));
end;

constructor TMyDialog.Init(AParent: PWindowsObject; AName: PCHAR);
var dummy : PWindowsObject;
begin
  TDlgWindow.Init(AParent, AName);
  PictureStr:= StrNew('(###) ###-####');
  dummy := new(PEdit, InitResource(@Self, idFirst, Size1));
  dummy := new(PEdit, InitResource(@Self, idLast, Size1));
  Special := new(PFormEdit, InitResource(@Self, idPhone, Size1, PictureStr));
  fillchar(TheRec, sizeof(TheRec), #0);
  TransferBuffer := @TheRec;
end;


destructor TMyDialog.Done;
begin
  TDlgWindow.Done;
  StrDispose(PictureStr);
end;


function TMyDialog.GetClassName: PChar;
begin
  GetClassName := 'PictureDemo';
end;


procedure TMyDialog.GetWindowClass(var AWndClass: TWndClass);
begin
  TDlgWindow.GetWindowClass(AWndClass);
  AWndClass.hIcon:=LoadIcon(hInstance, 'PictureIcon');
end;


procedure TMyDialog.PhoneNumberPicture(var Msg: TMessage);
var
  TheDialog: PDialog;
  PtrEdit: PEdit;
begin
  TheDialog:= new(PDialog, init(nil, 'PhonePicture'));
  if Check1 then
    begin
      StrCopy(ThePhonePic, '(###) ###-####');
      Check1 := False;
    end;
  new(PtrEdit, InitResource(TheDialog, idPhonePicture, Size2));
  TheDialog^.TransferBuffer := @ThePhonePic;
  Application^.ExecDialog(TheDialog);

  Special^.ChangePicture(ThePhonePic);
end;


procedure TMyDialog.About(var Msg: TMessage);
begin
  Application^.ExecDialog(new(PDialog, Init(@Self, 'AboutBox')));
end;



var
  MyApp: TMyApp;
begin
  Check1:= True;                    { variable Check1 used to regulate the initialization }
  MyApp.Init('Demo');               { of the transfer buffer a second time.               }
  MyApp.Run;
  MyApp.Done;
end.
