/*	ecbiosx.h
 *
 *	Copyright (C) Eicon Technology Corporation, 1988-1994.
 *	This module contains Proprietary Information of
 *	Eicon Technology Corporation, and should be treated
 *	as confidential.
 *
 *	ecbiosx.h - ECBIOS programming interface structures and constants.
 * 
*/

#define ECBIOSAPI __cdecl

/* Special lsn and cid values */

#define ALL_LSN	 	0	
#define INVALID_LSN	-1
#define	ALL_CID	        65535 
#define	ALL_LANA	0x00		/* Special lana values for DCB struct */
#define	INVALID_LANA 	ALL_LANA	/* invalid lana number in the config file. */

/* Special timeout values */

#define	TO_IMM		 0
#define TO_FOREVER  	-1

/* NCB commands */

#define	NCB_CMD			0x7f		/* Command number mask */
#define NCB_CALL		0x10		/* Call */
#define NCB_LISTEN		0x11		/* Listen */
#define NCB_HANGUP		0x12		/* Hangup */
#define NCB_SEND		0x14		/* Send */
#define NCB_RECEIVE		0x15		/* Receive */
#define	NCB_MDDIAL		0x20		/* Modem Dial */
#define	NCB_MDANSWER		0x21		/* Modem Answer */
#define	NCB_MDHANGUP		0x22		/* Modem Hangup */
#define	NCB_MDNUMBER		0x23		/* Modem Number */
#define	NCB_ADDNAME		0x30
#define	NCB_DELNAME		0x31
#define NCB_RESET		0x32		/* Reset */
#define	NCB_STATS		0x33		/* Statistics */
#define	NCB_MDSTATUS		0x33		/* Modem Status */
#define NCB_STATUS		0x34		/* Status */
#define NCB_CANCEL		0x35		/* Cancel */
#define	NCB_ADDGRP		0x36
#define	NCB_UNLINK		0x70
#define	NCB_TRACE		0x79		/* Trace enable */
#define NCB_IPC			0x7b		/* IPC (remote commands) */
#define	NCB_ILLEGAL		0x7f		/* Illegal command */
#define NCB_NOWAIT		0x80		/* Asynchronous command */

#define	NCB_PENDING		0xff		/* NCB status code */
#define	NCB_NOLSN		0xff		/* Illegal lsn value */

/* Info field bits */

#define	NCB_INTR		0x01		/* Interrupt received */
#define	NCB_VCRESET		0x02		/* Virtual circuit reset */
#define	NCB_MBIT		0x10		/* M-bit */
#define	NCB_ENDEND		0x20		/* End-to-end confirm */
#define	NCB_DBIT		0x40		/* D-bit */
#define	NCB_QBIT		0x80		/* Q-bit */
 
#define	NCB_RESSIZE		14		/* NCB reserved field size */
#define	NCB_NAMELEN		16		/* NCB name field length */


/******************************************/
/* Return codes for application requests. */

#define	BAD_LENGTH		0x01
#define	BAD_CMD			0x03
#define TOO_MANY_CMD	        0x22
#define	BAD_LANA_NUM	        0x23
#define	NONE_DONE		0x40
#define	DONE_TIMEOUT	        0x41
#define	BAD_DONE_PARAM	        0x42
#define TOO_MANY_THREAD	        0x43
#define ECBIOS_FATAL            0xff
#define EC_MALFUNC		0x50
#define	EC_LOADED		0x55
#define EC_DUMP			0xF9
#define	EC_HALT			0xFD


typedef	unsigned char	byte;
typedef	unsigned short	word;
typedef	unsigned long	ulong;

union	ADR
{
	ulong	l;
	word	h[2];
	byte    *x;
};


struct	NCB
{
	byte	command;
	byte	retcode;
	byte	lsn;
	byte	info;
	union	ADR buf;
	word	len;
	byte	cname[16];
	byte	aname[16];
	byte	sto;
	byte	rto;
	union	ADR post;
	byte	lana;
	byte	complete;
	word	cid;
	byte	reserved[12];
};
typedef struct NCB ncb_t;	

union	NCBADR
{
	ulong	l;
	word	h[2];
	struct	NCB   *x;
};

struct DCB				/* Done Control Block */
{
	word	cid;			/* Connection ID. */
	word	lana;			/* EC card number and port within EC card. */
	ulong	timeout;		/* Timeout (in millisec). */
	ncb_t  *done_ncb;		/* Far pointer on a done NCB. */
};

typedef struct DCB dcb_t;

/* DLL Function declarations */
extern int	ECBIOSAPI	EcbiosOpen ();
extern int	ECBIOSAPI	EcbiosClose ();
extern int	ECBIOSAPI	EcbiosSubmit (ncb_t *);
extern int	ECBIOSAPI	EcbiosDone (dcb_t *);
extern unsigned long	ECBIOSAPI	EcbiosOpenSync ();
extern void	ECBIOSAPI	EcbiosCloseSync (unsigned long hdl);
extern int	ECBIOSAPI	EcbiosSubmitSync (ncb_t *, unsigned long hdl);
