/* Copyright (C) 1994 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* shcgen.h */
/* Interface to shcgen.c */
/* Requires shc.h */

/* Compute an optimal Huffman code from an input data set. */
/* The client must have set all the elements of *def. */
int hc_compute(P3(hc_definition *def, long *freqs, gs_memory_t *mem));

/* Generate the encoding table from the definition. */
/* The size of the encode array is def->num_values. */
void hc_make_encoding(P2(hce_code *encode, const hc_definition *def));

/* Calculate the size of the decoding table. */
uint hc_sizeof_decoding(P2(const hc_definition *def, int initial_bits));

/* Generate the decoding tables. */
void hc_make_decoding(P3(hcd_code *decode, const hc_definition *def,
  int initial_bits));
