/* Copyright (C) 1992, 1993 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* ivmspace.h */
/* Local/global space management */
/* Requires imemory.h */
/* Requires ialloc.h if testing/setting allocator state */

/*
 * According to the PostScript language specification, attempting to store
 * a reference to a local object into a global object must produce an
 * invalidaccess error.  However, systemdict must be able to refer to
 * a number of local dictionaries such as userdict and errordict.
 * Therefore, we implement a special hack in 'def' that allows such stores
 * if the dictionary being stored into is systemdict (which is normally
 * only writable during initialization) or a dictionary that appears
 * in systemdict (such as level2dict), and the current save level is zero
 * (to guarantee that we can't get dangling pointers).
 * We could allow this for any global dictionary, except that the garbage
 * collector must treat any such dictionaries as roots when collecting
 * local VM without collecting global VM.
 *
 * We must check for local-into-global stores in three categories of places:
 *
 *	- The scanner, when it encounters a //name inside {}.
 *
 *	- All operators that allocate ref-containing objects and also
 *	store into them:
 *		packedarray  gstate  makepattern?
 *		makefont  scalefont  definefont  filter?
 *
 *	- All operators that store refs into existing objects
 *	("operators" marked with * are actually PostScript procedures):
 *		put(array)  putinterval(array)  astore  copy(to array)
 *		def  store*  put(dict)  copy(dict)
 *		dictstack  execstack  makeoperator
 *		currentgstate  defineusername?
 */

/* Test whether an object is local/global. */
#define r_is_local(rp) r_has_attr(rp, a_local)
#define r_is_global(rp) !r_is_local(rp)
#define check_global(rf)\
  if ( !r_is_global(&rf) ) return_error(e_invalidaccess)
/* The following is a shortcut for checking */
/* r_is_global(&rdest) && r_is_local(rcont) */
#define check_store_space(rdest,rcont)\
  if ( ~r_type_attrs(&(rdest)) & r_type_attrs(&(rcont)) & a_local )\
    return_error(e_invalidaccess)
