/* Rexx command script to install PTFs for IBM Personal Dictation System */

  say
  say "This program will install a fix for the"
  say "IBM Personal Dictation System 1.0"
  say

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLOADFUNCS'
  call SysLoadFuncs

  Ar_Path="SPCH_RUN\ARCHIVE"

  /* inplst  = "input.lst" */

  parse upper arg inplst

  if (inplst = "") then do
     say "Invalid number of arguments"
     say "Example: INSTALL <CONTROL-FILENAME>"
     exit(0)
  end /* do */




  SpeechDrive = value('SPCH_DRIVE',,'OS2ENVIRONMENT')   /* Determine the speech drive drive */

  if length(SpeechDrive )=0 then do
     say "The environment variable SPCH_DRIVE is not set."
     say "Please make sure this variable is set in your config.sys"
     say
     say "*** Installation Failed ***"
     exit(1)
  end

  if length(SpeechDrive) \= 1 then do
     SpeechDrive=substr(SpeechDrive,1,1)      /* consider only the first character keyed */
  end  /* Do */

  SpeechDrive = SpeechDrive||":\"

  parse source full_cmd_file       /* get the drive and path of the cmd file */
  parse var full_cmd_file os2_string invoked_from cmd_file
  zip_drv = filespec("drive", cmd_file)  /* extract the drive */
  zip_path = filespec("path", cmd_file)  /* extract the path */

  iplst = zip_drv||zip_path||inplst

     if stream(iplst, 'c', 'query exists') \= iplst  then  do /* verify if the file is in the directory */
         call beep 800, 300
         say "The file " inplst " cannot be found in the directory "zip_drv||zip_path
         say "This file is required for the installation of the fix."
         say
         say "*** The fix could not be installed ***"
         say "Call your IBM Support Representative for assistance."
         exit(1)
     end /*do */

      j=1
     copylist.0=0

 do until lines(iplst) = 0
     line = linein(iplst)
     parse upper var  line file Sp_Path
     Sp_Path = strip(Sp_Path)
     cur_dir = directory()           /* get the current directory */
     Spch_dir = directory(SpeechDrive||Sp_Path) /* go to spch_ro\bin directory */
     Spch_dir = translate(Spch_dir)
     call directory cur_dir          /* return to the original directory */


     if Spch_dir \= translate(SpeechDrive||Sp_Path) then do /* verify if spch_ro/bin exists */
        call beep 800, 300
        say "The directory " SpeechDrive||Sp_Path "cannot be found"
        say "This directory is required for the installation of the fix."
        say
        say "*** The fix could not be installed ***"
        say "Call your IBM Support Representative for assistance."
        exit(1)
     end  /* Do */

     play_path=zip_drv||zip_path||file

     if stream(play_path, 'c', 'query exists') \= play_path  then  do /* verify if the file is in the directory */
         call beep 800, 300
         say "The file " file " cannot be found in the directory "zip_drv||zip_path
         say "This file is required for the installation of the fix."
         say
         say "*** The fix could not be installed ***"
         say "Call your IBM Support Representative for assistance."
         exit(1)
     end  /* do */

    say "   Updating " file||"..."
    CheckPath=SpeechDrive||Sp_Path||"\"||file
    if stream(CheckPath, 'c', 'query exists') = CheckPath then do
       say "archive the files..."
       call sysmkdir(SpeechDrive||Ar_Path)
       '@copy ' CheckPath  SpeechDrive||Ar_path || ' >NUL'
       /*if the copy is not a success then exit */
       if rc \= 0 then do

           if copylist.0 > 0 then do
              /* Restore the directory with original files */
              do k=1 to copylist.0 by 1
                 '@copy ' SpeechDrive||Ar_path||"\"||filespec("name",copylist.k) filespec("drive", copylist.k)||filespec("path", copylist.k) || '>NUL'
              end /* do k */
           end /* do copylist.0 */
          say " "
          say "The installation could not copy the files onto the Speech Drive."
          say "There might not be enough space on the drive to install the fix."
          say "Please verify there is adequate space on your Speech Drive"
          say "and retry the installation."
          say "*** The fix could not be installed ***"
          exit (1)
       end  /* do rc*/

      copylist.j=checkPath
      copylist.0=j
      j = j+1
    end /* do rc */
    /*
    else do
       say "File " file "not found in the directory " SpeechDrive||Sp_Path
    end
    */

    /* turn off the readonly attribute of the files to be tranfered */
    '@attrib -r 'CheckPath
    say "Copy the file into the correct directory"
    '@copy ' play_path  SpeechDrive||Sp_Path||'>NUL'
  end /* do until lines */
  call beep 800, 300
  say " "
  say "The fix for the IBM Personal Dictation System 1.0"
  say "has been successfully applied."

exit(0)

