{$S-,R-,I-,V-,B-}

{*********************************************************}
{*                    BENCH.PAS 1.00                     *}
{*                by TurboPower Software                 *}
{*********************************************************}

program Bench;
  {-Benchmark a program}

uses
  OpTimer, OpString, OpDos;

(*
  BENCH is a simple utility for benchmarking compiled programs. It uses
  the ExecDos procedure in the OPDOS unit to EXEC the program, and the
  OPTIMER unit to measure its execution time.

  For example, let's say that you wanted to compare the performance of
  MASM against that of Turbo Assembler, using OPTSR.ASM as a test case.
  You would enter the following commands at the DOS prompt:

     BENCH MASM OPTSR;
     BENCH TASM OPTSR

  For best results, especially in comparisons, the program(s) being
  benchmarked should be on a RAM disk, in order to minimize the amount of time
  spent by DOS in loading the program.
*)

type
  StringPtr = ^string;
var
  CmdLine : String;
  Code : Integer;
  Start, Stop : LongInt;

begin
  WriteLn('BENCH. Utility for benchmarking programs.');
  if ParamCount = 0 then begin
    WriteLn('Usage: BENCH progname [params]');
    Halt;
  end;

  {get a copy of the command line}
  CmdLine := TrimLead(StringPtr(Ptr(PrefixSeg, $80))^);

  {time the execution of the program}
  Start := ReadTimer;
  Code := ExecDos(CmdLine, True, NoExecDosProc);
  Stop := ReadTimer;

  {check the return code}
  case Code of
    0 : {Success} ;
   -1 : WriteLn('Insufficient memory to store free list');
   -2 : WriteLn('DOS setblock error before EXEC call');
   -3 : WriteLn('DOS setblock error after EXEC call');
   -4 : WriteLn('Insufficient memory to run DOS command');
   else WriteLn('DOS reports error code of ', Code);
  end;

  {halt in case of error}
  if Code <> 0 then
    Halt(1);

  {report elapsed time}
  WriteLn('Elapsed time: ', ElapsedTime(Start, Stop)/1000.0:0:2, ' seconds');
end.
