PROGRAM Hallo1;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "Hallo1"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program puts out the text "Hrllo world" into a PM window.          *
*                                                                          *
*                                                                          *
****************************************************************************}


USES Crt,API,PmTypes;  {bind Units used}


VAR
    HalloClass:STRING; {Window class for main window}
    WindowStyle:ULONG; {Style of the main window}
    Frame,Win:HWND;    {Handles of the main window}
    Title:STRING;      {Title of the main window}
    _qmsg:QMSG;        {Message Queue}


{Window procedure for the Window-Class "Hallo". Handles messages.
 Messages not processed will be given to the Standard Window-Procedure
 (WinDefWndProc).
 This function must be CDECL because PM calls this in C-Manner}
FUNCTION WindowProc(Win:HWND;Msg:ULONG;Para1,Para2:POINTER):ULONG;CDECL;
VAR Handled:BOOLEAN;
    result:ULONG;
    _hps:HPS;
    rec:RECTL;
    point:POINTL;
    s:STRING;
BEGIN
     Handled:=TRUE;
     result:=0;
     CASE Msg OF
         WM_ERASEBACKGROUND:result:=1;
         WM_PAINT:
         BEGIN
              _hps:=WinBeginPaint(rec,0,Win);
              GpiSetBackColor(CLR_BACKGROUND,_hps);
              GpiSetColor(CLR_NEUTRAL,_hps);
              GpiSetBackMix(BM_OVERPAINT,_hps);
              point.x:=50;
              point.y:=100;
              s:='Hello world...';
              GpiCharStringAt(s[1],length(s),point,_hps);
              WinEndPaint(_hps);
         END;
         WM_CLOSE:WinPostMsg(NIL,NIL,WM_QUIT,Win);
         ELSE Handled:=FALSE;
     END; {Case}
     IF not Handled THEN result:=WinDefWindowProc(Para2,Para1,Msg,Win);
     WindowProc:=result;
END;

BEGIN {Main}
     {Initialize PM}
     AppHandle:=WinInitialize(0);
     AppQueueHandle:=WinCreateMsgQueue(0,AppHandle);

     {register Window-Class}
     HalloClass:='Hallo';
     WinRegisterClass(0,CS_SIZEREDRAW,@WindowProc,HalloClass,AppHandle);

     {define main application window}
     WindowStyle:=FCF_TITLEBAR OR FCF_SYSMENU OR FCF_MINMAX OR FCF_TASKLIST
                  OR FCF_SIZEBORDER;
      Title:='Hallo1 Sample Application';
     Frame:=WinCreateStdWindow(Win,0,0,0,Title,HalloClass,WindowStyle,0,
                               HWND_DESKTOP);

     {Set position and show main window}
     WinSetWindowPos(SWP_SHOW OR SWP_ACTIVATE OR SWP_MOVE OR SWP_SIZE,
                     200,300,100,100,HWND_TOP,Frame);

     {Handle message queue}
     WHILE WinGetMsg(0,0,0,_qmsg,Apphandle)<>0 DO
       WinDispatchMsg(_qmsg,Apphandle);

     {Delete main window}
     WinDestroyWindow(Frame);

     {Shut down PM}
     WinDestroyMsgQueue(AppQueueHandle);
     WinTerminate(AppHandle);
END.

 
