/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*                                                                          */
/*          FidoNet(R) Mail Session Calling System Synchronization          */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/



 /*
    Sender Synchronization state table.
   
    This logic is used by the calling system. It will determine the
    type of mail transfer which can be used in communicating with
    the called system.
   
    This stuff was copied almost verbatim from a file sent to us by TJ.
    (Of course, then we hacked the heck out of it!!!)
  
    Thanks, Tom.
  

 .-----+----------+-------------------------+-------------------------+-----.
 | SS0 | SyncInit |                         | Prepare 3 sec Sync timer|     |
 |     |          |                         | Prepare .5 sec NAK tmr  |     |
 |     |          |                         | Init NAK Count          |     |
 |     |          |                         | Start 60 sec master tmr | SS1 |
 |-----+----------+-------------------------+-------------------------+-----|
 | SS1 | SendSync | 1. Over 60 seconds      |                         |     |
 |     |          |    or carrier lost      | no response             | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. 3 sec elapsed        | Clear Inbound buffer    |     |
 |     |          |    or timer not started | Send YOOHOO, then TSYNC |     |
 |     |          |                         | Start 3 sec Sync timer  | SS2 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. not elapsed          |                         | SS2 |
 |-----+----------+-------------------------+-------------------------+-----|
 | SS2 | WaitResp | 1. Nothing received     | require a response      | SS1 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. ENQ received         | WaZOO Protocol selected | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. 'C' received         | probable FSC001         | SS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 4. NAK received         | probable FSC001         | SS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 5. Debris (might include| Reset NAK timer         |     |
 |     |          |    (YOOHOO|TSYNC) & 127)| if started              | SS1 |
 |-----+----------+-------------------------+-------------------------+-----|
 | SS3 | NAKTmr   | 1. Timer not expired    | Zero NAK count          |     |
 |     |          |    or timer not started | Start .5 sec NAK timer  | SS1 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Timer expired        | Bump NAK count          | SS4 |
 |-----+----------+-------------------------+-------------------------+-----|
 | SS4 | NAKCount | 1. Count >= 2?          | assume FSC001           | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Count < 2            | Keep looking            | SS1 |
 `-----+----------+-------------------------+-------------------------+-----'


 */

/* Include this file before any other includes or defines! */

#include "includes.h"

/*
 * Data structure used by all SendSync state machine functions.
 * Contains all data which needs to be passed between various states.
 *
 */

typedef struct {
   long NAK_Timer;                      /* 1/2 second NAK interval timer    */
   long SendSyncTimer;                  /* 3 second SendSync Timer          */
   long Master_Timer;                   /* 60 second master timeout         */
   int  NAK_Count;                      /* Count of NAK's received          */
   int  result;                         /* Result we want to send out       */
} SSARGS, *SSARGSP;

int SSSyncInit (SSARGSP, int);          /* Called by state machine at start */
int SSExit     (SSARGSP, int);          /* Called by state machine at end   */
int SSSendSync (SSARGSP);               /* SS1 state processing function    */
int SSWaitResp (SSARGSP);               /* SS2 state processing function    */
int SSNAKTmr   (SSARGSP);               /* SS3 state processing function    */
int SSNAKCount (SSARGSP);               /* SS4 state processing function    */


#define SS0    0                        /* Reserved value of 0 for init     */
#define SSexit 0                        /* Slot 1 is exit, but called by 0  */
#define SS1    2                        /* First "user" slot is 2.          */
#define SS2    3                        /* After that, it all maps n : n+1  */
#define SS3    4
#define SS4    5
#define SS5    6


STATES Send_Sync [] = {                 /* Table used by state machine      */
   { "SSSyncInit", SSSyncInit },        /* And referred to by 'SSn' defines */
   { "SSExit",     SSExit },            /* listed above ...                 */
   { "SSSendSync", SSSendSync },
   { "SSWaitResp", SSWaitResp },
   { "SSNAKTmr",   SSNAKTmr },
   { "SSNAKCount", SSNAKCount },
};


/*
 * CallerSendSync
 * Determine whether we are talking to an FTS-0001 mailer or an FTS-0006
 * mailer. Use the general state machine driver.
 *
 * This is the only external entry point into this module.
 *
 */
 
int CallerSendSync (void)
{
   SSARGS args;
   int res;

   args.result = 0;

   res = state_machine (Send_Sync, &args, 2);
   return (res);
}



/*
 * This routine is called by the state machine when the 'SSexit'
 * state is seen. Its return value is what the state machine
 * will return to its caller as the result of the function.
 *
 */
 
int SSExit (SSARGSP args, int cur_state)
{
   happy_compiler = cur_state;  /* Makes the compiler happy! */
   return (args->result);
}



 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | SS0 | SyncInit |                         | Prepare 3 sec Sync timer|     |
 |     |          |                         | Prepare .5 sec NAK tmr  |     |
 |     |          |                         | Init NAK Count          |     |
 |     |          |                         | Start 60 sec master tmr | SS1 |
 `-----+----------+-------------------------+-------------------------+-----'

  */


int SSSyncInit (SSARGSP args, int start_state)
{
   args->NAK_Timer = args->SendSyncTimer = 0L;
   args->NAK_Count = 0;
   args->Master_Timer = timerset (6000);
   happy_compiler = start_state;  /* Makes the compiler happy! */
   return (SS1);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | SS1 | SendSync | 1. Over 60 seconds      |                         |     |
 |     |          |    or carrier lost      | no response             | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. 3 sec elapsed        | Clear Inbound buffer    |     |
 |     |          |    or timer not started | Send YOOHOO, then TSYNC |     |
 |     |          |                         | Start 3 sec Sync timer  | SS2 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. not elapsed          |                         | SS2 |
 `-----+----------+-------------------------+-------------------------+-----'

  */


int SSSendSync (SSARGSP args)
{
   if (!(CARRIER) || (timeup (args->Master_Timer))) {
      args->result = 0;         /* Failure */
      return (SSexit);
   }
   
   if (!(args->SendSyncTimer) || timeup (args->SendSyncTimer)) {
      CLEAR_INBOUND ();
      if (!no_WaZOO_Session)    /* If we're WaZOO,   */
         SENDBYTE (YOOHOO);
      SENDBYTE (TSYNC);
      args->SendSyncTimer = timerset (300);
   }
   return (SS2);
}


 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | SS2 | WaitResp | 1. Nothing received     | require a response      | SS1 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. ENQ received         | Wazoo Protocol selected | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. 'C' received         | probable FSC001         | SS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 4. NAK received         | probable FSC001         | SS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 5. Debris (might include| Reset NAK timer         |     |
 |     |          |    (YOOHOO|TSYNC) & 127)| if started              | SS1 |
 `-----+----------+-------------------------+-------------------------+-----'

  */


int SSWaitResp (SSARGSP args)
{
   int i;
   int exit_code;
   
   if (!CHAR_AVAIL ()) {
      return (SS1);
   }
   
   i = PEEKBYTE ();
   
   switch (i) {
   
      case 'C':
      case NAK:
         exit_code = SS3;
         break;

      case ENQ:
         if (!no_WaZOO_Session) {      /* If we're WaZOO,   */
            args->result = 2;      /* WaZOO */
            exit_code = SSexit;
            break;
         }         

      /* Deliberately fall through from ENQ if we're not doing WaZOO */

      default:
         (void) TIMED_READ (0);
         if (args->NAK_Timer) {
            args->NAK_Timer = timerset (50);
         }
         exit_code = SS1;
         break;
    }

   return (exit_code);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | SS3 | NAKTmr   | 1. Timer not expired    | Zero NAK count          |     |
 |     |          |    or timer not started | Start .5 sec NAK timer  | SS1 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Timer expired        | Bump NAK count          | SS4 |
 `-----+----------+-------------------------+-------------------------+-----'

  */


int SSNAKTmr (SSARGSP args)
{
   if (!(args->NAK_Timer) || !timeup (args->NAK_Timer)) {
      args->NAK_Count = 0;
      args->NAK_Timer = timerset (50);
      (void) TIMED_READ (0);
      return (SS1);
   } else {
      (args->NAK_Count)++;
      return (SS4);
   }
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | SS4 | NAKCount | 1. Count >= 2?          | assume FSC001           | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Count < 2            | Keep looking            | SS1 |
 `-----+----------+-------------------------+-------------------------+-----'

  */


int SSNAKCount (SSARGSP args)
{
   if (no_WaZOO_Session || args->NAK_Count >= 2) {
      args->result = 1;         /* FSC001 */
      return (SSexit);
   } else {
      (void) TIMED_READ (0);
      return (SS1);
   }
}

