/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*       Routines for putting lines of text in windows for BinkleyTerm      */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*   This module is derived from code developed by Augie Hansen in his      */
/*   book "Proficient C" published by Microsoft Press.  Mr. Hansen was      */
/*   kind enough to give us verbal permission to use his routines, and      */
/*   Bob, Vince and Alan (and all our full screen users) are grateful.      */
/*   If you decide to use this code in some package you are doing, give     */
/*   some thought to going out and buying the book. He deserves that.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern BUFFER Sbuf;
extern CELLP Scrnbuf;

int sb_putc (REGIONP win, int ch)
{
   int cmax, rmax;
   int noscroll = 0, puterr = 0;

#ifdef MILQ
   RECT                 Rect;
#endif

   /* calculate the screen buffer position and limits */

#ifdef MILQ
   GetClientRect( win->hWnd, &Rect );
   cmax = Rect.right - Rect.left;
   rmax = Rect.bottom - Rect.top;
   Sbuf.row = Rect.top + win->row;
   Sbuf.col = Rect.left + win->col;
#else
   cmax = win->c1 - win->c0;
   rmax = win->r1 - win->r0;
   Sbuf.row = win->r0 + win->row;
   Sbuf.col = win->c0 + win->col;
#endif

   /* process the character */
   switch (ch)
      {
      case '\b':
         /* Non destructive backspace */
         if (win->col > 0)
            {
            --(win->col);
            --(Sbuf.col);
            return (SB_OK);
            }
         else
            return (SB_ERR);

      case '\r':
         /* clear trailing line segment */
         while (win->col < cmax)
            {
            if (sb_putc (win, ' ') == SB_ERR)
               {
               ++puterr;
               }
            }
         sb_wc (win, ' ', 1);
         break;

#ifdef TABEXP
      case '\t':
         /* convert tabs to spaces */
         lim = win->col + 8 - (win->col & 7);
         while (win->col < lim)
            {
            if (sb_putc (win, ' ') == SB_ERR)
               {
               ++puterr;
               }
            }
         break;
#endif /* TABEXP */

      default:
#ifndef MILQ
         (Scrnbuf + Sbuf.row * SB_COLS + Sbuf.col)->b.ch = (unsigned char) ch;
#endif

#ifdef MILQ
         WinPutc( win->hWnd, win->row - 1, win->col - 1, ch, SYSTEM_COLOR );
#endif
         if (Sbuf.col < Sbuf.lcol[Sbuf.row])
            {
            Sbuf.lcol[Sbuf.row] = Sbuf.col;
            }
         if (Sbuf.col > Sbuf.rcol[Sbuf.row])
            {
            Sbuf.rcol[Sbuf.row] = Sbuf.col;
            }
         break;
      }

   /* update the cursor position */
   if (win->col < cmax)
      {
      ++(win->col);
      }
   else if (win->row < rmax)
      {
      win->col = 0;
      ++(win->row);
      }
   else if (win->wflags & SB_SCROLL)
      {
      sb_scrl (win, 1);
      win->col = 0;
      win->row = rmax;
      }
   else
      {
      ++noscroll;
      }

   /* update screen buffer position */
   Sbuf.row = win->r0 + win->row;
   Sbuf.col = win->c0 + win->col;
   Sbuf.flags |= SB_DELTA;

   return ((noscroll || puterr) ? SB_ERR : SB_OK);
}

#ifndef MILQ
void sb_puts (REGIONP win, char *s)
{
   while (*s)
      {
      if (sb_putc (win, *s++) == SB_ERR)
         return; /* (SB_ERR); */
      }

   return; /* (SB_OK); */
}
#endif
