/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*                                                                          */
/*          FidoNet(R) Mail Session Called System Synchronization           */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/


 /*
    Receiver Synchronization state table.
   
    This logic is used by the called system. It will determine the
    type of mail transfer which can be used in communicating with
    the calling system.
   
    This stuff was originally copied from a file sent to us by TJ.
    (Of course, then we hacked the heck out of it!!!)
  
    Thanks, Tom.
  

 .-----+----------+-------------------------+-------------------------+-----.
 | RS0 | SyncInit |                         | Start 5 second idle tmr | RS1 |
 |-----+----------+-------------------------+-------------------------+-----|
 | RS1 | IdleWait | 1. 5 sec tmr expired    | Take the initiative     | RS2 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Carrier lost         | Session aborted         | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. Peek = YOOHOO        | Looks like a live WaZOO | RS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 4. Peek = TSYNC         | Live FSC001, we think   | RS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 5. Peek = CR, LF, space | He looks alive          | RS2 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 6. Other character      | Eat it                  | RS1 |
 |-----+----------+-------------------------+-------------------------+-----|
 | RS2 |SendBanner| 1. Error returned       | Session aborted         | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Banner sent OK       |                         | RS3 |
 |-----+----------+-------------------------+-------------------------+-----|
 | RS3 |RecvInit  |                         | Init ext-mail scan ptrs | RS4 |
 |     |          |                         | Start 20 sec timer      |     |
 |     |          |                         | Init 10 sec timer       |     |
 |-----+----------+-------------------------+-------------------------+-----|
 | RS4 |SendSync  | 1. Error returned       | Session aborted         | exit|
 |     |(xmit sync+-------------------------+-------------------------+-----|
 |     |string)   | 2. String sent OK       | Watch for sender sync   | RS5 |
 |-----+----------+-------------------------+-------------------------+-----|
 | RS5 | WaitSync | 1. Carrier lost         | Session aborted         | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. YOOHOO received      | WaZOO session selected  | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. TSYNC received       | probable FSC001         | RS6 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 4. CR received          | Still sync'ing          | RS4 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 5. ESC received         | BBS session             | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 6. Other character rcvd | check ext-mail string   | RS7 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 7. 10 sec timer elapsed | FSC001 protocol selected| exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 8. 20 sec timer elapsed | Not a mail session      | exit|
 |-----+----------+-------------------------+-------------------------+-----|
 | RS6 | TsyncTmr | 1. Timer not running    | Start 10 second timer   | RS5 |
 |     |          |                         | Reset 20 sec timer      |     |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Timer running        | Two TSYNCS = FTS-0001   | exit|
 |-----+----------+-------------------------+-------------------------+-----|
 | RS7 | ExtMail  | 1. String matched       | External mail selected  | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Checked all strings  | Get next input character| RS5 |
 `-----+----------+-------------------------+-------------------------+-----'

 */


/* Include this file before any other includes or defines! */

#include "includes.h"

/*
 * Data structure used by all RecvSync state machine functions.
 * Contains all data which needs to be passed between various states.
 *
 */

typedef struct {
   long Idle_Timer;                     /* 5 second initial idle timer      */
   long BBS_Timer;                      /* 20 second Timer for BBS user     */
   char *ExtMailScan[16];               /* Scan pointer for External Mail   */
   long TSYNC_Timer;                    /* 10 second TSYNC timer            */
   int  result;                         /* Result we want to send out       */
} RSARGS, *RSARGSP;

int RSSyncInit (RSARGSP, int);          /* Called by state machine at start */
int RSExit     (RSARGSP, int);          /* Called by state machine at end   */
int RSIdleWait (RSARGSP);               /* RS1 state processing function    */
int RSSendBannr(RSARGSP);               /* RS2 state processing function    */
int RSRecvInit (RSARGSP);               /* RS3 state processing function    */
int RSSendSync (RSARGSP);               /* RS4 state processing function    */
int RSWaitSync (RSARGSP);               /* RS5 state processing function    */
int RSTsyncTmr (RSARGSP);               /* RS6 state processing function    */
int RSExtMail  (RSARGSP);               /* RS7 state processing function    */


#define RS0    0                        /* Reserved value of 0 for init     */
#define RSexit 0                        /* Slot 1 is exit, but called by 0  */
#define RS1    2                        /* First "user" slot is 2.          */
#define RS2    3                        /* After that, it all maps n : n+1  */
#define RS3    4
#define RS4    5
#define RS5    6
#define RS6    7
#define RS7    8


STATES Recv_Sync [] = {                 /* Table used by state machine      */
   { "RSSyncInit", RSSyncInit },        /* And referred to by 'SSn' defines */
   { "RSExit",     RSExit },            /* listed above ...                 */
   { "RSIdleWait", RSIdleWait },
   { "RSSendBannr",RSSendBannr },
   { "RSRecvInit", RSRecvInit },
   { "RSSendSync", RSSendSync },
   { "RSWaitSync", RSWaitSync },
   { "RSTsyncTmr", RSTsyncTmr },
   { "RSExtMail",  RSExtMail },
};


/*
 * CalledRecvSync
 * Determine whether the calling system is an FTS-0001 mailer, an FTS-0006
 * mailer, an external mailer, or a human caller. Use the general state 
 * machine driver.
 *
 * This is the only external entry point into this module.
 *
 */
 
int CalledRecvSync (void)
{
   RSARGS args;
   int res;

   args.result = 0;

   res = state_machine (Recv_Sync, &args, 2);
   return (res);
}



/*
 * This routine is called by the state machine when the 'RSexit'
 * state is seen. Its return value is what the state machine
 * will return to its caller as the result of the function.
 *
 */
 
int RSExit (RSARGSP args, int cur_state)
{
   happy_compiler = cur_state;  /* Makes compiler happy! */
   return (args->result);
}

 /*

 .-----+----------+-------------------------+-------------------------+-----.
 | RS0 | SyncInit |                         | Start 5 second idle tmr | RS1 |
 `-----+----------+-------------------------+-------------------------+-----'

 */
 

int RSSyncInit (RSARGSP args, int start_state)
{
   args->Idle_Timer = timerset (500);
   happy_compiler = start_state;  /* Makes compiler happy! */
   return (RS1);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | RS1 | IdleWait | 1. 5 sec tmr expired    | Take the initiative     | RS2 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Carrier lost         | Session aborted         | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. Peek = YOOHOO        | Looks like a live WaZOO | RS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 4. Peek = TSYNC         | Live FSC001, we think   | RS3 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 5. Peek = CR, LF, space | He looks alive          | RS2 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 6. Other character      | Eat it                  | RS1 |
 `-----+----------+-------------------------+-------------------------+-----'

 */
 

int RSIdleWait (RSARGSP args)
{
   unsigned int i;
   int ret;

   while (!timeup (args->Idle_Timer)) {

      if (!CARRIER) {
         args->result = 0;
         return (RSexit);
      }

      if ((i = (unsigned int) PEEKBYTE ()) == 0xffff)
         continue;

      switch (i & 0xff) {

      case TSYNC:
      case YOOHOO:
         ret = RS3;                           /* Fast lane, no banner */
         break;
      
      case CR:
      case LV:
      case ' ':
      case ENQ:
      case ESC:
         ret =  RS2;                          /* He's alive, do banner*/
         break;

      default:
         (void) TIMED_READ (0);               /* eat it up            */
         ret = RS1;
         break;
      }
      return (ret);

   }
   return (RS2);                                 /* Idle for 5 seconds   */
}

 /*

 .-----+----------+-------------------------+-------------------------+-----.
 | RS2 |SendBanner| 1. Error returned       | Session aborted         | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Banner sent OK       |                         | RS3 |
 `-----+----------+-------------------------+-------------------------+-----'

 */
 

int RSSendBannr (RSARGSP args)
{
   char buff[128];

   (void) sprintf (buff, MSG_TXT(M_ADDRESS), 
                         Full_Addr_Str (&my_addr),
                         ANNOUNCE,
                         ((serial == -1) ? MSG_TXT(M_UNREGISTERED) : " "));

   if (!SendBanner ((char far *)buff)) {
      args->result = 0;
      return (RSexit);
   }

   if (BBSbanner != NULL) {                      /* If BBS name spec'ed, */
      SENDBYTE ('\r');                           /* make sure user gets  */
      SENDBYTE ('\n');                           /* a full cr/lf...      */

      if (!SendBanner ((char far *)BBSbanner)) {
         args->result = 0;
         return (RSexit);
      }

      SENDBYTE ('\r');                           /* make sure user gets  */
      SENDBYTE ('\n');                           /* a full cr/lf...      */
   }

   if (!mail_only) {
      if (!SendBanner (BBSwelcome)) {
         args->result = 0;
         return (RSexit);
      }
   }

   return (RS3);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | RS3 |RecvInit  |                         | Init ext-mail scan ptrs | RS4 |
 |     |          |                         | Start 20 sec timer      |     |
 |     |          |                         | Init 10 sec timer       |     |
 `-----+----------+-------------------------+-------------------------+-----'

 */
 

int RSRecvInit (RSARGSP args)
{
   register int k;

   for (k = 0; k < num_ext_mail; k++) {
      args->ExtMailScan[k] = ext_mail_string[k]; /* UUCP handshake       */
   }

   args->BBS_Timer = timerset (BBStimeout);      /* 20 second timeout    */
   args->TSYNC_Timer = 0L;                       /* Initialize for test  */

   return (RS4);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | RS4 |SendSync  | 1. Error returned       | Session aborted         | exit|
 |     |(xmit sync+-------------------------+-------------------------+-----|
 |     |string)   | 2. String sent OK       | Watch for sender sync   | RS5 |
 `-----+----------+-------------------------+-------------------------+-----'

 */


int RSSendSync (RSARGSP args)
{
   char far *c;

   if (mail_only) {                              /* If no BBS allowed,   */
      c = (char far *) noBBS;                    /* tell human to git    */
   } else {
      c = (char far *) BBSesc;                   /* or hit ESC for BBS   */
   }

   if (!SendBanner (c)) {
      args->result = 0;
      return (RSexit);
   }

   return (RS5);
}

 /*

 .-----+----------+-------------------------+-------------------------+-----.
 | RS5 | WaitSync | 1. Carrier lost         | Session aborted         | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. YOOHOO received      | WaZOO session selected  | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 3. TSYNC received       | probable FSC001         | RS6 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 4. CR received          | Still sync'ing          | RS4 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 5. ESC received         | BBS session             | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 6. Other character rcvd | check ext-mail string   | RS7 |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 7. 10 sec timer elapsed | FSC001 protocol selected| exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 8. 20 sec timer elapsed | Not a mail session      | exit|
 `-----+----------+-------------------------+-------------------------+-----'

 */


int RSWaitSync (RSARGSP args)
{
   unsigned int i;
   int ret = -1;

   while (CARRIER) {

      if (got_ESC ()) {                          /* Manual abort?        */
         LOWER_DTR ();                             /* Yes, drop carrier    */
         timer (10);
         args->result = 0;
         return (RSexit);
      }

      /* Note: the following line is a NON-DESTRUCTIVE READ! */

      switch ((i = (unsigned int) PEEKBYTE ()) & 0xff) {

      case YOOHOO:                            /* Looks like a WaZOO   */

         if (no_WaZOO_Session) {              /* If we're not WaZOO,  */
            (void) TIMED_READ (0);            /* Eat the YooHoo       */
            continue;
         }

         CLEAR_OUTBOUND ();                   /* End noisy banner now */
         args->result = 3;                    /* WaZOO session        */
         ret = RSexit;
         break;

      case TSYNC:                             /* Looks like an FTSC   */

         CLEAR_OUTBOUND ();                   /* End noisy banner now */
         (void) TIMED_READ (0);               /* Eat the TSYNC        */

         if (!no_WaZOO_Session) {             /* If we support WaZOO, */
            ret = RS6;                        /* Go set up the timer  */
         } else {
            args->result = 2;                 /* FTS-0001 session     */
            ret = RSexit;
         }

         break;

      case CR:                                /* Still sync'ing       */

         (void) TIMED_READ (0);               /* Eat the character    */
         ret = RS4;                           /* Back to that stuff   */
         break;

      case ESC:                               /* User wants the BBS   */

         (void) TIMED_READ (0);               /* Eat the character    */
         if (!mail_only) {
            args->result = 1;                 /* BBS session          */
            ret = RSexit;
         }
         break;

      default:                                /* A less special char  */
         if (i != 0xffff)
            ret = RS7;                        /* Check ext mailers    */
         break;

      }
      if (ret >= 0)
         return (ret);

      if ((args->TSYNC_Timer != 0L) && (timeup (args->TSYNC_Timer))) {
         args->result = 2;                    /* FTS-0001 session     */
         return (RSexit);
      }

      if (timeup (args->BBS_Timer)) {         /* The big timeout      */
         args->result = 1;                    /* BBS session          */
         return (RSexit);
      }

      time_release ();                        /* Give up the slice    */

   } /* End (while CARRIER) */

   args->result = 0;                             /* carrier loss = abort */
   return (RSexit);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | RS6 | TsyncTmr | 1. Timer not running    | Start 10 second timer   | RS5 |
 |     |          |                         | Reset 20 sec timer      |     |
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Timer running        | Two TSYNCS = FTS-0001   | exit|
 `-----+----------+-------------------------+-------------------------+-----'

 */


int RSTsyncTmr (RSARGSP args)
{
   if (args->TSYNC_Timer == 0L) {                /* If not already set,  */
      args->TSYNC_Timer = timerset (1000);       /* Then just set it     */
      args->BBS_Timer = timerset (BBStimeout);   /* Reset 20 sec timer   */
      return (RS5);
   }
   args->result = 2;                             /* FTS-0001 session     */
   return (RSexit);
}

 /*
 
 .-----+----------+-------------------------+-------------------------+-----.
 | RS7 | ExtMail  | 1. String matched       | External mail selected  | exit|
 |     |          +-------------------------+-------------------------+-----|
 |     |          | 2. Checked all strings  | Get next input character| RS5 |
 `-----+----------+-------------------------+-------------------------+-----'

 */


int RSExtMail (RSARGSP args)
{
   int i, k;

   /* Note: last character was read in RS5 using a NON-DESTRUCTIVE READ.
      We now will get it out with a DESTRUCTIVE READ.                     */

   i = TIMED_READ (0) & 0xff;                    /* Eat the character     */

   for (k = 0; k < num_ext_mail; k++) {
      if (i != (int) *(args->ExtMailScan[k]++)) {    /* Does this match next? */
         args->ExtMailScan[k] = ext_mail_string[k];  /* No, reset pointer */
      } else {
         if (!*args->ExtMailScan[k]) {           /* End of UUCP string?   */
                args->result = 5 + k;            /* 5 + n for external    */
                return (RSexit);
         }
      }
   }

   return (RS5);
}
