/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*                                                                          */
/*                    BinkleyTerm Language File Loader                      */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#define LANGFILE        ( PRDCT_PRFX ".LNG" )

/*
 * Read the compiled BinkleyTerm Language file.
 *
 */

int load_language (void)
{
    int pointer_size;
    char *memory;
    unsigned int memory_size;
    char *malloc_target;
    char *envptr;
    char LANGpath[128];
    int error;
    int i;
    int read;
    struct stat stbuf;
    FILE           *fpt;                         /* stream pointer           */
    char *Ptr;

   envptr = getenv (PRDCT_PRFX);                 /* get path from environment*/
   if ((envptr != NULL)                          /* If there was one, and    */
       && (!dexists (LANGFILE)))                 /* No local language file,  */
      {
      (void) strcpy (LANGpath, envptr);          /* use BINKLEY as our path  */
      (void) add_backslash (LANGpath);
      }
   else
      LANGpath[0] = '\0';

   (void) strcat (LANGpath, LANGFILE);

   /*
    * Get some info about the file
    */

    error = stat (LANGpath, &stbuf);
    if (error != 0)
        {
        (void) fprintf (stderr, "Cannot get information on file %s\n",LANGpath);
        exit (250);
        }

   /*
    * Allocate space for the raw character array and for the
    * pointer and fixup arrays
    *
    */

    memory_size = (unsigned int) stbuf.st_size;

    Ptr = malloc_target = calloc (1, memory_size);
    if (malloc_target == NULL)
        {
        (void) fprintf (stderr, "Unable to allocate string memory\n");
        exit (250);
        }
   /*
    * Open the input file
    *
    */

    fpt = share_fopen (LANGpath, "rb", DENY_WRITE); /* Open the file         */
    if (fpt == NULL)                            /* Were we successful?       */
        {
        (void) fprintf (stderr, "Can not open input file %s\n", LANGpath);
        exit (250);
        }
   /*
    * Read the entire file into memory now.
    *
    */
    read = fread (malloc_target, 1, memory_size, fpt);
    if ((unsigned)read != memory_size)
        {
        (void) fprintf (stderr, "Could not read language data from file %s\n",LANGpath);
        (void) fclose (fpt);
        exit (250);
        }
   /*
    * Close the file.
    *
    */
    error = fclose (fpt);
    if (error != 0)
        {
        (void) fprintf (stderr, "Unable to close language file %s\n",LANGpath);
        exit (250);
        }
   /*
    * Do fixups on the string pointer array as follows:
    *
    * 1. Get element count from input
    * 2. Start of the string memory immediately follows the strings
    * 3. Apply arithmetic correction to entire array.
    *
    */

    LangHdr = (struct _lang_hdr *)malloc_target;
    msgtxt = (char **) (malloc_target + sizeof (struct _lang_hdr));

    pointer_size = LangHdr->ElemCnt;            /* Count of elements w/o NULL*/
    if (pointer_size != X_TOTAL_MSGS)
        {
        (void) fprintf (stderr, "Count of %d from file does not match %d required\n",
                    pointer_size, X_TOTAL_MSGS);
        exit (250);
        }
    memory = (char *) &msgtxt[pointer_size];    /* Text starts after pointers*/
    for (i = 1; i < pointer_size; i++)
        {
        msgtxt[i] = memory + (int) (msgtxt[i] - msgtxt[0]);
        }
    msgtxt[0] = memory;

   /*
    * Process the Terminal Mode Keymap.
    *
    * First comes the integer count.
    * Following that is the array of keymaps.
    *
    */

    Ptr = (char *)LangHdr
        + sizeof (struct _lang_hdr)
        + (sizeof ( char * ) * (LangHdr->ElemCnt))
        + LangHdr->PoolSize;

    TrmnlKeyFncHdr.KeyFncCnt = *(int *)Ptr;
    Ptr += sizeof (int);
    TrmnlKeyFncHdr.KeyFncTbl = (struct _key_fnc *)Ptr;

    Ptr += sizeof (struct _key_fnc) * TrmnlKeyFncHdr.KeyFncCnt;

   /*
    * Process the Unattended Mode Keymap.
    *
    * First comes the integer count.
    * Following that is the array of keymaps.
    *
    */

    UnattendedKeyFncHdr.KeyFncCnt = *(int *)Ptr;
    Ptr += sizeof (int);

    UnattendedKeyFncHdr.KeyFncTbl = (struct _key_fnc *)Ptr;

    Ptr += sizeof (struct _key_fnc) * UnattendedKeyFncHdr.KeyFncCnt;

   /*
    * Process the product code table.
    *
    * This looks a lot like the language stuff above.
    *
    * The first thing we have here is the header (which contains a count).
    * Following that, the pointer array.
    * Finally, the strings themselves.
    *
    * Get all of that sorted out, do fixups on the string array, and
    * everything should be ducky.
    */

    PrdctHdr = (struct _lang_hdr *)Ptr;
    PrdctTbl = (char **) (Ptr + sizeof (struct _lang_hdr));
    memory = (char *)PrdctTbl
           + (sizeof (char *) * PrdctHdr->ElemCnt);
    memory += strlen (memory) + 1;

    for (i = 1; i < PrdctHdr->ElemCnt; i++)
        {
        PrdctTbl[i] = memory + (int) (PrdctTbl[i] - PrdctTbl[0]);
        }
    PrdctTbl[0] = memory;

    Ptr += sizeof (struct _lang_hdr)
        +  (sizeof ( char * ) * (PrdctHdr->ElemCnt))
        +  PrdctHdr->PoolSize;

   /*
    * Finally set up the ANSI output mapping table.
    *
    * This one is easy. Just point at it.
    */

    AnsiHdr = (struct _lang_hdr *)Ptr;
    AnsiTbl = (char *) (Ptr + sizeof (struct _lang_hdr));

    return (1);
}

