/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                This module was written by Greylock Software              */
/*                                                                          */
/*                                                                          */
/*                        Keyboard Remapping Routine                        */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"


static struct _key_fnc_hdr *CrntKeyFncHdr;


struct _key_fnc_hdr *KbMapSet (struct _key_fnc_hdr *KeyFncHdr)
{
   struct _key_fnc_hdr  *OldKeyFncHdr = CrntKeyFncHdr;

   CrntKeyFncHdr = KeyFncHdr;
   return OldKeyFncHdr;
}

#ifndef MILQ

int ScanCompare (struct _key_fnc *x, struct _key_fnc *y)
{
   return (x->ScanCode - y->ScanCode);
}

unsigned pascal KbRemap (unsigned ScanCode)
{
   struct _key_fnc InFnc;
   struct _key_fnc *KeyFnc;
   int i;

/*
 * FOSSIL keyboarding is so wierd.
 *
 * The spec is really clear about what you're supposed to do with
 * letter and function keys. Some of the IBM FOSSILs didn't give a
 * damn and put scan codes in the high order part of the character
 * keys. That breaks this guy utterly. So we'll get rid of the 
 * bits if they happen to be there.
 */

   if (ScanCode & 0xff)
       ScanCode &= 0xff;                /* Clean up after Opus!Comm */

/* If the table is empty, searching it is sort of pointless.        */

   if (!CrntKeyFncHdr->KeyFncCnt)
       return ScanCode;

   InFnc.ScanCode = ScanCode;

   KeyFnc = CrntKeyFncHdr->KeyFncTbl;

   for (i = CrntKeyFncHdr->KeyFncCnt; i > 0; i--, KeyFnc++)
       {
       if (ScanCompare (KeyFnc, &InFnc) == 0)
           return KeyFnc->FncIdx;
       }

   return ScanCode;
}

#endif

