/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                 This module was written by Bob Hartman                   */
/*                                                                          */
/*                                                                          */
/*                 BinkleyTerm FTSC Mail Session Routines                   */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

int Whack_CR ()
{
   long t1, t2;
   unsigned char j;
   char m;
   int k, l;
   unsigned int i;
   char buf[180];

   t1 = timerset (3000);                         /* set 30 second timeout */
   j = CR;
   (void) strcpy (buf, MSG_TXT(M_INTRO));
   l = (int) strlen (buf);
   m = 0;
   k = 2;
   while (!timeup (t1) && CARRIER)               /* till then or CD lost  */
      {

      /* We send two XON's to try to unstick a V.42 miscue */
      if (k-- > 0)
         SENDBYTE (XON);                         /* Unstick other side?   */

      /* Send either the CR or SPACE */
      SENDBYTE (j);

      /* Now switch to either CR or SPACE based on last output */
      j = (unsigned char) (45 - j);

      /* Now read what we get back to see if we get anything useful */
      while (((i = (unsigned) TIMED_READ (0)) != (unsigned int)EOF) && (!timeup (t1)) && CARRIER)
         {
         if (i == CR)
            {
            if (m)
               {
               if (un_attended && fullscreen)
                  {
                  clear_filetransfer ();

                  sb_move (file_hWnd, 1, 2);
                  sb_puts( GetDlgItem( file_hWnd, FILE_LN_1 ), buf );
                  sb_show ();
                  status_line ("*%s", buf);
                  }
               else
                  {
                  set_xy (NULL);
                  scr_printf (buf);
                  }
               /* We got what we wanted */
               /* Now try to stop output on an Opus */
               SENDBYTE ('');
               return (0);
               }
            }
         else if (i >= ' ')
            {
            buf[l++] = (char) (i & 0xff);
            buf[l] = '\0';
            if (l > (int)SB_COLS - 6)
               l = SB_COLS - 6;
            m = 1;
            }
         }

      if (got_ESC ())
         {
         status_line (MSG_TXT(M_CONNECT_ABORTED));
         mdm_hangup ();
         return (-1);
         }

      /* Delay for a second */
      t2 = timerset (100);
      while (!timeup (t2))
         time_release ();
      }

   if (CARRIER)
      status_line (MSG_TXT(M_NOBODY_HOME));
   else
      status_line (MSG_TXT(M_NO_CARRIER));
   return (-1);
}
