/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*            This module was originally written by Bob Hartman             */
/*                                                                          */
/*                                                                          */
/*                  BinkleyTerm Initial Fullscreen Setup                    */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifndef MILQ
#define WHOLEWIN
#endif

#ifdef MILQ
#define MENU_ENABLED
#if defined (MENU_ENABLED) || defined (MILQ)
#define RESOURCE_ENABLED
#endif
#endif

extern VIOMODEINFO vfos_mode;
void MilqMassageWnd( REGIONP Win, int Color );

void do_today ()
{
   char j[30];
   ADDR tmp;

   if (fullscreen)
      {

      (void) sprintf (j, "%d/%d", hist.bbs_calls, hist.mail_calls);
      (void) sprintf (junk, "%-8.8s", j);
      sb_move (history_hWnd, HIST_BBS_ROW, 2);
#ifndef MILQ
      sb_puts (history_hWnd, MSG_TXT(M_BBS_MAIL));
#endif
      sb_puts( GetDlgItem (history_hWnd, GD_BBS), junk );
      (void) sprintf (junk, "%-6d", hist.calls_made);

      sb_move (history_hWnd, HIST_ATT_ROW, 2);
#ifndef MILQ
      sb_puts (history_hWnd, MSG_TXT(M_CALLS_OUT));
#endif
      sb_puts( GetDlgItem (history_hWnd, GD_OUT), junk );

      (void) sprintf (j, "%d/%ld", hist.connects, hist.callcost);
      (void) sprintf (junk, "%-8.8s", j);

      sb_move (history_hWnd, HIST_CONN_ROW, 2);
#ifndef MILQ
      sb_puts (history_hWnd, MSG_TXT(M_GOOD_COST));
#endif
      sb_puts( history_Cost, junk );

      (void) sprintf (j, "%d/%d", hist.files_in, hist.files_out);
      (void) sprintf (junk, "%-8.8s", j);

      sb_move (history_hWnd, HIST_FILE_ROW, 2);
#ifndef MILQ
      sb_puts (history_hWnd, MSG_TXT(M_FILES_IO));
#endif
      sb_puts( history_Fl, junk );

      sb_move (history_hWnd, HIST_LAST_ROW, 2);
#ifndef MILQ
      sb_puts (history_hWnd, MSG_TXT(M_LAST));
#endif
      sb_puts( history_Last, MSG_TXT(M_LAST));
      }
   tmp = hist.last_addr;
   tmp.Domain = NULL;
   last_type (hist.last_caller, &tmp);
}

void bottom_line ()
{
   if (fullscreen)
      {
#ifdef WHOLEWIN
      sb_move (wholewin, SB_ROWS - 1, 0);
      (void) sb_putc (wholewin, ' ');
      sb_puts (wholewin, ANNOUNCE);
#ifdef OVERLAYS
      sb_puts (wholewin, "-Overlay");
#endif
      sb_puts (wholewin, CbMPILER_NAME);
      if (serial == -1)
         sb_puts (wholewin, MSG_TXT(M_UNREGISTERED));
      sb_move (wholewin, SB_ROWS - 1, SB_COLS - 23);
      sb_puts (wholewin, MSG_TXT(M_ALTF10));
#endif
      }
}

void put_up_time ()
{
   struct tm *tp;
   time_t ltime;

   if (fullscreen && (un_attended || doing_poll))
      {
      (void) time (&ltime);
      tp = localtime (&ltime);

      (void) sprintf (junk, "%s %s %02d @ %02d:%02d",
               wkday[tp->tm_wday], mtext[tp->tm_mon], tp->tm_mday,
               tp->tm_hour, tp->tm_min);
      sb_move (settings_hWnd, SET_TIME_ROW, SET_TIME_COL);
      sb_puts( settings_DtTm, junk );
      sb_show ();
      }
}

