//-------------------------------------------------------------------
//  FILE:               ERRORS.H
//
//  DESCRIPTION:        Enumerated errors specific to this
//                      application.
//
//  AUTHOR:             Carlos Yu ( 8/11/94 )
//                      Copyright (c) 1994, CYSoft Incorporated
//-------------------------------------------------------------------

#ifndef __ERRORS_H
#define __ERRORS_H

//-------------
//  Constants
//-------------

#define                 MAXSTRING     255

typedef enum
{                       //-------------------------------------------
    CY_SUCCESS,         //  No error occurred
    CY_REGISTER = 1016, //  Unable to register the window
    CY_ALREADYACTIVE,   //  The application is already active
    CY_MAINCREATE,      //  The window was not created
    CY_MAINDLGCREATE,   //  The main dialog could not be created
    CY_HOOKDLL,         //  Unable to load COMMENT.DLL
    CY_PROGLEN,         //  The length of the programmer is too long
    CY_COMPANYLEN,      //  The length of the company is too long
    CY_BWCCDLL,         //  Unable to load BWCC.DLL
    CY_DUMMY            //  Dummy entry
                        //-------------------------------------------
} APP_ERROR;

#endif
