
//-------------------------------------------------------------------- 
//  FILE:               COMMENT.C
//
//  DESCRIPTION:        Hook procedure for the commenter program
//
//  AUTHOR:             Carlos Yu ( 08/30/94 - 20:54:58 )
//
//                      Copyright (c), 1994 CYSoft Incorporated
//--------------------------------------------------------------------
//------------------------------
//  Compiler Specific Includes  
//------------------------------
                 
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#define STRICT
#include <windows.h>
#include <windowsx.h>

//---------------------------------
//  Application Specific Includes  
//---------------------------------

#include "comment.h"

#define                 FKEYS       111

//-----------------------------
//  Module/External Variables  
//-----------------------------                   

static HWND             _hWnd  = 0;
static HHOOK            _hHook = 0;

static BOOL             _bCtrlDown  = FALSE;
static BOOL             _bCheckCtrl = TRUE;

static BOOL             _bShiftDown  = FALSE;
static BOOL             _bCheckShift = TRUE;

static UINT             _msgHook = WM_RBUTTONDOWN;
static char             _keyCode [ 4 ];

#ifdef _BORLAND40

    extern const HINSTANCE _cdecl _hInstance;

#else

    HINSTANCE           _hInstance;

#endif

//-----------------------
//  Function Prototypes  
//-----------------------

LRESULT CALLBACK        MsgHookProc ( int, WPARAM, LPARAM );

//-------------------------------------------------------------------
//  FUNCTION:           SetHook
//
//  DESCRIPTION:        Installs or removes the message hook
//
//  ARGUMENTS:          bInstall - TRUE to install,  FALSE to remove
//                      hWnd     - Handle of the window to receive
//                                 user-defined messages when the 
//                                 hook finds a window to comment
//
//  RETURNS:            NONE
//-------------------------------------------------------------------

BOOL far PASCAL _export SetHook ( BOOL bInstall, HWND hWnd )
{           
    //--------------------------
    //  Save the window handle
    //--------------------------
    
    assert ( 0 != hWnd );

    _hWnd = hWnd;

    //---------------------------------
    //  Install or remove the hook???
    //---------------------------------

    if ( bInstall )
    {
        //---------------------------------------------
        //  An installation of the HOOK was requested
        //---------------------------------------------

        if ( 0 == _hHook )
        {
            _hHook = SetWindowsHookEx ( WH_GETMESSAGE, 
                         ( HOOKPROC ) MsgHookProc, _hInstance, 0 );
                         
            assert ( 0 != _hHook );
                                   
            return ( TRUE );
        }
        else
        {
            //------------------------------
            //  The hook is already active
            //------------------------------

            MessageBox ( 0, "The hook is already active", "ERROR", MB_OK );

            return ( FALSE );
        }
    }
    else
    {
        //-----------------------------
        //  Remove the installed HOOK
        //-----------------------------

        if ( 0 == _hHook )
        {
            //----------------------------------------------------
            //  Cannot remove a HOOK that has not been installed
            //----------------------------------------------------

            MessageBox ( 0, "Hook was never installed", "ERROR", MB_OK );

            return ( FALSE );
        }

        //--------------------
        //  Release the hook
        //--------------------

        if ( UnhookWindowsHookEx ( _hHook ) )
        {
            _hHook = 0;

            return ( TRUE );
        }
        else
        {
            //-----------------------------
            //  Unable to remove the HOOK
            //-----------------------------

            MessageBox ( 0, "Unable to remove the mouse HOOK", "ERROR", MB_OK );
            return ( FALSE );
        }                                               
    }
}

//-------------------------------------------------------------------
//  FUNCTION:           SetActiveMsg
//
//  DESCRIPTION:        Sets the message to intercept
//
//  ARGUMENTS:          uMsg - the message to intercept
//
//  RETURNS:            NONE
//-------------------------------------------------------------------

void far PASCAL _export SetActiveMsg ( UINT uMsg )
{
    //--------------------------------
    //  Set the message to intercept  
    //--------------------------------
    
    assert ( ( WM_KEYDOWN )                ||
             ( WM_RBUTTONDOWN == uMsg )    ||
             ( WM_MBUTTONDOWN == uMsg ) );

    _msgHook = uMsg;
}

//-------------------------------------------------------------------
//  FUNCTION:           SetShiftKey
//
//  DESCRIPTION:        Sets the value of the shift key flag
//
//  ARGUMENTS:          bShift
//
//  RETURNS:            NONE
//-------------------------------------------------------------------

void far PASCAL _export SetShiftKey ( BOOL bShift )
{
    _bCheckShift = bShift;
}


//-------------------------------------------------------------------
//  FUNCTION:           SetVirtualKey
//
//  DESCRIPTION:        Sets the value of the virtual key
//
//  ARGUMENTS:          vkCode - the virtual key code
//
//  RETURNS:            NONE
//-------------------------------------------------------------------

void far PASCAL _export SetVirtualKey ( char *vkCode )
{
    strcpy ( _keyCode, vkCode );
} 

//-------------------------------------------------------------------
//  FUNCTION:           SetCtrlKey
//
//  DESCRIPTION:        Sets the value of the ctrl key flag
//
//  ARGUMENTS:          bCtrl
//
//  RETURNS:            NONE
//-------------------------------------------------------------------

void far PASCAL _export SetCtrlKey ( BOOL bCtrl )
{
    _bCheckCtrl = bCtrl;
} 
 

//-------------------------------------------------------------------
//  FUNCTION:           MsgHookProc
//
//  DESCRIPTION:        Callback function called whenever there is
//                      a message to be processed
//
//  ARGUMENTS:          code   - process message flag
//                      wParam - message identifier
//                      lParam - address of MOUSEHOOKSTRUCT
//
//  RETURNS:            0 to process, 1 to discard message
//-------------------------------------------------------------------

LRESULT CALLBACK        MsgHookProc ( int code, WPARAM wParam, LPARAM lParam )
{
    MSG*                lpMsgHook;

    HWND                hWndParent; 
    
    char                tmpBuffer [ 5 ];        
    
    char                szClassName [ 255 ];    
    
    //-----------------------------------------
    //  Check if the message can be processed  
    //-----------------------------------------
    
    if ( 0 > code )
        return ( CallNextHookEx ( _hHook, code, wParam, lParam ) );
        
    //------------------------------
    //  Get the message parameters 
    //------------------------------
    
    lpMsgHook = ( MSG* ) lParam;
    
    switch ( lpMsgHook->message )
    {
        case WM_KEYUP:
        
            //--------------------
            //  Toggle key flags 
            //--------------------
        
            if ( VK_SHIFT == lpMsgHook->wParam )
                _bShiftDown = FALSE;
                
            if ( VK_CONTROL == lpMsgHook->wParam )
                _bCtrlDown = FALSE;                
                
            break;
            
        case WM_KEYDOWN:          
        
            //--------------------
            //  Toggle key flags 
            //--------------------        
        
            if ( VK_SHIFT == lpMsgHook->wParam )
                _bShiftDown = TRUE;
                
            if ( VK_CONTROL == lpMsgHook->wParam )
                _bCtrlDown = TRUE;                
            
        case WM_RBUTTONDOWN:
        case WM_MBUTTONDOWN:
        
            if ( lpMsgHook->message == _msgHook )
            {
                //-------------------------------
                //  Check if the hotkey matches  
                //-------------------------------
                
                if ( WM_KEYDOWN == _msgHook )
                {                   
                    int lKey;
                    
                    if ( 'F' == _keyCode [ 0 ] )
                    {                                      
                        strcpy ( tmpBuffer, _keyCode + 1 );
                        lKey = atoi ( tmpBuffer );
                        lKey += FKEYS;
                    }  
                    else
                        lKey = _keyCode [ 0 ];
                    
                    //--------------------------------
                    //  Check if the hot key matches   
                    //--------------------------------
                    
                    if ( lKey != ( int ) lpMsgHook->wParam )
                        return ( CallNextHookEx ( _hHook, code, wParam, lParam ) );        
                }
                    
                //---------------------------
                //  Check for the shift key  
                //---------------------------
        
                if ( ( TRUE == _bCheckShift ) && ( FALSE == _bShiftDown ) )
                    return ( CallNextHookEx ( _hHook, code, wParam, lParam ) );        
                else
                {
                    SendMessage ( lpMsgHook->hwnd, WM_KEYUP, VK_SHIFT, 0L );
                    _bShiftDown = FALSE;
                }
                    
                //-----------------------------
                //  Check for the control key  
                //-----------------------------
        
                if ( ( TRUE == _bCheckCtrl ) && ( FALSE == _bCtrlDown ) )
                    return ( CallNextHookEx ( _hHook, code, wParam, lParam ) );                    
                else
                {
                    SendMessage ( lpMsgHook->hwnd, WM_KEYUP, VK_CONTROL, 0L );
                    _bCtrlDown = FALSE;
                }
            
                GetClassName ( lpMsgHook->hwnd, szClassName, 255 );

                //-----------------------------------
                //  Check for a powerbuilder window
                //-----------------------------------

                if ( 0 == ( strcmp ( szClassName, "Edit" ) ) )
                {                                                           
                    //---------------------------
                    //  We found an edit window
                    //---------------------------

                    hWndParent = GetParent ( lpMsgHook->hwnd );
                    GetClassName ( hWndParent, szClassName, 255 );

                    if ( 0 == ( strcmp ( szClassName, "pbscr030" ) ) )
                    {                                                
                        //-------------------------------------------                        
                        //  The edit window belongs to Powerbuilder
                        //-------------------------------------------

                        SendMessage ( _hWnd, WM_POWERBUILDER, 0,
                            ( LPARAM ) lpMsgHook->hwnd );
                    }

                }
                else if ( 0 == ( strcmp ( szClassName, "EditWindClass" ) ) )
                {
                    //-----------------------------------
                    //  Found the Borland editor window
                    //-----------------------------------
                                            
                    SendMessage ( _hWnd, WM_BORLAND, 0,
                        ( LPARAM ) lpMsgHook->hwnd );                                 
                }
                else if ( 0 == ( strcmp ( szClassName, "MSVCEditWindow" ) ) )
                {
                    //------------------------------------
                    //  Found the Visual C++ edit window
                    //------------------------------------
                                                                                                                     
                    SendMessage ( _hWnd, WM_MICROSOFT, 0,
                        ( LPARAM ) lpMsgHook->hwnd );                        
                }
            }
            
            break;
    }
    
    //---------------------------------
    //  Pass control to the next hook  
    //---------------------------------
        
    return ( CallNextHookEx ( _hHook, code, wParam, lParam ) );    
}
                
                
