






  PRODUCT  :  Borland C++                           NUMBER  :  1789
  VERSION  :  4.0
       OS  :  WIN
     DATE  :  March 21, 1994                           PAGE  :  1/5

    TITLE  :  REMOVING EXCEPTION HANDLING FROM YOUR APP OR DLL




  REMOVING EXCEPTION HANDLING FROM YOUR APPLICATION OR DLL
  ========================================================

  This document covers how to remove exception handling from an
  application or DLL written with Borland C++ 4.0.

  Note: If your purpose in reading this document is solely to
  disable the new operator from throwing an xalloc exception,
  you should use the set_new_handler function to do this instead
  of the steps outline in this document.

  Requirements if you do remove exception handling
  ------------------------------------------------

  It is important to know the limitations placed on your code if
  the exception handling code is removed, since unstable programs
  may result if exceptions are then used.  The obvious requirement
  is that you do not want to use exceptions in your own code. i.e.
  the keywords try, catch, throw, __try, __except, and __finally
  are taboo.  The more subtle requirement is that you do not want
  to use any code or classes that use exception handling, either
  directly by linking them into your code, or indirectly by using
  a DLL which uses exception handling (including the DLL version
  of the Runtime Library).  Here's a list of the classes and
  libraries which we know cause exception handling to be added to
  your application and should not be used (or their header files
  included):

    * the OWL II classes  (\bc4\include\owl\*.h)
    * the BIDS class libraries  (\bc4\include\classlib\*.h)
    * class TRegExp  (regexp.h)
    * class string  (cstring.h)
    * class TSubString  (cstring.h)
    * the C++ diagnosic macros  (checks.h)
    * the setjmp/longjmp functions (setjmp.h)

  How to remove exception handling
  --------------------------------

  This table shows which of the following steps you need to take
  to remove exception handling from your program, depending on
  the language the program is written in and whether it is a DLL
  or an EXE.  In all cases, you will want to turn off the enable







  PRODUCT  :  Borland C++                           NUMBER  :  1789
  VERSION  :  4.0
       OS  :  WIN
     DATE  :  March 21, 1994                           PAGE  :  2/5

    TITLE  :  REMOVING EXCEPTION HANDLING FROM YOUR APP OR DLL




  exception handling option of the compiler (-x-).

                             Language

                         C++             C
                   -------------------------------
               EXE | Steps 1 & 2 |    Step 1     |
      Target       |-------------|---------------|
               DLL |   Step 2    |               |
                   -------------------------------

    Step 1
    ------
    Replace the standard version of the exception initialization
    routine with a dummy version by adding the following code
    somewhere in your application.

      #ifdef __cplusplus
      extern "C"
      #endif
      void _ExceptInit(void) {}

    Step 2
    ------
    Since the standard handling of new throws an xalloc exception,
    and instanciates a global instance of xalloc, we need to
    replace it.  Adding the following code to your project, either
    as a separate .CPP file or by merging the code into your own,
    will replace the standard implementation of new in the
    runtime libraries.

      #include <stddef.h>
      #include <stdlib.h>
      #include <new.h>

      new_handler _new_handler = NULL;

      new_handler set_new_handler(new_handler p)
      {
          new_handler t = _new_handler;
          _new_handler = p;
          return t;
      }







  PRODUCT  :  Borland C++                           NUMBER  :  1789
  VERSION  :  4.0
       OS  :  WIN
     DATE  :  March 21, 1994                           PAGE  :  3/5

    TITLE  :  REMOVING EXCEPTION HANDLING FROM YOUR APP OR DLL




      void *operator new( size_t size )
      {
          void * p = 0;

          size = size ? size : 1;
          while ( (p = malloc(size)) == NULL &&
                  _new_handler != NULL)
              _new_handler();

          return p;
      }

      void far * operator new(unsigned long size)
      {
          void far * p;
          size = size ? size : 1;
          while ( (p = farmalloc(size)) == NULL &&
                  _new_handler != NULL)
              _new_handler();
          return p;
      }


  Checking to make sure exceptions are gone
  -----------------------------------------

  You can verify exception handling has been removed from your
  program by examining a detailed map file (-s for TLINK).  If
  you find any of the following symbols, exception handling was
  not fully removed:

    In the 'Detailed Map of Segments' section:
      1. S=_TEXTB
      2. S=_TEXTC

    In the 'Publics by Name' section:
      1. __InitExceptBlock
      2. _throwexception

  If you do find any of these symbols, then you'll need to verify
  that the functions and variables defined in Steps 1 & 2 above
  are actually replacing their corresponding versions in the
  runtime libraries.  You can do this by turning on the 'Warn







  PRODUCT  :  Borland C++                           NUMBER  :  1789
  VERSION  :  4.0
       OS  :  WIN
     DATE  :  March 21, 1994                           PAGE  :  4/5

    TITLE  :  REMOVING EXCEPTION HANDLING FROM YOUR APP OR DLL




  duplicate symbols' warning on the linker (-d for TLINK).  You
  should see duplicates for all the symbols in steps you applied.

  An example
  ----------

  This is an example of a Windows DLL compiled with C++ which
  has exception handling removed.  You can use the file
  NOEXCEPT.CPP in your own project to remove exception handling:

  //=============================================================
  // NOEXCEPT.CPP - can be compiled as C or C++
  //=============================================================
  #ifndef __DLL__

  #ifdef __cplusplus
  extern "C"
  #endif // __cplusplus
  void _ExceptInit(void) {}

  #endif // __DLL__

  #ifdef __cplusplus
  #include <alloc.h>
  #include <new.h>

  new_handler _new_handler = NULL;

  new_handler set_new_handler(new_handler p)
  {
      new_handler t = _new_handler;
      _new_handler = p;
      return t;
  }

  void *operator new( size_t size )
  {
      void * p = 0;

      size = size ? size : 1;
      while ( (p = malloc(size)) == NULL &&
              _new_handler != NULL)
          _new_handler();







  PRODUCT  :  Borland C++                           NUMBER  :  1789
  VERSION  :  4.0
       OS  :  WIN
     DATE  :  March 21, 1994                           PAGE  :  5/5

    TITLE  :  REMOVING EXCEPTION HANDLING FROM YOUR APP OR DLL




      return p;
  }

  void far * operator new(unsigned long size)
  {
      void far * p;
      size = size ? size : 1;
      while ( (p = farmalloc(size)) == NULL &&
              _new_handler != NULL)
          _new_handler();
      return p;
  }

  #endif // __cplusplus

  //=============================================================
  // TESTDLL.CPP
  //=============================================================
  #include <windows.h>

  int WINAPI _export CallMe( void )
  {
    return 0;
  }

  #pragma argsused
  int FAR PASCAL LibMain( HINSTANCE hinst, WORD wDataSeg, WORD
        cbHeapSize, LPSTR lpszCmdLine )
  {
    return 1;
  }

  //=============================================================
  // BUILDDLL.BAT
  //=============================================================
  bcc -ml -WDE -ls -x- testdll.cpp noexcept.cpp
  rc testdll.dll


  DISCLAIMER: You have the right to use this technical information
  subject to the terms of the No-Nonsense License Statement that
  you received with the Borland product to which this information
  pertains.
