/* @(#) %M% V%I% %H%
//
// File name
// -------------
// NTTESTC.C
//
// (c) Cavendish Software Ltd 1991, 1992, 1993, 1994
//
// File Description
// ----------------
// "C" Test Program for NewTrack v3.0/Windows
//
*/

#include "newtrack.hpp"
#include "ntdlltst.hpp"

#include <windows.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>

#if defined(_BORLAND_VER) && NT_WIN32
# define __try try
#endif


/* Callback routine */
#if defined(_BORLAND_VER)
#pragma argsused
#endif
void CALLBACK MyNewTrackCallback(LPNT_CALLBACKDATA pData,
	LPNT_CALLBACKDATA pSharedData)
{
	/* Break into the debugger */
	DebugBreak();
}

#if defined(_BORLAND_VER)
#pragma argsused
#endif
#if defined(_CONSOLE)
int main(int argc, char **argv)
#else
int FAR PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpszCmdLine, int nCmdShow)
#endif
{
	void	*pvMem1;
	void	*pvMem2;
    char	*pcMem2;
	char	*copy;
	char	*p;
	char	NT_HUGE *large_array;

/* Under Windows NT, INT 3's (hard-coded breakpoints) cause the app to
//	terminate if the debugger is not running, so we must trap it (if
//	the debugger is running, it will get there first).
*/
#if NT_WIN32
	int EvalBreakpointException(int nExceptionCode, LPEXCEPTION_POINTERS lpExceptionInfo);
	__try {
#endif

	/* Turn on NewTrack, and record a stack trace of unfreed memory
	//	allocations in NTTEST.LOG
    */
	NT_Initialise(NTF_NO_FLAGS, MyNewTrackCallback);
	NT_SetLogFile("NTTEST.LOG");

	// Allocate some memory...
	pvMem1 = malloc(1024);
	pvMem2 = malloc(1024);
    pcMem2 = (char *)pvMem2;

	free(pvMem1);

	/* Oops! Pointer underrun */
	*(pcMem2-2)=0;
	free(pvMem2);				/* Free()ing is where the over/under runs are detected */

	/* Get some more memory */
	pvMem2 = malloc(1024);
	pcMem2 = (char *)pvMem2;
	*(pcMem2+1025) = 0;			/* Oops again! Pointer overrun */
	free(pvMem2);				/* Free()ing is where the over/under runs are detected */

	/* Oops! 'a' is already deleted */
	free(pvMem1);

	/* strdup() returns a copy of the passed string.  If you are using
	//	the DLL version of the Borland Run-Time Library, then this string
	//	will have been allocated by malloc() and *not* registered with NewTrack.
	//	This will cause an "Invalid Pointer passed to delete" message when you
	//	free() it.  (Unless you have modified the RTL DLL)
    */
	copy = strdup("hello world");
	free(copy);

	/* Allocate a test block; this will also test operator new[](unsigned) */
	p = (char *) malloc(100);

	NT_AssertPointer(p, p + 10, 1);		/* Can we use the 1 byte at p+10? (Yes) */
	NT_AssertOffset(p, 10, 1);			/* Can we use the 1 byte at p+10? (Yes) */
	NT_AssertPointer(p, p + 100, 1);	/* Can we use the 1 byte at p+100? (No) */
	NT_AssertOffset(p, 100, 1);			/* Can we use the 1 byte at p+100? (No) */
	NT_AssertPointer(p, p + 99, 1);		/* Can we use the 1 byte at p+99? (Yes) */
	NT_AssertOffset(p, 99, 1);			/* Can we use the 1 byte at p+99? (Yes) */
	NT_AssertPointer(p, p + 99, 2);		/* Can we use the 2 bytes at p+99? (No) */
	NT_AssertOffset(p, 99, 2);			/* Can we use the 2 bytes at p+99? (No) */
	NT_AssertPointer(p, NULL, 0);		/* Is p a valid object? (Yes)           */

	malloc(100);	/* We're not going to free this....     */

	/* Next, we need to test that all the functions work. */
#if !defined(_MSC_VER)
	large_array = (char NT_HUGE *)farmalloc(70000L);
#else
	large_array = (char NT_HUGE *)farmalloc(70000L);
#endif

	free(large_array);

	/* This will (should) give you an "Invalid Pointer passed to delete"
	//	message...
    */
	free(large_array);

	/* This will free the "malloc(20)" twice, and then return a new pointer */
	p = NewTrackDLLTest((char *)malloc(20));
	free(p);

	/* Incidentally, I cannot find a way of testing operator new (unsigned long)
	//	under Borland v4.0.  It is not possible to create a structure >64K, and
	//	arrays larger than 64K pass through operator new[](unsigned long).  Is
	//	this obsolete?


	// There should be 5 unfreed allocations:
	//	In this file:
	//	1) Line  73: "pvMem2 = malloc..." - this is unfreed because of an under run
	//	2) Line  83: "pvMem2 = malloc..." - this is unfreed because of an overrun
	//	3) Line 101: "p = (char *) malloc(..."
	//	4) Line 113: "malloc(..."
	//
	//	In NTDLLTST.CPP
	//	5) Line  31: "new char [4000];"
	//
	// You should also get 12 NewTrack Error dialog boxes (system-modal),
	//	excluding the dialog box reporting the number of unfreed allocations.
	//  BUT: If you are using the unmodified DLL version of the run-time 
	//	library, you will get an additional "Invalid Pointer..." message
	//	for line 111 where the return from strdup() is freed.
    */

	NT_Terminate();				/* Stop NewTrack, and check for unfreed allocations */

/* Trap the INT 3 under Windows NT to prevent termination */
#if NT_WIN32
	} __except( EvalBreakpointException(GetExceptionCode(), GetExceptionInformation()) )
	{
		/* Nothing */
	}
#endif

	return 0;
}

#if NT_WIN32
int EvalBreakpointException(int nExceptionCode, LPEXCEPTION_POINTERS lpExceptionInfo)
{
	/* If it's a breakpoint (INT 3)... */
	if (nExceptionCode == EXCEPTION_BREAKPOINT)
	{
		unsigned char *pInstruction =
			(unsigned char *)lpExceptionInfo->ExceptionRecord->ExceptionAddress;

		/* If the instruction was INT 3, skip to the next instruction */
		if (*pInstruction == 0xCC)
			lpExceptionInfo->ContextRecord->Eip++;

		return EXCEPTION_CONTINUE_EXECUTION;
	}

	/* Let the system handle it */
	return EXCEPTION_CONTINUE_SEARCH;
}
#endif

