//
// $Id: NTTEST.CPP,v 1.2 1994/08/01 13:38:32 john Exp john $
//
// File name
// -------------
// NTTEST.CPP
//
//
// Written by John Spackman
// (c) Cavendish Software Limited, 1992-1994
//
//
// File Description
// ----------------
// Test Program for NewTrack v3.0/Windows
//
//
// Change Log
// ----------
// $Log: NTTEST.CPP,v $
// Revision 1.2  1994/08/01  13:38:32  john
// *** empty log message ***
//
// Revision 1.1  1994/06/10  11:31:08  john
// Initial revision
//
//
//

#include "newtrack.hpp"
#include "ntdlltst.hpp"

#include <windows.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>

#if defined(_BORLAND_VER) && NT_WIN32
# define __try try
#endif


class A
{
public:
	int a1;
};

class B : public A
{
public:
	int b1;
};


// Callback routine
#if defined(_BORLAND_VER)
#pragma argsused
#endif
void CALLBACK MyNewTrackCallback(NT_CALLBACKDATA FAR *pData,
	NT_CALLBACKDATA FAR *pSharedData)
{
	// Break into the debugger
	DebugBreak();
}

#if defined(_BORLAND_VER)
#pragma argsused
#endif
#if defined(_CONSOLE)
int main(int argc, char **argv)
#else
int FAR PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpszCmdLine, int nCmdShow)
#endif
{

// Under Windows NT, INT 3's (hard-coded breakpoints) cause the app to
//	terminate if the debugger is not running, so we must trap it (if
//	the debugger is running, it will get there first).
#if NT_WIN32
	int EvalBreakpointException(int nExceptionCode, LPEXCEPTION_POINTERS lpExceptionInfo);
	__try {
#endif

	// Turn on NewTrack, and record a stack trace of unfreed memory
	//	allocations in NTTEST.LOG
	NT_Initialise(NTF_NO_FLAGS, MyNewTrackCallback);
	NT_SetLogFile("NTTEST.LOG");

	// Initialise the Test DLL if we're using stand-alone NewTracks
#if defined(STANDALONE_DLL_TEST)
	NTDLLTST_Initialise();
#endif

	// Allocate a few variables...
	A *a = new A;
	B *b = new B;
	char *c = (char *)b;

	delete a;

	// Oops! Pointer underrun
	*(c-2)=0;
	delete b;					// Deleting 'b' is where the over/under runs are detected

	// Get another B
	b = new B;
	c = (char *)b;
	*(c+sizeof(B)+1) = 0;		// Oops again! Pointer overrun
	delete b;					// Deleting 'b' is where the over/under runs are detected

	// Oops! 'a' is already deleted
	delete a;

	// strdup() returns a copy of the passed string.  If you are using
	//	the DLL version of the Borland Run-Time Library, then this string
	//	will have been allocated by malloc() and *not* registered with NewTrack.
	//	This will cause an "Invalid Pointer passed to delete" message when you
	//	free() it.  (Unless you have modified the RTL DLL)
	char *copy = strdup("hello world");
	free(copy);

	// Allocate a test block; this will also test operator new[](unsigned)
	char *p = new char [100];

	NT_AssertPointer(p, p + 10, 1);		// Can we use the 1 byte at p+10? (Yes)
	NT_AssertOffset(p, 10, 1);			// Can we use the 1 byte at p+10? (Yes)
	NT_AssertPointer(p, p + 100, 1);	// Can we use the 1 byte at p+100? (No)
	NT_AssertOffset(p, 100, 1);			// Can we use the 1 byte at p+100? (No)
	NT_AssertPointer(p, p + 99, 1);		// Can we use the 1 byte at p+99? (Yes)
	NT_AssertOffset(p, 99, 1);			// Can we use the 1 byte at p+99? (Yes)
	NT_AssertPointer(p, p + 99, 2);		// Can we use the 2 bytes at p+99? (No)
	NT_AssertOffset(p, 99, 2);			// Can we use the 2 bytes at p+99? (No)
	NT_AssertPointer(p, NULL, 0);		// Is p a valid object? (Yes)

	{	// Define a block so that the destructor gets called before NT_Terminate()...
		B	z;

		NT_AssertPointer(&z, NULL, 0);	// Is this stack object OK? (Yes)
		NT_AssertPointer(&z, p, 1);		// Is p within this stack object? (No)
	}

	a = new A;							// We're not going to free this....

	// Next, we need to test that all the operators work.
	char			*small_array;
	char			NT_HUGE *large_array;

	small_array = new char [100];		// operator new[](unsigned)
#if !defined(_MSC_VER)
	large_array = new char NT_HUGE [70000L];	// operator new[](unsigned long)
#else
	large_array = new char [100];		// MS-VC++ does not support large arrays
#endif
	a = new A;							// operator new(unsigned)

	// If these all succeed, then we will check that all types of delete
	//	are being detected by re-deleting the pointers.
	delete [] small_array;				// operator delete[](void *)
	delete [] large_array;				// operator delete[](void far *)
	delete a;							// operator delete(void *)

	// This will (should) give you three "Invalid Pointer passed to delete"
	//	messages...
	delete [] small_array;				// operator delete[](void *)
	delete [] large_array;				// operator delete[](void far *)
	delete a;							// operator delete(void *)

	// This will free the "new char [20]" twice, and then return a new pointer
	p = NewTrackDLLTest(new char [20]);
	delete [] p;

	// Incidentally, I cannot find a way of testing operator new (unsigned long)
	//	under Borland v4.0.  It is not possible to create a structure >64K, and
	//	arrays larger than 64K pass through operator new[](unsigned long).  Is
	//	this obsolete?


	// There should be 5 unfreed allocations:
	//	In this file:
	//	1) Line  95: "B *b = new B;" - this is unfreed because of an under run
	//	2) Line 105: "b = new B;" - this is unfreed because of an overrun
	//	3) Line 122: "char *p = new char [100];"
	//	4) Line 141: "a = new A"
	//
	//	In NTDLLTST.CPP
	//	5) Line  43: "new char [4000];"
	//
	// You should also get 12 NewTrack Error dialog boxes (system-modal),
	//	excluding the dialog box reporting the number of unfreed allocations.
	//  BUT: If you are using the unmodified DLL version of the run-time
	//	library, you will get an additional "Invalid Pointer..." message
	//	for line 111 where the return from strdup() is freed.

	// Terminate the Test DLL if we're using stand-alone NewTracks
#if defined(STANDALONE_DLL_TEST)
	NTDLLTST_Terminate();
#endif

	NT_Terminate();				// Stop NewTrack, and check for unfreed allocations

// Trap the INT 3 under Windows NT to prevent termination
#if NT_WIN32
	} __except( EvalBreakpointException(GetExceptionCode(), GetExceptionInformation()) )
	{
		// Nothing
	}
#endif

	return 0;
}

#if NT_WIN32
int EvalBreakpointException(int nExceptionCode, LPEXCEPTION_POINTERS lpExceptionInfo)
{
	// If it's a breakpoint (INT 3)...
	if (nExceptionCode == EXCEPTION_BREAKPOINT)
	{
		unsigned char *pInstruction =
			(unsigned char *)lpExceptionInfo->ExceptionRecord->ExceptionAddress;

		// If the instruction was INT 3, skip to the next instruction
		if (*pInstruction == 0xCC)
			lpExceptionInfo->ContextRecord->Eip++;

		return EXCEPTION_CONTINUE_EXECUTION;
	}

	// Let the system handle it
	return EXCEPTION_CONTINUE_SEARCH;
}
#endif

