//	@(#) %M% V%I% %H%
//
// CHEAP.HPP
//
// Header file for CHeap, a Windows 3.1 suballocator that uses
//	LocalXxxx() functions to manage memory in multiple heaps.
//	Includes Win32-compatible HeapXxxx() allocation function
//	emulation.
//
// Written by John Spackman
// (c) Cavendish Software Limited 1994
//


#if !defined(__CHEAP_HPP)
#define __CHEAP_HPP


#if defined(__FLAT__) | defined(_WIN32)
# error CHeap does not support Win32
#endif
#if defined(__DLL__) || defined(_WINDLL)
# define CHEAP_APICALL	FAR PASCAL _export
#else
# define CHEAP_APICALL	FAR PASCAL
#endif


// HEADER FILES
#if !(defined(__WINDOWS_H) || defined(_INC_WINDOWS))
#include <windows.h>
#endif


// PREPROCESSOR SYMBOL DEFINITIONS -- HeapXxx() flags
#define HEAP_GENERATE_EXCEPTIONS	0x0000		// Not supportable in Win16
#define HEAP_NO_SERIALIZE			0x0000		// Not supported in Win16
#define HEAP_ZERO_MEMORY			0x0001		// Causes all initialised memory to be zero-ed
//#define HEAP_REALLOC_IN_PLACE_ONLY	0x0000	// Not supportable in Win16


// PREPROCESSOR SYMBOL DEFINITIONS -- CHeap sizes/restrictions
#define CHEAP_NEWBLOCK_THRESHOLD	(0x7000)	// Size above which a new CHeapBlock will be created
#define CHEAP_HEAPBLOCK_SIZE		(0x7000)	// Size of one CHeapBlock
#define CHEAP_LOCALINIT_EXTRA		(0x20)		// Overhead allowed for local heap functions
#define CHEAP_MAXALLOC_SIZE			(0x7fff - CHEAP_LOCALINIT_EXTRA)


// FUNCTION PROTOTYPES -- LocalXxxx() replacement functions which
//	allow a selector to be specified

#if defined(__cplusplus)
extern "C" {
#endif

HLOCAL BasedLocalAlloc(UINT uiHeapSel, UINT fuAllocFlags, UINT uSize);
UINT BasedLocalCompact(UINT uiHeapSel, UINT uiMinSize);
UINT BasedLocalFlags(UINT uiHeapSel, HLOCAL hLcl);
HLOCAL BasedLocalFree(UINT uiHeapSel, HLOCAL hLcl);
HLOCAL BasedLocalHandle(UINT uiHeapSel, LPVOID lpvMem);
LPVOID BasedLocalLock(UINT uiHeapSel, HLOCAL hLcl);
HLOCAL BasedLocalReAlloc(UINT uiHeapSel, HLOCAL hLcl, UINT uNewSize, UINT uFlags);
UINT BasedLocalSize(UINT uiHeapSel, HLOCAL hLcl);
BOOL BasedLocalUnlock(UINT uiHeapSel, HLOCAL hLcl);


// FUNCTION PROTOTYPES -- Win32 Heap allocation simulation routines

// Creates a heap
HANDLE CHEAP_APICALL HeapCreate(DWORD fFlags, DWORD uiInitSize, DWORD uiMaxSize);

// Destroys a heap
BOOL CHEAP_APICALL HeapDestroy(HANDLE hHeap);

// Allocates memory from the specified heap
LPVOID CHEAP_APICALL HeapAlloc(HANDLE hHeap, DWORD fFlags, DWORD uiSize);

// Frees previously allocated memory to the heap
BOOL CHEAP_APICALL HeapFree(HANDLE hHeap, DWORD fFlags, LPVOID lpvMem);

// Adjusts the size of an existing block
LPVOID CHEAP_APICALL HeapReAlloc(HANDLE hHeap, DWORD fFlags, LPVOID lpvMem, DWORD uiSize);

// Returns the size of the heap object
DWORD CHEAP_APICALL HeapSize(HANDLE hHeap, DWORD fFlags, LPVOID lpvMem);


#if defined(__cplusplus)
}
#endif

#endif // d(__CHEAP_HPP)

