BASEDIR=..\..
HAVEALLSOURCE=N
#
# FileName
# --------
# DISTRIB.MAK
#
# Description
# -----------
# Makefile for generating Distribution kit.
#
# This will build directories using the following naming convention:
#
#	NEWT_<Type><Caller-Type><Memory-Model>
#
# Where:
#	<Type>			is the type of NewTrack build: S (Stand alone) or Dll
#	<Caller-Type>	is where the library is to be built (Exe or Dll)
#	<Memory-Model>	is the memory model (Large or Flat)
#
#	NEWT_SEL		-	Stand-alone for linking into Large model executables
#	NEWT_SDL		-	Stand-alone for linking into Large model DLLs
#	NEWT_DEL		-	DLL Version for linking into Large model executables
#	NEWT_DDL		-	DLL Version for linking into Large model DLLs
#
# In addition, the NEWT_DLL directory is made to contain the DLL
#
# The libraries are placed in the current directory.  The compiler and
#	it's configuration are chosen with the following *required* macros:
#
#	COMPILER		-	Compiler (BOR or MSVC)
#	COMPILERVER		-	Version (31 or 40 for Borland, 15 or 10 for MSVC)
#	BUILDTYPE		-	S or D		(NewTrack as Stand-Alone or DLL)
#	CALLERTYPE		-	E or D		(NewTrack called from a .DLL or .EXE)
#	MODEL			-	L or F		(Memory Model)
#	MAKEDLL			-	Y or N		(Make the NEWTRACK.DLL)
#	SHAREWARE		-	Y or N		(Shareware or full (sold) version)
#
# Optional macros:
#	DEBUG			-	Y or N (default)	(Debug build)
#	MAKETEST		-	Y or N (default)	(Make test program/dll)
#
#
#
# Queries:
#	Console or GUI?
#	RTL or static library?
#	Multithreaded?
#


all:	makeall

!ifdef INCLUDEFILE
!include $(INCLUDEFILE)
!endif


!ifndef BASEDIR
BASEDIR=..\..\..\..
!endif
!ifndef HAVEALLSOURCE
HAVEALLSOURCE=Y
!endif
THISMAKEFILE=$(BASEDIR)\distrib.mak
USEDEFFILE=N

!ifndef MAKETEST
MAKETEST=N
!endif

!if "$(MAKEDLL)"=="Y"
MAKETEST=N
!endif

!if "$(MAKEDLL)"=="Y"
!if "$(BUILDTYPE)"!="D" || "$(CALLERTYPE)"!="D"
!error BUILDTYPE and CALLERTYPE must both be D (for DLL) when building the DLL (MAKEDLL==Y)
!endif
!if "$(MAKETEST)"!="N"
!error Cannot build test app(s) when MAKEDLL==Y
!endif
!endif


!ifndef COMPILERID
!error COMPILERID not defined
!endif


#####################################################################################################
#
# RELSRCDIR			-	directory for released source code
# RELINCDIR			-	directory for released include files
# UNRELSRCDIR		-	directory for unreleased source code
# UNRELINCDIR		-	directory for unreleased include files
# CFXSRCDIR			-	directory for the Cavendish Frameworks library source (unreleased)
# CFXINCDIR			-	directory for the Cavendish Frameworks library headers (unreleased)
# LIB_MONIKER		-	name of the dir/lib file for the current macro settings
# DLLLIB_MONIKER	-	name for the CALLERTYPE==DLL version of the current lib
# EXELIB_MONIKER	-	name for the CALLERTYPE==EXE version of the current lib
# MONIKER			-	name of the directory and .LIB file we are about to generate
# OUTPUTDIR			-	complete name of the output directory for .OBJS
# LIBNAME			-	complete name of the .LIB file to generate
# EXE_LIBNAME		-	complete name of the .LIB file for EXEs for the current BUILDTYPE
# DLL_LIBNAME		-	complete name of the .LIB file for DLLs for the current BUILDTYPE
# DLLNAME			-	complete name of the DLL (if we generate it)
# DLLLIBNAME		-	complete name of the DLL's import library
# NTTEST_EXENAME	-	name of the NewTrack test app
# NTDLLTST_LIBNAME	-	name of the test app's DLL's import library (if we build it)
# NTDLLTST_DLLNAME	-	name of the test app's DLL (if we build it)
# THISTARGET		-	final target for this build
#

RELSRCDIR		=..\..\source
RELINCDIR		=..\..\include
UNRELSRCDIR		=$(BASEDIR)\..\source\newtrack
UNRELINCDIR		=$(BASEDIR)\..\source\newtrack
CFXSRCDIR		=$(BASEDIR)\..\source\cfx
CFXINCDIR		=$(BASEDIR)\..\source\cfx
CHEAPSRCDIR		=$(BASEDIR)\..\source\cheap
CHEAPINCDIR		=$(BASEDIR)\..\source\cheap
USECHEAP		=N

#
# Need To Know:
#
#	1. Name of .LIB to generate or to link in
#	2. Name of .LIB for .EXEs
#	3. Name of .LIB for .DLLs
#	4. Name of .DLL to generate
#
#

BUILDTYPE_DIRNAME	=$(BUILDTYPE)
!ifdef NT_USING_MFC
BUILDTYPE_DIRNAME	=X
!else
!ifdef NT_USING_OWL
BUILDTYPE_DIRNAME	=X
!endif
!endif


LIBEXE_NEWTRACK		=NEWT_$(BUILDTYPE_DIRNAME)E$(MODEL).lib
LIBDLL_NEWTRACK		=NEWT_$(BUILDTYPE_DIRNAME)D$(MODEL).lib

!if "$(CALLERTYPE)"=="E"
LIB_NEWTRACK		=$(LIBEXE_NEWTRACK)
!else
LIB_NEWTRACK		=$(LIBDLL_NEWTRACK)
!endif
DLL_NEWTRACK		=NEWT_DLL.dll
DLL_NEWTRACK_IMPLIB	=NEWT_DLL.lib
MAP_NEWTRACK		=NEWT_DLL.map

!if "$(MAKETEST)"=="Y"
MONIKER				=TST_$(BUILDTYPE)$(CALLERTYPE)$(MODEL)
!else
!if "$(MAKEDLL)"=="Y"
MONIKER				=NEWT_DLL
!else
MONIKER				=NEWT_$(BUILDTYPE_DIRNAME)$(CALLERTYPE)$(MODEL)
!endif
!endif

OUTPUTDIR			=$(MONIKER)
EXE_NTTEST			=$(OUTPUTDIR)\NTTEST.EXE
MAP_NTTEST			=$(OUTPUTDIR)\NTTEST.MAP
LIB_NTDLLTST		=$(OUTPUTDIR)\ntdlltst.lib
DLL_NTDLLTST		=$(OUTPUTDIR)\ntdlltst.dll
MAP_NTDLLTST		=$(OUTPUTDIR)\ntdlltst.map

!if "$(MAKETEST)"=="Y"
THISTARGET			=$(EXE_NTTEST)
!else
!if "$(MAKEDLL)"=="Y"
THISTARGET			=$(DLL_NEWTRACK_IMPLIB)
!else
THISTARGET			=$(LIB_NEWTRACK)
!endif
!endif


RSP_FILE			=$(OUTPUTDIR)\$(MONIKER).rsp
#DEP_RSP_FILE		=$(RSP_FILE)



!include $(BASEDIR)\$(COMPILERID).inc

!ifdef NT_USING_MFC
NT_USING_XXX	=$(CC_DEFINE)NT_USING_MFC $(CC_DEFINE)_AFXDLL $(CC_DEFINE)_DEBUG
!else
!ifdef NT_USING_OWL
NT_USING_XXX	=$(CC_DEFINE)NT_USING_OWL
!endif
!endif

!ifdef DLLBASE
SETDLLBASE=$(LD_SETBASE)$(DLLBASE)
!endif

!if "$(USEDEFFILE)"=="Y"
DLL_DEFFILE			=$(LD_SETDEF)$(RELSRCDIR)\newtrack.def
NTDLLTST_DEFFILE	=$(LD_SETDEF)$(RELSRCDIR)\ntdlltst.def
!endif

!if "$(CONSOLE)"=="Y"
CC_DEFCONSOLE		=$(CC_DEFINE)_CONSOLE
!endif




#
# Object Files
#

# DLL_OBJS contains a list of .OBJS that are required to create the NewTrack .DLL;
DLL_OBJS			= $(OUTPUTDIR)\NEWTDLL.OBJ $(OUTPUTDIR)\NEWTKASM.OBJ
LD_DLL_OBJS			= $(OUTPUTDIR)\NEWTDLL.OBJ $(LD_OBJSEP) $(OUTPUTDIR)\NEWTKASM.OBJ
AR_DLL_OBJS			= $(OUTPUTDIR)\NEWTDLL.OBJ $(AR_OBJSEP)$(OUTPUTDIR)\NEWTKASM.OBJ

# LIB_OBJS contains a list of .OBJs that are made into the library
LIB_OBJS			= $(LIB_OBJS) $(OUTPUTDIR)\NEWTRACK.OBJ
LD_LIB_OBJS			= $(LD_LIB_OBJS) $(LD_OBJSEP) $(OUTPUTDIR)\NEWTRACK.OBJ
AR_LIB_OBJS			= $(AR_LIB_OBJS) $(AR_OBJSEP)$(OUTPUTDIR)\NEWTRACK.OBJ

# WIN32_OBJS contains a list of .OBJs that are required for multithreading support
WIN32_OBJS			= $(OUTPUTDIR)\CFXTHRED.OBJ
LD_WIN32_OBJS		= $(OUTPUTDIR)\CFXTHRED.OBJ
AR_WIN32_OBJS		= $(OUTPUTDIR)\CFXTHRED.OBJ

# DEBUG_OBJS contains a list of .OBJS that are required only for the debug build
DEBUG_OBJS			= $(OUTPUTDIR)\CFXDEBUG.OBJ
LD_DEBUG_OBJS		= $(OUTPUTDIR)\CFXDEBUG.OBJ
AR_DEBUG_OBJS		= $(OUTPUTDIR)\CFXDEBUG.OBJ

# CHEAP_OBJS contains a list of .OBJS that make up the CHeap suballocator
CHEAP_OBJS			= $(OUTPUTDIR)\CHEAP.OBJ
LD_CHEAP_OBJS		= $(OUTPUTDIR)\CHEAP.OBJ
AR_CHEAP_OBJS		= $(OUTPUTDIR)\CHEAP.OBJ

# FULL_OBJS contains a list of .OBJs that are required for the full version
FULL_OBJS			= $(OUTPUTDIR)\READDOS.OBJ $(OUTPUTDIR)\READEXE.OBJ
LD_FULL_OBJS		= $(OUTPUTDIR)\READDOS.OBJ $(LD_OBJSEP) $(OUTPUTDIR)\READEXE.OBJ
AR_FULL_OBJS		= $(OUTPUTDIR)\READDOS.OBJ $(AR_OBJSEP)$(OUTPUTDIR)\READEXE.OBJ

# NTTEST_OBJS contains a list of .OBJs that are reqd for the NTTEST.EXE test app
NTTEST_OBJS			= $(OUTPUTDIR)\NTTEST.OBJ
LD_NTTEST_OBJS		= $(OUTPUTDIR)\NTTEST.OBJ

# NTDLLTST_OBJS contains a list of .OBJS that are reqd for the NTDLLTST.DLL test dll
NTDLLTST_OBJS		= $(OUTPUTDIR)\NTDLLTST.OBJ
LD_NTDLLTST_OBJS	= $(OUTPUTDIR)\NTDLLTST.OBJ



#
# Combined object files
#


#
# Need To Know:
#
#	1. All .OBJs required for DLL
#	2. All .LIBs required for EXE


DLL_ALL_OBJS			= $(DLL_OBJS)
LDDLL_ALL_OBJS			= $(LD_DLL_OBJS)
ARDLL_ALL_OBJS			= $(AR_DLL_OBJS)

!if "$(MULTITHREADED)"=="Y"
DLL_ALL_OBJS			= $(DLL_ALL_OBJS) $(WIN32_OBJS)
LDDLL_ALL_OBJS			= $(LDDLL_ALL_OBJS) $(LD_OBJSEP) $(LD_WIN32_OBJS)
ARDLL_ALL_OBJS			= $(ARDLL_ALL_OBJS) $(AR_OBJSEP)$(AR_WIN32_OBJS)
!endif

!if "$(DEBUG)"=="Y"
DLL_ALL_OBJS			= $(DLL_ALL_OBJS) $(DEBUG_OBJS)
LDDLL_ALL_OBJS			= $(LDDLL_ALL_OBJS) $(LD_OBJSEP) $(LD_DEBUG_OBJS)
ARDLL_ALL_OBJS			= $(ARDLL_ALL_OBJS) $(AR_OBJSEP)$(AR_DEBUG_OBJS)
!endif

!if "$(USECHEAP)"=="Y"
DLL_ALL_OBJS			= $(DLL_ALL_OBJS) $(CHEAP_OBJS)
LDDLL_ALL_OBJS			= $(LDDLL_ALL_OBJS) $(LD_OBJSEP) $(LD_CHEAP_OBJS)
ARDLL_ALL_OBJS			= $(ARDLL_ALL_OBJS) $(AR_OBJSEP)$(AR_CHEAP_OBJS)
!endif

!if "$(SHAREWARE)"=="N"
DLL_ALL_OBJS			= $(DLL_ALL_OBJS) $(FULL_OBJS) $(COMPILER_OBJS)
LDDLL_ALL_OBJS			= $(LDDLL_ALL_OBJS) $(LD_OBJSEP) $(LD_FULL_OBJS) $(LD_OBJSEP) $(LD_COMPILER_OBJS)
ARDLL_ALL_OBJS			= $(ARDLL_ALL_OBJS) $(AR_OBJSEP)$(AR_FULL_OBJS) $(AR_OBJSEP)$(AR_COMPILER_OBJS)
!endif

LIB_ALL_OBJS			= $(LIB_OBJS)
LDLIB_ALL_OBJS			= $(LD_LIB_OBJS)
ARLIB_ALL_OBJS			= $(AR_LIB_OBJS)

!if "$(BUILDTYPE)"=="S"
LIB_ALL_OBJS			= $(LIB_ALL_OBJS) $(DLL_ALL_OBJS)
LDLIB_LIBS				=
ARLIB_ALL_OBJS			= $(ARLIB_ALL_OBJS) $(AR_OBJSEP)$(ARDLL_ALL_OBJS)
!else
LIB_ALL_OBJS			= $(LIB_ALL_OBJS) $(DLL_NEWTRACK_IMPLIB)
LDLIB_LIBS				= $(LIBDLL_NEWTRACK)
ARLIB_ALL_OBJS			= $(ARLIB_ALL_OBJS) $(AR_OBJSEP)$(DLL_NEWTRACK_IMPLIB)
!endif

NTTEST_ALL_OBJS			= $(NTTEST_OBJS)
LDNTTEST_ALL_OBJS		= $(LD_NTTEST_OBJS)
NTTEST_ALL_LIBS			= $(LIBEXE_NEWTRACK)
LDNTTEST_ALL_LIBS		= $(LIBEXE_NEWTRACK)

!if "$(CALLERTYPE)"=="E"
NTTEST_ALL_OBJS			= $(NTTEST_ALL_OBJS) $(NTDLLTST_OBJS)
LDNTTEST_ALL_OBJS		= $(LDNTTEST_ALL_OBJS) $(LD_OBJSEP) $(LD_NTDLLTST_OBJS)
CC_NTDLLTST_FLAGS		= $(CCEXE_FLAGS)
!else
NTTEST_ALL_LIBS			= $(NTTEST_ALL_LIBS) $(LIB_NTDLLTST)
LDNTTEST_ALL_LIBS		= $(LDNTTEST_ALL_LIBS) $(LD_LIBSEP) $(LIB_NTDLLTST)
CC_NTDLLTST_FLAGS		= $(CCDLL_FLAGS)
!endif


!if "$(DEBUG)"=="Y"
DEBUG_DEL				= rem
!else
DEBUG_DEL				= del
!endif


# Explicit rules

makeall: $(RSP_FILE) $(THISTARGET) $(DEP_NTTESTEXENAME)

!if "$(MAKETEST)"=="N"
!if "$(MAKEDLL)"=="Y"

$(DLL_NEWTRACK_IMPLIB):		$(DLL_NEWTRACK)
	$(IMPLIB) $(DLL_NEWTRACK_IMPLIB) $(DLL_NEWTRACK)

!ifdef NMAKE
$(DLL_NEWTRACK):		$(DLL_ALL_OBJS)
	$(LINK) $(LDDLL_FLAGS) $(SETDLLBASE) @<<
		$(LDDLL_STARTUP) $(LDDLL_ALL_OBJS)
		$(LD_SETOUT)$(DLL_NEWTRACK)
		$(LD_SETMAP)$(MAP_NEWTRACK)
		$(LDDLL_LIB_EXTRA)
		$(DLL_DEFFILE)
		$(LD_TERMINATE_RSP)
<<
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map
!else
$(DLL_NEWTRACK):		$(DLL_ALL_OBJS)
	$(LINK) $(LDDLL_FLAGS) $(SETDLLBASE) @&&/
		$(LDDLL_STARTUP) $(LDDLL_ALL_OBJS)
		$(LD_SETOUT)$(DLL_NEWTRACK)
		$(LD_SETMAP)$(MAP_NEWTRACK)
		$(LDDLL_LIB_EXTRA)
		$(DLL_DEFFILE)
		$(LD_TERMINATE_RSP)
/

!endif
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map

!else

!ifdef NMAKE
$(LIB_NEWTRACK):		$(LIB_ALL_OBJS)
	-if exist $(LIB_NEWTRACK) del $(LIB_NEWTRACK)
	$(LIBMGR) $(LIB_FLAGS) $(LIB_SETOUT)$(LIB_NEWTRACK) @<<
		$(AR_OBJSEP)$(ARLIB_ALL_OBJS)
		$(LIB_TERMINATE_RSP)
<<
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map
!else
$(LIB_NEWTRACK):		$(LIB_ALL_OBJS)
	-if exist $(LIB_NEWTRACK) del $(LIB_NEWTRACK)
	$(LIBMGR) $(LIB_FLAGS) $(LIB_SETOUT)$(LIB_NEWTRACK) @&&/
		$(AR_OBJSEP)$(ARLIB_ALL_OBJS)
		$(LIB_TERMINATE_RSP)
/

	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map
!endif

!endif

!else

!ifdef NMAKE

$(EXE_NTTEST):	$(NTTEST_ALL_OBJS) $(NTTEST_ALL_LIBS)
	$(LINK) $(LDEXE_FLAGS) @<<
		$(LDEXE_STARTUP) $(LDNTTEST_ALL_OBJS)
		$(LD_SETOUT)$(EXE_NTTEST)
		$(LD_SETMAP)$(MAP_NTTEST)
		$(LDNTTEST_ALL_LIBS) $(LD_LIBSEP) $(LDEXE_LIB_EXTRA)
		$(LD_TERMINATE_RSP)
<<
	copy $(DLL_NEWTRACK) $(OUTPUTDIR)
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map

!else

$(EXE_NTTEST):	$(NTTEST_ALL_OBJS) $(NTTEST_ALL_LIBS)
	$(LINK) $(LDEXE_FLAGS) @&&/
		$(LDEXE_STARTUP) $(LDNTTEST_ALL_OBJS)
		$(LD_SETOUT)$(EXE_NTTEST)
		$(LD_SETMAP)$(MAP_NTTEST)
		$(LDNTTEST_ALL_LIBS) $(LD_LIBSEP) $(LDEXE_LIB_EXTRA)
		$(LD_TERMINATE_RSP)
/

	copy $(DLL_NEWTRACK) $(OUTPUTDIR)
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map

!endif


$(LIB_NTDLLTST):	$(DLL_NTDLLTST)
	$(IMPLIB) $(LIB_NTDLLTST) $(DLL_NTDLLTST)

!ifdef NMAKE
$(DLL_NTDLLTST):	$(NTDLLTST_OBJS) $(LIBEXE_NEWTRACK)
	$(LINK) $(LDDLL_FLAGS) @<<
		$(LDDLL_STARTUP) $(LD_NTDLLTST_OBJS)
		$(LD_SETOUT)$(DLL_NTDLLTST)
		$(LD_SETMAP)$(MAP_NTDLLTST)
		$(LIBDLL_NEWTRACK) $(LD_LIBSEP) $(LDDLL_LIB_EXTRA)
		$(NTDLLTST_DEFFILE)
		$(LD_TERMINATE_RSP)
<<
	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map
!else
$(DLL_NTDLLTST):	$(NTDLLTST_OBJS) $(LIBEXE_NEWTRACK)
	$(LINK) $(LDDLL_FLAGS) @&&/
		$(LDDLL_STARTUP) $(LD_NTDLLTST_OBJS)
		$(LD_SETOUT)$(DLL_NTDLLTST)
		$(LD_SETMAP)$(MAP_NTDLLTST)
		$(LIBDLL_NEWTRACK) $(LD_LIBSEP) $(LDDLL_LIB_EXTRA)
		$(NTDLLTST_DEFFILE)
		$(LD_TERMINATE_RSP)
/

	-$(DEBUG_DEL) *.pch
	-$(DEBUG_DEL) *.pdb
	-$(DEBUG_DEL) *.csm
	-$(DEBUG_DEL) *.sym
	-$(DEBUG_DEL) *.map
!endif

!endif


#
# Explicit rules for released source files
#

$(OUTPUTDIR)\newtrack.obj:		$(RELSRCDIR)\newtrack.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(NT_USING_XXX) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(RELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\nttest.obj:		$(RELSRCDIR)\nttest.cpp $(DEP_RSP_FILE)
	$(CC) $(CCEXE_FLAGS) $(CC_DEFCONSOLE) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(RELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\ntdlltst.obj:		$(RELSRCDIR)\ntdlltst.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_NTDLLTST_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(RELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\rtlextra.obj:		$(RELSRCDIR)\rtlextra.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(NT_USING_XXX) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(RELSRCDIR)\$(@B).cpp



!if "$(HAVEALLSOURCE)"=="Y"

#
# Explicit rules for unreleased source files
#

$(OUTPUTDIR)\newtdll.obj:		$(UNRELSRCDIR)\newtdll.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\newtkasm.obj:		$(UNRELSRCDIR)\newtkasm.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readdos.obj:		$(UNRELSRCDIR)\readdos.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readexe.obj:		$(UNRELSRCDIR)\readexe.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readpe.obj:		$(UNRELSRCDIR)\readpe.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readne.obj:		$(UNRELSRCDIR)\readne.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readcv.obj:		$(UNRELSRCDIR)\readcv.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readbpe.obj:		$(UNRELSRCDIR)\readbpe.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\readbne.obj:		$(UNRELSRCDIR)\readbne.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(UNRELSRCDIR)\$(@B).cpp

!ifdef NMAKE
$(OUTPUTDIR)\..\nt_vc15.obj:		$(UNRELSRCDIR)\nt_vc15.asm $(DEP_RSP_FILE)
	$(ASM) @<<
$(ASM_FLAGS) $(UNRELSRCDIR)\$(@B).asm,$(OUTPUTDIR)\..\$(@B).obj;
<<KEEP
!endif

$(OUTPUTDIR)\cfxdebug.obj:		$(CFXSRCDIR)\cfxdebug.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(CFXSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\cfxthred.obj:		$(CFXSRCDIR)\cfxthred.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(CFXSRCDIR)\$(@B).cpp

$(OUTPUTDIR)\cheap.obj:			$(CHEAPSRCDIR)\cheap.cpp $(DEP_RSP_FILE)
	$(CC) $(CC_FLAGS) $(CC_SETOUT)$(OUTPUTDIR)\$(@B).obj $(CC_COMPILEONLY) $(CHEAPSRCDIR)\$(@B).cpp

!endif

