@Echo Off
REM Assume that Setup recognizes the CPU that we are running on.
SET RecognizedProcessor=1

REM If we are running on an x86 or a MIPS, run the binary Setup.
IF NOT %PROCESSOR_ARCHITECTURE% == x86 GOTO Notx86
Start %0\..\ISETup.exe
GOTO Exit

:Notx86
IF NOT %PROCESSOR_ARCHITECTURE% == MIPS GOTO NotMIPS
Start %0\..\MSETup.exe
GOTO Exit

:NotMIPS
SET RecognizedProcessor=0
REM Check to see if the user entered a command line parameter.
IF NOT %1x == x GOTO HaveCmdLineParm
REM  Display the "Usage" information.
ECHO This batch file installs the source code for "Advanced Windows NT."
ECHO.
ECHO Usage: SETUP (DestPath)
ECHO.
ECHO Where DestPath is the drive and path where the files 
ECHO should be copied to and decompressed.  For example,
ECHO.
ECHO             %0 C:\ADVWINNT
ECHO.
ECHO installs the source files to the ADVWINNT directory of drive C.
ECHO If this directory does not exist, it will be created.
GOTO Exit

:HaveCmdLineParm
REM  User entered a command-line parameter.  Let's get going...

REM  Attempt to create the specified subdirectory.
MkDir %1
IF EXIST %1 GOTO DirExists
REM  Unable to make the directory.
ECHO The directory (%1) could not be created.  Run Setup again
ECHO and specify a different (DestPath).
GOTO Exit

:DirExists
REM The subdirectory already exists.

REM Create an environment variable containing all of the subdirectories.
SET AllDirs=VMAlloc.03 VMStat.03 VMMap.03 SysStat.03 FileRev.04 MMFShare.04
SET AllDirs=%AllDirs% CritSecs.05 Mutexes.05 SprMrkt.05 Bucket.05 DocStats.05
SET AllDirs=%AllDirs% LISLab.06 CopyData.06 ModUse.07 MultInst.07 PMRest.07
SET AllDirs=%AllDirs% TLSDyn.08 TLSStat.08 DiskInfo.09 AlertIO.09 DirWalk.09 FileChng.09
SET AllDirs=%AllDirs% SEHTerm.10 SEHExcpt.10 SEHSoft.10

ECHO Creating the directory tree structure.
FOR %%d IN (%AllDirs%) DO IF NOT EXIST %1\%%d MkDir %1\%%d

ECHO.
ECHO Copying and decompressing the source files.
FOR %%d IN (%AllDirs%) DO ECHO Installing sample application: %%d. & Expand -r %0\..\%%d\*.* %1\%%d > Nul

REM Copy/decompress all of the files in the root directory.
ECHO.
ECHO Installing auxiliary files.
FOR %%f IN (AdvWinNT.Ma_ MakeAll.Ba_ AdvWinNT.TXT) DO Expand -r %0\..\%%f %1 > Nul

ECHO.
ECHO The files have been copied successfully.
CD %1
Start Notepad %1\AdvWinNT.Txt


:Exit
REM If SETUP is running on a non-recognized CPU, the binary
REM ?SETUP.EXE does not run.  The user relies ooon this batch 
REM file for all information.  Just in case the user is running
REM this batch file from a GUI application, make sure that
REM we pause the information or the console window will vanish
REM with all of the text in it.
IF %RecognizedProcessor% == 0 PAUSE Press a key to exit SETUP.

REM Erase all environment variables created by this batch file.
SET AllDirs=
SET RecognizedProcessor=
