(*
 * Copyright (C) 1989 Eric Ng
 *
 * Aint is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License, Version 1, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * without any warranty whatsoever, without even the implied warranties
 * of merchantability or fitness for a particular purpose.  See the
 * enclosed GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with egaint; see the file COPYING.  If not, write to:
 *
 *       Free Software Foundation, Inc.
 *       675 Massachusetts Avenue
 *       Cambridge, Massachusetts 02139
 *
 *)

(*
 * Aint is now being re-distributed as part of the egaint 0.93.05
 * package.  The complete egaint 0.93.05 package can be obtained at
 * either of the following bulletin board systems:
 *
 *       Tom and Sue McDermet's The Odyssey
 *       A carrier of the SmartNet network
 *       Morris Plains, New Jersey
 *       (201) 984-6574
 *
 *       John Looker's Bandersnatch
 *       Phoenix Net #807/7
 *       Basking Ridge, New Jersey
 *       (201) 766-3801
 *
 * In addition, bug reports, modifications, and other assorted
 * queries can be directed, via Internet e-mail, to
 *
 *       erc@{mars,irss,inis}.njit.edu
 *
 * Please note that since I will be returning to college in the
 * fall, future versions of egaint may not be posted on the above
 * bulletin board systems.  The e-mail address, however, should
 * remain valid.
 *
 *)

(*
 * Aint 0.90.01 was originally written in Turbo Pascal 4.0;
 * however, I have just received my upgrade copy of Turbo Pascal 5.5.
 * This new version of the compiler, so far, has not exhibited
 * any problems and compiled without change.  What this means,
 * through interpolation, is that it should (but is not guaranteed to)
 * compile with Turbo Pascal 5.0 (but I can't verify this).
 *
 *)

{$B-}
{$D-}
{$I-}
{$L-}
{$R-}
{$S-}
{$V-}

PROGRAM aint;

 USES
  CRT, DOS;


 CONST
  id        : STRING[22] = 'aint 0.90.01 Copyright (C) 1989 Eric Ng';

  nblocks   = 7;              { different blocks }
  blksiz    = 3;              { block size (minus one) }

  norients  = 3;              { different orientations (minus one) }

  nblkclrs  = 7;              { different colors for blocks }
  nchars    = 4;              { different characters for blocks }

  rowmin    = 1;              { playing field coordinates on the screen }
  rowmax    = 24;
  colmin    = 29;
  colmax    = 50;

  pelsiz     = 2;              { element size }
  blkrows   = 24;             { size of playing field in block-rows }
  xblkrows  = 25;             { blkrows plus one (the constant bottom) }
  blkcols   = 10;             { size of playing field in block-columns }

  mkrow     = 1;              { initial row for freshly-made blocks }
  mkcol     = 5;              { initial column for freshly-made blocks }

  mvup      = -1;             { displacements for movement }
  mvdown    = 1;
  mvleft    = -1;
  mvright   = 1;

  maxlvl    = 10;             { maximum level }

  maxhgt    = 10;             { maximum height }
  nfadd     = 3;              { random added fill number }
  nfbase    = 3;              { base fill number }

  bnsrclr   = 5;              { bonus for clearing a row }
  bnsrmul   = 3;              { bonus for clearing multiple rows }
  bnsnext   = 1;              { bonus for not using show next }
  bnsfran   = 1;              { bonus for frantic levels }

  rplvl     = 10;             { rows to clear per level }

{ swpiter   = 10; }           { number of times to swap pieces }

  nhisc     = 15;             { number of high scores }
  hiscnm    = 'aint.rec';     { high score filename }


 TYPE
  disptype  = (color, mono, plasma);   { different display types }
  msgclrs   = (low, norm, high);       { different display attributes }
  bufstr    = STRING[32];

  hiscrec   = RECORD
               score    : longint;
               rclr     : word;
               lvl      : byte;
               hgt      : byte;
               name     : bufstr
              END;


 CONST
  blktab    : ARRAY[1..nblocks, 1..blksiz, 1..2] OF shortint =
   { bar }    ((( 0, -2), ( 0, -1), ( 0,  1)),
   { box }     (( 0, -1), ( 1, -1), ( 1,  0)),
   { tee }     (( 0, -1), ( 0,  1), ( 1,  0)),
   { zig }     (( 0,  1), ( 1, -1), ( 1,  0)),
   { zag }     (( 0, -1), ( 1,  0), ( 1,  1)),
   { ell }     (( 0, -1), ( 0,  1), (-1, -1)),
   { lel }     (( 0, -1), ( 0,  1), (-1,  1)));

  blkclrtab : ARRAY[disptype, 1..nblkclrs] OF byte =
   { color }  ((LightBlue, LightGreen, LightCyan, LightRed,
                LightMagenta, Yellow, White),
   { mono }    (LightGray, White, LightGray, White, LightGray, White,
                LightGray),
   { plasma }  (Red, LightGray, Blue, Red, LightGray, Blue, Red));

  chartab   : ARRAY[1..nchars] OF char =
              (#176, #177, #178, #219);

  msgclrtab : ARRAY[disptype, msgclrs] OF byte =
   { color }  ((LightGray, LightGray, White),
   { mono }    (LightGray, LightGray, White),
   { plasma }  (Blue, Red, LightGray));

  tdeltab   : ARRAY[1..maxlvl] OF integer =
              (10, 9, 8, 7, 6, 5, 4, 3, 2, 1);

  titletab  : ARRAY[1..nblocks] OF STRING[3] =
              ('Bar', 'Box', 'Tee', 'Zig', 'Zag', 'Ell', 'Lel');

 VAR
  field     : ARRAY[0..xblkrows, 1..blkcols] OF boolean;
  xblktab   : ARRAY[1..nblocks, 0..norients, 1..blksiz, 1..2] OF shortint;
  hisc      : ARRAY[1..nhisc] OF hiscrec;
  blkclr    : ARRAY[1..nblkclrs] OF byte;
  blkstats  : ARRAY[1..nblocks] OF word;

  rg        : Registers;         { registers }

  endrun    : boolean;           { end run flag }
  cheater   : boolean;

  clow      : byte;              { message colors }
  cnorm     : byte;
  chigh     : byte;

  disp      : disptype;          { display type }
  cst, csb  : byte;              { save for cursor format }
  savemode  : word;              { save for text mode }

  trny      : boolean;           { tournament flag }
  trnynum   : byte;              { tournament game number }

  shnext    : boolean;           { show next flag }
  shstats   : boolean;           { show stats flag }

  blks      : word;
  score     : longint;           { score }
  rclr      : word;              { rows cleared }
  lvl       : byte;              { current level }
  hgt       : byte;              { initial height }
  rank      : integer;           { rank }

  fhisc     : FILE OF hiscrec;   { handle for high score file }


 PROCEDURE csron;
  BEGIN
   rg.ah := $01;
   rg.ch := csb;
   rg.cl := cst;
   Intr($10, rg)
  END;


 PROCEDURE csroff;
  BEGIN
   rg.ah := $01;
   rg.cx := $ffff;
   Intr($10, rg)
  END;


 PROCEDURE drawbox;

  VAR
   x1, y1   : byte;
   x2, y2   : byte;
   xd, yd   : byte;
   i        : integer;

  BEGIN
   x1 := lo(WindMin)+1;                { obtain current window coordinates }
   y1 := hi(WindMin)+1;
   x2 := lo(WindMax)+1;
   y2 := hi(WindMax)+1;

   Window(x1-1, y1-1, x2+2, y2+1);
   xd := x2-x1+3;
   yd := y2-y1+3;

   GotoXY(1, 1);                       { upper left corner }
   Write(#201);
   GotoXY(1, yd);                      { lower left corner }
   Write(#200);
   GotoXY(xd, 1);                      { upper right corner }
   Write(#187);
   GotoXY(xd, yd);                     { lower right corner }
   Write(#188);

   FOR i := 2 TO xd-1 DO
    BEGIN
     GotoXY(i, 1);                     { upper horizontal bar }
     Write(#205);
     GotoXY(i, yd);                    { lower horizontal bar }
     Write(#205)
    END;

   FOR i := 2 TO yd-1 DO
    BEGIN
     GotoXY(1, i);                     { left vertical bar }
     Write(#186);
     GotoXY(xd, i);                    { right vertical bar }
     Write(#186)
    END;

   Window(x1, y1, x2, y2)              { restore window coordinates }
  END;


 PROCEDURE wininfo;
  BEGIN
   Window(5, 3, 24, 7)
  END;


 PROCEDURE winnext;
  BEGIN
   Window(5, 11, 24, 14);
  END;


 PROCEDURE winstats;
  BEGIN
   Window(55, 3, 76, 13)
  END;


 PROCEDURE winfield;
  BEGIN
   Window(colmin, rowmin, colmax, rowmax)
  END;


 FUNCTION gettmr : longint;

  VAR
   l        : longint;

  BEGIN
   rg.ah := $00;
   Intr($1a, rg);
   l := rg.cx;
   l := (l SHR 16)+rg.dx;
   gettmr := l
  END;


 PROCEDURE init;

  VAR
   i, j     : integer;
   b        : STRING[1];

  BEGIN
   disp := color;
   b := Copy(ParamStr(1), 1, 1);
   IF ParamCount > 0 THEN
    CASE b[1] OF
     'C', 'c':           disp := color;
     'B', 'b', 'M', 'm': disp := mono;
     'P', 'p':           disp := plasma
    END;

   FOR i := 1 TO nblocks DO
    FOR j := 1 TO blksiz DO
     BEGIN
      xblktab[i, 0, j, 1] :=  blktab[i, j, 1];     { north }
      xblktab[i, 0, j, 2] :=  blktab[i, j, 2];
      xblktab[i, 1, j, 1] :=  blktab[i, j, 2];     { east }
      xblktab[i, 1, j, 2] := -blktab[i, j, 1];
      xblktab[i, 2, j, 1] := -blktab[i, j, 1];     { south }
      xblktab[i, 2, j, 2] := -blktab[i, j, 2];
      xblktab[i, 3, j, 1] := -blktab[i, j, 2];     { west }
      xblktab[i, 3, j, 2] :=  blktab[i, j, 1]
     END;

   FOR i := 1 TO nblkclrs DO
    blkclr[i] := blkclrtab[disp, i];

   clow := msgclrtab[disp, low];
   cnorm := msgclrtab[disp, norm];
   chigh := msgclrtab[disp, high];

   FillChar(hisc, sizeof(hisc), 0);

   Assign(fhisc, hiscnm);
   Reset(fhisc);

   i := 1;
   IF IOResult = 0 THEN
    BEGIN
     WHILE (i <= nhisc) AND (NOT Eof(fhisc)) DO
      BEGIN
       Read(fhisc, hisc[i]);
       i := i+1
      END;
     Close(fhisc)
    END;

   FOR j := i TO nhisc DO
    hisc[j].score := 0;

   savemode := LastMode;
   TextMode(CO80);

   rg.ah := $0f;
   Intr($10, rg);
   rg.ah := $03;
   Intr($10, rg);
   cst := rg.ch;
   csb := rg.cl;

   trny    := FALSE;
   trnynum := 0;
   lvl     := 5;
   hgt     := 0;
   shnext  := TRUE;
   shstats := TRUE
  END;


 PROCEDURE initgame;

  VAR
   i, j     : integer;
 { k, l, m  : integer;
   n        : integer;
   tmp      : shortint;
   tmps     : STRING[3]; }

  PROCEDURE getoptions;

   VAR
    c       : byte;
    k       : char;

   PROCEDURE opening;
    BEGIN
     TextColor(cnorm);
     TextBackground(Black);
     ClrScr;

     GotoXY(20, 1);
     TextColor(chigh);
     Write('aint 0.90.01  Copyright (C) 1989 Eric Ng');

     GotoXY(6, 2);
     TextColor(cnorm);
     Write('Aint is free software; you can redistribute it and/or modify it under');
     GotoXY(6, 3);
     Write('the terms of the GNU General Public License, Version 1, as published');
     GotoXY(6, 4);
     Write('by the Free Software Foundation.  This program comes without any');
     GotoXY(6, 5);
     Write('warranty, without even the implied warranties of merchantability or');
     GotoXY(6, 6);
     Write('fitness for a particular purpose.  See the file COPYING for details.');

     GotoXY(11, 24);
     TextColor(clow);
     Write('Use ');
     TextColor(chigh);
     Write('J');
     TextColor(clow);
     Write(' for up, ');
     TextColor(chigh);
     Write('K');
     TextColor(clow);
     Write(' to rotate, ');
     TextColor(chigh);
     Write('L');
     TextColor(clow);
     Write(' for down, and ');
     TextColor(chigh);
     Write('SPACE');
     TextColor(clow);
     Write(' when done')
    END;

   PROCEDURE showoptions;

    PROCEDURE showflag(f : boolean);
     BEGIN
      IF f THEN
       Write('Yes')
      ELSE
       Write('No ')
     END;

    BEGIN
     TextColor(chigh);
     GotoXY(20, 2);                    { tournament }
     showflag(trny);
     GotoXY(20, 4);                    { tournament game number }
     Write(trnynum, '':2);
     GotoXY(20, 6);                    { initial level }
     Write(lvl, '':2);
     GotoXY(20, 8);                    { initial height }
     Write(hgt, '':2);
     GotoXY(20, 10);                   { show next }
     showflag(shnext);
     GotoXY(20, 12);                   { show statistics }
     showflag(shstats)
    END;

   PROCEDURE drawoptions;
    BEGIN
     opening;

     Window(28, 9, 51, 21);
     TextColor(clow);
     drawbox;

     TextColor(cnorm);
     GotoXY(1, 2);
     Write('Tournament:':18);
     GotoXY(1, 4);
     Write('Tournament Game:':18);
     GotoXY(1, 6);
     Write('Initial Level:':18);
     GotoXY(1, 8);
     Write('Initial Height:':18);
     GotoXY(1, 10);
     Write('Show Next:':18);
     GotoXY(1, 12);
     Write('Show Statistics:':18);

     showoptions
    END;

   PROCEDURE rotateopt;
    BEGIN
     CASE c OF
       2: trny := NOT trny;
       4: trnynum := (trnynum+1) MOD 256;
       6: lvl := (lvl MOD (2*maxlvl))+1;
       8: hgt := (hgt+1) MOD (maxhgt+1);
      10: shnext := NOT shnext;
      12: shstats := NOT shstats
     END;
     showoptions
    END;

   BEGIN
    drawoptions;
    c := 2;

    REPEAT
     TextColor(clow+Blink);
     GotoXY(19, c);
     Write(#26);
     TextColor(clow);

     REPEAT UNTIL KeyPressed;
     k := ReadKey;
     GotoXY(19, c);
     Write(#32);

     CASE k OF
      'J', 'j': IF c < 4 THEN
                 c := 12
                ELSE
                 c := c-2;
      'K', 'k': rotateopt;
      'L', 'l': IF c > 10 THEN
                 c := 2
                ELSE
                 c := c+2
     END;
    UNTIL k = #32;
    Window(1, 1, 80, 25);
   END;

  BEGIN
   csroff;

   getoptions;

   FillChar(field, sizeof(field)-blkcols, 0);
   FillChar(field[xblkrows, 1], blkcols, 1);

   FillChar(blkstats, sizeof(blkstats), 0);
   blks := 0;

   IF trny THEN
    RandSeed := trnynum
   ELSE
    Randomize;

 { FOR n := 1 TO swpiter DO
    FOR i := 1 TO nblocks DO
     BEGIN
      j := Random(nblocks)+1;

      FOR k := 0 TO 3 DO
       FOR l := 1 TO blksiz DO
        FOR m := 1 TO 2 DO
         BEGIN
          tmp := xblktab[i, k, l, m];
          xblktab[i, k, l, m] := xblktab[j, k, l, m];
          xblktab[j, k, l, m] := tmp
         END;

      tmps        := titletab[i];
      titletab[i] := titletab[j];
      titletab[j] := tmps;
     END }
   END;

 PROCEDURE drawscreen;

  VAR
   i        : integer;

  BEGIN
   ClrScr;
   wininfo;                            { score box }
   TextColor(clow);
   drawbox;
   TextColor(cnorm);
   GotoXY(3, 2);
   Write('Score:');
   GotoXY(3, 3);
   Write('Level:');
   GotoXY(4, 4);
   Write('Rows:');

   IF shnext THEN                      { show next box }
    BEGIN
     winnext;
     TextColor(clow);
     drawbox;
     GotoXY(8, 1);
     Write(#179);
     GotoXY(8, 2);
     Write(#179);
     TextColor(chigh);
     Write('  aint 0.9');
     TextColor(clow);
     GotoXY(8, 3);
     Write(#179);
     TextColor(chigh);
     Write('  (C) 1989');
     TextColor(clow);
     GotoXY(8, 4);
     Write(#179)
    END;

   IF shstats THEN                     { show stats box }
    BEGIN
     winstats;
     TextColor(clow);
     drawbox;
     TextColor(cnorm);
     FOR i := 1 TO nblocks DO
      BEGIN
       GotoXY(2, 1+I);
       Write(titletab[I])
      END;
     GotoXY(2, 9);
     Write(#196+#196+#196+#196+#196+#196+#196+#196);
     GotoXY(2, 10);
     Write('Sum');
     TextColor(clow);
     FOR i := 1 TO 11 DO
      BEGIN
       GotoXY(11, i);
       Write(#179)
      END;
     TextColor(chigh);
     GotoXY(13, 4);
     Write('J');
     TextColor(cnorm);
     Write('Left':8);
     TextColor(chigh);
     GotoXY(13, 5);
     Write('K');
     TextColor(cnorm);
     Write('Rotate':8);
     TextColor(chigh);
     GotoXY(13, 6);
     Write('L');
     TextColor(cnorm);
     Write('Right':8);
     TextColor(chigh);
     GotoXY(13, 7);
     Write('Sp');
     TextColor(cnorm);
     Write('Drop':7);
     TextColor(chigh);
     GotoXY(13, 8);
     Write('^\');
     TextColor(cnorm);
     Write('Quit':7)
    END;

    Window(colmin, rowmin+1, colmax, rowmax);
    drawbox;
    Window(colmin-1, rowmin, colmax+1, rowmax);
    GotoXY(1, 1);
    Write(#186, '':colmax-colmin+1, #186);
    winfield
  END;

{

1                           |11223344556677889900|
2  +12345678901234567890+   |                    |   +1234567890123456789012+
3  1                    |   |                    |   |                      |
4  2  Score: 214748364  |   |                    |   | Bar 0000             |
5  3  Level: 00         |   |                    |   | Box 0000   J    Left |
6  4   Rows: 0000       |   |                    |   | Tee 0000   K  Rotate |
7  5                    |   |                    |   | Zig 0000   L   Right |
8  +--------------------+   |                    |   | Zag 0000   Sp   Drop |
9                           |                    |   | Ell 0000   Esc  Quit |
0  +1234567-123456789012+   |                    |   | Lel 0000             |
1  |       |            |   |                    |   | --------             |
2  |  XXX  |  aint 0.9  |   |                    |   | Sum 0000             |
3  |    X  |  (C) 1989  |   |                    |   |                      |
4  |       |            |   |                    |   +----------------------+
5  +--------------------+   |                    |
6                           |                    |
7                           |                    |
8                           |                    |
9                           |                    |
0                           |                    |
1                           |                    |
2                           +--------------------+

}


 PROCEDURE play;

  VAR
   bombed   : boolean;
   cheater  : boolean;
   dropped  : boolean;
   endgame  : boolean;
   frantic  : boolean;
   blk      : byte;
   nextblk  : byte;
   orient   : byte;
   row, col : byte;
   color    : byte;
   ch       : char;
   kb       : char;
   t, tdel  : longint;
   bns      : integer;

  PROCEDURE fillfield;

   VAR
    c       : char;
    i, j    : integer;
    k, l    : integer;

   BEGIN
    FOR i := blkrows DOWNTO blkrows-(hgt-1) DO
     BEGIN
      k := Random(nfadd)+nfbase;
      FOR j := 1 TO k DO
       BEGIN
        l := Random(blkcols)+1;
        field[i, l] := TRUE;
        TextColor(blkclr[Random(nblkclrs)+1]);
        GotoXY(pelsiz*l, i);
        c := chartab[Random(nchars)+1];
        Write(c+c)
       END
     END
   END;

  PROCEDURE mkblk;
   BEGIN
    blk     := nextblk;
    orient  := 0;
    row     := mkrow;
    col     := mkcol;
    ch      := chartab[Random(nchars)+1];
    color   := blkclr[Random(nblkclrs)+1];
    nextblk := Random(nblocks)+1
   END;

  PROCEDURE drawblk(ch: char);

   VAR
    r, c    : byte;
    i       : integer;

   BEGIN
    TextColor(color);
    GotoXY(pelsiz*col, row);
    Write(ch+ch);
    FOR i := 1 TO blksiz DO
     BEGIN
      c := col+xblktab[blk, orient, i, 2];
      r := row+xblktab[blk, orient, i, 1];
      IF (r IN [1..blkrows]) AND (c IN [1..blkcols]) THEN
       BEGIN
        GotoXY(pelsiz*c, r);
        Write(ch+ch)
       END
     END
   END;

  PROCEDURE dispinfo;
   BEGIN
    wininfo;
    IF cheater THEN
     TextColor(chigh+Blink)
    ELSE
     TextColor(chigh);
    GotoXY(10, 2);
    Write(score);
    TextColor(chigh);
    GotoXY(10, 3);
    Write(lvl, '':1);
    GotoXY(10, 4);
    Write(rclr);
    winfield
   END;

  FUNCTION check(m : shortint) : boolean;

   VAR
    f       : boolean;
    i       : integer;
    y       : byte;

   BEGIN
    m := row+m;

    f := field[m, col];
    FOR i := 1 TO blksiz DO
     BEGIN
      y := m+xblktab[blk, orient, i, 1];
      IF y IN [1..xblkrows] THEN
       f := f OR field[y, col+xblktab[blk, orient, i, 2]]
     END;
    check := f
   END;

  PROCEDURE checkmv(m : shortint);

   VAR
    f1, f2  : boolean;
    x       : byte;
    i       : integer;

   BEGIN
    m := col+m;

    f1 := m IN [1..blkcols];
    IF f1 THEN
     f2 := field[row, m]
    ELSE
     f2 := TRUE;
    FOR i := 1 TO blksiz DO
     BEGIN
      x := m+xblktab[blk, orient, i, 2];
      f1 := f1 AND (x IN [1..blkcols]);
      IF f1 THEN
       f2 := f2 OR field[row+xblktab[blk, orient, i, 1], x]
     END;

    IF f1 AND (NOT f2) THEN
     BEGIN
      drawblk(#32);
      col := m;
      drawblk(ch)
     END
   END;

  PROCEDURE checkrot;

   VAR
    f1, f2  : boolean;
    o, x    : byte;
    i       : integer;

   BEGIN
    o  := (orient+1) MOD 4;
    f1 := TRUE;
    f2 := FALSE;

    FOR i := 1 TO blksiz DO
     BEGIN
      x  := col+xblktab[blk, o, i, 2];
      f1 := f1 AND (x IN [1..blkcols]);
      IF f1 THEN
       f2 := f2 OR field[row+xblktab[blk, o, i, 1], x]
     END;

    IF f1 AND (NOT f2) THEN
     BEGIN
      drawblk(#32);
      orient := o;
      drawblk(ch)
     END
   END;

  PROCEDURE checkpoly;

   VAR
    f1, f2  : boolean;
    p, x, y : byte;
    i       : integer;

   BEGIN
    p  := (blk MOD nblocks)+1;
    f1 := TRUE;
    f2 := FALSE;

    FOR i := 1 TO blksiz DO
     BEGIN
      x  := col+xblktab[p, orient, i, 2];
      y  := row+xblktab[p, orient, i, 1];
      f1 := f1 AND ((x IN [1..blkcols]) AND (y IN [1..blkrows]));
      IF f1 THEN
       f2 := f2 OR field[y, x]
     END;

    IF f1 AND (NOT f2) THEN
     BEGIN
      drawblk(#32);
      blk := p;
      drawblk(ch)
     END
   END;

  PROCEDURE mvblk(m : shortint);
   BEGIN
    IF NOT check(m) THEN
     BEGIN
      drawblk(#32);
      row := row+m;
      drawblk(ch)
     END
   END;

  PROCEDURE dropblk;
   BEGIN
    score := score+lvl*(blkrows-row)+hgt+bns;
    drawblk(#32);
    WHILE NOT check(mvdown) DO
     Inc(row, mvdown);
    drawblk(ch);
    dropped := TRUE
   END;

  PROCEDURE plantblk;

   VAR
    i       : integer;
    y       : byte;

   BEGIN
    field[row, col] := TRUE;
    FOR i := 1 TO blksiz DO
     BEGIN
      y := row+xblktab[blk, orient, i, 1];
      IF y IN [1..blkrows] THEN
       field[y, col+xblktab[blk, orient, i, 2]] := TRUE
     END
   END;

  PROCEDURE checkrows;

   VAR
    i       : integer;
    r       : byte;

   FUNCTION checkrow(r : integer) : boolean;

    VAR
     f      : boolean;
     i, j   : integer;

    BEGIN
     r := row+r;

     IF r < xblkrows THEN
      BEGIN
       f := field[r, 1];
       i := 2;
       WHILE f AND (i <= blkcols) DO
        BEGIN
         f := f AND field[r, i];
         i := i+1
        END;

       IF f THEN
        BEGIN
         rclr := rclr+1;
         IF (lvl < maxlvl) AND (rclr = ((lvl+1)*rplvl)) THEN
          BEGIN
           lvl  := lvl+1;
           tdel := tdeltab[lvl]
          END;
         score := score+lvl*bnsrclr*r+hgt+bns;
         Move(field[0, 1], field[1, 1], blkcols*r);
         FillChar(field, blkcols, 0);

         rg.ax := $0701;
         rg.bh := $07;
         rg.ch := 1;
         rg.cl := colmin;
         rg.dh := r-1;
         rg.dl := colmax-1;
         Intr($10, rg);

        END
      END;
     checkrow := f
    END;

   BEGIN
    r := 0;
    FOR i := -2 TO 2 DO
     IF checkrow(i) THEN
      r := r+1;

    IF r > 1 THEN
     score := score+lvl*bnsrmul*r+hgt+bns
   END;

  PROCEDURE dispnext(ch : char);

   VAR
    i       : integer;

   BEGIN
    winnext;
    TextColor(cnorm);
    GotoXY(4, 2);
    Write(ch);
    FOR i := 1 TO blksiz DO
     BEGIN
      GotoXY(4+xblktab[nextblk, 0, i, 2], 2+xblktab[nextblk, 0, i, 1]);
      Write(ch)
     END;
    winfield
   END;

  PROCEDURE dispstats(b: integer);
   BEGIN
    blkstats[b] := blkstats[b]+1;
    blks := blks+1;

    winstats;
    TextColor(chigh);
    GotoXY(6, 1+b);
    Write(blkstats[b]:4);
    GotoXY(6, 10);
    Write(blks:4);
    winfield
   END;

  PROCEDURE blitzblk;

   VAR
    x, y    : byte;

   BEGIN
    IF Random(maxlvl) < lvl THEN
     BEGIN
      x := Random(blkcols)+1;
      y := Random(blkrows)+1;
      IF field[y, x] THEN
       BEGIN
        field[y, x] := FALSE;
        GotoXY(pelsiz*x, y);
        Write(#32+#32)
       END
     END
   END;

{ PROCEDURE smartbomb;

   BEGIN
    Move(field[0, 1], field[1, 1], blkcols*blkrows);
    FillChar(field, blkcols, 0);

    rg.ax := $0701;
    rg.bh := $07;
    rg.ch := 1;
    rg.cl := colmin;
    rg.dh := blkrows-1;
    rg.dl := colmax-1;
    Intr($10, rg);

    bombed := FALSE
   END; }

  PROCEDURE smartbomb;

   VAR
    x, y    : byte;

   BEGIN
    FOR y := row-2 TO row+2 DO
     FOR x := col-2 TO col+2 DO
      IF (y IN [1..blkrows]) AND (x IN [1..blkcols]) THEN
       BEGIN
        field[y, x] := FALSE;
        GotoXY(pelsiz*x, y);
        Write(#32+#32)
       END;

    bombed := FALSE;
   END;

  PROCEDURE nuke;

   VAR
    x, y    : byte;

   BEGIN
    FOR y := 1 TO blkrows DO
     FOR x := 1 TO blkcols DO
      field[y, x] := FALSE;
    ClrScr;
    IF shnext THEN
     dispnext(#32);
    mkblk;
    IF shnext THEN
     dispnext(chartab[nchars]);
    IF shstats THEN
     dispstats(blk);
    drawblk(ch)
   END;

  BEGIN
   IF hgt <> 0 THEN
    fillfield;

   rclr    := 0;
   score   := 0;
   bombed  := FALSE;
   cheater := FALSE;
   endgame := FALSE;

   IF NOT shnext THEN
    bns := bnsnext
   ELSE
    bns := 0;
   IF lvl > maxlvl THEN
    BEGIN
     lvl     := lvl-maxlvl;
     bns     := bns+bnsfran;
     frantic := TRUE
    END
   ELSE
    frantic := FALSE;

   tdel    := tdeltab[lvl];
   nextblk := Random(nblocks)+1;

   REPEAT
    dropped := FALSE;

    IF shnext THEN
     dispnext(#32);
    mkblk;
    IF shnext THEN
     dispnext(chartab[nchars]);
    IF shstats THEN
     dispstats(blk);
    drawblk(ch);

    IF check(mvdown) THEN
     endgame := TRUE
    ELSE
     BEGIN
      REPEAT
       IF frantic THEN
        blitzblk;
       t := gettmr;

       REPEAT
        REPEAT UNTIL KeyPressed OR (gettmr > t+tdel);
        IF KeyPressed THEN
         BEGIN
          kb := ReadKey;
          CASE kb OF
    { ^A } #1:       mvblk(mvup);
    { ^J } #10:      tdel := 2*tdel;
    { ^K } #11:      checkpoly;
    { ^L } #12:      BEGIN
                      lvl := (lvl MOD maxlvl)+1;
                      tdel := tdeltab[lvl]
                     END;
    { ^Q } #17:      BEGIN
                      color := color+Blink;
                      bombed := TRUE
                     END;
    { ^Z } #26:      mvblk(mvdown);
    { ^\ } #28:      BEGIN
                      dropblk;
                      endgame := TRUE
                     END;
    { Sp } #32:      dropblk;
           'J', 'j': checkmv(mvleft);
           'K', 'k': checkrot;
           'L', 'l': checkmv(mvright);
   { ^Bs } #127:     nuke
          END;
          IF (NOT cheater) AND (kb IN [#1, #10, #11, #12, #17, #26, #127]) THEN
           cheater := TRUE
         END
       UNTIL (gettmr > t+tdel) OR dropped;

       IF NOT dropped THEN
        mvblk(mvdown)
      UNTIL check(mvdown);

      plantblk;
      checkrows;

      IF bombed THEN
       smartbomb;

      dispinfo;
      t := gettmr;
      REPEAT UNTIL (gettmr > t+tdel);

      WHILE KeyPressed DO
       kb := ReadKey
     END
   UNTIL endgame;

   IF cheater THEN
    score := 0;

   REPEAT UNTIL KeyPressed;
   kb := ReadKey
  END;


 PROCEDURE cleanup;

  VAR
   c        : char;
   i, j     : integer;
{

  +123456789012345678901234567890123456789012345678901234567890123456+
  1 Rank |  Score  | Level | Rows | Name                             |
  2------------------------------------------------------------------|
  3   1  | 0000000 |  01   | 0000 | 12345678901234567890123456789012 |
  4   2
  5   3
  6   4
  7   5
  8   6
  9   7
  0   8
  1   9
  2  10
  3  11
  4  12
  5  13
  6  14
  7  15

}

  BEGIN
   Window(1, 1, 80, 25);
   ClrScr;
   csron;

   rank := 0;

   i := 1;
   WHILE (i <= nhisc) AND (hisc[i].score >= score) DO
    i := i+1;
   IF i <= nhisc THEN
    BEGIN
     rank := i;
     FOR j := nhisc-1 DOWNTO i DO
      hisc[j+1] := hisc[j];
     hisc[i].score := score;
     hisc[i].lvl   := lvl;
     hisc[i].rclr  := rclr;
     TextColor(cnorm);
     Write('Enter your name for posterity: ');
     TextColor(chigh);
     ReadLn(hisc[i].name)
    END;

   TextColor(chigh);
   ClrScr;
   GotoXY(30, 2);
   Write('The Glorious Fifteen');

   Window(7, 5, 73, 5+nhisc+1);
   TextColor(clow);
   drawbox;

   TextColor(cnorm);
   GotoXY(1, 1);
   Write(' Rank    Score    Level   Rows   Name');

   TextColor(clow);
   FOR i := 1 TO nhisc+2 DO
    BEGIN
     GotoXY(7, i);
     Write(#179);
     GotoXY(17, i);
     Write(#179);
     GotoXY(25, i);
     Write(#179);
     GotoXY(32, i);
     Write(#179)
    END;

   TextColor(clow);
   GotoXY(1, 2);
   FOR i := 7 TO 73 DO
    Write(#196);

   FOR i := 1 TO nhisc DO
    BEGIN
     IF rank = i THEN
      BEGIN
       TextBackground(chigh);
       TextColor(Black)
      END
     ELSE
      TextColor(cnorm);
     GotoXY(3, 2+i);
     Write(i:2);
     IF rank = i THEN
      TextBackground(Black);
     IF hisc[i].score <> 0 THEN
      BEGIN
       TextColor(chigh);
       GotoXY(9, 2+i);
       Write(hisc[i].score:7);
       GotoXY(20, 2+i);
       Write(hisc[i].lvl:2);
       GotoXY(27, 2+i);
       Write(hisc[i].rclr:4);
       GotoXY(34, 2+i);
       Write(hisc[i].name)
      END
    END;

   Window(1, 1, 80, 25);
   REPEAT
    TextColor(cnorm);
    GotoXY(31, 24);
    Write('Try again (Y/N)? ');
    TextColor(chigh);
    ReadLn(c)
   UNTIL c IN ['N', 'Y', 'n', 'y'];
   endrun := c IN ['N', 'n']
  END;


 PROCEDURE restore;

  VAR
   i        : integer;

  BEGIN
   Assign(fhisc, hiscnm);
   Rewrite(fhisc);

   i := 1;
   WHILE (i <= nhisc) AND (hisc[i].score <> 0) DO
    BEGIN
     Write(fhisc, hisc[i]);
     i := i+1
    END;
   Close(fhisc);

   csron;
   TextMode(savemode)
  END;


 BEGIN
  endrun := FALSE;
  init;
  REPEAT
   initgame;
   drawscreen;
   play;
   cleanup
  UNTIL endrun;
  restore
 END.

