PROGRAM PmEdit;

{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMEdit"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program implements a small text-Editor which can be extended       *
*  easily (it's the same editor the IDE has)                               *
*                                                                          *
*                                                                          *
****************************************************************************}

{$m 32768}    {Set stack size}

USES Api,PMobject,PmDialog,PmEditor,Dos,Crt,PmTypes;

RESOURCE PmEdit;

TYPE TMyApp=OBJECT(TEditorApplication)
                 CONSTRUCTOR Init;
                 DESTRUCTOR Done;
                 PROCEDURE HandleCommand(Win:HWND;Command:WORD);VIRTUAL;
                 PROCEDURE AppCreateNotify(AppFrWin,AppWin:HWND);VIRTUAL;
                 PROCEDURE AppRunNotify(AppFrWin:HWND);VIRTUAL;
                 PROCEDURE SetPosText(Win:HWND;Extra:PEditor);VIRTUAL;
                 PROCEDURE SetupMenu(Frame,Client:HWND);VIRTUAL;
                 PROCEDURE About;
            END;


VAR
    MyApp:TMyApp;


PROCEDURE TMyApp.SetPosText(Win:HWND;Extra:PEditor);
VAR s:string;
BEGIN
     s:=tostr(Extra^.CursorY+Extra^.VSlider.acvalue)+':'+
        tostr(Extra^.CursorX+Extra^.HSlider.acvalue);
     StatusBarSetText(1,s,-1);
     IF not Extra^.Insertmode THEN StatusBarSetText(2,'Insert',-1)
     ELSE StatusBarSetText(2,'Overwrite',-1);
     IF Extra^.Modified THEN StatusbarSetText(3,'Modified',-1)
     ELSE StatusBarSetText(3,'',-1);
END;

PROCEDURE TMyApp.About;
VAR Dlg:TDialog;
    r:LONGWORD;
BEGIN
     Dlg.Init(1,AppWinFrameHandle,0,1004,NIL);
     Dlg.ExecDialog(r);
     Dlg.Done;
END;


PROCEDURE TMyApp.HandleCommand(Win:HWND;command:WORD);
VAR
    s:string;
    w:word;
    e:PEditor;
    name:namestr;
    dir:dirstr;
    ext:extstr;
BEGIN
     Inherited.HandleCommand(Win,Command);
     CASE command OF
         CM_ABOUT:About;
         CM_NEW:OpenNewFile;
         CM_OPEN:IF FileOpenDialog(AppWinHandle,s) THEN OpenFile(s);
         CM_SAVEAS:SaveFileAs;
         CM_SAVE:SaveFile;
         CM_SAVEALL:SaveAllFiles;
     END; {case}
END;

PROCEDURE TMyApp.SetupMenu(Frame,Client:HWND);
BEGIN
     InsertMenuHelp(4,65535,'',-1);  {Default menu help}
     InsertMenuHelp(4,CM_OPEN,'Locate and open a file in an Edit window',-1);
     InsertMenuHelp(4,CM_NEW,'Create a new file in a new Edit window',-1);
     InsertMenuHelp(4,CM_SAVE,'Save the file in the active Edit window',-1);
     InsertMenuHelp(4,CM_SAVEAS,
       'Save the current file under a different name, directory or drive',-1);
     InsertMenuHelp(4,CM_SAVEALL,'Save all modified files in all Edit windows',-1);
     InsertMenuHelp(4,CM_TILE,'Arrange windows on desktop by tiling',-1);
     InsertMenuHelp(4,CM_CASCADE,'Arrange windows on desktop by cascading',-1);
     InsertMenuHelp(4,CM_CLOSE,'Close the active window',-1);
     InsertMenuHelp(4,CM_CLOSEALL,'Close all windows on the desktop',-1);
     InsertMenuHelp(4,CM_GOTO,'Move the cursor to a specified line number',-1);
     InsertMenuHelp(4,CM_FIND,'Search for specified text',-1);
     InsertMenuHelp(4,CM_REPLACE,'Search for text and replace it with new text',-1);
     InsertMenuHelp(4,CM_ABOUT,'Display Copyright notice',-1);

     InsertMenuHelp(4,CM_NEXT,'Make the next Edit window active',-1);

     SetMenuState(CM_FIND,FALSE);
     SetMenuState(CM_REPLACE,FALSE);
     SetMenuState(CM_CUT,FALSE);
     SetmenuState(CM_UNDO,FALSE);
     SetMenuState(CM_REDO,FALSE);
     SetMenuState(CM_SEARCHAGAIN,FALSE);
     SetMenuState(CM_GOTO,FALSE);

END;

PROCEDURE TMyApp.AppCreateNotify(AppFrWin,AppWin:HWND);
BEGIN
     ChildIconRes:=1001;
     WinSetWindowPos(SWP_SPEED,400,500,50,50,HWND_TOP,AppFrWin);
     CreateToolBar(30);
     ToolBarInsertButton(CM_OPEN,2001,10,3,28,24);
     ToolBarInsertButton(CM_SAVE,2000,45,3,28,24);
     ToolBarInsertButton(CM_FIND,2002,80,3,28,24);
     ToolBarInsertButton(CM_SEARCHAGAIN,2003,115,3,28,24);
     CreateStatusBar(22);
     StatusBarInsertItem(1,10,3,60,16);
     StatusBarInsertItem(2,80,3,50,16);
     StatusBarInsertItem(3,140,3,50,16);
     StatusBarInsertItem(4,200,3,430,16);

     SetEditorPtr(2009,0); {Mouse pointer for editor window}
END;

PROCEDURE TMyApp.AppRunNotify(AppFrWin:HWND);
BEGIN
     About;
END;

CONSTRUCTOR TMyApp.Init;
BEGIN
     Inherited.Init;
     EditorCol:=CLR_BLACK;
     EditorBackCol:=CLR_CYAN;
     StdExt:='.PAS';
     FileOpenDlgWildCards:='*.*';
     FilesaveDlgWildCards:='*.*';

     InsertResources(TRUE,TRUE,TRUE);  {Application has menus}
END;

DESTRUCTOR TMyApp.Done;
BEGIN
END;

var p:pointer;

BEGIN
     MyApp.Init;
     MyApp.Run(1000,'Speed-386 Sample Application PMEdit',CLR_BLACK,CLR_DARKGRAY);
     MyApp.Done;
END. 



























 
























































