'**************************************************************************
'*******************************  Windows API's  **************************
'**************************************************************************
GLOBAL hSetup AS INTEGER
GLOBAL fFrameInit AS INTEGER
GLOBAL fInstallInit AS INTEGER

CONST SM_CXSCREEN = 0
CONST SM_CYSCREEN = 1

CONST WF_80x87    = 1024
CONST WF_CPU186   =  128
CONST WF_CPU286   =    2
CONST WF_CPU386   =    4
CONST WF_CPU486   =    8
CONST WF_STANDARD =   16
CONST WF_ENHANCED =   32


'' DoMsgBox Flags

CONST MB_OK          = 0
CONST MB_ICONHAND    = 16
CONST MB_TASKMODAL   = 8192


DECLARE FUNCTION DoMsgBox LIB "mscomstf.dll" (lpText$,lpCaption$,wType%) As INTEGER
DECLARE FUNCTION GetWindowsDirectory LIB "kernel" (szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetSystemDirectory LIB "kernel" (szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetProfileString LIB "kernel" (szSect$, szKey$, szDefault$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION GetVersion LIB "kernel" AS INTEGER
DECLARE FUNCTION GetSystemMetrics LIB "user" (nIndex%) AS INTEGER
DECLARE FUNCTION GetWinFlags LIB "kernel" AS LONG
DECLARE FUNCTION YnrcRemoveFile LIB "msinsstf.dll" (szFullPathSrc$, cmo%) AS INTEGER




'**************************************************************************
'****************************** Setup Constants ***************************
'**************************************************************************


''Command Option Flags

CONST cmoVital       = 1
CONST cmoCopy        = 2
CONST cmoUndo        = 4
CONST cmoRoot        = 8
CONST cmoDecompress  = 16
CONST cmoTimeStamp   = 32
CONST cmoReadOnly    = 64
CONST cmoBackup      = 128
CONST cmoForce       = 256
CONST cmoRemove      = 512
CONST cmoOverwrite   = 1024
CONST cmoAppend      = 2048
CONST cmoPrepend     = 4096
CONST cmoNone        = 0
CONST cmoAll         = 65535


''File Exist Modes

CONST femExists     = 0
CONST femRead       = 1
CONST femWrite      = 2
CONST femReadWrite  = 3


''Read-Only Return Code

CONST ynrcNo         = 0
CONST ynrcYes        = 1
CONST ynrcErr1       = 2
CONST ynrcErr2       = 3
CONST ynrcErr3       = 4
CONST ynrcErr4       = 5
CONST ynrcErr5       = 6
CONST ynrcErr6       = 7
CONST ynrcErr7       = 8
CONST ynrcErr8       = 9
CONST ynrcErr9       = 10


''General Return Codes

CONST grcOkay       = 0
CONST grcNotOkay    = 1
CONST grcUserQuit   = 48


''Ranges

''CONST cbSymValMax = 8192
CONST cbSymValMax = 512
    ''REVIEW: symbol table will allow strings up to 8192 bytes
    '' but we get Out of String Space wattdrvr error if we alloc
    '' STRING$() that big. (See GetSymbolValue and GetListItem)
    '' We should look into using dynamic far alloc instead of
    '' STRING$ for large buffers.
    '' NOTE: 8192 works okay with runtime wattdrvr, however.


''ON ERROR Error Codes
CONST STFERR      = 1024   ''setup system error
CONST STFQUIT     = 1025   ''user quit

CONST scmOff      = 0
CONST scmOnIgnore = 1
CONST scmOnFatal  = 2


'**************************************************************************
'********************************  Setup API's  ***************************
'**************************************************************************

'' common

DECLARE FUNCTION FParseFATPathIntoPieces LIB "mscomstf.dll" (szPath$, szVol$, cbVol%, szDir$, cbDir%, szFile$, cbFile%) AS INTEGER
DECLARE FUNCTION FOpenInf LIB "mscomstf.dll" (szFile$, fCheck%, fCheckSyms%) AS INTEGER
DECLARE FUNCTION FSetSilent LIB "mscomstf.dll" (mode%) AS INTEGER
DECLARE FUNCTION FSetBeepingMode LIB "mscomstf.dll" (mode%) AS INTEGER
DECLARE FUNCTION HShowWaitCursor LIB "msshlstf.dll" AS INTEGER
DECLARE FUNCTION FRestoreCursor  LIB "msshlstf.dll" (hPrev%) AS INTEGER
DECLARE FUNCTION FOpenLogFile    LIB "mscomstf.dll" (szFile$, fAppend%) AS INTEGER
DECLARE FUNCTION FCloseLogFile   LIB "mscomstf.dll" AS INTEGER
DECLARE FUNCTION FWriteToLogFile LIB "mscomstf.dll" (sz$, fRequire%) AS INTEGER


''shell

DECLARE FUNCTION FSetBitmap LIB "msshlstf.dll" (szDll$, Bitmap%) AS INTEGER
DECLARE FUNCTION FDoDialog LIB "msuilstf.dll" (hwnd%, szDll$, Dlg%, szDlgProc$, HelpDlg%, szHelpProc$) AS INTEGER
DECLARE FUNCTION FKillNDialogs LIB "msuilstf.dll" (n%) AS INTEGER
DECLARE SUB SetWindowText LIB "User" (hwnd%, lpString$)
DECLARE FUNCTION FSetSymbolValue LIB "msshlstf.dll" (szSymbol$, szValue$) AS INTEGER
DECLARE FUNCTION FRemoveSymbol LIB "mscomstf.dll" (szSym$) AS INTEGER
DECLARE FUNCTION CbGetSymbolValue LIB "mscomstf.dll" (szSymbol$, szValue$, Length%) AS INTEGER
DECLARE FUNCTION UsGetListLength LIB "mscomstf.dll" (szSymbol$) AS INTEGER
DECLARE FUNCTION CbGetListItem LIB "mscomstf.dll" (szListSymbol$, n%, szListItem$, cbMax%) AS INTEGER
DECLARE FUNCTION FAddListItem LIB "mscomstf.dll" (szListSymbol$, szListItem$) AS INTEGER
DECLARE FUNCTION FReplaceListItem LIB "mscomstf.dll" (szListSymbol$, n%, szListItem$) AS INTEGER
DECLARE FUNCTION FSetSymbolToListOfInfKeys LIB "mscomstf.dll" (szSym$, szSect$, fNulls%) AS INTEGER


''shell

DECLARE FUNCTION InitializeFrame LIB "msshlstf.dll" (szCmdLine$) AS INTEGER
DECLARE FUNCTION HwndFrame LIB "msshlstf.dll" AS INTEGER
DECLARE FUNCTION HinstFrame LIB "msshlstf.dll" AS INTEGER



''install

DECLARE SUB      ProSetPos LIB "msinsstf.dll" (x%, y%)
DECLARE FUNCTION FCreateDir LIB "msinsstf.dll" (szDir$, cmo%) AS INTEGER
DECLARE FUNCTION FAddSectionFilesToCopyList LIB "mscomstf.dll" (szSect$, szSrc$, szDest$) AS INTEGER
DECLARE FUNCTION FAddSectionKeyFileToCopyList LIB "mscomstf.dll" (szSect$, szKey$, szSrc$, szDest$) AS INTEGER
DECLARE FUNCTION FAddSpecialFileToCopyList LIB "mscomstf.dll" (szSect$, szKey$, szSrc$, szDest$) AS INTEGER
DECLARE FUNCTION GrcCopyFilesInCopyList LIB "msinsstf.dll" (hInstance%) AS INTEGER
DECLARE FUNCTION FCreateIniKeyValue LIB "msinsstf.dll" (szFile$, szSect$, szKey$, szValue$, cmo%) AS INTEGER
DECLARE FUNCTION FCreateSysIniKeyValue LIB "msinsstf.dll" (szFile$, szSect$, szKey$, szValue$, cmo%) AS INTEGER
DECLARE FUNCTION FCreateProgManGroup LIB "msinsstf.dll" (szGroup$, szPath$, cmo%) AS INTEGER
DECLARE FUNCTION FCreateProgManItem LIB "msinsstf.dll" (szGroup$, szItem$, szCmd$, cmo%) AS INTEGER
DECLARE FUNCTION FShowProgManGroup LIB "msinsstf.dll" (szGroup$, szCmd$, cmo%) AS INTEGER
DECLARE FUNCTION FStampResource LIB "msinsstf.dll" (szSect$, szKey$, szDst$, wResType%, wResId%, szData$, cbData%) AS INTEGER
DECLARE FUNCTION FAddDos5Help LIB "msinsstf.dll" (szProgName$, szProgHelp$, cmo%) AS INTEGER
DECLARE FUNCTION FCopyOneFile LIB "msinsstf.dll" (szSrc$, szDest$, cmo%, fAppend%) AS INTEGER
DECLARE FUNCTION FInitializeInstall LIB "msinsstf.dll" (hinst%, hwndFrame%) AS INTEGER
DECLARE FUNCTION FIsDirWritable LIB "msinsstf.dll" (szDir$) AS INTEGER
DECLARE FUNCTION FIsFileWritable LIB "msinsstf.dll" (szFile$) AS INTEGER
DECLARE FUNCTION FExitExecRestart LIB "msinsstf.dll" AS INTEGER
DECLARE FUNCTION SetCopyMode LIB "msinsstf.dll" (fMode%) AS INTEGER
DECLARE FUNCTION GetCopyMode LIB "msinsstf.dll" AS INTEGER
DECLARE FUNCTION SetDecompMode LIB "msinsstf.dll" (fMode%) AS INTEGER
DECLARE FUNCTION GetDecompMode LIB "msinsstf.dll" AS INTEGER
DECLARE FUNCTION SetSizeCheckMode LIB "msinsstf.dll" (scmMode%) AS INTEGER

DECLARE FUNCTION SetTimeValue LIB "msinsstf.dll" (usHours%, usMinutes%, usSeconds%) AS INTEGER



'*************************************************************************
'****************  Setup Basic Wrapper Declarations  *********************
'*************************************************************************


''shell

DECLARE SUB SetBitmap(szDll$, Bitmap%)
DECLARE FUNCTION UIStartDlg(szDll$, Dlg%, szDlgProc$, HelpDlg%, szHelpProc$) AS STRING
DECLARE SUB UIPop (n%)
DECLARE SUB UIPopAll
DECLARE SUB SetTitle (sz$)
DECLARE SUB ReadInfFile (szFile$)
DECLARE SUB SetSymbolValue (szSymbol$, szValue$)
DECLARE SUB RemoveSymbol (szSym$)
DECLARE FUNCTION GetSymbolValue (szSymbol$) AS STRING
DECLARE FUNCTION GetListLength(szSymbol$) AS INTEGER
DECLARE FUNCTION GetListItem(szSymbol$, n%) AS STRING
DECLARE SUB AddListItem(szSymbol$, szItem$)
DECLARE SUB ReplaceListItem(szSymbol$, n%, szItem$)

DECLARE FUNCTION InitFrame (szCmdLine$) AS INTEGER
DECLARE FUNCTION InitSetup (szCmdLine$) AS INTEGER

DECLARE FUNCTION ShowWaitCursor AS INTEGER
DECLARE SUB RestoreCursor (hPrev%)

DECLARE FUNCTION SetBeepingMode (mode%) AS INTEGER
DECLARE FUNCTION SetSilentMode (mode%) AS INTEGER



''install


DECLARE SUB CreateDir (szDir$, cmo%)
DECLARE SUB AddSectionFilesToCopyList (szSect$, szSrc$, szDest$)
DECLARE SUB AddSectionKeyFileToCopyList (szSect$, szKey$, szSrc$, szDest$)
DECLARE SUB AddSpecialFileToCopyList (szSect$, szKey$, szSrc$, szDest$)
DECLARE SUB CopyFilesInCopyList
DECLARE SUB CreateIniKeyValue (szFile$, szSect$, szKey$, szValue$, cmo%)
DECLARE SUB CreateSysIniKeyValue (szFile$, szSect$, szKey$, szValue$, cmo%)
DECLARE SUB CreateProgmanGroup (szGroup$, szPath$, cmo%)
DECLARE SUB CreateProgmanItem (szGroup$, szItem$, szCmd$, szOther$, cmo%)
DECLARE SUB ShowProgmanGroup (szGroup$, Cmd%, cmo%)
DECLARE SUB StampResource (szSect$, szKey$, szDst$, wResType%, wResId%, szData$, cbData%)
DECLARE SUB AddDos5Help (szProgName$, szProgHelp$, cmo%)
DECLARE SUB CopyFile (szFullPathSrc$, szFullPathDst$, cmo%, fAppend%)
DECLARE SUB RemoveFile (szFullPathSrc$, cmo%)
DECLARE SUB InitInstall
DECLARE SUB OpenLogFile (szFile$, fAppend%)
DECLARE SUB CloseLogFile
DECLARE SUB WriteToLogFile (szStr$)
DECLARE FUNCTION ExitExecRestart AS INTEGER
DECLARE FUNCTION IsDirWritable (szDir$) AS INTEGER
DECLARE FUNCTION IsFileWritable (szFile$) AS INTEGER



'' Error Handling

'' Setup API Errors
CONST saeFail   = 0
CONST saeInit   = 1
CONST saeNYI    = 3
CONST saeArg    = 4    ''must be max sae value

DECLARE SUB StfApiErr (nMsg%, szApi$, szArgs$)
DECLARE SUB BadArgErr (nArg%, szApi$, szArgs$)

'' chk arg
DECLARE FUNCTION FValidFATDir LIB "mscomstf.dll" (szDir$) AS INTEGER
DECLARE FUNCTION CchlValidFATSubPath LIB "mscomstf.dll" (szPath$) AS INTEGER
DECLARE FUNCTION FValidFATPath LIB "mscomstf.dll" (szPath$) AS INTEGER
DECLARE FUNCTION FValidDrive (szDrive$) AS INTEGER

DECLARE FUNCTION FValidInfSect (szSect$) AS INTEGER
DECLARE FUNCTION FValidIniFile (szFile$) AS INTEGER



'' Windows system detect

DECLARE FUNCTION GetWindowsMajorVersion AS INTEGER
DECLARE FUNCTION GetWindowsMinorVersion AS INTEGER
DECLARE FUNCTION GetWindowsMode AS INTEGER
DECLARE FUNCTION GetWindowsDir  AS STRING
DECLARE FUNCTION GetWindowsSysDir AS STRING
DECLARE FUNCTION IsWindowsShared AS INTEGER
DECLARE FUNCTION GetScreenWidth AS INTEGER
DECLARE FUNCTION GetScreenHeight AS INTEGER


'*************************************************************************
'*****************  Setup Basic Wrapper Definitions  *********************
'*************************************************************************
FUNCTION InitSetup(szCmdLine$) STATIC AS INTEGER
    fFrameInit = 0
    fInstallInit = 0


    i% = InitFrame(szCmdLine$)
    fFrameInit = 1

    InitInstall
    fInstallInit = 1

    InitSetup = i%
END FUNCTION



'**************************************************************************
FUNCTION InitFrame(szCmdLine$) STATIC AS INTEGER
    IF hSetup > 0 THEN
	ELSE
        i% = InitializeFrame(szCmdLine$)
        IF i% = -1 THEN
            END   '' NOT an error - Usage (/?) or Command line copy operation
        ELSEIF i% = 0 THEN
			END
        ELSE
            InitFrame = i%
        END IF
    END IF
END FUNCTION


'**************************************************************************
SUB SetBitmap(szDll$, Bitmap%) STATIC
    IF FSetBitmap(szDll$, Bitmap%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB SetTitle(sz$) STATIC
    SetWindowText HwndFrame(), sz$
END SUB


'*************************************************************************
SUB ReadInfFile (szFile$) STATIC
	IF FOpenInf(szFile$, 1, 0) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
FUNCTION UIStartDlg(szDll$, Dlg%, szDlgProc$, HelpDlg%, szHelpProc$) STATIC AS STRING

    IF FDoDialog(HwndFrame(), szDll$, Dlg%, szDlgProc$, HelpDlg%, szHelpProc$) = 0 THEN
		ERROR STFERR
    ELSE
        UIStartDlg = GetSymbolValue("DLGEVENT")
    END IF
END FUNCTION


'*************************************************************************
SUB UIPop (n%) STATIC
    IF FKillNDialogs(n%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB UIPopAll STATIC
    IF FKillNDialogs(65535) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
FUNCTION GetSymbolValue(szSymbol$) STATIC AS STRING
	szValue$ = string$(cbSymValMax,32)
    Length% = CbGetSymbolValue(szSymbol$, szValue$, cbSymValMax)
    GetSymbolValue = szValue$
    IF Length% >= cbSymValMax THEN
        res% = DoMsgBox("Buffer Overflow", "MS-Setup Error", MB_ICONHAND+MB_OK)
        ERROR STFERR
    END IF
    IF szSymbol$ = "" THEN
        ERROR STFERR
    END IF
    szValue$ = ""
END FUNCTION


'*************************************************************************
FUNCTION GetListLength(szSymbol$) STATIC AS INTEGER
	GetListLength = UsGetListLength(szSymbol$)
    IF szSymbol$ = "" THEN
        ERROR STFERR
    END IF
END FUNCTION


'*************************************************************************
FUNCTION GetListItem(szListSymbol$, nItem%) STATIC AS STRING

    szListItem$ = string$(cbSymValMax,32)
    Length% = CbGetListItem(szListSymbol$, nItem%, szListItem$, cbSymValMax)
    GetListItem = szListItem$
    IF Length% >= cbSymValMax THEN
        res% = DoMsgBox("Buffer Overflow", "MS-Setup Error", MB_ICONHAND+MB_OK)
        ERROR STFERR
    END IF
    IF szListSymbol$ = "" THEN
        ERROR STFERR
    END IF
    if nItem% <= 0 or nItem% > GetListLength(szListSymbol$) then
        ERROR STFERR
    end if
    szListItem$ = ""
END FUNCTION


'*************************************************************************
SUB AddListItem(szSymbol$, szItem$) STATIC
	IF FAddListItem(szSymbol$, szItem$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB ReplaceListItem(szSymbol$, n%, szItem$) STATIC

    IF FReplaceListItem(szSymbol$, n%, szItem$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB SetSymbolValue(szSymbol$, szValue$) STATIC
	IF FSetSymbolValue(szSymbol$, szValue$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB RemoveSymbol(szSym$) STATIC
	IF FRemoveSymbol(szSym$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
FUNCTION ShowWaitCursor STATIC AS INTEGER
    ShowWaitCursor = HShowWaitCursor
END FUNCTION


'*************************************************************************
SUB RestoreCursor (hPrev%) STATIC
    i% = FRestoreCursor(hPrev%)
    IF i% = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
FUNCTION SetBeepingMode (mode%) STATIC AS INTEGER
    SetBeepingMode = FSetBeepingMode(mode%)
END FUNCTION


'*************************************************************************
FUNCTION SetSilentMode (mode%) STATIC AS INTEGER
    SetSilentMode = FSetSilent(mode%)
END FUNCTION


'*************************************************************************
SUB InitInstall STATIC
    IF hSetup > 0 THEN
	ELSEIF FInitializeInstall(HinstFrame(), HwndFrame()) = 0 THEN
		END
    END IF
END SUB


'*************************************************************************
SUB CreateDir (szDir$, cmo%) STATIC
	IF FCreateDir(szDir$, cmo%) = 0 THEN
		ERROR STFERR
    END IF
END SUB



'*************************************************************************
SUB CreateIniKeyValue (szFile$, szSect$, szKey$, szValue$, cmo%) STATIC

    IF FCreateIniKeyValue(szFile$, szSect$, szKey$, szValue$, cmo%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB CreateSysIniKeyValue (szFile$, szSect$, szKey$, szValue$, cmo%) STATIC

    IF FCreateSysIniKeyValue(szFile$, szSect$, szKey$, szValue$, cmo%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB CreateProgmanGroup (szGroup$, szPath$, cmo%) STATIC
	IF FCreateProgManGroup(szGroup$, szPath$, cmo%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB ShowProgmanGroup (szGroup$, Cmd%, cmo%) STATIC
	IF FShowProgManGroup(szGroup$, STR$(Cmd%), cmo%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB StampResource (szSect$, szKey$, szDst$, wResType%, wResId%, szData$, cbData%) STATIC

    IF FStampResource (szSect$, szKey$, szDst$, wResType%, wResId%, szData$, cbData%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB CreateProgmanItem (szGroup$, szItem$, szCmd$, szOther$, cmo%) STATIC
    szItemNew$ = szItem$
    IF szOther$ <> "" THEN
        szItemNew$ = szItem$ + "," + szOther$
    END IF

    IF FCreateProgManItem(szGroup$, szItemNew$, szCmd$, cmo%) = 0 THEN
		ERROR STFERR
    END IF
    szItemNew$ = ""
END SUB


'*************************************************************************
SUB AddDos5Help (szProgName$, szProgHelp$, cmo%) STATIC
	IF FAddDos5Help (szProgName$, szProgHelp$, cmo%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB CopyFilesInCopyList STATIC
    grc% = GrcCopyFilesInCopyList (HinstFrame())

    IF grc% = grcUserQuit THEN
        ERROR STFQUIT
    ELSEIF grc% > 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB CopyFile (szFullPathSrc$, szFullPathDst$, cmo%, fAppend%) STATIC

    IF  FCopyOneFile(szFullPathSrc$, szFullPathDst$, (cmo OR cmoCopy), fAppend%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB RemoveFile (szFullPathSrc$, cmo%) STATIC
	IF	YnrcRemoveFile(szFullPathSrc$, cmo%) = ynrcNo THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB AddSectionFilesToCopyList (szSect$, szSrc$, szDest$) STATIC

    IF FAddSectionFilesToCopyList (szSect$, szSrc$, szDest$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB AddSectionKeyFileToCopyList (szSect$, szKey$, szSrc$, szDest$) STATIC

    IF FAddSectionKeyFileToCopyList (szSect$, szKey$, szSrc$, szDest$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB AddSpecialFileToCopyList (szSect$, szKey$, szSrc$, szDest$) STATIC

    IF FAddSpecialFileToCopyList (szSect$, szKey$, szSrc$, szDest$) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB OpenLogFile (szFile$, fAppend%) STATIC
	IF FOpenLogFile(szFile$, fAppend%) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB CloseLogFile STATIC
    IF FCloseLogFile() = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
SUB WriteToLogFile (szStr$) STATIC
    IF FWriteToLogFile(szStr$, 1) = 0 THEN
		ERROR STFERR
    END IF
END SUB


'*************************************************************************
FUNCTION IsDirWritable (szDir$) STATIC AS INTEGER
    IsDirWritable = FIsDirWritable(szDir$)
END FUNCTION


'*************************************************************************
FUNCTION IsFileWritable (szFile$) STATIC AS INTEGER
	IsFileWritable = FIsFileWritable(szFile$)
END FUNCTION


'*************************************************************************
FUNCTION GetWindowsMajorVersion STATIC AS INTEGER
    GetWindowsMajorVersion = GetVersion() MOD 256
END FUNCTION


'*************************************************************************
FUNCTION GetWindowsMinorVersion STATIC AS INTEGER
    GetWindowsMinorVersion = GetVersion() / 256
END FUNCTION


'*************************************************************************
FUNCTION GetWindowsMode STATIC AS INTEGER
    GetWindowsMode = 0
    longTmp& = GetWinFlags()
    IF longTmp& AND WF_STANDARD THEN
        GetWindowsMode = 1
    ELSEIF longTmp& AND WF_ENHANCED THEN
        GetWindowsMode = 2
    END IF
END FUNCTION


'*************************************************************************
FUNCTION GetWindowsDir STATIC AS STRING
    szBuf$ = string$(256, 32)
    cbBuf% = GetWindowsDirectory(szBuf$, 256)

    IF cbBuf% = 0 THEN
        GetWindowsDir = ""
		ERROR STFERR
    ELSE
        IF cbBuf% > 255 THEN
            res% = DoMsgBox("Buffer Overflow", "MS-Setup Error", MB_ICONHAND+MB_OK)
            ERROR STFERR
        END IF
        szBuf$ = RTRIM$(szBuf$)
        IF MID$(szBuf$, 1, 1) = "\" THEN
            'szBuf$ = MID$(CURDIR$, 1, 2) + szBuf$
            szBuf$ = MID$(GetWindowsSysDir, 1, 2) + szBuf$
        ELSEIF MID$(szBuf$, 2, 1) <> ":" THEN
            szBuf$ = MID$(GetWindowsSysDir, 1, 3) + szBuf$
        END IF
        IF MID$(szBuf$, LEN(szBuf$), 1) <> "\" THEN
            szBuf$ = szBuf$ + "\"
        END IF
        GetWindowsDir = szBuf$
    END IF

    szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION GetWindowsSysDir STATIC AS STRING
    szBuf$ = string$(256, 32)
    cbBuf% = GetSystemDirectory(szBuf$, 256)

    IF cbBuf% = 0 THEN
		ERROR STFERR
    ELSE
        IF cbBuf% > 255 THEN
            res% = DoMsgBox("Buffer Overflow", "MS-Setup Error", MB_ICONHAND+MB_OK)
            ERROR STFERR
        END IF
        szBuf$ = RTRIM$(szBuf$)
        IF MID$(szBuf$, 1, 1) = "\" THEN
            szBuf$ = MID$(CURDIR$, 1, 2) + szBuf$
        ELSEIF MID$(szBuf$, 2, 1) <> ":" THEN
            szBuf$ = MID$(CURDIR$, 1, 3) + szBuf$
        END IF
        IF MID$(szBuf$, LEN(szBuf$), 1) <> "\" THEN
            szBuf$ = szBuf$ + "\"
        END IF
        GetWindowsSysDir = szBuf$
    END IF

    szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION IsWindowsShared STATIC AS INTEGER
    szWin$ = UCASE$(GetWindowsDir())
    szSys$ = UCASE$(GetWindowsSysDir())

    IF len(szWin$) = 0 THEN
		ERROR STFERR
    END IF

    IF len(szSys$) <= len(szWin$) THEN
        IsWindowsShared = 1
    ELSE
        szSys$ = MID$(szSys$, 1, len(szWin$))
        IF szWin$ = szSys$ THEN
            IsWindowsShared = 0
        ELSE
            IsWindowsShared = 1
        END IF
    END IF
END FUNCTION


'*************************************************************************
FUNCTION GetScreenWidth STATIC AS INTEGER
    GetScreenWidth = GetSystemMetrics(SM_CXSCREEN)
END FUNCTION


'*************************************************************************
FUNCTION GetScreenHeight STATIC AS INTEGER
    GetScreenHeight = GetSystemMetrics(SM_CYSCREEN)
END FUNCTION


'*************************************************************************
FUNCTION ExitExecRestart STATIC AS INTEGER
    ExitExecRestart = FExitExecRestart
END FUNCTION




'**************************************************************************
'***************************  Error Handlers  *****************************
'**************************************************************************


'**************************************************************************
SUB StfApiErr (nMsg%, szApi$, szArgs$) STATIC      ''DEBUG only
    select case nMsg%
        case saeFail
            lpText$ = "Failed"
        case saeInit
            lpText$ = "Already Initialized"
        case saeNYI
            lpText$ = "NYI"
        case else
            lpText$ = "Bad Arg "+LTRIM$(STR$(nMsg% - saeArg))
    end select

    lpText$ = lpText$ + ": "+ szApi$
    if szArgs$ <> "" then
        lpText$ = lpText + " (" + szArgs$ + ")"
    end if
    lpCaption$ = "MS-Setup Toolkit API Error"
    res% = DoMsgBox(lpText$, lpCaption$, MB_TASKMODAL+MB_ICONHAND+MB_OK)
    print lpText$
    lpText$ = ""
    lpCaption$ = ""
END SUB

'**************************************************************************
SUB BadArgErr (nArg%, szApi$, szArgs$) STATIC      ''DEBUG only
    StfApiErr nArg%+saeArg, szApi$, szArgs$
    ERROR STFERR
END SUB


'** REVIEW: Move this function into common lib (we'll need it there too)
'**************************************************************************
FUNCTION FValidInfSect (szSect$) STATIC AS INTEGER
    if (szSect$ = "") OR (INSTR(1,szSect$,"]") <> 0) then
        FValidInfSect = 0
    else
        FValidInfSect = 1
    end if
END FUNCTION


'** REVIEW: Move this function into common lib (we'll need it there too)
'**************************************************************************
FUNCTION FValidIniFile (szFile$) STATIC AS INTEGER
    if (FValidFATPath(szFile$) = 0) AND (UCASE$(szFile$) <> "WIN.INI") then
        FValidIniFile = 0
    else
        FValidIniFile = 1
    end if
END FUNCTION

'**************************************************************************
FUNCTION FValidDrive (szDrive$) STATIC AS INTEGER

    if szDrive$ = "" then
        FValidDrive = 0
    elseif INSTR(1,szDrive$,"\\") = 1 then   ' UNC path
        FValidDrive = 1
    elseif ASC(UCASE$(szDrive$)) - ASC("A") < 0 then
        FValidDrive = 0
    elseif ASC(UCASE$(szDrive$)) - ASC("A") > 25 then
        FValidDrive = 0
    elseif LEN(szDrive$) = 1 then
        FValidDrive = 1
    elseif INSTR(2,szDrive$,":\") = 2 then
        FValidDrive = 1
    elseif INSTR(1,szDrive$,":") = 2 then
        FValidDrive = 1
    else
        FValidDrive = 0
    end if
END FUNCTION



TRAP CleanupTrap From "MSSHLSTF.DLL"

End Trap

hSetup = InitSetup(COMMAND$)

ON ERROR GOTO QUIT
