#ifndef __EXLIB_H
#define __EXLIB_H

#ifndef __WINDOWS_H
#include <windows.h>
#endif

// assorted identifiers for generic DLL functions
#define EX_PLUGINIT		3
#define EX_PLUGDESTROY	4
#define EX_PLUGCOMMAND 	5
#define EX_PLUGPROCESS	6

#ifndef AL_IDLE
// Returns from DLL functions
#define AL_IDLE		0
#define AL_OK		1
#define AL_DIE		2
#define AL_HANGUP	3
#endif

#if !defined(EXLIBH)
#define EXLIBH EXLIBH
DECLARE_HANDLE32(EXLIBH);
DECLARE_HANDLE32(EXTOOLBAR);
DECLARE_HANDLE32(EXCHILD);
#endif

typedef void (FAR * FAR TBSetupType)( EXLIBH, EXCHILD );

typedef struct tagExcalWindow {
	HINSTANCE	DLLInstance;	// the DLL instance
#if defined( OWL_OWLDEFS_H )
	TWindow *	OwlWindow;		// an OWL window pointer
#else
	LPVOID		OwlWindow;		// an OWL window pointer
#endif
	LPCSTR		Title;			// title of the window
	LPCSTR		Class;			// Window Class
	DWORD			Style;			// Window Style
	WORD			x, y, cx, cy;	// window position and size
	LPARAM		CreateParms;	// creation parameters passed with WM_CREATE
	LPCSTR		Menu;				// menu identifier
	int			EditCount;		// count of popup menus for the edit menu(s)
	int			MenuCount;		// number of popup menus on the user supplied menu
	BOOL			KBHandling;		// need to provide keyboard handling?
	int 			ShowMethod;		// usually SW_SHOW
	LPCSTR		Icon;				// icon identifier
	TBSetupType ToolbarSetup;	// for setting up the toolbar
	} ExcalWindow;

// API function declarations
#ifdef __cplusplus
extern "C" {
#endif

HWND FAR PASCAL ExMDIClient( EXLIBH LibH );
HWND FAR PASCAL ExCreateTool( EXLIBH LibH, ExcalWindow FAR *control );
void FAR PASCAL ExSetToDie( EXLIBH LibH );
void FAR PASCAL ExSetPtr( EXLIBH LibH, LPVOID value );
LPVOID FAR PASCAL ExGetPtr( EXLIBH LibH );
EXTOOLBAR FAR PASCAL ExCreateToolbar( EXLIBH LibH, EXCHILD child, WORD id );

// Values for type for ExButtonGadget
#define EXBG_COMMAND 0
#define EXBG_EXCLUSIVE 1
#define EXBG_NONEXCLUSIVE	2
// Values for state for ExButtonGadget
#define EXBG_STATE_UP 0
#define EXBG_STATE_DOWN 1
#define EXBG_STATE_INDETERMINATE 2

void FAR PASCAL ExButtonGadget( EXTOOLBAR cb, LPCSTR resid, WORD id, WORD type,
	BOOL enabled, WORD state, BOOL repeat );
void FAR PASCAL ExSeparatorGadget( EXTOOLBAR cb, WORD size );
void FAR PASCAL ExInsertToolbar( EXCHILD child, EXTOOLBAR cb );
void FAR PASCAL ExAddBlock( EXLIBH LibH, LPVOID data, WORD len );
HFONT FAR PASCAL ExDlgFont( EXLIBH LibH );
int FAR PASCAL ExDlgFontW( EXLIBH LibH );
int FAR PASCAL ExDlgFontH( EXLIBH LibH );
int FAR PASCAL ExDlgEditH( EXLIBH LibH );
void FAR PASCAL ExSetStatus( EXLIBH LibH, LPCSTR text );
void FAR PASCAL ExPumpMessages( EXLIBH LibH );

#ifdef __cplusplus
	};
#endif

#endif