#ifndef __ALCHEMW_H
#define __ALCHEMW_H

// assorted identifiers for generic DLL functions
#define AL_PLUGTYPE 	3
#define AL_PLUGPROCESS	4
#define AL_PLUGDESTROY	5
#define AL_PLUGUNIQUE	6
#define AL_PLUGDIALOG	7
#define AL_PLUGBUTTON	8
#define AL_PLUGDATA		9
#define AL_PLUGMOUSE		10
#define AL_PLUGDLLSIZE	11
#define AL_PLUGNEXTDLL	12
#define AL_PLUGDLLVERIFY	13
#define AL_PLUGCOMMAND	14
#define AL_PLUGBROADCAST	15
#define AL_PLUGACTIVATE		16
#define AL_PLUGPAINT			17
#define AL_PLUGRESIZE		18
#define AL_PLUGRECEIVE		19

// assorted identifiers for screen DLL functions
#define AL_PLUGSTARTSCREEN 	3
#define AL_PLUGSCREENBLOCK	4
#define AL_PLUGENDSCREEN	5

// assorted identifiers for string substitution DLL's
#define AL_PLUGTEXT		1

// window types
#define AL_WIN_NONE		0
#define AL_WIN_HIDDEN	1
#define AL_WIN_GRAPHIC	2
#define AL_WIN_PLUGIN	3
#define AL_WIN_MULTI		0x1000

// Returns from PlugProcess
#define AL_IDLE		0
#define AL_OK		1
#define AL_DIE		2
#define AL_HANGUP	3

// Returns from PlugCheckDLL
#define NODLL_OK			0	// DLL is just fine... use it.
#define NODLL_NONE		1	// no copy of the DLL
#define NODLL_MINOR		2	// minor revision... error corrections only
#define NODLL_MAJOR		3	// major revision... definitely incompatable
#define NODLL_NEWER		4	// too new major revision... maybe incompatable
#define NODLL_BADOS		5	// DLL not available for your particular OS
#define NODLL_LANGUAGE	6	// DLL not available for particular language
#define NODLL_OVERWRITE	7	// will over-write something by other mfgr

// Standard colors
#define AL_BLACK		 0
#define AL_RED			 1
#define AL_GREEN		 2
#define AL_BROWN		 3
#define AL_BLUE			 4
#define AL_MAGENTA		 5
#define AL_CYAN			 6
#define AL_GRAY			 7
#define AL_LTGRAY		 8
#define AL_LTRED		 9
#define AL_LTGREEN		10
#define AL_YELLOW		11
#define AL_LTBLUE		12
#define AL_LTMAGENTA	13
#define AL_LTCYAN		14
#define AL_WHITE		15

#define AL_BLANK_LONG	0x80000000L
#define AL_BLANK_WORD	0x8000
#define AL_BLANK_BYTE	0x80


// broadcast codes from Grail
#define AL_BROAD_ALLHERE	1	// short count followed by structure below
#define AL_BROAD_ENTER		2	// see structure below
#define AL_BROAD_LEAVE		3	// LONG follows that is the ID

typedef struct tagAlBroadEnter {
	LONG		MultiID;			// ID of registered dll
	LONG		UserID;			// ID of person entering
	BYTE		Slot;				// the slot the person entered on.
	char		First[21], Middle[21], Last[21];
	char		Handle[41];
	} AlBroadEnter;


#if !defined( LPSLOT )
DECLARE_HANDLE32(LPSLOT);
#endif

// API function declarations
#ifdef __cplusplus
extern "C" {
#endif

// miscellaneous functions
WORD FAR PASCAL AlSlot( LPSLOT SlotH );
LPSTR FAR PASCAL AlArgs( LPSLOT SlotH, LPSTR dest, WORD len );
void FAR PASCAL AlCaption( LPSLOT SlotH, LPCSTR title );
void FAR PASCAL AlLogWrite( LPSLOT SlotH, LPCSTR text );
HGLOBAL FAR PASCAL AlAlloc( LPSLOT SlotH, DWORD size );
void FAR PASCAL AlFree( LPSLOT SlotH );
void * FAR PASCAL AlLock( LPSLOT SlotH );
void FAR PASCAL AlUnlock( LPSLOT SlotH );
HGLOBAL FAR PASCAL AlReAlloc( LPSLOT SlotH, DWORD size );
HGLOBAL FAR PASCAL AlGetHandle( LPSLOT SlotH );
void FAR PASCAL AlSetHandle( LPSLOT SlotH, HGLOBAL handle );
LPVOID FAR PASCAL AlGetPointer( LPSLOT SlotH );
VOID FAR PASCAL AlSetPointer( LPSLOT SlotH, LPVOID pointer );
void FAR PASCAL AlAddBlock( LPSLOT SlotH, LPVOID data, WORD len );
HWND FAR PASCAL AlMainWindow( LPSLOT SlotH );
void FAR PASCAL AlSetWindowOrg( LPSLOT SlotH, HDC hdc );
WORD FAR PASCAL AlSetState( LPSLOT SlotH, WORD value );
WORD FAR PASCAL AlGetState( LPSLOT SlotH );
void FAR PASCAL AlPushState( LPSLOT SlotH, WORD value );
WORD FAR PASCAL AlPopState( LPSLOT SlotH );

// screen handling routines
HFILE FAR PASCAL AlOpenScreen( LPSLOT SlotH, LPCSTR name, OFSTRUCT *ofs,
								UINT mode );
HFILE FAR PASCAL AlOpenScratch( LPSLOT SlotH, LPCSTR name, OFSTRUCT *ofs,
								UINT mode );
HFILE FAR PASCAL AlOpenUserFile( LPSLOT SlotH, LPCSTR name, OFSTRUCT *ofs,
				UINT mode );
HFILE FAR PASCAL AlOpenGlobalFile( LPSLOT SlotH, LPCSTR name, OFSTRUCT *ofs,
				UINT mode );
DWORD FAR PASCAL AlDateTimeNow();
void FAR PASCAL AlDateDecode( DWORD date, WORD *year, WORD *month, WORD *day );
DWORD FAR PASCAL AlDateEncode( WORD year, WORD month, WORD day );
void FAR PASCAL AlReleaseButton( LPSLOT SlotH );
void FAR PASCAL AlSound( LPSLOT SlotH, LPCSTR sound );
void FAR PASCAL AlMessageBox( LPSLOT SlotH, LPCSTR message, LPCSTR title, WORD code );
void FAR PASCAL AlMouseDisable( LPSLOT SlotH );
void FAR PASCAL AlMouseEnable( LPSLOT SlotH );
void FAR PASCAL AlMouseRelease( LPSLOT SlotH );

// Dialog processing functions
void FAR PASCAL AlExecDialog( LPSLOT SlotH );
BOOL FAR PASCAL AlLoadDialog( LPSLOT SlotH, LPCSTR resourceID, HINSTANCE module );
void FAR PASCAL AlNewDialog( LPSLOT SlotH, LPCSTR caption, UINT x, UINT y, UINT w, UINT h );
void FAR PASCAL AlDialogPress( LPSLOT SlotH, WORD id );
void FAR PASCAL AlSetString( LPSLOT SlotH, UINT id, LPCSTR string );
void FAR PASCAL AlSetCheck( LPSLOT SlotH, UINT id );
void FAR PASCAL AlLbAddString( LPSLOT SlotH, UINT id, LPCSTR string );
void FAR PASCAL AlCbAddString( LPSLOT SlotH, UINT id, LPCSTR string );
void FAR PASCAL AlLimitText( LPSLOT SlotH, UINT id, UINT len );
void FAR PASCAL AlItemEdit( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style );
void FAR PASCAL AlItemStatic( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style, LPCSTR text );
void FAR PASCAL AlItemButton( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style, LPCSTR text );
void FAR PASCAL AlItemListBox( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style );
void FAR PASCAL AlItemComboBox( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style );
void FAR PASCAL AlItemScrollBar( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style );
void FAR PASCAL AlItemBorShade( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style, LPCSTR text );
void FAR PASCAL AlItemBorCheck( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style, LPCSTR text );
void FAR PASCAL AlItemBorRadio( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style, LPCSTR text );
void FAR PASCAL AlItemBorButton( LPSLOT SlotH, UINT id, WORD x, WORD y, WORD w, WORD h,
	DWORD style );
WORD FAR PASCAL AlDialogReturn( LPSLOT SlotH );
LPSTR FAR PASCAL AlGetText( LPSLOT SlotH, UINT id, LPSTR dest, UINT len );
int FAR PASCAL AlGetTextLen( LPSLOT SlotH, UINT id );
BOOL FAR PASCAL AlGetCheck( LPSLOT SlotH, UINT id );
WORD FAR PASCAL AlGetSelected( LPSLOT SlotH, UINT id );
WORD FAR PASCAL AlGetSelList( LPSLOT SlotH, UINT id, WORD *dest,
	int limit );
WORD FAR PASCAL AlGetSelCount( LPSLOT SlotH, UINT id );
WORD FAR PASCAL AlGetScrollPos( LPSLOT SlotH, UINT id );
void FAR PASCAL AlSetScrollPos( LPSLOT SlotH, UINT id, WORD pos );
void FAR PASCAL AlSetScrollRange( LPSLOT SlotH, UINT id,
	WORD lower, WORD upper );
void FAR PASCAL AlLbSelect( LPSLOT SlotH, UINT id, UINT pick );
void FAR PASCAL AlLbSelectItem( LPSLOT SlotH, UINT id, UINT pick );
void FAR PASCAL AlLbSelectRange( LPSLOT SlotH, UINT id, UINT lower, UINT upper );
void FAR PASCAL AlCbSelect( LPSLOT SlotH, UINT id, UINT pick );

// general Grail database access
BOOL FAR PASCAL AlGrailRequest( LPSLOT SlotH, LPCSTR table, LPCSTR fields,
	LPCSTR filter );
BOOL FAR PASCAL AlGrailExecute( LPSLOT SlotH, LPCSTR command );
BOOL FAR PASCAL AlCreateGrailInsert( LPSLOT SlotH, LPCSTR table,
	WORD size, BOOL needID );
BOOL FAR PASCAL AlCreateGrailUpdate( LPSLOT SlotH, LPCSTR table,
	WORD size, DWORD id );
void * FAR PASCAL AlGrailLock( LPSLOT SlotH );
void FAR PASCAL AlGrailUnlock( LPSLOT SlotH );
DWORD FAR PASCAL AlGrailLastInsert( LPSLOT SlotH );

// Current User Information
DWORD FAR PASCAL AlGetUserID( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserULBytes( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserDLBytes( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserBalance( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserRevenue( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserLastCall( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserDayByteLeft( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserWeekByteLeft( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserMonthByteLeft( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserPermByte( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserPermTime( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserFirstCall( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserExpiration( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserCallByte( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserDayByte( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserWeekByte( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserMonthByte( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserBirth( LPSLOT SlotH );
DWORD FAR PASCAL AlGetUserOtherMail( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserULFiles( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserDLFiles( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserTotalCall( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserDayTimeLeft( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserWeekTimeLeft( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserMonthTimeLeft( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserByteRatio( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserFileRatio( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserCallTime( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserDayTime( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserWeekTime( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserMonthTime( LPSLOT SlotH );
WORD FAR PASCAL AlGetUserLanguage( LPSLOT SlotH );
LPSTR FAR PASCAL AlGetUserFirst( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserMiddle( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserLast( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserHandle( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPassword( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserTitle( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPosition( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserCompany( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserAddress1( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserAddress2( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserCity( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserState( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserCountry( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPostal( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPhoneHome( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPhoneWork( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPhoneFax( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserPhoneBBS( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserFirstVerify( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserLastVerify( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserLocalNet( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetUserNetID( LPSLOT SlotH, LPSTR dest, WORD len );

LPSTR FAR PASCAL AlGetUserComment( LPSLOT SlotH, LPSTR dest, WORD len );
BOOL FAR PASCAL AlGetUserFlag( LPSLOT SlotH, LPSTR dest, WORD index );
WORD FAR PASCAL AlGetUserFlagCount( LPSLOT SlotH );
BOOL FAR PASCAL AlIsUserFlag( LPSLOT SlotH, LPCSTR flag );
void FAR PASCAL AlSetUserFlag( LPSLOT SlotH, LPSTR name );
void FAR PASCAL AlClearUserFlag( LPSLOT SlotH, LPSTR name );

void FAR PASCAL AlSetUserULBytes( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserDLBytes( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserBalance( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserRevenue( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserLastCall( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserDayByteLeft( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserWeekByteLeft( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserMonthByteLeft( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserPermByte( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserPermTime( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserFirstCall( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserExpiration( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserCallByte( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserDayByte( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserWeekByte( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserMonthByte( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserBirth( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserOtherMail( LPSLOT SlotH, DWORD value );
void FAR PASCAL AlSetUserULFiles( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserDLFiles( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserTotalCall( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserDayTimeLeft( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserWeekTimeLeft( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserMonthTimeLeft( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserByteRatio( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserFileRatio( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserCallTime( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserDayTime( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserWeekTime( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserMonthTime( LPSLOT SlotH, WORD value );
void FAR PASCAL AlSetUserLanguage( LPSLOT SlotH, WORD value );
LPSTR FAR PASCAL AlSetUserFirst( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserMiddle( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserLast( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserHandle( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPassword( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserTitle( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPosition( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserCompany( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserAddress1( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserAddress2( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserCity( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserState( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserCountry( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPostal( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPhoneHome( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPhoneWork( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPhoneFax( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserPhoneBBS( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserFirstVerify( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserLastVerify( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserLocalNet( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserNetID( LPSLOT SlotH, LPSTR text );
LPSTR FAR PASCAL AlSetUserComment( LPSLOT SlotH, LPSTR text );

// Current Port Information
DWORD FAR PASCAL AlGetPortID( LPSLOT SlotH );
DWORD FAR PASCAL AlGetPortLastUser( LPSLOT SlotH );
DWORD FAR PASCAL AlGetPortCalls( LPSLOT SlotH );
DWORD FAR PASCAL AlGetPortBaud( LPSLOT SlotH );
DWORD FAR PASCAL AlGetPortTemplate( LPSLOT SlotH );
DWORD FAR PASCAL AlGetPortGuest( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortWinStyle( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortWinX( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortWinY( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortWinW( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortWinH( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortBeepRepeat( LPSLOT SlotH );
WORD FAR PASCAL AlGetPortBeepInterval( LPSLOT SlotH );
BYTE FAR PASCAL AlGetPortPort( LPSLOT SlotH );
BOOL FAR PASCAL AlGetPortRingDetect( LPSLOT SlotH );
BOOL FAR PASCAL AlGetPortUseHangup( LPSLOT SlotH );
BYTE FAR PASCAL AlGetPortRingCount( LPSLOT SlotH );
BYTE FAR PASCAL AlGetPortTimeout( LPSLOT SlotH );
BOOL FAR PASCAL AlGetPortLockRate( LPSLOT SlotH );
void FAR PASCAL AlGetPortDriveMap( LPSLOT SlotH, LPSTR dest );
LPSTR FAR PASCAL AlGetPortNetName( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortSendExcal( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortLogin( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortNewUser( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortModemName( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortReset( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortInit( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortOffHook( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortOnHook( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortAnswer( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortRing( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortCIDPrefix( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortCIDPrivate( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortCIDNone( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortHangup( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect1200( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect2400( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect4800( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect9600( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect19k( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect38k( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortConnect57k( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortErrorCorrect( LPSLOT SlotH, WORD index,
										LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortEffBaud( LPSLOT SlotH, WORD index, LPSTR dest,
									WORD len );
LPSTR FAR PASCAL AlGetPortWaitMessage( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortScratch( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortSoundName( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortFirst( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortMiddle( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortLast( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetPortHandle( LPSLOT SlotH, LPSTR dest, WORD len );

// system settings
WORD FAR PASCAL AlGetSysMajorRev( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysMinorRev( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysPageFrom( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysPageTo( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysByteCreditPct( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysDayCarryPct( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysWeekCarryPct( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysMonthCarryPct( LPSLOT SlotH );
DWORD FAR PASCAL AlGetSysDayCarryLimit( LPSLOT SlotH );
DWORD FAR PASCAL AlGetSysWeekCarryLimit( LPSLOT SlotH );
DWORD FAR PASCAL AlGetSysMonthCarryLimit( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysCanPage( LPSLOT SlotH );
BYTE FAR PASCAL AlGetSysAdultAge( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysLogClear( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysPageClear( LPSLOT SlotH );
BYTE FAR PASCAL AlGetSysMinimumTime( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysChargePartial( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysNoULClock( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysCreditNow( LPSLOT SlotH );
LPSTR FAR PASCAL AlGetSysSystemName( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysSerial( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysCreditCard( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysDefTopic( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysTimeZone( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysChat( LPSLOT SlotH, WORD index, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysScreenDir( LPSLOT SlotH, LPSTR dest, WORD len );
void FAR PASCAL AlGetSysLogFlags( LPSLOT SlotH, LPSTR dest );
LPSTR FAR PASCAL AlGetSysUserDir( LPSLOT SlotH, LPSTR dest, WORD len );
LPSTR FAR PASCAL AlGetSysPreviewDir( LPSLOT SlotH, LPSTR dest, WORD len );
BOOL FAR PASCAL AlGetSysNoAttachments( LPSLOT SlotH );
WORD FAR PASCAL AlGetSysPreviewCharge( LPSLOT SlotH );
BOOL FAR PASCAL AlGetSysHandles( LPSLOT SlotH );

// Graphic commands
void FAR PASCAL AlScreenStart( LPSLOT SlotH, BYTE color );
void FAR PASCAL AlScreenEnd( LPSLOT SlotH );
void FAR PASCAL AlLine( LPSLOT SlotH, WORD x1, WORD y1, WORD x2, WORD y2,
	BYTE color, BYTE mode, WORD width );
void FAR PASCAL AlRectangle( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, BYTE color, BYTE mode, WORD width );
void FAR PASCAL AlEllipse( LPSLOT SlotH, WORD x1, WORD y1, WORD x2, WORD y2,
	BYTE color, BYTE mode, WORD width );
void FAR PASCAL AlFRectangle( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, BYTE color, BYTE mode, WORD width,
	BYTE fg, BYTE bg, BYTE fill, BOOL transparent );
void FAR PASCAL AlFEllipse( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, BYTE color, BYTE mode, WORD width,
	BYTE fg, BYTE bg, BYTE fill, BOOL transparent );
void FAR PASCAL AlRoundRect( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, WORD xe, WORD ye, BYTE color, BYTE mode, WORD width );
void FAR PASCAL AlFRoundRect( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, WORD xe, WORD ye, BYTE color, BYTE mode, WORD width,
	BYTE fg, BYTE bg, BYTE fill, BOOL transparent );
void FAR PASCAL AlArc( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, WORD x3, WORD y3, WORD x4, WORD y4,
	BYTE color, BYTE mode, WORD width );
void FAR PASCAL AlPie( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, WORD x3, WORD y3, WORD x4, WORD y4,
	BYTE color, BYTE mode, WORD width,
	BYTE fg, BYTE bg, BYTE fill, BOOL transparent );
void FAR PASCAL AlChord( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, WORD x3, WORD y3, WORD x4, WORD y4,
	BYTE color, BYTE mode, WORD width,
	BYTE fg, BYTE bg, BYTE fill, BOOL transparent );
void FAR PASCAL AlHit( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, BYTE id, BYTE key  );
void FAR PASCAL AlButton( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, BYTE id, BYTE key, BYTE font, BYTE width, BYTE height,
	BYTE style, BYTE color, LPCSTR caption );
void FAR PASCAL AlPolygon( LPSLOT SlotH, WORD count, WORD *point,
	BYTE color, BYTE mode, WORD width );
void FAR PASCAL AlFPolygon( LPSLOT SlotH, WORD count, WORD *point,
	BYTE color, BYTE mode, WORD width,
	BYTE fg, BYTE bg, BYTE fill, BOOL transparent );
void FAR PASCAL AlText( LPSLOT SlotH, WORD x1, WORD y1,
	WORD x2, WORD y2, BYTE font, BYTE width, BYTE height,
	BYTE style, BYTE position, BYTE color, LPCSTR text );
void FAR PASCAL AlCard( LPSLOT SlotH, BYTE card, WORD x1, WORD y1,
	WORD x2, WORD y2 );

// International conversions
LPSTR FAR PASCAL AlUserMoneyFormat( LPSLOT SlotH, LPSTR dest, DWORD amt );
LPSTR FAR PASCAL AlSysMoneyFormat( LPSLOT SlotH, LPSTR dest, DWORD amt );
LPSTR FAR PASCAL AlSysShortDate( LPSLOT SlotH, DWORD date, LPSTR dest, int len );
LPSTR FAR PASCAL AlSysLongDate( LPSLOT SlotH, DWORD date, LPSTR dest, int len );
LPSTR FAR PASCAL AlUserShortDate( LPSLOT SlotH, DWORD date, LPSTR dest, int len );
LPSTR FAR PASCAL AlUserLongDate( LPSLOT SlotH, DWORD date, LPSTR dest, int len );
LPSTR FAR PASCAL AlSysTime( LPSLOT SlotH, DWORD date, LPSTR dest, int len );
LPSTR FAR PASCAL AlUserTime( LPSLOT SlotH, DWORD date, LPSTR dest, int len );
BOOL FAR PASCAL AlSysDateScan( LPSLOT SlotH, DWORD *dest, LPCSTR date );
BOOL FAR PASCAL AlUserDateScan( LPSLOT SlotH, DWORD *dest, LPCSTR date );
BOOL FAR PASCAL AlSysTimeScan( LPSLOT SlotH, DWORD *dest, LPCSTR time );
BOOL FAR PASCAL AlUserTimeScan( LPSLOT SlotH, DWORD *dest, LPCSTR time );
void FAR PASCAL AlUserInternational( LPSLOT SlotH, LPSTR sShortDate,
	LPSTR sLongDate, LPSTR s1159, LPSTR s2359, LPSTR sTime, BOOL *iTime,
	BOOL *iTLZero, LPSTR sThousand, LPSTR sDecimal, LPSTR sList, LPSTR sDate );

// slot controls
void FAR PASCAL AlChainScreen( LPSLOT SlotH, LPCSTR name );
void FAR PASCAL AlSlotDownload( LPSLOT SlotH, long id );
void FAR PASCAL AlSlotMail( LPSLOT SlotH );
void FAR PASCAL AlSlotPlugIn( LPSLOT SlotH, LPCSTR name, LPCSTR cmd );
void FAR PASCAL AlSlotPreview( LPSLOT SlotH, long id);
void FAR PASCAL AlSlotLibrary( LPSLOT SlotH, long id );
void FAR PASCAL AlSlotConference( LPSLOT SlotH, long id );
void FAR PASCAL AlSlotBulletin( LPSLOT SlotH, LPCSTR name, LPCSTR title );

// language independence routines
BOOL FAR PASCAL AlLoadLangDialog( LPSLOT SlotH, LPCSTR resourceID );
HINSTANCE FAR PASCAL AlLoadLangLibrary( LPSLOT SlotH );
void FAR PASCAL AlFreeLangLibrary( LPSLOT SlotH );
HINSTANCE FAR PASCAL AlLangLibrary( LPSLOT SlotH );
LPCSTR FAR PASCAL AlLangString( LPSLOT SlotH, UINT id, LPSTR dest, WORD len );

// multi-user routines
BOOL FAR PASCAL AlCreateMulti( LPSLOT SlotH, WORD count, DWORD *dest, WORD size );
BOOL FAR PASCAL AlCreateMultiAll( LPSLOT SlotH, WORD size );
BOOL FAR PASCAL AlCreateMultiSingle( LPSLOT SlotH, LONG dest, WORD size );
void * FAR PASCAL AlMultiLock( LPSLOT SlotH );
void FAR PASCAL AlMultiUnlock( LPSLOT SlotH );
LONG FAR PASCAL AlMultiSelf( LPSLOT SlotH );

// Direct COMM support (won't work with excalibur connections)
int FAR PASCAL AlCommHandle( LPSLOT SlotH );
void FAR PASCAL AlSwitchDLL( LPSLOT SlotH, LPCSTR name, LPCSTR args );
void FAR PASCAL AlRunDLL( LPSLOT SlotH, LPCSTR name, LPCSTR args );
BOOL FAR PASCAL AlCarrier( LPSLOT SlotH );
BOOL FAR PASCAL AlSetNoHangup( LPSLOT SlotH, BOOL flag );

#ifdef __cplusplus
	};
#endif


#endif
