//====================================================================
//  PICK2.CPP
//
//  Game for Excalibur
//
//	This C++ source code for an Excalibur BBS Plug-In is intended only as
//	a sample of using the Alchemist's Workbench API and creating a plug-in
//	for Camelot.  Excalibur Communications makes no warranty of any kind,
// expressed or implied, including without limitation, any warranties of
//	merchantability and/or fitness for a particular purpose.  Use this
//	source code at your own risk.
//
//====================================================================

#include "opl.h"
#include <windows.h>
#include <alchemw.h>
#include <stdlib.h>	// for rand and srand
#include <gdc.h>

DEFINE_LIBRARY_ENTRY;

class Pickit : public Plugin {
	char Grid[10][10];
	DWORD OpponentID;
	char OpponentName[50];
	int Player1, Player2;
	BOOL IsColumn;				// I'm first if true and pick columns from CurrentPos
	BOOL MyTurn;
	int CurrentPos;
	// messages to other opponent
	enum { INITGRID, MOVE };
	// current states
	enum { SHOW, WAIT, WAITOPPONENT, OVERFLOW, STARTGAME, WAITLEAVING,
			WAITERROR, GAMEOVER };
	void waitOpponent();
	void overFlow();
	void startGame();
	int State;
public:
	Pickit(LPSLOT sloth);
	virtual LPCSTR Title() { return "Pick-It"; }
	WORD Type() { return AL_WIN_GRAPHIC|AL_WIN_MULTI; }
	WORD Mouse( BYTE code, WORD x, WORD y );
	WORD Process();
	WORD Dialog( WORD result );
	WORD Button( WORD );
	void showGrid();
	void showScore();
	void doMove( int pos );
	WORD Broadcast( BYTE *data, WORD len );
	WORD Receive( BYTE *data, WORD, DWORD sender );
	};

DEFINE_PLUGINS( Pickit );
PLUGIN_UNIQUE;


Pickit::Pickit(LPSLOT sloth) : Plugin(sloth), State(WAITOPPONENT)
	{
	}


/*
**	showGrid displays all the current number values and the grid that the user
**	will see.
*/
void Pickit::
showGrid()
	{
	AlScreenStart( AL_GREEN );
	if ( MyTurn )
		AlText( 20, 10, 100, 30,
			GDC_FACE_ARIAL, 12, 32, 0, GDC_FONT_LEFT, AL_LTGREEN,
			"Your Turn!" );
	else
		AlText( 20, 10, 100, 30,
			GDC_FACE_ARIAL, 12, 32, 0, GDC_FONT_LEFT, AL_LTRED,
			"Waiting for your opponent:" );

	AlFRectangle( 50, 50, 550, 550, AL_BLACK, PS_SOLID, 4,
		AL_LTGRAY, 0, 0, 0 );
	if ( MyTurn == IsColumn )
		AlFRectangle( 50, 50+CurrentPos*50,
			550, 100+CurrentPos*50, AL_BLACK, PS_SOLID, 4,
			AL_WHITE, 0, 0, 0 );
	else
		AlFRectangle( 50+CurrentPos*50, 50,
			100+CurrentPos*50, 550, AL_BLACK, PS_SOLID, 4,
			AL_WHITE, 0, 0, 0 );

	for ( int i=0; i<9; i++ ) {
		AlLine( 100+50*i, 50, 100+50*i, 550, AL_BLACK, PS_DASH, 1 );
		AlLine( 50, 100+50*i, 550, 100+50*i, AL_BLACK, PS_DASH, 1 );
		}
	for ( int x=0; x<10; x++ ) {
		for( int y=0; y<10; y++ ) {
			if ( Grid[y][x] <100 ) {
				char temp[20];
				wsprintf( temp, "%d", Grid[y][x] );
				AlText( 50+x*50, 60+y*50, 100+x*50, 100+y*50,
						GDC_FACE_ARIAL, 10, 32, 0, GDC_FONT_CENTER, AL_LTRED,
						temp );
				}
			}
		}
	AlText( 600, 50, 730, 100,
			GDC_FACE_TIMES, 12, 32, 0, GDC_FONT_RIGHT, AL_LTBLUE,
			"Your Score: " );
	AlText( 600, 100, 730, 200,
			GDC_FACE_TIMES, 12, 32, 0, GDC_FONT_RIGHT, AL_LTBLUE,
			"Opponent: " );
	char temp[20];
	wsprintf( temp, "%d", Player1 );
	AlText( 730, 50, 800, 100,
			GDC_FACE_TIMES, 12, 32, 0, GDC_FONT_LEFT, AL_LTCYAN, temp );
	wsprintf( temp, "%d", Player2 );
	AlText( 730, 100, 800, 200,
			GDC_FACE_TIMES, 12, 32, 0, GDC_FONT_LEFT, AL_LTCYAN, temp );

	AlButton( 600, 300, 730, 350, 1, 0, GDC_FACE_TIMES, 12, 32,
				GDC_FONT_BOLD, AL_BLACK, "Rules" );

	AlText( 20, 560, 200, 590,
		GDC_FACE_ARIAL, 12, 32, 0, GDC_FONT_RIGHT, AL_BLACK, "Your Opponent:" );

	AlText( 210, 560, 400, 590,
		GDC_FACE_ARIAL, 12, 32, 0, GDC_FONT_LEFT, AL_YELLOW, OpponentName );

	AlScreenEnd();

	if ( MyTurn )
		AlMouseEnable();
	else
		AlMouseDisable();
	}

void Pickit::
waitOpponent()
	{
	AlScreenStart( AL_LTGRAY );
	AlText( 300, 200, 500, 400, GDC_FACE_ARIAL, 40, 80,
			GDC_FONT_BOLD|GDC_FONT_ITAL|GDC_FONT_SHADE4,
			GDC_FONT_CENTER|GDC_FONT_WRAP, AL_RED, "Waiting For Opponent" );
	AlScreenEnd();
	}


void Pickit::
startGame()
	{
	srand( (int)GetTickCount() );
	for ( int i=0; i<100; i++ )
		Grid[0][i] = rand()%21+rand()%21 - 15;
	Player1 = 0;
	Player2 = 0;
	CurrentPos = rand()%10;

	AlCreateMulti( OpponentID, sizeof( Grid ) + 3 );
	BYTE *data = (BYTE*)AlMultiLock();
	*data++ = INITGRID;
	IsColumn = rand()%2;
	*data++ = IsColumn;
	*data++ = CurrentPos;
	MyTurn = IsColumn;
	hmemcpy( data, Grid, sizeof(Grid) );
	AlMultiUnlock();
	showGrid();
	State = WAIT;
	}

WORD Pickit::
Process()
	{
	switch ( State ) {
		case SHOW:
			showGrid();
			State = WAIT;
			break;
		case WAITOPPONENT:
			waitOpponent();
			break;
		case OVERFLOW:
			AlMessageBox( "Two people are already playing", "Sorry!",
					MB_OK|MB_ICONEXCLAMATION );
			State = WAITLEAVING;
			break;
		case STARTGAME:
			startGame();
			break;
		}
	return AL_IDLE;
	}


WORD Pickit::
Dialog( WORD )
	{
	if ( State == WAITERROR ) {
		State = WAIT;
		return AL_OK;
		}
	// all dialogs currently drop out of the game
	return AL_DIE;
	}

void Pickit::
showScore()
	{
	AlMouseDisable();
	if ( Player1 > Player2 ) {
		char temp[100];
		wsprintf( temp, "You Win!  %d to %d.", Player1, Player2 );
		AlMessageBox( temp, "Game Over!", MB_OK|MB_ICONEXCLAMATION );
		}
	else {
		char temp[100];
		wsprintf( temp, "You Lose,  %d to %d.", Player1, Player2 );
		AlMessageBox( temp, "Game Over!", MB_OK|MB_ICONEXCLAMATION );
		}
	}

WORD Pickit::
Mouse( BYTE /*code*/, WORD x, WORD y )
	{
	AlMouseRelease();
	int pos = -1;

	if ( IsColumn ) {
		if ( x >= 50 && x < 550 ) {
			x -= 50;
			x /= 50;
			int row = CurrentPos;
			if ( Grid[row][x] < 100 ) {	// ok selection
				Player1 += Grid[row][x];
				Grid[row][x] = 100;
				pos = x;
				}
			}
		}
	else {
		if ( y >= 50 && y < 550 ) {
			y -= 50;
			y /= 50;
			int col = CurrentPos;
			if ( Grid[y][col] < 100 ) {	// ok selection
				Player1 += Grid[y][col];
				Grid[y][col] = 100;
				pos = y;
				}
			}
		}

	if ( pos < 0 ) {
		State = WAITERROR;
		AlMessageBox( "That spot is empty. Pick another.",
						"Ooops!", MB_OK|MB_ICONHAND );
		return AL_IDLE;
		}
	else {
		DWORD users[2];
		users[0] = OpponentID;
		users[1] = AlMultiSelf();
		AlCreateMulti( 2, users, 2 );	// 2 bytes for the 2 users
		BYTE *data = (BYTE*)AlMultiLock();
		data[0] = MOVE;
		data[1] = pos;
		AlMultiUnlock();

		return AL_IDLE;
		}
	}


WORD Pickit::
Button( WORD )
	{
	// only one button out there
	AlReleaseButton();
	AlSlotBulletin( "PICKRULE.EXT", "Pick-It Rules" );
	return AL_IDLE;
	}

WORD Pickit::
Broadcast( BYTE *data, WORD len )
	{
	Plugin::Broadcast( data, len );
	if ( *data == AL_BROAD_ALLHERE ) {
		int count = ConnectList.GetItemsInContainer();
		if ( count == 1 )
			State = WAITOPPONENT; 	// Lonely here, huh?
		else if ( count == 2 ) {
			UserDictImp scan(ConnectList);
			// which of the two in this room is my opponent?
			while( scan ) {
				if ( scan.Current().MultiID != AlMultiSelf() ) {
					OpponentID = scan.Current().MultiID;
					strcpy( OpponentName, scan.Current().Handle );
					break;
					}
				scan++;
				}
			State = STARTGAME;
			}
		else
			State = OVERFLOW;
		}
	else if ( *data == AL_BROAD_LEAVE ) {
		if ( *(long*)(data+1) == OpponentID && State != GAMEOVER ) {
			AlMessageBox( "Your opponent has left.  I guess you win.", "Notice",
         		MB_OK );
			}
		}
	return AL_OK;
	}

void Pickit::
doMove( int pos )
	{
	// first, if that move wasn't me, score the other player
	if ( ! MyTurn ) {
		if ( IsColumn ) {
			Player2 += Grid[pos][CurrentPos];
			Grid[pos][CurrentPos] = 100;
			}
		else {
			Player2 += Grid[CurrentPos][pos];
			Grid[CurrentPos][pos] = 100;
			}
		}
	CurrentPos = pos;
	MyTurn = ! MyTurn;

	// check for possible moves
	int max = -100;
	pos = -1;
	if ( MyTurn != IsColumn ) {
		for ( int i=0; i<10; i++ ) {
			if ( Grid[i][CurrentPos] != 100 && Grid[i][CurrentPos] > max ) {
				max = Grid[i][CurrentPos];
				pos = i;
				}
			}
		}
	else {
		for ( int i=0; i<10; i++ ) {
			if ( Grid[CurrentPos][i] != 100 && Grid[CurrentPos][i] > max ) {
				max = Grid[CurrentPos][i];
				pos = i;
				}
			}
		}
	if ( max == -100 ) {	// you lack move.  Game over
		State = GAMEOVER;
		showScore();
		}

	showGrid();
	}

WORD Pickit::
Receive( BYTE *data, WORD, DWORD sender )
	{
	if ( *data == INITGRID ) {
		OpponentID = sender;
		UserDictImp scan(ConnectList);
		// let's get our opponent's name
		while( scan ) {
			if ( scan.Current().MultiID == sender ) {
				strcpy( OpponentName, scan.Current().Handle );
				break;
				}
			scan++;
			}

		data++;
		MyTurn = IsColumn = ! *data++;
		CurrentPos = *data++;
		hmemcpy( Grid, data, sizeof( Grid ) );
		Player1 = Player2 = 0;
		showGrid();
		State = WAIT;
		}
	else if ( *data == MOVE ) {
		doMove( data[1] );
		}
	return AL_OK;
	}
