struct ViewInfo {
	BITMAPINFOHEADER	*Bitmap;			// bitmap structure to fill-in/use
	int				ImageBits;			// number of bits to use in extracted bitmap
	BOOL				FattenPixels;		// if source bits < ImageBits, use ImageBits
   											// as an absolute value and fatten the pixels
	BOOL				UsePalette;			// use provided palette instead of default
	DWORD 			EnlargeSize;
	LOGPALETTE		Palette;				// the palette and supporting entries
	PALETTEENTRY	_Palette[255];
	LPBYTE			ImageData;			// where to put more image data...
	WORD				ImageDataSize;		// limit on how much to put in it and, if
												// not filled, how much WAS put in it
	BOOL				Eof;					// no more data
	LPVOID			Private;				// private data to the DLL

   // return values for ViewData
	enum { UNUSED, ERR, DONE, MORE, ENLARGE };

	WORD				Error;				// specific error code (see below)
	enum { BADFORMAT };
	};

extern "C" {
typedef void FAR PASCAL _export (*ViewDisplayFn)( BITMAPINFOHEADER *bmih,
	WORD firstline, WORD lastline, void *userdata );

WORD FAR PASCAL _export ViewInit( ViewInfo * );
void FAR PASCAL _export ViewTerm( ViewInfo * );
WORD FAR PASCAL _export ViewData( ViewInfo *, ViewDisplayFn, LPVOID data );

typedef WORD FAR PASCAL _export (*ViewInitFn)( ViewInfo * );
typedef void FAR PASCAL _export (*ViewTermFn)( ViewInfo * );
typedef WORD FAR PASCAL _export (*ViewDataFn)( ViewInfo *, ViewDisplayFn, LPVOID data );
}


typedef void (*ReduceFn)( int row, BYTE huge *dest, RGBQUAD *destpal,
									LPBYTE src, RGBQUAD *srcpal, int pixels );
ReduceFn PickReduction( int destbits, int srcbits );

