#include <classlib\listimp.h>

#ifndef __ALCHEMW_H
#include "alchemw.h"
#endif

#ifndef __VER_H
#include "ver.h"
#endif


#ifndef __PLUGIN_H
#define __PLUGIN_H

BOOL operator==( const AlBroadEnter &be1, const AlBroadEnter &be2 );
typedef TListImp<AlBroadEnter> UserDict;
typedef TListIteratorImp<AlBroadEnter> UserDictImp;

class Plugin {
private:
	BOOL MultiLingual;		// plugin uses standard multi-lingual setup
protected:
	UserDict ConnectList;	// list of who is here
	LPSLOT SlotH;

private:
	void _broadAllHere( const BYTE *data );
	void _broadEnter( const BYTE *data );
	void _broadLeave( const BYTE *data );

public:
	Plugin(LPSLOT sloth) : SlotH(sloth) {}
	void SetHandle( LPSLOT h ) { SlotH = h; }
	virtual ~Plugin() { if ( MultiLingual ) AlFreeLangLibrary(); }
	virtual void InitLanguage() {}
	virtual LPCSTR Title() { return 0; }
	virtual LPCSTR DLLName() { return ""; }
	virtual LPCSTR DestName() { return ""; }
	virtual void DLLArgs( LPSTR dest ) { dest[0] = 0; }

	// a requirement
	virtual WORD Type()=0;

   // shells for the entry points
	virtual WORD Process() { return AL_IDLE; }
	virtual WORD Dialog( WORD /* result */ ) { return AL_DIE; }
	virtual BOOL GrailData( void * /*data*/, BOOL /* more */ ) { return FALSE; }
	virtual WORD Mouse( BYTE /*code*/, WORD /* x */, WORD /* y */ ) { return AL_OK; }
	virtual WORD Button( WORD id ) { return AL_OK; }
	virtual DWORD DLLSize();
	virtual BOOL NextDLL( LPSTR /* name */, WORD /* limit */, LPSTR /*dest*/, WORD /*limit*/ )
		{ return FALSE; }
	virtual WORD CheckDLL( DWORD /* curOS */, VS_FIXEDFILEINFO * /*info*/,
		LPSTR /*company*/, LPSTR /*intern*/, LPSTR /*ver*/, LPSTR /* descript*/ );
	virtual WORD Command( BYTE *cmd, WORD len ) { return AL_DIE; }
	virtual WORD Broadcast( BYTE * /*data*/, WORD /*len*/ );
	virtual WORD Receive( BYTE * /*data*/, WORD /*len*/, DWORD /*sender*/ )
		{ return AL_OK; }
	virtual void Activate( BOOL /*active*/) {}
	virtual void Paint( HDC /*dc*/, BOOL /*erase*/, RECT &/*bound*/ ) {}
	virtual void Resize( WORD width, WORD height ) {}

	// shells for library functions
	WORD AlSlot() { return ::AlSlot( SlotH ); }

	LPSTR AlArgs( LPSTR dest, WORD len ) { return ::AlArgs( SlotH, dest, len ); }
	void AlCaption( LPCSTR title ) { ::AlCaption( SlotH, title ); }
	void AlLogWrite( LPCSTR text ) { ::AlLogWrite( SlotH, text ); }
	HGLOBAL AlAlloc( DWORD size ) { return ::AlAlloc( SlotH, size ); }
	void AlFree() { ::AlFree( SlotH ); }
	void * AlLock() { return ::AlLock( SlotH ); }
	void AlUnlock() { ::AlUnlock( SlotH ); }
	HGLOBAL AlReAlloc( DWORD size ) { return ::AlReAlloc( SlotH, size ); }
	HGLOBAL AlGetHandle() { return ::AlGetHandle( SlotH ); }
	void AlSetHandle( HGLOBAL handle ) { ::AlSetHandle( SlotH, handle ); }
	HFILE AlOpenScreen( LPCSTR name, OFSTRUCT *ofs, UINT mode ) { return ::AlOpenScreen( SlotH, name, ofs, mode ); }
	HFILE AlOpenScratch( LPCSTR name, OFSTRUCT *ofs, UINT mode ) { return ::AlOpenScratch( SlotH, name, ofs, mode ); }
	HFILE AlOpenUserFile( LPCSTR name, OFSTRUCT *ofs, UINT mode ) { return ::AlOpenUserFile( SlotH, name, ofs, mode ); }
	HFILE AlOpenGlobalFile( LPCSTR name, OFSTRUCT *ofs, UINT mode ) { return ::AlOpenGlobalFile( SlotH, name, ofs, mode ); }
	void AlReleaseButton() { ::AlReleaseButton( SlotH ); }
	void AlSound( LPCSTR sound ) { ::AlSound( SlotH, sound ); }
	WORD AlSetState( WORD value ) { return ::AlSetState( SlotH, value ); }
	WORD AlGetState() { return ::AlGetState( SlotH ); }
	void AlPushState( WORD value ) { ::AlPushState( SlotH, value ); }
	WORD AlPopState() { return ::AlPopState( SlotH ); }
	void AlMessageBox( LPCSTR message, LPCSTR title, WORD code ) { ::AlMessageBox( SlotH, message, title, code ); }
	void AlMouseDisable() { ::AlMouseDisable( SlotH ); }
	void AlMouseEnable() { ::AlMouseEnable( SlotH ); }
	void AlMouseRelease() { ::AlMouseRelease( SlotH ); }
	void AlAddBlock( LPVOID data, WORD len ) { ::AlAddBlock( SlotH, data, len ); }

	void AlExecDialog() { ::AlExecDialog( SlotH ); }
	BOOL AlLoadDialog( LPCSTR resourceID, HINSTANCE module ) { return ::AlLoadDialog( SlotH, resourceID, module ); }
	BOOL AlLoadDialog( WORD id, HINSTANCE module ) { return AlLoadDialog( MAKEINTRESOURCE(id), module ); }
	void AlNewDialog( LPCSTR caption, UINT x, UINT y, UINT w, UINT h ) { ::AlNewDialog( SlotH, caption, x, y, w, h ); }
	void AlDialogPress( WORD id ) { ::AlDialogPress( SlotH, id ); }
	void AlSetString( UINT id, LPCSTR string ) { ::AlSetString( SlotH, id, string ); }
	void AlSetCheck( UINT id ) { ::AlSetCheck( SlotH, id ); }
	void AlLbAddString( UINT id, LPCSTR string ) { ::AlLbAddString( SlotH, id, string ); }
	void AlCbAddString( UINT id, LPCSTR string ) { ::AlCbAddString( SlotH, id, string ); }
	void AlLimitText( UINT id, UINT len ) { ::AlLimitText( SlotH, id, len ); }
	void AlItemEdit( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style ) { ::AlItemEdit( SlotH, id, x, y, w, h, style ); }
	void AlItemStatic( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style, LPCSTR text ) { ::AlItemStatic( SlotH, id, x, y, w, h, style, text ); }
	void AlItemButton( UINT id, WORD x, WORD y, WORD w, WORD h,DWORD style, LPCSTR text ) { ::AlItemButton( SlotH, id, x, y, w, h, style, text ); }
	void AlItemListBox( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style ) { ::AlItemListBox( SlotH, id, x, y, w, h, style ); }
	void AlItemComboBox( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style ) { ::AlItemComboBox( SlotH, id, x, y, w, h, style ); }
	void AlItemScrollBar( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style ) { ::AlItemScrollBar( SlotH, id, x, y, w, h, style ); }
	void AlItemBorShade( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style, LPCSTR text ) { ::AlItemBorShade( SlotH, id, x, y, w, h, style, text ); }
	void AlItemBorCheck( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style, LPCSTR text ) { ::AlItemBorCheck( SlotH, id, x, y, w, h, style, text ); }
	void AlItemBorRadio( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style, LPCSTR text ) { ::AlItemBorRadio( SlotH, id, x, y, w, h, style, text ); }
	void AlItemBorButton( UINT id, WORD x, WORD y, WORD w, WORD h, DWORD style ) { ::AlItemBorButton( SlotH, id, x, y, w, h, style ); }
	WORD AlDialogReturn() { return ::AlDialogReturn( SlotH ); }
	LPSTR AlGetText( UINT id, LPSTR dest, UINT len ) { return ::AlGetText( SlotH, id, dest, len ); }
	int AlGetTextLen( UINT id ) { return ::AlGetTextLen( SlotH, id ); }
	BOOL AlGetCheck( UINT id ) { return ::AlGetCheck( SlotH, id ); }
	WORD AlGetSelected( UINT id ) { return ::AlGetSelected( SlotH, id ); }
	WORD AlGetSelList( UINT id, WORD *dest, int limit ) { return ::AlGetSelList( SlotH, id, dest, limit ); }
	WORD AlGetSelCount( UINT id ) { return ::AlGetSelCount( SlotH, id ); }
	WORD AlGetScrollPos( UINT id ) { return ::AlGetScrollPos( SlotH, id ); }
	void AlSetScrollPos( UINT id, WORD pos ) { ::AlSetScrollPos( SlotH, id, pos ); }
	void AlSetScrollRange( UINT id, WORD lower, WORD upper ) { ::AlSetScrollRange( SlotH, id, lower, upper ); }
	void AlLbSelect( UINT id, UINT pick ) { ::AlLbSelect( SlotH, id, pick ); }
	void AlLbSelectItem( UINT id, UINT pick ) { ::AlLbSelectItem( SlotH, id, pick ); }
	void AlLbSelectRange( UINT id, UINT lower, UINT upper ) { ::AlLbSelectRange( SlotH, id, lower, upper ); }
	void AlCbSelect( UINT id, UINT pick ) { ::AlCbSelect( SlotH, id, pick ); }

	// general Grail database access
	BOOL AlGrailRequest( LPCSTR table, LPCSTR fields, LPCSTR filter ) { return ::AlGrailRequest( SlotH, table, fields, filter ); }
	BOOL AlGrailExecute( LPCSTR command ) { return ::AlGrailExecute( SlotH, command ); }
	BOOL AlCreateGrailInsert( LPCSTR table, WORD size, BOOL needID ) { return ::AlCreateGrailInsert( SlotH, table, size, needID ); }
	BOOL AlCreateGrailUpdate( LPCSTR table, WORD size, DWORD id ) { return ::AlCreateGrailUpdate( SlotH, table, size, id ); }
	LPVOID AlGrailLock() { return ::AlGrailLock( SlotH ); }
	void AlGrailUnlock() { ::AlGrailUnlock( SlotH ); }
	DWORD AlGrailLastInsert() { return ::AlGrailLastInsert( SlotH ); }

	// Current User Information
	DWORD AlGetUserID() { return ::AlGetUserID( SlotH ); }
	DWORD AlGetUserULBytes() { return ::AlGetUserULBytes( SlotH ); }
	DWORD AlGetUserDLBytes() { return ::AlGetUserDLBytes( SlotH ); }
	DWORD AlGetUserBalance() { return ::AlGetUserBalance( SlotH ); }
	DWORD AlGetUserRevenue() { return ::AlGetUserRevenue( SlotH ); }
	DWORD AlGetUserLastCall() { return ::AlGetUserLastCall( SlotH ); }
	DWORD AlGetUserDayByteLeft() { return ::AlGetUserDayByteLeft( SlotH ); }
	DWORD AlGetUserWeekByteLeft() { return ::AlGetUserWeekByteLeft( SlotH ); }
	DWORD AlGetUserMonthByteLeft() { return ::AlGetUserMonthByteLeft( SlotH ); }
	DWORD AlGetUserPermByte() { return ::AlGetUserPermByte( SlotH ); }
	DWORD AlGetUserPermTime() { return ::AlGetUserPermTime( SlotH ); }
	DWORD AlGetUserFirstCall() { return ::AlGetUserFirstCall( SlotH ); }
	DWORD AlGetUserExpiration() { return ::AlGetUserExpiration( SlotH ); }
	DWORD AlGetUserCallByte() { return ::AlGetUserCallByte( SlotH ); }
	DWORD AlGetUserDayByte() { return ::AlGetUserDayByte( SlotH ); }
	DWORD AlGetUserMonthByte() { return ::AlGetUserMonthByte( SlotH ); }
	DWORD AlGetUserBirth() { return ::AlGetUserBirth( SlotH ); }
	DWORD AlGetUserOtherMail() { return ::AlGetUserOtherMail( SlotH ); }
	WORD AlGetUserULFiles() { return ::AlGetUserULFiles( SlotH ); }
	WORD AlGetUserDLFiles() { return ::AlGetUserDLFiles( SlotH ); }
	WORD AlGetUserTotalCall() { return ::AlGetUserTotalCall( SlotH ); }
	WORD AlGetUserDayTimeLeft() { return ::AlGetUserDayTimeLeft( SlotH ); }
	WORD AlGetUserWeekTimeLeft() { return ::AlGetUserWeekTimeLeft( SlotH ); }
	WORD AlGetUserMonthTimeLeft() { return ::AlGetUserMonthTimeLeft( SlotH ); }
	WORD AlGetUserByteRatio() { return ::AlGetUserByteRatio( SlotH ); }
	WORD AlGetUserFileRatio() { return ::AlGetUserFileRatio( SlotH ); }
	WORD AlGetUserCallTime() { return ::AlGetUserCallTime( SlotH ); }
	WORD AlGetUserDayTime() { return ::AlGetUserDayTime( SlotH ); }
	WORD AlGetUserWeekTime() { return ::AlGetUserWeekTime( SlotH ); }
	WORD AlGetUserMonthTime() { return ::AlGetUserMonthTime( SlotH ); }
	WORD AlGetUserLanguage() { return ::AlGetUserLanguage( SlotH ); }
	LPSTR AlGetUserFirst( LPSTR dest, WORD len ) { return ::AlGetUserFirst( SlotH, dest, len ); }
	LPSTR AlGetUserMiddle( LPSTR dest, WORD len ) { return ::AlGetUserMiddle( SlotH, dest, len ); }
	LPSTR AlGetUserLast( LPSTR dest, WORD len ) { return ::AlGetUserLast( SlotH, dest, len ); }
	LPSTR AlGetUserHandle( LPSTR dest, WORD len ) { return ::AlGetUserHandle( SlotH, dest, len ); }
	LPSTR AlGetUserPassword( LPSTR dest, WORD len ) { return ::AlGetUserPassword( SlotH, dest, len ); }
	LPSTR AlGetUserTitle( LPSTR dest, WORD len ) { return ::AlGetUserTitle( SlotH, dest, len ); }
	LPSTR AlGetUserPosition( LPSTR dest, WORD len ) { return ::AlGetUserPosition( SlotH, dest, len ); }
	LPSTR AlGetUserCompany( LPSTR dest, WORD len ) { return ::AlGetUserCompany( SlotH, dest, len ); }
	LPSTR AlGetUserAddress1( LPSTR dest, WORD len ) { return ::AlGetUserAddress1( SlotH, dest, len ); }
	LPSTR AlGetUserAddress2( LPSTR dest, WORD len ) { return ::AlGetUserAddress2( SlotH, dest, len ); }
	LPSTR AlGetUserCity( LPSTR dest, WORD len ) { return ::AlGetUserCity( SlotH, dest, len ); }
	LPSTR AlGetUserState( LPSTR dest, WORD len ) { return ::AlGetUserState( SlotH, dest, len ); }
	LPSTR AlGetUserCountry( LPSTR dest, WORD len ) { return ::AlGetUserCountry( SlotH, dest, len ); }
	LPSTR AlGetUserPostal( LPSTR dest, WORD len ) { return ::AlGetUserPostal( SlotH, dest, len ); }
	LPSTR AlGetUserPhoneHome( LPSTR dest, WORD len ) { return ::AlGetUserPhoneHome( SlotH, dest, len ); }
	LPSTR AlGetUserPhoneWork( LPSTR dest, WORD len ) { return ::AlGetUserPhoneWork( SlotH, dest, len ); }
	LPSTR AlGetUserPhoneFax( LPSTR dest, WORD len ) { return ::AlGetUserPhoneFax( SlotH, dest, len ); }
	LPSTR AlGetUserPhoneBBS( LPSTR dest, WORD len ) { return ::AlGetUserPhoneBBS( SlotH, dest, len ); }
	LPSTR AlGetUserFirstVerify( LPSTR dest, WORD len ) { return ::AlGetUserFirstVerify( SlotH, dest, len ); }
	LPSTR AlGetUserLastVerify( LPSTR dest, WORD len ) { return ::AlGetUserLastVerify( SlotH, dest, len ); }
	LPSTR AlGetUserLocalNet( LPSTR dest, WORD len ) { return ::AlGetUserLocalNet( SlotH, dest, len ); }
	LPSTR AlGetUserNetID( LPSTR dest, WORD len ) { return ::AlGetUserNetID( SlotH, dest, len ); }

	LPSTR AlGetUserComment( LPSTR dest, WORD len ) { return ::AlGetUserComment( SlotH, dest, len ); }
	BOOL AlGetUserFlag( LPSTR dest, WORD index ) { return ::AlGetUserFlag( SlotH, dest, index ); }
	WORD AlGetUserFlagCount() { return ::AlGetUserFlagCount( SlotH ); }
	BOOL AlIsUserFlag( LPCSTR flag ) { return ::AlIsUserFlag( SlotH, flag ); }
	void AlSetUserFlag( LPSTR name ) { ::AlSetUserFlag( SlotH, name ); }
	void AlClearUserFlag( LPSTR name ) { ::AlClearUserFlag( SlotH, name ); }

	void AlSetUserULBytes( DWORD value ) { ::AlSetUserULBytes( SlotH, value ); }
	void AlSetUserDLBytes( DWORD value ) { ::AlSetUserDLBytes( SlotH, value ); }
	void AlSetUserBalance( DWORD value ) { ::AlSetUserBalance( SlotH, value ); }
	void AlSetUserRevenue( DWORD value ) { ::AlSetUserRevenue( SlotH, value ); }
	void AlSetUserLastCall( DWORD value ) { ::AlSetUserLastCall( SlotH, value ); }
	void AlSetUserDayByteLeft( DWORD value ) { ::AlSetUserDayByteLeft( SlotH, value ); }
	void AlSetUserWeekByteLeft( DWORD value ) { ::AlSetUserWeekByteLeft( SlotH, value ); }
	void AlSetUserMonthByteLeft( DWORD value ) { ::AlSetUserMonthByteLeft( SlotH, value ); }
	void AlSetUserPermByte( DWORD value ) { ::AlSetUserPermByte( SlotH, value ); }
	void AlSetUserPermTime( DWORD value ) { ::AlSetUserPermTime( SlotH, value ); }
	void AlSetUserFirstCall( DWORD value ) { ::AlSetUserFirstCall( SlotH, value ); }
	void AlSetUserExpiration( DWORD value ) { ::AlSetUserExpiration( SlotH, value ); }
	void AlSetUserCallByte( DWORD value ) { ::AlSetUserCallByte( SlotH, value ); }
	void AlSetUserDayByte( DWORD value ) { ::AlSetUserDayByte( SlotH, value ); }
	void AlSetUserMonthByte( DWORD value ) { ::AlSetUserMonthByte( SlotH, value ); }
	void AlSetUserBirth( DWORD value ) { ::AlSetUserBirth( SlotH, value ); }
	void AlSetUserOtherMail( DWORD value ) { ::AlSetUserOtherMail( SlotH, value ); }
	void AlSetUserULFiles( WORD value ) { ::AlSetUserULFiles( SlotH, value ); }
	void AlSetUserDLFiles( WORD value ) { ::AlSetUserDLFiles( SlotH, value ); }
	void AlSetUserTotalCall( WORD value ) { ::AlSetUserTotalCall( SlotH, value ); }
	void AlSetUserDayTimeLeft( WORD value ) { ::AlSetUserDayTimeLeft( SlotH, value ); }
	void AlSetUserWeekTimeLeft( WORD value ) { ::AlSetUserWeekTimeLeft( SlotH, value ); }
	void AlSetUserMonthTimeLeft( WORD value ) { ::AlSetUserMonthTimeLeft( SlotH, value ); }
	void AlSetUserByteRatio( WORD value ) { ::AlSetUserByteRatio( SlotH, value ); }
	void AlSetUserFileRatio( WORD value ) { ::AlSetUserFileRatio( SlotH, value ); }
	void AlSetUserCallTime( WORD value ) { ::AlSetUserCallTime( SlotH, value ); }
	void AlSetUserDayTime( WORD value ) { ::AlSetUserDayTime( SlotH, value ); }
	void AlSetUserWeekTime( WORD value ) { ::AlSetUserWeekTime( SlotH, value ); }
	void AlSetUserMonthTime( WORD value ) { ::AlSetUserMonthTime( SlotH, value ); }
	void AlSetUserLanguage( WORD value ) { ::AlSetUserLanguage( SlotH, value ); }
	LPSTR AlSetUserFirst( LPSTR text ) { return ::AlSetUserFirst( SlotH, text ); }
	LPSTR AlSetUserMiddle( LPSTR text ) { return ::AlSetUserMiddle( SlotH, text ); }
	LPSTR AlSetUserLast( LPSTR text ) { return ::AlSetUserLast( SlotH, text ); }
	LPSTR AlSetUserHandle( LPSTR text ) { return ::AlSetUserHandle( SlotH, text ); }
	LPSTR AlSetUserPassword( LPSTR text ) { return ::AlSetUserPassword( SlotH, text ); }
	LPSTR AlSetUserTitle( LPSTR text ) { return ::AlSetUserTitle( SlotH, text ); }
	LPSTR AlSetUserPosition( LPSTR text ) { return ::AlSetUserPosition( SlotH, text ); }
	LPSTR AlSetUserCompany( LPSTR text ) { return ::AlSetUserCompany( SlotH, text ); }
	LPSTR AlSetUserAddress1( LPSTR text ) { return ::AlSetUserAddress1( SlotH, text ); }
	LPSTR AlSetUserAddress2( LPSTR text ) { return ::AlSetUserAddress2( SlotH, text ); }
	LPSTR AlSetUserCity( LPSTR text ) { return ::AlSetUserCity( SlotH, text ); }
	LPSTR AlSetUserState( LPSTR text ) { return ::AlSetUserState( SlotH, text ); }
	LPSTR AlSetUserCountry( LPSTR text ) { return ::AlSetUserCountry( SlotH, text ); }
	LPSTR AlSetUserPostal( LPSTR text ) { return ::AlSetUserPostal( SlotH, text ); }
	LPSTR AlSetUserPhoneHome( LPSTR text ) { return ::AlSetUserPhoneHome( SlotH, text ); }
	LPSTR AlSetUserPhoneWork( LPSTR text ) { return ::AlSetUserPhoneWork( SlotH, text ); }
	LPSTR AlSetUserPhoneFax( LPSTR text ) { return ::AlSetUserPhoneFax( SlotH, text ); }
	LPSTR AlSetUserPhoneBBS( LPSTR text ) { return ::AlSetUserPhoneBBS( SlotH, text ); }
	LPSTR AlSetUserFirstVerify( LPSTR text ) { return ::AlSetUserFirstVerify( SlotH, text ); }
	LPSTR AlSetUserLastVerify( LPSTR text ) { return ::AlSetUserLastVerify( SlotH, text ); }
	LPSTR AlSetUserLocalNet( LPSTR text ) { return ::AlSetUserLocalNet( SlotH, text ); }
	LPSTR AlSetUserNetID( LPSTR text ) { return ::AlSetUserNetID( SlotH, text ); }
	LPSTR AlSetUserComment( LPSTR text ) { return ::AlSetUserComment( SlotH, text ); }

	// Current Port Information
	DWORD AlGetPortID() { return ::AlGetPortID( SlotH ); }
	DWORD AlGetPortLastUser() { return ::AlGetPortLastUser( SlotH ); }
	DWORD AlGetPortCalls() { return ::AlGetPortCalls( SlotH ); }
	DWORD AlGetPortBaud() { return ::AlGetPortBaud( SlotH ); }
	DWORD AlGetPortTemplate() { return ::AlGetPortTemplate( SlotH ); }
	DWORD AlGetPortGuest() { return ::AlGetPortGuest( SlotH ); }
	WORD AlGetPortWinStyle() { return ::AlGetPortWinStyle( SlotH ); }
	WORD AlGetPortWinX() { return ::AlGetPortWinX( SlotH ); }
	WORD AlGetPortWinY() { return ::AlGetPortWinY( SlotH ); }
	WORD AlGetPortWinW() { return ::AlGetPortWinW( SlotH ); }
	WORD AlGetPortWinH() { return ::AlGetPortWinH( SlotH ); }
	WORD AlGetPortBeepRepeat() { return ::AlGetPortBeepRepeat( SlotH ); }
	WORD AlGetPortBeepInterval() { return ::AlGetPortBeepInterval( SlotH ); }
	BYTE AlGetPortPort() { return ::AlGetPortPort( SlotH ); }
	BOOL AlGetPortRingDetect() { return ::AlGetPortRingDetect( SlotH ); }
	BOOL AlGetPortUseHangup() { return ::AlGetPortUseHangup( SlotH ); }
	BYTE AlGetPortRingCount() { return ::AlGetPortRingCount( SlotH ); }
	BYTE AlGetPortTimeout() { return ::AlGetPortTimeout( SlotH ); }
	BOOL AlGetPortLockRate() { return ::AlGetPortLockRate( SlotH ); }
	void AlGetPortDriveMap( LPSTR dest ) { ::AlGetPortDriveMap( SlotH, dest ); }
	LPSTR AlGetPortNetName( LPSTR dest, WORD len ) { return ::AlGetPortNetName( SlotH, dest, len ); }
	LPSTR AlGetPortSendExcal( LPSTR dest, WORD len ) { return ::AlGetPortSendExcal( SlotH, dest, len ); }
	LPSTR AlGetPortLogin( LPSTR dest, WORD len ) { return ::AlGetPortLogin( SlotH, dest, len ); }
	LPSTR AlGetPortNewUser( LPSTR dest, WORD len ) { return ::AlGetPortNewUser( SlotH, dest, len ); }
	LPSTR AlGetPortModemName( LPSTR dest, WORD len ) { return ::AlGetPortModemName( SlotH, dest, len ); }
	LPSTR AlGetPortReset( LPSTR dest, WORD len ) { return ::AlGetPortReset( SlotH, dest, len ); }
	LPSTR AlGetPortInit( LPSTR dest, WORD len ) { return ::AlGetPortInit( SlotH, dest, len ); }
	LPSTR AlGetPortOffHook( LPSTR dest, WORD len ) { return ::AlGetPortOffHook( SlotH, dest, len ); }
	LPSTR AlGetPortOnHook( LPSTR dest, WORD len ) { return ::AlGetPortOnHook( SlotH, dest, len ); }
	LPSTR AlGetPortAnswer( LPSTR dest, WORD len ) { return ::AlGetPortAnswer( SlotH, dest, len ); }
	LPSTR AlGetPortRing( LPSTR dest, WORD len ) { return ::AlGetPortRing( SlotH, dest, len ); }
	LPSTR AlGetPortCIDPrefix( LPSTR dest, WORD len ) { return ::AlGetPortCIDPrefix( SlotH, dest, len ); }
	LPSTR AlGetPortCIDPrivate( LPSTR dest, WORD len ) { return ::AlGetPortCIDPrivate( SlotH, dest, len ); }
	LPSTR AlGetPortCIDNone( LPSTR dest, WORD len ) { return ::AlGetPortCIDNone( SlotH, dest, len ); }
	LPSTR AlGetPortHangup( LPSTR dest, WORD len ) { return ::AlGetPortHangup( SlotH, dest, len ); }
	LPSTR AlGetPortConnect( LPSTR dest, WORD len ) { return ::AlGetPortConnect( SlotH, dest, len ); }
	LPSTR AlGetPortConnect1200( LPSTR dest, WORD len ) { return ::AlGetPortConnect1200( SlotH, dest, len ); }
	LPSTR AlGetPortConnect2400( LPSTR dest, WORD len ) { return ::AlGetPortConnect2400( SlotH, dest, len ); }
	LPSTR AlGetPortConnect4800( LPSTR dest, WORD len ) { return ::AlGetPortConnect4800( SlotH, dest, len ); }
	LPSTR AlGetPortConnect9600( LPSTR dest, WORD len ) { return ::AlGetPortConnect9600( SlotH, dest, len ); }
	LPSTR AlGetPortConnect19k( LPSTR dest, WORD len ) { return ::AlGetPortConnect19k( SlotH, dest, len ); }
	LPSTR AlGetPortConnect38k( LPSTR dest, WORD len ) { return ::AlGetPortConnect38k( SlotH, dest, len ); }
	LPSTR AlGetPortConnect57k( LPSTR dest, WORD len ) { return ::AlGetPortConnect57k( SlotH, dest, len ); }
	LPSTR AlGetPortErrorCorrect( WORD index, LPSTR dest, WORD len ) { return ::AlGetPortErrorCorrect( SlotH, index, dest, len ); }
	LPSTR AlGetPortEffBaud( WORD index, LPSTR dest, WORD len ) { return ::AlGetPortEffBaud( SlotH, index, dest, len ); }
	LPSTR AlGetPortWaitMessage( LPSTR dest, WORD len ) { return ::AlGetPortWaitMessage( SlotH, dest, len ); }
	LPSTR AlGetPortScratch( LPSTR dest, WORD len ) { return ::AlGetPortScratch( SlotH, dest, len ); }
	LPSTR AlGetPortSoundName( LPSTR dest, WORD len ) { return ::AlGetPortSoundName( SlotH, dest, len ); }
	LPSTR AlGetPortFirst( LPSTR dest, WORD len ) { return ::AlGetPortFirst( SlotH, dest, len ); }
	LPSTR AlGetPortMiddle( LPSTR dest, WORD len ) { return ::AlGetPortMiddle( SlotH, dest, len ); }
	LPSTR AlGetPortLast( LPSTR dest, WORD len ) { return ::AlGetPortLast( SlotH, dest, len ); }
	LPSTR AlGetPortHandle( LPSTR dest, WORD len ) { return ::AlGetPortHandle( SlotH, dest, len ); }

	// system settings
	WORD AlGetSysMajorRev() { return ::AlGetSysMajorRev( SlotH ); }
	WORD AlGetSysMinorRev() { return ::AlGetSysMinorRev( SlotH ); }
	WORD AlGetSysPageFrom() { return ::AlGetSysPageFrom( SlotH ); }
	WORD AlGetSysPageTo() { return ::AlGetSysPageTo( SlotH ); }
	WORD AlGetSysByteCreditPct() { return ::AlGetSysByteCreditPct( SlotH ); }
	WORD AlGetSysDayCarryPct() { return ::AlGetSysDayCarryPct( SlotH ); }
	WORD AlGetSysWeekCarryPct() { return ::AlGetSysWeekCarryPct( SlotH ); }
	WORD AlGetSysMonthCarryPct() { return ::AlGetSysMonthCarryPct( SlotH ); }
	DWORD AlGetSysDayCarryLimit() { return ::AlGetSysDayCarryLimit( SlotH ); }
	DWORD AlGetSysWeekCarryLimit() { return ::AlGetSysWeekCarryLimit( SlotH ); }
	DWORD AlGetSysMonthCarryLimit() { return ::AlGetSysMonthCarryLimit( SlotH ); }
	BOOL AlGetSysCanPage() { return ::AlGetSysCanPage( SlotH ); }
	BYTE AlGetSysAdultAge() { return ::AlGetSysAdultAge( SlotH ); }
	BOOL AlGetSysLogClear() { return ::AlGetSysLogClear( SlotH ); }
	BOOL AlGetSysPageClear() { return ::AlGetSysPageClear( SlotH ); }
	BYTE AlGetSysMinimumTime() { return ::AlGetSysMinimumTime( SlotH ); }
	BOOL AlGetSysChargePartial() { return ::AlGetSysChargePartial( SlotH ); }
	BOOL AlGetSysNoULClock() { return ::AlGetSysNoULClock( SlotH ); }
	BOOL AlGetSysCreditNow() { return ::AlGetSysCreditNow( SlotH ); }
	LPSTR AlGetSysSystemName( LPSTR dest, WORD len ) { return ::AlGetSysSystemName( SlotH, dest, len ); }
	LPSTR AlGetSysSerial( LPSTR dest, WORD len ) { return ::AlGetSysSerial( SlotH, dest, len ); }
	LPSTR AlGetSysCreditCard( LPSTR dest, WORD len ) { return ::AlGetSysCreditCard( SlotH, dest, len ); }
	LPSTR AlGetSysDefTopic( LPSTR dest, WORD len ) { return ::AlGetSysDefTopic( SlotH, dest, len ); }
	LPSTR AlGetSysTimeZone( LPSTR dest, WORD len ) { return ::AlGetSysTimeZone( SlotH, dest, len ); }
	LPSTR AlGetSysChat( WORD index, LPSTR dest, WORD len ) { return ::AlGetSysChat( SlotH, index, dest, len ); }
	LPSTR AlGetSysScreenDir( LPSTR dest, WORD len ) { return ::AlGetSysScreenDir( SlotH, dest, len ); }
	void AlGetSysLogFlags( LPSTR dest ) { ::AlGetSysLogFlags( SlotH, dest ); }
	LPSTR AlGetSysUserDir( LPSTR dest, WORD len ) { return ::AlGetSysUserDir( SlotH, dest, len ); }
	LPSTR AlGetSysPreviewDir( LPSTR dest, WORD len ) { return ::AlGetSysPreviewDir( SlotH, dest, len ); }
	BOOL AlGetSysHandles() { return ::AlGetSysHandles( SlotH ); }
	WORD AlGetSysPreviewCharge() { return ::AlGetSysPreviewCharge( SlotH ); }
	BOOL AlGetSysNoAttachments() { return ::AlGetSysNoAttachments( SlotH ); }

	// Graphic commands
	void AlScreenStart( BYTE color ) { ::AlScreenStart( SlotH, color ); }
	void AlScreenEnd() { ::AlScreenEnd( SlotH ); }
	void AlLine( WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BYTE mode, WORD width ) { ::AlLine( SlotH, x1, y1, x2, y2, color, mode, width ); }
	void AlRectangle( WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BYTE mode, WORD width ) { ::AlRectangle( SlotH, x1, y1, x2, y2, color, mode, width ); }
	void AlEllipse( WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BYTE mode, WORD width ) { ::AlEllipse( SlotH, x1, y1, x2, y2, color, mode, width ); }
	void AlFRectangle( WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BYTE mode, WORD width, BYTE fg, BYTE bg, BYTE fill, BOOL transparent ) { ::AlFRectangle( SlotH, x1, y1, x2, y2, color, mode, width, fg, bg, fill, transparent ); }
	void AlFEllipse( WORD x1, WORD y1, WORD x2, WORD y2, BYTE color, BYTE mode, WORD width, BYTE fg, BYTE bg, BYTE fill, BOOL transparent ) { ::AlFEllipse( SlotH, x1, y1, x2, y2, color, mode, width, fg, bg, fill, transparent ); }
	void AlRoundRect( WORD x1, WORD y1, WORD x2, WORD y2, WORD xe, WORD ye, BYTE color, BYTE mode, WORD width ) { ::AlRoundRect( SlotH, x1, y1, x2, y2, xe, ye, color, mode, width ); }
	void AlFRoundRect( WORD x1, WORD y1, WORD x2, WORD y2, WORD xe, WORD ye, BYTE color, BYTE mode, WORD width, BYTE fg, BYTE bg, BYTE fill, BOOL transparent ) { ::AlFRoundRect( SlotH, x1, y1, x2, y2, xe, ye, color, mode, width, fg, bg, fill, transparent ); }
	void AlArc( WORD x1, WORD y1, WORD x2, WORD y2, WORD x3, WORD y3, WORD x4, WORD y4, BYTE color, BYTE mode, WORD width ) { ::AlArc( SlotH, x1, y1, x2, y2, x3, y3, x4, y4, color, mode, width ); }
	void AlPie( WORD x1, WORD y1, WORD x2, WORD y2, WORD x3, WORD y3, WORD x4, WORD y4, BYTE color, BYTE mode, WORD width, BYTE fg, BYTE bg, BYTE fill, BOOL transparent ) { ::AlPie( SlotH, x1, y1, x2, y2, x3, y3, x4, y4, color, mode, width, fg, bg, fill, transparent ); }
	void AlChord( WORD x1, WORD y1, WORD x2, WORD y2, WORD x3, WORD y3, WORD x4, WORD y4, BYTE color, BYTE mode, WORD width, BYTE fg, BYTE bg, BYTE fill, BOOL transparent ) { ::AlChord( SlotH, x1, y1, x2, y2, x3, y3, x4, y4, color, mode, width, fg, bg, fill, transparent ); }
	void AlHit( WORD x1, WORD y1, WORD x2, WORD y2, BYTE id, BYTE key  ) { ::AlHit( SlotH, x1, y1, x2, y2, id, key  ); }
	void AlButton( WORD x1, WORD y1, WORD x2, WORD y2, BYTE id, BYTE key, BYTE font, BYTE width, BYTE height, BYTE style, BYTE color, LPCSTR caption ) { ::AlButton( SlotH, x1, y1, x2, y2, id, key, font, width, height, style, color, caption ); }
	void AlPolygon( WORD count, WORD *point, BYTE color, BYTE mode, WORD width ) { ::AlPolygon( SlotH, count, point, color, mode, width ); }
	void AlFPolygon( WORD count, WORD *point, BYTE color, BYTE mode, WORD width, BYTE fg, BYTE bg, BYTE fill, BOOL transparent ) { ::AlFPolygon( SlotH, count, point, color, mode, width, fg, bg, fill, transparent ); }
	void AlText( WORD x1, WORD y1, WORD x2, WORD y2, BYTE font, BYTE width, BYTE height, BYTE style, BYTE position, BYTE color, LPCSTR text ) { ::AlText( SlotH, x1, y1, x2, y2, font, width, height, style, position, color, text ); }
	void AlCard( BYTE card, WORD x1, WORD y1, WORD x2, WORD y2 ) { ::AlCard( SlotH, card, x1, y1, x2, y2 ); }

	// International conversions
	LPSTR AlUserMoneyFormat( LPSTR dest, DWORD amt ) { return ::AlUserMoneyFormat( SlotH, dest, amt ); }
	LPSTR AlSysMoneyFormat( LPSTR dest, DWORD amt ) { return ::AlSysMoneyFormat( SlotH, dest, amt ); }
	LPSTR AlSysShortDate( DWORD date, LPSTR dest, int len ) { return ::AlSysShortDate( SlotH, date, dest, len ); }
	LPSTR AlSysLongDate( DWORD date, LPSTR dest, int len ) { return ::AlSysLongDate( SlotH, date, dest, len ); }
	LPSTR AlUserShortDate( DWORD date, LPSTR dest, int len ) { return ::AlUserShortDate( SlotH, date, dest, len ); }
	LPSTR AlUserLongDate( DWORD date, LPSTR dest, int len ) { return ::AlUserLongDate( SlotH, date, dest, len ); }
	LPSTR AlSysTime( DWORD date, LPSTR dest, int len ) { return ::AlSysTime( SlotH, date, dest, len ); }
	LPSTR AlUserTime( DWORD date, LPSTR dest, int len ) { return ::AlUserTime( SlotH, date, dest, len ); }
	BOOL AlSysDateScan( DWORD *dest, LPCSTR date ) { return ::AlSysDateScan( SlotH, dest, date ); }
	BOOL AlUserDateScan( DWORD *dest, LPCSTR date ) { return ::AlUserDateScan( SlotH, dest, date ); }
	BOOL AlSysTimeScan( DWORD *dest, LPCSTR time ) { return ::AlSysTimeScan( SlotH, dest, time ); }
	BOOL AlUserTimeScan( DWORD *dest, LPCSTR time ) { return ::AlUserTimeScan( SlotH, dest, time ); }
	void AlUserInternational( LPSTR sShortDate, LPSTR sLongDate, LPSTR s1159, LPSTR s2359, LPSTR sTime, BOOL *iTime, 	BOOL *iTLZero, LPSTR sThousand, LPSTR sDecimal, LPSTR sList, LPSTR sDate )
		{ ::AlUserInternational( SlotH, sShortDate, sLongDate, s1159, s2359, sTime, iTime, iTLZero, sThousand, sDecimal, sList, sDate ); }

	// new items
	void AlChainScreen( LPCSTR name ) { ::AlChainScreen( SlotH, name ); }
	void AlSlotDownload( long id ) { ::AlSlotDownload( SlotH, id ); }
	void AlSlotMail() { ::AlSlotMail( SlotH ); }
	void AlSlotPlugIn( LPCSTR name, LPCSTR cmd ) { ::AlSlotPlugIn( SlotH, name, cmd ); }
	void AlSlotPreview( long id) { ::AlSlotPreview( SlotH, id); }
	void AlSlotLibrary( long id ) { ::AlSlotLibrary( SlotH, id ); }
	void AlSlotConference( long id ) { ::AlSlotConference( SlotH, id ); }
	void AlSlotBulletin( LPCSTR name, LPCSTR title ) { ::AlSlotBulletin( SlotH, name, title ); }

	BOOL AlLoadLangDialog( LPCSTR resourceID ) { return ::AlLoadLangDialog( SlotH, resourceID ); }
	BOOL AlLoadLangDialog( WORD resourceID ) { return AlLoadLangDialog( MAKEINTRESOURCE(resourceID) ); }
	HINSTANCE AlLoadLangLibrary() { MultiLingual = TRUE; return ::AlLoadLangLibrary( SlotH ); }
	void AlFreeLangLibrary() { ::AlFreeLangLibrary( SlotH ); }
	HINSTANCE AlLangLibrary() { return ::AlLangLibrary( SlotH ); }
	LPCSTR AlLangString( UINT id, LPSTR dest, WORD len ) { return ::AlLangString( SlotH, id, dest, len ); }
	LPVOID AlGetPointer() { return ::AlGetPointer( SlotH ); }
	VOID AlSetPointer( LPVOID pointer ) { ::AlSetPointer( SlotH, pointer ); }
	HWND AlMainWindow() { return ::AlMainWindow( SlotH ); }
	void AlSetWindowOrg( HDC hdc ) { ::AlSetWindowOrg( SlotH, hdc ); }
	BOOL AlCreateMulti( int count, DWORD *dest, WORD size ) { return ::AlCreateMulti( SlotH, count, dest, size ); }
	BOOL AlCreateMulti( LONG dest, WORD size ) { return  ::AlCreateMultiSingle( SlotH, dest, size ); }
	BOOL AlCreateMulti( WORD size ) { return  ::AlCreateMultiAll( SlotH, size ); }
	LPVOID AlMultiLock() { return ::AlMultiLock( SlotH ); }
	void AlMultiUnlock() { ::AlMultiUnlock( SlotH ); }
   LONG AlMultiSelf() { return ::AlMultiSelf( SlotH ); }
	};

extern HINSTANCE _hInstance;

#define DEFINE_LIBRARY_ENTRY \
	extern "C" { \
	int FAR _export PASCAL \
	LibMain( HINSTANCE hInstance, WORD wDataSegment, \
									WORD wHeapSize, LPSTR lpszCmdLine ); \
	int FAR _export PASCAL WEP ( int bSystemExit ); \
	}\
int FAR _export PASCAL LibMain(	HINSTANCE, WORD, WORD wHeapSize, LPSTR ) \
	{ \
	if ( wHeapSize > 0 ) UnlockData(0); \
	return TRUE; \
	} \
int FAR _export PASCAL WEP ( int /* bSystemExit */ ) \
	{ return 1; }

#define DEFINE_PLUGINS( CLASSNAME ) \
	extern "C" { \
	WORD FAR _export PASCAL PlugType( LPSLOT SlotH, LPSTR title ); \
	WORD FAR _export PASCAL PlugProcess( LPSLOT SlotH ); \
	void FAR _export PASCAL PlugDestroy( LPSLOT SlotH ); \
	BOOL _export PASCAL PlugUnique( LPSLOT SlotH, LPCSTR args, LPSTR message ); \
	WORD _export PASCAL PlugDialog( LPSLOT SlotH, WORD result ); \
	WORD _export PASCAL PlugButton( LPSLOT SlotH, WORD id ); \
	BOOL _export PASCAL PlugData( LPSLOT SlotH, BOOL more, void FAR *data ); \
	WORD _export PASCAL PlugMouse( LPSLOT SlotH, BYTE code, WORD x, WORD y ); \
	DWORD _export PASCAL PlugDLLSize( LPSLOT SlotH ); \
	BOOL _export PASCAL PlugNextDLL( LPSLOT SlotH, LPSTR name, WORD limit, LPSTR dest, WORD dlim ); \
	WORD _export PASCAL PlugDLLVerify( LPSLOT SlotH, DWORD curOS, \
		VS_FIXEDFILEINFO *info, LPSTR company, LPSTR intern, LPSTR ver, LPSTR descript ); \
	WORD _export PASCAL PlugCommand( LPSLOT SlotH, BYTE *cmd, WORD len ); \
	WORD _export PASCAL PlugBroadcast( LPSLOT SlotH, BYTE *data, WORD len ); \
	void _export PASCAL PlugActivate( LPSLOT SlotH, BOOL active ); \
	void _export PASCAL PlugPaint( LPSLOT SlotH, HDC dc, BOOL erase, RECT *rect ); \
	void _export PASCAL PlugResize( LPSLOT SlotH, WORD width, WORD height ); \
	WORD _export PASCAL PlugReceive( LPSLOT SlotH, BYTE *data, WORD len, DWORD sender ); \
	}; \
WORD FAR _export PASCAL PlugType( LPSLOT SlotH, LPSTR title ) \
	{ \
	CLASSNAME FAR *c = new FAR CLASSNAME(SlotH); \
	int result = c->Type(); \
	if ( (result&0xfff) == AL_WIN_PLUGIN ) { \
		lstrcpy( title, c->DLLName() ); \
		c->DLLArgs( title + strlen( title ) + 1 ); \
		} \
	else { \
		if ( c->Title() ) \
			strcpy( title, c->Title() ); \
		else \
			title[0] = 0; \
		} \
	c->InitLanguage();	\
	AlSetPointer( SlotH, c ); \
	return result; \
	} \
WORD FAR _export PASCAL PlugProcess( LPSLOT SlotH ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Process(); } \
void FAR FAR _export PASCAL PlugDestroy( LPSLOT SlotH ) \
	{ delete ((CLASSNAME FAR *)AlGetPointer(SlotH)); } \
WORD FAR _export PASCAL PlugDialog( LPSLOT SlotH, WORD result ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Dialog( result ); } \
BOOL FAR _export PASCAL PlugData( LPSLOT SlotH, BOOL more, LPVOID data ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->GrailData( data, more ); } \
WORD FAR _export PASCAL PlugMouse( LPSLOT SlotH, BYTE code, WORD x, WORD y ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Mouse( code, x, y ); } \
WORD FAR _export PASCAL PlugButton( LPSLOT SlotH, WORD id ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Button( id ); } \
DWORD FAR _export PASCAL PlugDLLSize( LPSLOT SlotH ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->DLLSize(); } \
BOOL FAR _export PASCAL PlugNextDLL( LPSLOT SlotH, LPSTR name, WORD limit, LPSTR dest, WORD dlim ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->NextDLL( name, limit, dest, dlim ); } \
WORD FAR _export PASCAL PlugDLLVerify( LPSLOT SlotH, DWORD curOS, \
	VS_FIXEDFILEINFO *info, LPSTR company, LPSTR intern, LPSTR ver, LPSTR descript ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->CheckDLL \
	( curOS, info, company, intern, ver, descript ); }\
WORD FAR _export PASCAL PlugCommand( LPSLOT SlotH, BYTE *cmd, WORD len ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Command( cmd, len ); } \
WORD FAR _export PASCAL PlugBroadcast( LPSLOT SlotH, BYTE *data, WORD len ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Broadcast( data, len ); } \
WORD FAR _export PASCAL PlugReceive( LPSLOT SlotH, BYTE *data, WORD len, DWORD sender ) \
	{ return ((CLASSNAME FAR *)AlGetPointer(SlotH))->Receive( data, len, sender ); } \
void FAR _export PASCAL PlugActivate( LPSLOT SlotH, BOOL active ) \
	{ ((CLASSNAME FAR *)AlGetPointer(SlotH))->Activate( active ); } \
void FAR _export PASCAL PlugPaint( LPSLOT SlotH, HDC dc, BOOL erase, RECT *rect ) \
	{ ((CLASSNAME FAR *)AlGetPointer(SlotH))->Paint( dc, erase, *rect ); } \
void FAR _export PASCAL PlugResize( LPSLOT SlotH, WORD width, WORD height ) \
	{ ((CLASSNAME FAR *)AlGetPointer(SlotH))->Resize( width, height ); }

#define PLUGIN_UNIQUE \
BOOL FAR _export PASCAL PlugUnique( LPSLOT, LPCSTR, LPSTR ) \
	{ return TRUE;	}

#define PLUGIN_NOTUNIQUE \
BOOL FAR _export PASCAL PlugUnique( LPSLOT, LPCSTR, LPSTR ) \
	{ return FALSE; }

#endif


