#include "opl.h"
#include <windows.h>

DWORD Plugin::
DLLSize()
	{
	OFSTRUCT ofs;
	HFILE temp = OpenFile( DLLName(), &ofs, OF_READ );
	DWORD size = 0;
	if ( temp >= 0 ) {
		size = _llseek( temp, 0, 2 );
		_lclose( temp );
		}
	return size;
	}


WORD Plugin::
CheckDLL( DWORD curOS, VS_FIXEDFILEINFO *info,
		LPSTR company, LPSTR intern, LPSTR ver, LPSTR descript )
	{
	if ( curOS != VOS__WINDOWS16 )
		return NODLL_BADOS;

	int result = NODLL_OK;

	DWORD infoh;
	DWORD size = GetFileVersionInfoSize( DLLName(), &infoh );
	if ( size )	{ 	// we've got version info
		BYTE *buffer = new BYTE [(int)size];
		GetFileVersionInfo( DLLName(), infoh, size, buffer );

		UINT sz;

		VS_FIXEDFILEINFO *test;
		VerQueryValue( buffer, "\\", &(void*)test, &sz );
		short *data;
		VerQueryValue( buffer, "\\VarFileInfo\\Translation", &(void*)data, &sz );
		char language[10];
		wsprintf( language, "%04x%04x", data[0], data[1] );
		if ( sz ) {
			if ( info ) {		// user has DLL check it...
				char name[100];
				void *newdata;
				wsprintf( name, "\\StringFileInfo\\%s\\CompanyName", language );
				VerQueryValue( buffer, name, &newdata, &sz);

				if ( lstrcmpi( (LPSTR)newdata, company ) != 0 )
					result = NODLL_OVERWRITE;
				else {
					if ( info->dwFileVersionMS < test->dwFileVersionMS )
						result = NODLL_MAJOR;
					// in general, we expect to be tolerant to the next major rev
					else if ( (info->dwFileVersionMS >>16)
								> (test->dwFileVersionMS >> 16) ) {
						int user = (info->dwFileVersionMS >> 16);
						int system = (test->dwFileVersionMS >> 16 );
						if ( user > system )
							result = NODLL_NEWER;
						}
					else if ( info->dwFileVersionLS < test->dwFileVersionLS )
						result = NODLL_MINOR;
					}
				}
			else
         	result = NODLL_NONE;		// user doesn't have one.
			// regardless, send the info back to the user about the DLL
			char name[100];
			void *newdata;
			wsprintf( name, "\\StringFileInfo\\%s\\CompanyName", language );
			VerQueryValue( buffer, name, &newdata, &sz);
			strcpy( company, (LPSTR)newdata );
			wsprintf( name, "\\StringFileInfo\\%s\\FileVersion", language );
			VerQueryValue( buffer, name, &newdata, &sz);
			strcpy( ver, (LPSTR)newdata );
			wsprintf( name, "\\StringFileInfo\\%s\\FileDescription", language );
			VerQueryValue( buffer, name, &newdata, &sz);
			strcpy( descript, (LPSTR)newdata );
			wsprintf( name, "\\StringFileInfo\\%s\\InternalName", language );
			VerQueryValue( buffer, name, &newdata, &sz);
			strcpy( intern, (LPSTR)newdata );
			}
		delete buffer;
		}
	else
		result = NODLL_NONE;

	return result;
	}

void Plugin::
_broadAllHere( const BYTE *data )
	{
	short count = *(short*)data;
	data += sizeof( short );
	AlBroadEnter *step = (AlBroadEnter*)data;
	while ( count-- ) {
		ConnectList.Add( *step );
		step++;
		}
	}

void Plugin::
_broadEnter( const BYTE *data )
	{
	AlBroadEnter &check = *(AlBroadEnter*)data;
	// don't add ourself.  It's coming in via ALLHERE
	if ( check.Slot != AlSlot() || check.UserID != AlGetUserID() )
		ConnectList.Add( check );
	}

void Plugin::
_broadLeave( const BYTE *data )
	{
	UserDictImp scan(ConnectList);
	AlBroadEnter check;
	check.MultiID = *(LONG*)data;
	while( scan ) {
		if ( scan.Current() ==check ) {
			ConnectList.Detach( scan.Current() );
			break;
			}
		scan++;
		}
	}

WORD Plugin::
Broadcast( BYTE *data, WORD )
	{
	switch( *data++ ) {
		case AL_BROAD_ALLHERE:
			_broadAllHere( data );
			break;
		case AL_BROAD_ENTER:
			_broadEnter( data );
			break;
		case AL_BROAD_LEAVE:
			_broadLeave( data );
			break;
		}

	return AL_OK;
	}

BOOL operator==( const AlBroadEnter &be1, const AlBroadEnter &be2 )
	{ return be1.MultiID==be2.MultiID; }

