program SEARCH;

uses
  WcGlobal,
  WcType,
  WcFileDB,
  WcMisc,
  Filer,
  QxIndex,
  QxStub;

(*


This is an example of how to use the file indexer with the ALLFILES.QX file,
you must first init the TINDEXFILE object found in QXINDEX.INT, this is done
in the WCFILEDB object, all you need to pass to it is the name of the index
file, the index routines will create one if the file is not found.

To use the search capabilities you need to init an TINDEXFINDER object found
again in QXINDEX.INT, you pass it the pointer to the TINDEXFILE that is
already initialized and it will return false if it did not initialize
succesfully or did not find any matches, from there you can use the GETNEXTKEY
or GETNEXTREF functions to go through the files that it has found.

Anytime you are using the QXINDEX file YOU MUST include the QXSTUB unit in
your uses statement because it initializes two functions that the indexer
uses, if you do not do this then the program will crash and burn.


*)

var
  MatchStr : String;
  KeyStr   : String[15];
  FileInfo : TFileRec;
  Finder   : TIndexFinder;
  FileRef  : LongInt;

  function InitFiler : Boolean;
  begin
    BtInitIsam(NetSupportType(MwConfig.Network), MinimizeUseOfNormalHeap, 0);
    InitFiler := IsamOk;
  end;


  function LoadMakeWild(var MwConfig : TMakewildRec) : Boolean;
  var
    F : File of TMakewildRec;
    SaveFileMode : Word;

  begin
    LoadMakewild := False;
    Assign(F, 'MAKEWILD.DAT');
    SaveFileMode := FileMode;
    FileMode := ShareMode;
    Reset(F);
    FileMode := SaveFileMode;
    if IoResult <> 0 then
      Exit;
    Read(F, MwConfig);
    LoadMakewild := IoResult = 0;
    Close(F);
    if IoResult = 0 then
      {ignore};
  end;


  function Register : Boolean;
  begin
    Register := False;
    if not LoadMakeWild(MwConfig) then
      Exit;
    if not InitFiler then
      Exit;
    OpenFile(NodeInfoFile, MwConfig.NodeInfoPath+'NODEINFO.DAT', SizeOf(TMasterInfo));
    Register := True;
  end;


  procedure UnRegister;
  begin
    CloseFile(NodeInfoFile);
  end;


begin
  if not Register then
    begin
      WriteLn('Unable to register');
      Exit;
    end;


  if not FileDB.Init then
    begin
      WriteLn('Could not init FILEDB');
      Exit;
    end;


  repeat
    WriteLn;
    Write('Enter text to search for (enter to abort): ');
    ReadLn(MatchStr);
    if MatchStr <> '' then
      begin
        if Length(MatchStr) > 15 then
          WriteLn('Match string is too long (15 characters or less')
        else if Length(MatchStr) = 1 then
          WriteLn('Match string is too short (2 characters or more')
        else
          begin
            KeyStr := StUpCase(MatchStr);
            if not Finder.Init(@FileDB.IndexDB, KeyStr) then
              WriteLn('Could not find any files matching '+MatchStr)
            else
              begin
                while Finder.GetNextRef(FileRef) do
                  begin
                    FileDB.GetRec(FileRef, FileInfo);
                    WriteLn('Found File '+FileInfo.FileName);
                  end;
                Finder.Done;
              end;
          end;
      end;
  until MatchStr = '';

  UnRegister;
end.